/* db2fasta.c     
Fetches a sequence from BLAST database, dumps as FASTA. */

#include <ncbi.h>
#include <tofasta.h>
#include <readdb.h>

#define NUMARG 3

static Args myargs [NUMARG] = {
  { "Database", 
	"nr", NULL, NULL, FALSE, 'd', ARG_STRING, 0.0, 0, NULL},
  { "Is this a protein database", 
	"T", NULL, NULL, TRUE, 'p', ARG_BOOLEAN, 0.0, 0, NULL},
  { "FASTA ID string", 
        NULL, NULL, NULL, TRUE, 'n', ARG_STRING, 0.0, 0, NULL}
};

Int2 Main (void)
 
{
	BioseqPtr bsp;
	Boolean is_prot;
	ReadDBFILEPtr rdfp;
	FILE *fp;
	Int4 index;

        if (! GetArgs ("db2fasta", NUMARG, myargs))
        {
                return (1);
        }

	if (myargs[1].intvalue)
		is_prot = TRUE;
	else
		is_prot = FALSE;

	fp = FileOpen("stdout", "w");

	rdfp = readdb_new(myargs[0].strvalue, is_prot);

	index = readdb_acc2fasta(rdfp, myargs[2].strvalue);

	bsp = readdb_get_bioseq(rdfp, index);

	BioseqRawToFasta(bsp, fp, !is_prot);

	bsp = BioseqFree(bsp);

	rdfp = readdb_destruct(rdfp);

	return 0;
}
	

