/* $Id: blastall.c,v 6.106 2001/12/20 21:51:06 madden Exp $
**************************************************************************
*                                                                         *
*                             COPYRIGHT NOTICE                            *
*                                                                         *
* This software/database is categorized as "United States Government      *
* Work" under the terms of the United States Copyright Act.  It was       *
* produced as part of the author's official duties as a Government        *
* employee and thus can not be copyrighted.  This software/database is    *
* freely available to the public for use without a copyright notice.      *
* Restrictions can not be placed on its present or future use.            *
*                                                                         *
* Although all reasonable efforts have been taken to ensure the accuracy  *
* and reliability of the software and data, the National Library of       *
* Medicine (NLM) and the U.S. Government do not and can not warrant the   *
* performance or results that may be obtained by using this software,     *
* data, or derivative works thereof.  The NLM and the U.S. Government     *
* disclaim any and all warranties, expressed or implied, as to the        *
* performance, merchantability or fitness for any particular purpose or   *
* use.                                                                    *
*                                                                         *
* In any work or product derived from this material, proper attribution   *
* of the author(s) as the source of the software or data would be         *
* appreciated.                                                            *
*                                                                         *
************************************************************************** 
*/
#include <ncbi.h>
#include <objseq.h>
#include <objsset.h>
#include <sequtil.h>
#include <seqport.h>
#include <tofasta.h>
#include <blast.h>
#include <blastpri.h>
#include <simutil.h>
#include <txalign.h>
#include <gapxdrop.h>
#include <sqnutils.h>
#include <xmlblast.h>
#include <mblast.h>
#include <blfmtutl.h>

#define DEFLINE_BUF 255


#define NUMARG (sizeof(myargs)/sizeof(myargs[0]))

static Args myargs [] = {
    { "Program Name",           /* 0 */
      NULL, NULL, NULL, FALSE, 'p', ARG_STRING, 0.0, 0, NULL},
    { "Database",               /* 1 */
      "nr", NULL, NULL, FALSE, 'd', ARG_STRING, 0.0, 0, NULL},
    { "Query File",             /* 2 */
      "stdin", NULL, NULL, FALSE, 'i', ARG_FILE_IN, 0.0, 0, NULL},
    { "Expectation value (E)",  /* 3 */
      "10.0", NULL, NULL, FALSE, 'e', ARG_FLOAT, 0.0, 0, NULL},
    { "alignment view options:\n0 = pairwise,\n1 = query-anchored showing identities,\n2 = query-anchored no identities,\n3 = flat query-anchored, show identities,\n4 = flat query-anchored, no identities,\n5 = query-anchored no identities and blunt ends,\n6 = flat query-anchored, no identities and blunt ends,\n7 = XML Blast output,\n8 = tabular, \n9 tabular with comment lines", /* 4 */
      "0", NULL, NULL, FALSE, 'm', ARG_INT, 0.0, 0, NULL},
    { "BLAST report Output File", /* 5 */
      "stdout", NULL, NULL, TRUE, 'o', ARG_FILE_OUT, 0.0, 0, NULL},
    { "Show GI's in deflines",  /* 6 */
      "F", NULL, NULL, FALSE, 'I', ARG_BOOLEAN, 0.0, 0, NULL},
    { "Number of database sequences to show one-line descriptions for (V)", /* 7 */
      "500", NULL, NULL, FALSE, 'v', ARG_INT, 0.0, 0, NULL},
    { "Number of database sequence to show alignments for (B)", /* 8 */
      "250", NULL, NULL, FALSE, 'b', ARG_INT, 0.0, 0, NULL},
    { "SeqAlign file",          /* 9 */
      NULL, NULL, NULL, TRUE, 'O', ARG_FILE_IN, 0.0, 0, NULL},
    { "Produce HTML output",    /* 10 */
      "F", NULL, NULL, FALSE, 'T', ARG_BOOLEAN, 0.0, 0, NULL},
};

Int2 Main (void)
 
{
    AsnIoPtr aip, xml_aip;
    BioseqPtr query_bsp;
    BioSourcePtr source;
    BlastPruneSapStructPtr prune;
    BLAST_OptionsBlkPtr options;
    Boolean db_is_na, query_is_na, show_gi, believe_query=FALSE;
    Boolean html = FALSE;
    Int4 number_of_descriptions, number_of_alignments;
    SeqAlignPtr  seqalign=NULL;
    SeqAnnotPtr seqannot = NULL;
    SeqEntryPtr sep;
    TxDfDbInfoPtr dbinfo=NULL, dbinfo_head;
    Uint1 align_type, align_view, err_ticket;
    Uint4 align_options, print_options;
    CharPtr blast_program, blast_database, blast_inputfile, blast_outputfile;
    FILE *infp, *outfp;

    if (! GetArgs ("blreplay", NUMARG, myargs)) {
        return (1);
    }
    
    UseLocalAsnloadDataAndErrMsg ();
    
    if (! SeqEntryLoad())
        return 1;
    
    ErrSetMessageLevel(SEV_WARNING);
    
    blast_program = myargs [0].strvalue;

    options = BLASTOptionNew(blast_program, TRUE);

    blast_database = myargs [1].strvalue;
    blast_inputfile = myargs [2].strvalue;
    blast_outputfile = myargs [5].strvalue;

    if (myargs[10].intvalue)
        html = TRUE;
    
    if ((infp = FileOpen(blast_inputfile, "r")) == NULL) {
        ErrPostEx(SEV_FATAL, 0, 0, "blast: Unable to open input file %s\n", blast_inputfile);
        return (1);
    }



    outfp = NULL;
    if (blast_outputfile != NULL) {
        if ((outfp = FileOpen(blast_outputfile, "w")) == NULL) {
            ErrPostEx(SEV_FATAL, 0, 0, "blast: Unable to open output file %s\n", blast_outputfile);
            return (1);
        }
    }
    
    align_view = (Int1) myargs[4].intvalue;
    
    align_type = BlastGetTypes(blast_program, &query_is_na, &db_is_na);

    sep = FastaToSeqEntryEx(infp, query_is_na, NULL, TRUE);
    if (sep == NULL)
	return (1);

    query_bsp = NULL;
    if (query_is_na) {
            SeqEntryExplore(sep, &query_bsp, FindNuc);
    } else {
            SeqEntryExplore(sep, &query_bsp, FindProt);
    }

    if (query_bsp == NULL) {
             ErrPostEx(SEV_FATAL, 0, 0, "Unable to obtain bioseq\n");
             return 2;
    }

    if(align_view < 7) {
        if (StringICmp("blastx", blast_program) == 0) {
            if (align_view != 0) {
                ErrPostEx(SEV_FATAL, 0, 0, "This option is not available with blastx");
                return 1;
            }
        } else if (StringICmp("tblastx", blast_program) == 0) {
            if (align_view != 0) {
                ErrPostEx(SEV_FATAL, 0, 0, "This option is not available with tblastx");
                return 1;
            }
        }
    }
    
    show_gi = (Boolean) myargs[6].intvalue;
    number_of_descriptions = myargs[7].intvalue;	
    number_of_alignments = myargs[8].intvalue;	
    

    print_options = 0;
    align_options = 0;
    align_options += TXALIGN_COMPRESS;
    align_options += TXALIGN_END_NUM;
    if (StringICmp("blastx", blast_program) == 0) {
        align_options += TXALIGN_BLASTX_SPECIAL;
    }
    if (show_gi) {
        align_options += TXALIGN_SHOW_GI;
        print_options += TXALIGN_SHOW_GI;
    }
    if (myargs[16].intvalue == 0)
        print_options += TXALIGN_SHOW_NO_OF_SEGS;
    
    if (align_view) {
        align_options += TXALIGN_MASTER;
        if (align_view == 1 || align_view == 3)
            align_options += TXALIGN_MISMATCH;
        if (align_view == 3 || align_view == 4 || align_view == 6)
            align_options += TXALIGN_FLAT_INS;
        if (align_view == 5 || align_view == 6)
            align_options += TXALIGN_BLUNT_END;
    } else {
        align_options += TXALIGN_MATRIX_VAL;
        align_options += TXALIGN_SHOW_QS;
    }
    
    if (html) {
        align_options += TXALIGN_HTML;
        print_options += TXALIGN_HTML;
    }

    aip = NULL;
    if (myargs[9].strvalue != NULL) {
        if ((aip = AsnIoOpen (myargs[9].strvalue,"r")) == NULL) {
                ErrPostEx(SEV_FATAL, 0, 0, "blast: Unable to open input SeqAnnot file %s\n", myargs[9].strvalue);
                return 1;
        }
	seqannot = SeqAnnotAsnRead(aip, NULL);
    }

    if (seqannot)
	seqalign = seqannot->data;

    if(align_view < 7) {
       if (html) {
          fprintf(outfp, "<HTML>\n<TITLE>BLAST Search Results</TITLE>\n");
          fprintf(outfp, "<BODY BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" "
                  "VLINK=\"#660099\" ALINK=\"#660099\">\n");
          fprintf(outfp, "<PRE>\n");
       }
    } else if (align_view == 7)     
       xml_aip = AsnIoOpen(blast_outputfile, "wx");


    ReadDBBioseqFetchEnable ("blreplay", blast_database, db_is_na, TRUE);
    
       if(align_view < 7) {
           init_buff_ex(90);
           BlastPrintVersionInfo(blast_program, html, outfp);
           fprintf(outfp, "\n");
           BlastPrintReference(html, 90, outfp);
           fprintf(outfp, "\n");
           AcknowledgeBlastQuery(query_bsp, 70, outfp, believe_query, html);

            /* Here we first check, that database do no exists */

           if(!PrintDbInformation(blast_database, !db_is_na, 70, outfp, html))
                return 1;

            free_buff();

            fprintf(outfp, "%s\n", "Searching..........................................done");
        }

      if (seqalign) {
           if (align_view == 8 || align_view == 9) {
	      if (align_view == 9)
              	PrintTabularOutputHeader(blast_database, query_bsp, NULL, 
                                       blast_program, 0, TRUE,
                                       outfp);

              BlastPrintTabulatedResults(seqalign, query_bsp, NULL, 
                                         number_of_alignments,
                                         blast_program, 
                                         FALSE,
                                         TRUE, 0, 0, outfp, FALSE);
          }
          else if(align_view == 7) 
          {
                 BXMLPrintOutput(xml_aip, seqalign, 
                                 options, blast_program, blast_database, 
                                 query_bsp, NULL, 0, NULL, NULL);
                 AsnIoReset(xml_aip);
          } else {
                 AddAlignInfoToSeqAnnot(seqannot, align_type);
                 if (outfp) { /* Uncacheing causes problems with ordinal nos. vs. gi's. */
                    ObjMgrSetHold();
                    init_buff_ex(85);
                    PrintDefLinesFromSeqAlignEx2(seqalign, 80, outfp, print_options, FIRST_PASS, 
			NULL, number_of_descriptions, NULL, NULL);
                    free_buff();
                    
                    prune = BlastPruneHitsFromSeqAlign(seqalign, number_of_alignments, NULL);
                    seqannot->data = prune->sap;

                    if (align_view != 0)
                            ShowTextAlignFromAnnot(seqannot, 60, outfp, NULL, NULL, align_options, NULL, NULL, NULL);
                    else
                            ShowTextAlignFromAnnot(seqannot, 60, outfp, NULL, NULL, align_options, NULL, NULL, FormatScoreFunc);
                    
                    seqannot->data = seqalign;
                    prune = BlastPruneSapStructDestruct(prune);
                    ObjMgrClearHold();
                    
                    ObjMgrFreeCache(0);
                    
                 }
                 seqannot = SeqAnnotFree(seqannot);
              } /* if XML Printing */
        } else {         /* seqalign is NULL */
           if(align_view == 7) {
              CharPtr message = "No hits found";

              BXMLPrintOutput(xml_aip, NULL, 
                              options, blast_program, blast_database, 
                              query_bsp, NULL, 0, message, NULL);
              
              AsnIoReset(xml_aip);
           } else if (align_view < 8) {
              fprintf(outfp, "\n\n ***** No hits found ******\n\n");
           }
        }
        
        if(html) {
           fprintf(outfp, "<PRE>\n");
        }
        
        init_buff_ex(85);
        dbinfo_head = dbinfo;
        
        if(align_view < 7) {
           while (dbinfo) {
              PrintDbReport(dbinfo, 70, outfp);
              dbinfo = dbinfo->next;
           }
        }
        dbinfo_head = TxDfDbInfoDestruct(dbinfo_head);
        
        free_buff();
        sep = SeqEntryFree(sep);

        if (html)
           fprintf(outfp, "</PRE>\n<P><HR><BR>\n<PRE>");
        
    ReadDBBioseqFetchDisable();
    
    aip = AsnIoClose(aip);
    
    if(align_view < 7) {
        if (html) {
            fprintf(outfp, "</PRE>\n</BODY>\n</HTML>\n");
        }
    } else if (align_view == 7)
        xml_aip = AsnIoClose(xml_aip);
    
    FileClose(infp);
    FileClose(outfp);
    
    return 0;
}
