#ifndef __FASTA__
#define __FASTA__

#pragma once

// ANSI headers
#include <stdio.h>


#include "LutefiskGlobals.h"


#if __dest_os == __mac_os
//#define TFASTX   // Uncomment for making TFASTX (DNA Searching version)
#define BIGMEM
#define FASTA_BEST
#define EXPM1
#define SFCHAR ':'
#define PROGRESS
#else if __dest_os	== __win32_os
//#define TFASTX   // Uncomment for making TFASTX (DNA Searching version)
#define BIGMEM
#define SFCHAR ':'
#define PROGRESS
#endif

#define YES 1
#define NO  0

#ifndef true
#	define true  1
#endif

#ifndef false
#	define false 0
#endif

#define max(a,b) ( ((a) > (b)) ? (a):(b) )
#define min(a,b) ( ((a) < (b)) ? (a):(b) )

/* Global Variables Declared in ffasta.c */
typedef struct {
	long score;	/* pam score with segment optimization*/
	long score0;	/* pam score of best single segment */
	float stddev;
	long gscore;	/* opt score */
	long sscore;	/* score used for sort */
	float zscore;
	float escore;
	long n1;		/* length of library sequence */
	long lseek;	/* position in library file */
	long dp;		/* diagonal of match */
	long start;	/* start of match in lib seq */
	long stop;	/* end of match in lib seq */
	long cont;	/* offset into sequence */
	long frame;
	long lib;	/* library for current sequence */
	short query;  /* Query seq. with the highest score (for cumulative) */
} beststr;

typedef struct {
	char 	seq[MAX_PEPTIDE_LENGTH];
	short 	nomMass[MAX_PEPTIDE_LENGTH];
	short	length;
	long 	*hashArray;
	long	*pamh2;
	long	*link;
	beststr	bestScore;
} tquery;

extern tquery *gQuery;

#define LUTEFISK_QUERY_LIMIT 15

extern long  gNumOfQueries;
extern long  gNumOfLibSequences;
extern struct SequenceScore lutefiskResult[LUTEFISK_QUERY_LIMIT];
extern long  pamfact;
extern long  fact;
extern long  kt1;
extern long  hmax;
extern long  noff;
extern long  n1;
extern char  *aa1;
extern char  gNtermBonus[20];

#endif /* __FASTA__ */