#ifndef __LUTEFISK__
#define __LUTEFISK__



/*	Prototypes for LutefiskMain.	*/
void ReadParamsFile(void);
void ReadDetailsFile(long int *bIonVal, long int *aIonVal, 
		long int *cIonVal, long int *dIonVal, long int *bMin17IonVal, long int *aMin17IonVal, 
		long int *yIonVal, long int *yMin2IonVal, long int *yMin17IonVal, long int *xIonVal, 
		long int *zPlus1IonVal, long int *wIonVal, long int *vIonVal, long int *bMinOHIonVal,
		long int *bMinOHMin17IonVal, long int *totalIonVal);
void SetupGapList(void);
void ReadEdmanFile();

/*	Prototypes for LutefiskGetCID.*/
void FreeAllMSData(struct MSData *currPtr);
void free_all(struct MSData *s);
struct MSData *LoadMSDataStruct(float massValue, long int ionIntensity);
struct MSData *AddToCIDList(struct MSData *firstPtr, struct MSData *currPtr);
void ModifyList(struct MSData *firstPtr, struct MSData *currPtr);
long int FindThreshold(struct MSData *firstPtr);
struct MSData *IonGrouper(long int threshold, float precursor);
struct MSData *IonSorter(struct MSData *ionGroupPtr, struct MSData *firstDataPtr, 
						 struct MSData *firstIonListPtr);
struct MSData *GetCidData(void);
void SmoothCID(struct MSData *firstPtr);
struct MSData *AddToListNoNull(struct MSData *firstPtr, struct MSData *currPtr);
void SortByMass(struct MSData *firstAvMassPtr);
void CheckTheIntensity(struct MSData *firstAvMassPtr);
void AddTheIonOffset(struct MSData *firstAvMassPtr);
struct MSData *WindowFilter(struct MSData *firstAvMassPtr);
void PurgeTheWindow(struct MSData *windowStartPtr, long int ionsInWindow, 
					struct MSData *firstAvMassPtr, long int endingMass);
long int countIons(struct MSData *firstAvMassPtr);
struct MSData *WeedTheIons(struct MSData *firstAvMassPtr, long int finalIonCount);
struct MSData *ZeroTheIons(struct MSData *firstAvMassPtr);
					
/*Prototypes for LutefiskMakeGraph.*/
void MakeSequenceGraph(struct MSData *firstMassPtr, short int *sequenceNode, long int bIonVal, 
						long int aIonVal,
						long int cIonVal, long int dIonVal, long int bMin17IonVal, 
						long int aMin17IonVal, long int yIonVal, long int yMin2IonVal, 
						long int yMin17IonVal, long int xIonVal, long int zPlus1IonVal, 
						long int wIonVal, long int vIonVal, long int bMinOHIonVal, 
						long int bMinOHMin17IonVal, short int *sequenceNodeC,
						short int *sequenceNodeN, long int totalIonVal);
void SequenceNodeInit(short int *sequenceNode, short int *sequenceNodeC, short int *sequenceNodeN);
void TrypticTemplate(struct MSData *firstMassPtr, short int *sequenceNode, 
						long int bIonVal, long int aIonVal, long int bMin17IonVal, 
						long int aMin17IonVal, long int yIonVal, long int yMin17IonVal, 
						short int *sequenceNodeC, short int *sequenceNodeN);
void FindTrypticBIons(struct MSData *firstMassPtr, short int *sequenceNodeN, long int bIonVal);
char IsThisPossible(float bMass, long int currentCharge);
void FindTrypticB17Ions(struct MSData *firstMassPtr, short int *sequenceNodeN, long int bMin17IonVal);
void FindTrypticAIons(struct MSData *firstMassPtr, short int *sequenceNodeN,  
						long int *ionPresent, long int aIonVal);
void FindTrypticA17Ions(struct MSData *firstMassPtr, short int *sequenceNodeN, 
						long int *ionPresent, long int aMin17IonVal);
void FindTrypticYIons(struct MSData *firstMassPtr, short int *sequenceNodeC, long int yIonVal);
void FindTrypticY17Ions(struct MSData *firstMassPtr, short int *sequenceNodeC, long int yMin17IonVal);
void AddTag(short int *sequenceNodeC, short int *sequenceNodeN);
void AddCTermResidue(short int *sequenceNodeC, short int *sequenceNodeN);
char RatchetIt(long int *aaNum, char cycle, char *sequence, long int longestSeq);
void AddEdmanData(short int *sequenceNodeC, short int *sequenceNodeN, long int totalIonVal);
						
/*Prototypes for LutefiskSummedNode.*/
void SummedNodeScore(short int *sequenceNode, short int *sequenceNodeC, 
					short int *sequenceNodeN, short int *oneEdgeNodes,
					short int *oneEdgeNodesIndex, long int totalIonVal);
void InitSummedNodeArrays(short int *sequenceNode, short int *sequenceNodeC, 
							short int *sequenceNodeN, short int *oneEdgeNodes, 
							char *evidence);
void AssignNodeValue(long int nextNode, long int currentNode, char *evidence, 
					short int *sequenceNode, short int *sequenceNodeC,
					short int *sequenceNodeN, long int totalIonVal);
long int FindCurrentNode(short int *sequenceNode, long int currentNode);
void SortOneEdgeNodes(short int *oneEdgeNodes, short int *oneEdgeNodesIndex);

/*Prototypes for SubsequenceMaker.*/
struct Sequence *SubsequenceMaker(short int *oneEdgeNodes, short int oneEdgeNodesIndex, 
						short int *sequenceNode, long int finalSeqNum, long int topSeqNum);
struct Sequence *NterminalSubsequences(short int *sequenceNode);
struct Sequence *LoadSequenceStruct(short int *peptide, short int peptideLength, 
							short int score, short int nodeValue, short int gapNum);
struct Sequence *LoadFinalSequenceStruct(short int *peptide, short int peptideLength, 
							short int score, short int nodeValue, short int gapNum);
struct Sequence *LinkSubsequenceList(struct Sequence *firstPtr, struct Sequence *newPtr);
struct Sequence *AddExtensions(struct Sequence *subsequencePtr, short int *sequenceNode, 
						short int *oneEdgeNodes, short int oneEdgeNodesIndex, 
						short int *aaPresentMass, long int finalSeqNum, 
						long int topSeqNum, short int *lastNode, short int lastNodeNum, 
						long int *seqNum);
void FreeSequenceStructs(struct Sequence *s);
struct Sequence *AlterSubsequenceList(struct Sequence *firstPtr, struct Sequence *newPtr);
char CorrectMass(short int *peptide, short int peptideLength, short int *aaPresentMass);
				
/*Prototypes for LutefiskScore.*/
struct SequenceScore *ScoreSequences(struct Sequence *finalSequencePtr, 
						struct MSData *firstMassPtr, long int rankedSeqNum);
void LoadTheIonArrays(struct MSData *firstMassPtr, long int *fragNum, 
						long int *fragMOverZ, long int *fragIntensity);
long int TotalIntensity(long int fragNum, long int *fragMOverZ, 
						long int *fragIntensity, long int precursor);
void WaterLoss(char *ionFound, long int fragNum, long int *fragMOverZ, long int *fragIntensity);
void LoadSequence(short int *sequence, long int *seqLength, 
					struct Sequence *currSeqPtr);
void PEFragments(char *ionFound, long int fragNum, long int *fragMOverZ, 
				short int *sequence, long int seqLength);
char ArgIons(char *ionFound, long int fragNum, long int *fragMOverZ, 
				short int *sequence, long int seqLength);
void InternalFrag(char *ionFound, long int *fragMOverZ, 
				short int *sequence, long int seqLength);
long int FindABYIons(char *ionFound, long int fragNum, long int *fragMOverZ, 
					 short int *sequence, long int seqLength, char argPresent);
void ScoreLowMassIons(char *ionFound, long int *fragMOverZ, 
				short int *sequence, long int seqLength, long int lowMassIons[][3]);
float IntensityScorer(long int *fragIntensity, char *ionFound, long int cleavageSites, 
						long int fragNum, long int seqLength, long int intensityTotal, 
						char argPresent);
void FreeAllSequence(struct Sequence *currPtr);
struct SequenceScore *LoadSeqScoreStruct(float intScore, short int *sequence, 
											long int seqLength);
struct SequenceScore *AddToSeqScoreList(struct SequenceScore *firstPtr, 
											struct SequenceScore *currPtr);
struct SequenceScore *FindLowestScore(struct SequenceScore *currPtr);
void SeqRanker(struct SequenceScore *firstScorePtr);
void AddTagBack(struct Sequence *finalSequencePtr);

#endif /*	__LUTEFISK__*/


