#
#sun (bsd)
# for mips, also use: -mips2 -O2
#
#CC= gcc -O
#CC= mpicc -B  
CC= gcc -O2  -I/usr/lpp/ppe.poe/include
 
CFLAGS=  -DUNIX -DBIGMEM -DSFCHAR="':'" -DEXPM1 -DPROGRESS
LFLAGS= -lm -o

#IBM RS/6000
NRAND= nrand48
RANFLG= -DRAND32
#HZ=60 for sun, mips, 100 for rs/6000, SGI, LINUX
HZ=60

PROGS= CIDentify_mpi CIDentifyX_mpi

SPROGS= CIDentify_mpi CIDentifyX_mpi

.c.o:
	$(CC) $(CFLAGS) -c $<

all : $(PROGS)

sall : $(SPROGS)

install : 
	cp $(PROGS) $(BIN)

CIDentify_mpi : ifastac.o getenv.o LutefiskGlobals.o jat.o pam.o zgmata.o f_band.o l_band.o g_band.o llmax.o scaleswf.o getaa.o ndispn.o time.o 
	mpcc ifastac.o getenv.o LutefiskGlobals.o jat.o pam.o zgmata.o scaleswf.o getaa.o ndispn.o time.o f_band.o l_band.o g_band.o llmax.o  $(LFLAGS) CIDentify_mpi  /usr/local/gnu/lib/gcc-lib/rs6000-ibm-aix4.3.3.0/2.95.2/libgcc.a -binitfini:poe_remote_main

CIDentifyX_mpi: tfastacx.o getenv.o LutefiskGlobals.o jat.o faatran.o pam.o txgmata.o lx_band2.o lx_align3.o scaleswf.o tgetaa.o ndispn.o time.o
	mpcc tfastacx.o getenv.o LutefiskGlobals.o jat.o faatran.o pam.o txgmata.o lx_band2.o lx_align3.o scaleswf.o tgetaa.o ndispn.o time.o $(LFLAGS) CIDentifyX_mpi /usr/local/gnu/lib/gcc-lib/rs6000-ibm-aix4.3.3.0/2.95.2/libgcc.a -binitfini:poe_remote_main


ifastac.o : fffasta_MPI.c upam.gbl ffasta.h Lutefisk.h jat.h
	$(CC)  $(CFLAGS) -DMAXSAV=10 -c  fffasta_MPI.c
	mv fffasta_MPI.o ifastac.o
        
tfastacx.o : fffasta_MPI.c upam.gbl ffasta.h Lutefisk.h jat.h
	$(CC)  $(CFLAGS) -DTFASTX -DMAXSAV=10 -c  fffasta_MPI.c
	mv fffasta_MPI.o tfastacx.o

faatran.o : upam.gbl aamap.gbl uascii.gbl

pam.o : uascii.gbl upam.gbl

upam.o : uascii.gbl upam.gbl

zxgmata.o : zxlgmata.c zzgmata.gbl upam.gbl
	$(CC)  $(CFLAGS) -c zxlgmata.c
	mv zxlgmata.o zxgmata.o

txgmata.o : zxlgmata.c zzgmata.gbl upam.gbl
	$(CC)  $(CFLAGS) -DTFASTX -c zxlgmata.c
	mv zxlgmata.o txgmata.o

jat.o : jat.c jat.h
	$(CC)  $(CFLAGS) -c jat.c
	
getenv.o : getenv.c getenv.h
	$(CC)  $(CFLAGS) -c getenv.c	

LutefiskGlobals.o : LutefiskGlobals.h ffasta.h
	$(CC)  $(CFLAGS) -c LutefiskGlobals.c

f_band.o : f_band.c zzgmata.gbl upam.gbl
	$(CC)  $(CFLAGS) -c f_band.c

lx_band2.o : lx_band2.c upam.gbl
	$(CC)  $(CFLAGS) -c lx_band2.c

lx_align3.o : lx_align3.c upam.gbl
	$(CC)  $(CFLAGS) -c lx_align3.c

llmax.o : llmax.c 
	$(CC) $(CFLAGS) -c llmax.c

scaleswf.o : scalesws.c
	$(CC) $(CFLAGS) -DFASTA_BEST -c scalesws.c
	mv scalesws.o scaleswf.o

g_band.o : g_band.c zzgmata.gbl upam.gbl
	$(CC)  $(CFLAGS) -c g_band.c

zgmata.o : zzlgmata.c  zzgmata.gbl upam.gbl
	$(CC)  $(CFLAGS) -c zzlgmata.c
	mv zzlgmata.o zgmata.o

getaa.o : nxgetaa_MPI.c upam.gbl uascii.gbl altlib.h
	$(CC) $(CFLAGS) -c nxgetaa_MPI.c
	mv nxgetaa_MPI.o getaa.o

tgetaa.o : nxgetaa_MPI.c upam.gbl uascii.gbl altlib.h
	$(CC) $(CFLAGS) -DTFASTA -c nxgetaa_MPI.c
	mv nxgetaa_MPI.o tgetaa.o

ndispn.o : upam.gbl

time.o : time.c
	$(CC) $(CFLAGS) -DHZ=$(HZ) -c time.c
	
clean	:
	 rm *.o CIDentify_mpi CIDentifyX_mpi

