/*
	zzlgmata.c Needleman-Wunsch nucleotide mapper to find overlaps

	copyright (c) 1983,1986,1987 William R. Pearson

	August, 1994 - corrected error in alignments for ssearch.

	July, 1994 - improved running time of smatch() by 30%

	Aug, 1991 - completely dchanged match() to use Miller/Chao linear
space in band algorithm.

	July 27, 1988 - improved output from consens, so that some context
of the match is shown.  Put in showall == -1 briefly, then removed it.

	June 29, 1988 - fixed bug in call to initmat();

	September 24, 1987 - combined zzlgmata.c and zggmata.c with
-DGLOBAL

*/

// ANSI headers
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// FASTA headers
#include "ffasta.h"
#include "ndispn.h"
#include "zzgmata.gbl"
#define XTERNAL
#include "upam.gbl"

#ifndef max
#define max(a,b) (((a)>(b))?(a):(b))
#define min(a,b) (((a)<(b))?(a):(b))
#endif


extern long n0, n1;		/* length of sequences */
extern long dnaseq;
extern char *aa0, *aa1;		/* sequence arrays */
#ifdef TFASTX
extern char *aa1y;
#else
extern char *aa0y;
#endif
extern FILE *outfd;
extern long showall;	/* show complete sequences, not just overlaps */
extern long llen;
extern long lnsflg;
extern long optwid;

long smin0, smin1, smins;	/* set bounds for DisplayConsensusAlignment */
extern long markx;

#ifdef LFASTA
extern long oneseq;
extern long lcrc0[];
extern long lcrc1[];
extern long ncrc;
extern long iscore, gscore;
long pmirror;
#endif

long window;
long nident;
static long *res=NULL;
static long nres;

/* Private function prototypes */
static void InitializeAlignmentResultsArray(long rsiz);
static void InitializeConsensusSeqArrays(long seqsiz);
static void FreeConsensusSeqArrays(void);
static long CalculateConsensusSeq(char *aa0, long n0, char *aa1, long n1, long *res, 
                                  long nres, long *nc);
                                  

/*==========================================================
*/
dmatch(char *aa0, long n0,long hoff,long display)
{
  long s0, s1;
  long nc, ns;
  float percent;
  unsigned long i,j;
  long low, up;
  long score;
  
  hoff -= optwid/2;

  if (!display) {
#ifdef TFASTX
    score = lx_align(aa0, n0, aa1y, n1, pam2, -(gdelval-ggapval),
		     -ggapval,-gshift,hoff,optwid);
#else
    score = lx_align(aa1, n1, aa0y, n0, pam2, -(gdelval-ggapval),
		     -ggapval,-gshift,hoff,optwid);
#endif
    if (score < 0) return 0;
    return score;
  }
  
  /*  score=LOCAL_ALIGN(aa0-1,aa1-1,n0,n1, low, up,
		    pam2,-(gdelval-ggapval),-ggapval,1,
		    &min0,&min1,&max0,&max1,optwid);
  
  if (score <=0) return 0;
  */
  return 0;
  
  if (showall==1) {
    if (hoff>0) maxc=optwid+((n0-hoff>=n1) ? n0 : n1+hoff);
    else maxc=optwid+((n1+hoff>=n0) ? n1 : n0-hoff);
  }
  else maxc = min(n0,n1)+2+4*optwid+2*llen;
  InitializeAlignmentResultsArray(n0+2+4*optwid);

  /* 	DISPLAY(aa0-1+min0-1,aa1-1+min1-1,max0-min0+1,max1-min1+1,
	res,min0,min1);
	*/
  InitializeConsensusSeqArrays(maxc);
  
  ns = CalculateConsensusSeq(aa0,n0,aa1,n1,res,nres,&nc);
  percent = (float)nident*100.0/nc;
  
#ifndef LFASTA
  if (markx == 4)
    disgraph(n0,n1,percent,score,min0,min1,max0,max1);
  else {
    fprintf(outfd," %5.1f%% identity in %d %s overlap\n",
	    percent,nc,sqnam);
    DisplayConsensusAlignment(seqc1, seqc0, ns);
  }
  FreeConsensusSeqArrays();
#else
  if (crcknew(seqc0,seqc1,ns)) {
    if (display) fprintf(outfd,
			 "\n %5.1f%% identity in %d %s overlap; init: %4d, opt: %4d\n",
			 percent,nc,sqnam,iscore,maxv);
    gscore = maxv;
    opnline((long)smin0,(long)smin1,gscore);
    DisplayConsensusAlignment(seqc0,seqc1,ns);
    clsline((long)smin0,(long)smin1,gscore);
#ifdef TPLOT
    if (oneseq) {
      pmirror = 1;
      i = smin0;
      smin0 = smin1;
      smin1 = i;
      opnline((long)smin0,(long)smin1,gscore);
      DisplayConsensusAlignment(seqc1,seqc0,ns);
      clsline((long)smin0,(long)smin1,gscore);
      pmirror = 0;
    }
#endif
  }
  else maxv = -1;
#endif
  return maxv;
}
  
  
static struct swstr {
  long H;
  long E;
} *ss;
/*==========================================================
*/
/* pmatch provides an interface to pro_dna() in lx_align.c */

/* aa0 has DNA sequence, aa1 has prot sequence */

pmatch(char *aa0, long n0, char *aa0t, long n0t, char *aa1, long n1, long flag)
{
  	long  nc;
  	long  minc;
  	long  maxc;
  	long  lc;
  	long  score;
	float percent;


	InitializeAlignmentResultsArray(n0*3/2);

  	score = pro_dna(aa1,n1,aa0t,n0,pam2,-(gdelval-ggapval), -ggapval, -gshift,
		            res,&nres);

	 /* display_alig(res,aa0t,aa1,nres,n0); */


	/* fprintf(stderr,"old: %d, nres: %d\n",min(n0,n1)*5/4, nres); */

  	if (showall==1) InitializeConsensusSeqArrays(max(n0,n1)*5/4);	
  	else InitializeConsensusSeqArrays(max(min(n0,n1)*5/4,nres)+2*llen);

  	nc = CalculateConsensusSeq(aa0t,n0,aa1,n1,res,nres,&lc);

  	percent = (100.0*(float)nident)/(float)lc;

  	if (markx == 4)
    	disgraph(n0,n1,percent,score,min0,min1,max0,max1);
  	else {
    	fprintf(outfd,"Smith-Waterman score: %d;   %5.1f%% identity in %d %s overlap\n",
	            score, percent,lc,sqnam);
    	DisplayConsensusAlignment(seqc0, seqc1, nc);
  	} 
  	FreeConsensusSeqArrays();
	
  	return score;
}

/*==========================================================
*/
static void InitializeAlignmentResultsArray(long rsiz)
{
  	if (res==NULL) res = (long *)calloc((size_t)rsiz,sizeof(long));
  	if (res==NULL) {
  		fprintf(stderr,"cannot allocate alignment results array %d\n",rsiz);
     	exit(1);
  	}
}

/*==========================================================
*/
static void InitializeConsensusSeqArrays(long seqsiz)
{
	seqc0 = calloc((size_t)seqsiz,sizeof(char));
  	seqc1 = calloc((size_t)seqsiz,sizeof(char));
  	if (seqc0==NULL || seqc1==NULL) {
  		fprintf(stderr,"cannot allocate consensus arrays %d\n",seqsiz);
     	exit(1);
   	}
  	salloc = 1;
}

/*==========================================================
*/
static void FreeConsensusSeqArrays(void)
{
  	free(seqc0); 
  	free(seqc1);
}

/*==========================================================
//	this function builds a consensus sequence in place by
//	going to the maximum match and moving left and up
*/
static long CalculateConsensusSeq(char *aa0, long n0, char *aa1, long n1, long *res, 
                                  long nres, long *nc)
{
  long i0, i1;
  long op, lenc, nd, ns, itmp;
  char *sp0, *sp1;
  long *rp, *rpmax;
  long i;
  long sidePadSize = 15;
  
  
  	smins = mins = 0;

#ifndef TFASTX
  	smin1 = min1= *res++;
  	smin0 = min0= *res++;
  	sp0 = seqc0 + mins;
  	sp1 = seqc1 + mins;
#else
  	smin0 = min1= *res++;
  	smin1 = min0= (*res++);
  	sp1 = seqc0 + sidePadSize;
  	sp0 = seqc1;
  	
  	/* Print the seq. for 10aa back from the overlap */
  	if ((sidePadSize - min1) > 0) {
		memset(seqc0, ' ', sidePadSize - min1);
		aancpy(seqc0 + sidePadSize - min1, aa1, min1);
		smin0 = 0;
  	}
  	else {
		aancpy(seqc0, aa1 + min1 - sidePadSize, sidePadSize);
		smin0 = min1-sidePadSize;
  	}
  			
  	/* Since the lib seq is stored as a 3-frame translation, get every 3rd res.*/
  	if ((min0 - (3 * sidePadSize)) < 0) {
  		memset(seqc1,' ',sidePadSize - (min0 - 1)/3);
		sp0 = seqc1 + sidePadSize - (min0 - 1)/3;
		if (!min0%3) i = 3;
		else i = min0%3;
  		for (; i < min0; i+=3) {
  			aancpy(sp0++,aa0+i,1);
  		}
		smin1 = 0;
  	}
  	else {
  		for (i = 3 * sidePadSize; i > 0; i-=3) {
  			aancpy(sp0++,aa0+min0-i,1);
  		}	
		smin1 = min0 - (3 * sidePadSize);
  	}
  	sp0 = seqc1 + sidePadSize;
#endif

	
      
  	rp = res;
  	rpmax = &res[nres-2];

  	lenc = nident = op = 0;
  	i0 = min0;
  	i1 = min1;

  	while (rp < rpmax ) {
    	switch (*rp++) {
    		case 0: 
      			*sp0++ = '-';
      			*sp1++ = sq[aa1[i1++]];
      			lenc++;
      			break;
    		case 2:
      			*sp0++ = '/';
      			i0 -= 1;
      			*sp1++ = '-';
      			*sp0 = sq[aa0[i0]];
      			i0 += 3;
      			*sp1 = sq[aa1[i1++]];
      			if (*sp0 == *sp1) nident++;
      			sp0++; sp1++;
      			lenc++;
      			*sp0 = sq[aa0[i0]];
      			i0 += 3;
      			*sp1 = sq[aa1[i1++]];
      			if (*sp0 == *sp1) nident++;
      			sp0++; 
      			sp1++;
      			lenc++;
      			break;
    		case 3:
      			*sp0 = sq[aa0[i0]];
      			i0 += 3;
      			*sp1 = sq[aa1[i1++]];
      			if (*sp0 == *sp1) nident++;
      			sp0++; 
      			sp1++;
      			lenc++;
      			break;
    		case 4:
      			*sp0++ = '\\';
      			i0 += 1;
      			*sp1++ = '-';
      			*sp0 = sq[aa0[i0]];
      			i0 += 3;
      			*sp1 = sq[aa1[i1++]];
      			if (*sp0 == *sp1) nident++;
      			sp0++; sp1++;
      			lenc++;
      			*sp0 = sq[aa0[i0]];
      			i0 += 3;
      			*sp1 = sq[aa1[i1++]];
      			if (*sp0 == *sp1) nident++;
      			sp0++; 
      			sp1++;
      			lenc++;
      			break;
    		case 5:
      			*sp0++ = sq[aa0[i0]];
      			i0 += 3;
      			*sp1++ = '-';
      			lenc++;
      			break;
    	}
  	}
  	
#ifndef TFASTX
  	max0 = i0;
  	max1 = i1;
#else
	max1 = i0;
  	max0 = i1;
	/* Print the seq. for 10aa after the overlap */
  	if ((max0 + sidePadSize) > n1) {
  		aancpy(sp1, aa1 + max0, n1 - max0);
  		sp1+= n1 - max0;
		memset(sp1,' ',sidePadSize);
		max0+= n1-max0;
  	}
  	else {
		aancpy(sp1,aa1 + max0, sidePadSize);
		max0+= sidePadSize;
	}
  	
  	if ((max1 + (3 * sidePadSize)) > n0 - 3) {
  		/* Since it is stored as a 3-frame translation get every 3rd res.*/
  		for (i = max1 + 3; i < n0 - 3; i+=3) {
  			aancpy(sp0++,aa0+i,1);
  		}
		memset(sp0,' ',sidePadSize);
		max1+= (n0-max1-1)/3;
  	}
  	else {
  		/* Since it is stored as a 3-frame translation get every 3rd res.*/
  		for (i = 0; i < (3 * sidePadSize); i+=3) {
  			aancpy(sp0++,aa0+max1+i,1);
  		}	
		max1+= sidePadSize;
  	}
  	
  	min1 = smin1;
  	min0 = smin0;
#endif

  	if (lenc < 0) lenc = 1;

  	*nc = lenc;
	nd = 0;
  	return mins + lenc + nd + (2 * sidePadSize);
}
                 

