DROP TABLE IF EXISTS besthits;
CREATE TEMPORARY TABLE besthits
SELECT query_id,
       SUBSTRING(
         MAX(CONCAT(RPAD(LPAD(
           FLOOR(IF(expect = 0,
                   10000,       -- special case for E value of 0
                   -LOG(expect) -- turn E value into whole number
                  ) * 10000
                ), 9, " "), 30, " "), hit_id)),31
       ) AS hit_id
FROM   search
       INNER JOIN search_hit USING (search_id)
WHERE  search.tag = "ecoli_human"
GROUP BY query_id;

SELECT expect AS 'E()',
       percid*100 AS '%ID', alen,
       search_query.descr AS query_descr,
       search_lib.descr AS lib_descr
FROM search
     INNER JOIN search_query USING (search_id)
     INNER JOIN besthits USING (query_id)
     INNER JOIN search_hit USING (hit_id)
     INNER JOIN search_lib USING (lib_id)
WHERE search_query.descr NOT LIKE "%IS5 transposase%"
AND search_query.descr NOT LIKE "%IS2 hypo%"
AND search.tag = "ecoli_human"
ORDER BY expect ASC
LIMIT 10;
