SELECT CONCAT(">gi|", gi, "|", db, "|", acc, "| ", descr, "\n", seq)
FROM   protein
       INNER JOIN annot USING (prot_id)
       INNER JOIN taxon AS all_mammalia USING (taxon_id)
       INNER JOIN taxon AS mammalia
           ON (all_mammalia.left_id BETWEEN mammalia.left_id
                                       AND mammalia.right_id)
       INNER JOIN taxon_name USING (taxon_id)
WHERE annot.pref = 1
  AND taxon_name.name = 'Mammalia'
  AND taxon_name.class = 'scientific name';
