#
# Table structure for table 'go'
#

DROP TABLE IF EXISTS go;
CREATE TABLE go (
  go_acc varchar(10) NOT NULL default '',
  name text NOT NULL,
  PRIMARY KEY  (go_acc),
  KEY acc (go_acc)
) TYPE=MyISAM;

#
# Table structure for table 'go_edge'
#

DROP TABLE IF EXISTS go_edge;
CREATE TABLE go_edge (
  child char(10) NOT NULL default '',
  parent char(10) NOT NULL default '',
  type enum('isa','partof') NOT NULL default 'isa',
  PRIMARY KEY  (child,parent)
) TYPE=MyISAM;

#
# Table structure for table 'go_assoc'
#

DROP TABLE IF EXISTS go_assoc;
CREATE TABLE go_assoc (
  go_acc char(10) NOT NULL default '',
  acc char(10) NOT NULL default '',
  evidence enum('IMP','IGI','IPI','ISS','IDA','IEP','IEA','TAS','NAS','NR') NOT NULL default 'NR',
  aspect enum('P','F','C') NOT NULL default 'P',
  PRIMARY KEY  (go_acc,acc,evidence),
  KEY go_acc (go_acc),
  KEY acc (acc)
) TYPE=MyISAM;

#
# Table structure for table 'go_synonym'
#

DROP TABLE IF EXISTS go_synonym;
CREATE TABLE go_synonym (
  go_acc char(10) NOT NULL default '',
  syn_acc char(10) NOT NULL default '',
  PRIMARY KEY  (go_acc,syn_acc),
  KEY acc (go_acc),
  KEY syn (syn_acc)
) TYPE=MyISAM;
