#!/usr/bin/perl -w
use strict;
use DBI;
use Getopt::Long;


my $db = 'seqdb_demo';
my $user = 'seqdb_user';     # db user name here
my $password = 'seqdb_pass';  # db password for this user here
my $host = 'xdb';  # add hostname if db running on different machine than
                   # update script

my $name = "generic";
my $create = 0;

GetOptions( "db|database=s" => \$db,
            "user=s" => \$user,
            "password=s" => \$password,
            "host=s" => \$host,
            "name=s" => \$name,
            "create" => \$create,
          );

my $dbh = DBI->connect("dbi:mysql:host=$host;db=$db", $user, $password)
    or die $DBI::errstr;

if ($create) {
    $dbh->do("DROP TABLE IF EXISTS go_slims");
    $dbh->do(q{ CREATE TABLE go_slims (
                  go_acc varchar(10) NOT NULL DEFAULT '',
                  name varchar(20) NOT NULL DEFAULT '',
                  rank INT UNSIGNED NOT NULL DEFAULT 0,
                  PRIMARY KEY (go_acc, name),
                  INDEX (name),
                  INDEX (go_acc)
                )
              });
} else {
    # clear out any current GO slim under this name:
    $dbh->do("DELETE FROM go_slims WHERE name = ?", {}, $name);
}


# prepare the insert statement:
my $insert = $dbh->prepare("INSERT INTO go_slims (go_acc, name, rank) VALUES (?, ?, ?)");

my $i = 0;
while (<>) {
    next unless m/^\s*(%|<)/o;
    my (undef, $go_terms) = split(/\s*;\s*/, $_, 2);
    my ($go_term) = split(", ", $go_terms, 1); # only take the first one
    $insert->execute($go_term, $name, $i++);
}
