DROP TABLE IF EXISTS search_hit;
CREATE TABLE search_hit (
  hit_id int(10) unsigned NOT NULL auto_increment,
  search_id int(10) unsigned NOT NULL default '0',
  query_id int(10) unsigned NOT NULL default '0',
  lib_id int(10) unsigned NOT NULL default '0',
  score int(10) unsigned NOT NULL default '0',
  bits double unsigned default NULL,
  expect double unsigned default NULL,
  percid double unsigned default NULL,
  alen int(10) unsigned NOT NULL default '0',
  qbegin int(10) unsigned NOT NULL default '0',
  qend int(10) unsigned NOT NULL default '0',
  lbegin int(10) unsigned NOT NULL default '0',
  lend int(10) unsigned NOT NULL default '0',
  strand enum('f','r','u') NOT NULL default 'f',
  PRIMARY KEY  (hit_id),
  KEY search_id (search_id),
  KEY query_id (query_id),
  KEY lib_id (lib_id)
) TYPE=MyISAM;

DROP TABLE IF EXISTS search;
CREATE TABLE search (
  search_id int(10) unsigned NOT NULL auto_increment,
  tag varchar(50) default NULL,
  comment text,
  algo text,
  algo_ver text,
  queryct int(10) unsigned NOT NULL default '0',
  querysize int(10) unsigned NOT NULL default '0',
  libct int(10) unsigned NOT NULL default '0',
  libsize int(10) unsigned NOT NULL default '0',
  matrix text,
  filtered enum('y', 'n') NOT NULL default 'n',
  PRIMARY KEY  (search_id),
  UNIQUE (tag)
) TYPE=MyISAM;

DROP TABLE IF EXISTS search_query;
CREATE TABLE search_query (
  query_id int(10) unsigned NOT NULL auto_increment,
  search_id int(10) unsigned NOT NULL default '0',
  seq_id int(10) unsigned NOT NULL default '0',
  name text NOT NULL default '',
  descr text NOT NULL default '',
  begin int(10) unsigned NOT NULL default '0',
  end int(10) unsigned NOT NULL default '0',
  len int(10) unsigned NOT NULL default '0',
  type text,
  PRIMARY KEY  (query_id),
  KEY search_id (search_id),
  KEY seq_id (seq_id),
  KEY beg (begin),
  KEY end (end),
  KEY len (len)
) TYPE=MyISAM;

DROP TABLE IF EXISTS search_lib;
CREATE TABLE search_lib (
  lib_id int(10) unsigned NOT NULL auto_increment,
  search_id int(10) unsigned NOT NULL default '0',
  seq_id int(10) unsigned NOT NULL default '0',
  name text NOT NULL default '',
  descr text NOT NULL default '',
  begin int(10) unsigned NOT NULL default '0',
  end int(10) unsigned NOT NULL default '0',
  len int(10) unsigned NOT NULL default '0',
  type text,
  PRIMARY KEY  (lib_id),
  KEY search_id (search_id),
  KEY seq_id (seq_id),
  KEY beg (begin),
  KEY end (end),
  KEY len (len)
) TYPE=MyISAM;
