
DROP DATABASE IF EXISTS seqdb_demo;
CREATE DATABASE seqdb_demo;
GRANT ALL PRIVILEGES ON seqdb_demo.*
      TO seqdb_user@localhost identified by "seqdb_pass";
GRANT ALL PRIVILEGES ON seqdb_demo.*
      TO seqdb_user@"%" identified by "seqdb_pass";
FLUSH PRIVILEGES;
use seqdb_demo;

#
# Table structure for table 'protein'
#

DROP TABLE IF EXISTS protein;
CREATE TABLE protein (
  prot_id int(10) unsigned NOT NULL auto_increment,
  seq text NOT NULL default '',
  len int(10) unsigned NOT NULL default '0',
  pi float NOT NULL default '0.00',
  mw float NOT NULL default '0.00',
  PRIMARY KEY  (prot_id),
  KEY len (len),
  KEY pi (pi),
  KEY mw (mw)
) TYPE=MyISAM;

#
# Table structure for table 'annot'
#

DROP TABLE IF EXISTS annot;
CREATE TABLE annot (
  acc char(20) NOT NULL default '',
  ver tinyint unsigned NOT NULL default 1,
  db enum('gb','emb','dbj','prf','ref','pdb','pir','sp','tpg') NOT NULL default 'gb',
  gi int(10) unsigned NOT NULL default 0,
  dna_acc char(20) default NULL,
  sp_name char(20) default NULL,
  prot_id int(10) unsigned NOT NULL default 0,
  taxon_id int(10) unsigned default NULL,
  descr text NOT NULL default '',
  pref tinyint(3) unsigned NOT NULL default 0,
  PRIMARY KEY  (db, acc, ver, gi),
  KEY acc (acc),
  KEY gi (gi),
  KEY prot_id (prot_id),
  KEY taxon_id (taxon_id),
  KEY pref (pref)
) TYPE=MyISAM;

#
# Table structure for table 'taxon'
#

DROP TABLE IF EXISTS taxon;
CREATE TABLE taxon (
  taxon_id int(10) unsigned NOT NULL default '0',
  parent_id int(10) unsigned NOT NULL default '0',
  left_id int(10) unsigned NOT NULL default '0',
  right_id int(10) unsigned NOT NULL default '0',
  rank enum('superphylum',
	    'superkingdom',
	    'parvorder',
	    'kingdom',
	    'superclass',
	    'infraclass',
	    'subphylum',
	    'superorder',
	    'infraorder',
	    'forma',
	    'phylum',
	    'species subgroup',
	    'subtribe',
	    'subclass',
	    'class',
	    'species group',
	    'suborder',
	    'subgenus',
	    'tribe',
	    'superfamily',
	    'varietas',
	    'order',
	    'subfamily',
	    'no rank',
	    'subspecies',
	    'family',
	    'genus',
	    'species'
	    ) NOT NULL default 'no rank',
  PRIMARY KEY  (taxon_id),
  KEY parent_id (parent_id),
  KEY left_id (left_id),
  KEY right_id (right_id),
  KEY rank (rank)
) TYPE=MyISAM;

#
# Table structure for table 'taxon_name'
#

DROP TABLE IF EXISTS taxon_name;
CREATE TABLE taxon_name (
  id int(10) unsigned NOT NULL auto_increment,
  taxon_id int(10) unsigned NOT NULL default '0',
  name text NOT NULL,
  class enum('acronym',
             'anamorph',
    	     'blast name',
             'common name',
             'equivalent name',
             'genbank acronym',
             'genbank anamorph',
             'genbank common name',
             'genbank synonym',
    	     'in-part',
    	     'includes',
             'misnomer',    
             'misspelling',
    	     'preferred acronym',
             'preferred common name',
             'scientific name',
    	     'synonym',
             'teleomorph'
             ) NOT NULL default 'common name',
  PRIMARY KEY  (id),
  KEY taxon_id (taxon_id),
  KEY class (class)
) TYPE=MyISAM;

