#!/usr/bin/perl -w

use strict;
use DBI;
use Getopt::Long;

my $db = 'seqdb_demo';
my $user = 'seqdb_user';
my $password = 'seqdb_pass';
my $host = '';                

GetOptions( "db|database=s" => \$db,
            "user=s" => \$user,
            "password=s" => \$password,
            "host=s" => \$host,
          );

my $dbh = DBI->connect("dbi:mysql:host=$host;db=$db", $user, $password)
    or die $DBI::errstr;

$dbh->do(<<EOSQL);
DROP TABLE IF EXISTS taxon_tc
EOSQL

$dbh->do(<<EOSQL);
CREATE TABLE taxon_tc (
  child_id INT UNSIGNED NOT NULL DEFAULT 0,
  parent_id INT UNSIGNED NOT NULL DEFAULT 0,
  INDEX (child_id),
  INDEX (parent_id),
  UNIQUE (child_id, parent_id)
)
EOSQL

my $children = $dbh->prepare(<<EOSQL);
SELECT taxon_id FROM taxon WHERE parent_id = ? AND taxon_id <> 1
EOSQL

my $insert = $dbh->prepare(<<EOSQL);
INSERT INTO taxon_tc (child_id, parent_id)
              VALUES (       ?,         ?)
EOSQL

$insert->execute(1, 1);
my @parents = (1);
dft(1);

sub dft {
    $children->execute(shift);
    for my $child (map { $_->[0] } @{$children->fetchall_arrayref}) {
        push @parents, $child;
        for my $parent (@parents) {
            $insert->execute($child, $parent)
        }
        dft($child);
        pop @parents;
    }
}
