/* Concurrent read version */
/*	20-June-1986	universal pam file */

/* $Id: upam.h 1124 2013-03-13 20:24:57Z wrp $ */
/* $Revision: 1124 $  */

/* modified to accomodate both lower and upper case amino acid numbers
   as a result MAXSQ = 50
*/


#ifndef UPAM_GBL_DEF
#define UPAM_GBL_DEF

#define TERM 25
#define EOSEQ 0
#define MAXSQ 60	/* increased to accomodate ESS=57 */
#define MAXUC 28
#define MAXLC 56

#define MAXHASH 32
#define NMAP MAXHASH+1

struct std_pam_str {
  char abbrev[6];	/* argument name */
  char name[10];	/* canonical name */
  int *pam;		/* data pointer */
  float scale;		/* pam scale (ln(2)/2, ln(2)/3 */
  float ulambda;	/* lambda (ungapped) */
  float entropy;	/* bits/position */
  float tfract_id;	/* target fract id */
  int gdel, ggap;	/* gdel, ggap */
};

#ifndef XTERNAL

int pamoff=0;

/*extern int gdelval, ggapval;*/

/* char sqnam[]="aa"; */
/* char sqtype[]="protein"; */


/* this alphabet covers 56 values, so that libraries can include lower-case characters which will be re-mapped unless -S */
char *NCBIstdaa = "-ABCDEFGHIKLMNPQRSTVWXYZU*OJ";
char *NCBIstdaa_l = "-ABCDEFGHIKLMNPQRSTVWXYZU*OJ-ABCDEFGHIKLMNPQRSTVWXYZU*OJ";
char NCBIstdaa_n = 28;

char *NCBIstdaa_ext = "-ABCDEFGHIKLMNPQRSTVWXYZU*OJ-abcdefghiklmnpqrstvwxyzu*oj";
char NCBIstdaa_ext_n = 56;

/* the residue ordering used for the internal pam matrices */
char *pam_sq;
int pam_sq_n;
char *apam_sq  = "\0ARNDCQEGHILKMFPSTWYVBZX*";
int apam_sq_n = 25;
char *npam_sq =  "\0ACGTURYMWSKDHVBNX";
int npam_sq_n = 17;

/* these values have been replaced by NCBIstdaa and *pam_sq */
/*
char aa[MAXSQ+1]  = {"\0ARNDCQEGHILKMFPSTWYVBZX*JARNDCQEGHILKMFPSTWYVBZX*J\0"};
char aax[MAXSQ+1] = {"\0ARNDCQEGHILKMFPSTWYVBZX*Jarndcqeghilkmfpstwyvbzx*j\0"};
*/
char pssm_aa[26]  = {"\0ARNDCQEGHILKMFPSTWYVBZX*"};

char othx[MAXSQ+1] = {"OUou\0"};
int noth = 2;
int nothx = 4;

int naa = 25;	/* this should be calculated from aa[] */
int naax = 50;

/* haa[] used to map all valid amino acid codes into a hash value;
   now, there is an additional hash value - not-mapped - NM */

/* this has been expanded to accomodate '*' */
  /* 0 A R N D C Q E G H  I  L  K  M  F  P  S  T  W  Y  V B Z X    *    J */
/*
int haa[MAXSQ+1] = {
  NMAP,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,3,7,NMAP,NMAP,10,
       1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,3,7,NMAP,NMAP,10};
*/
int h_NCBIstdaa[MAXSQ+1] = {
  /* - A  B C D E F G H I  K  L  M  N  P  Q  R  S  T  V  W    X  Y  Z  U  *    O  J */
  NMAP,1,13,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,NMAP,21, 5, 3,NMAP,10,11,
  NMAP,1,13,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,NMAP,21, 5, 3,NMAP,10,11
};

int h_NCBIstdaa_ext[MAXSQ+1] = {
  /* - A  B C D E F G H I  K  L  M  N  P  Q  R  S  T  V  W    X  Y  Z  U  *    O  J */
  NMAP,1,13,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,NMAP,21, 5, 3,NMAP,10,11,
  NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,
  NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,
};

/*
int haax[MAXSQ+1] = {
  NMAP, 1,2,3,4,5,6,7,8,9,
  10,11,12,13,14,15,16,17,18,19,
  20,3,7,NMAP,NMAP,10,NMAP,NMAP,NMAP,NMAP,
  NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,
  NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,
  NMAP};
*/

/*
  PAM 250 substitution matrix, scale = ln(2)/3 = 0.231049
  Expected score = -0.844, Entropy = 0.354 bits
  Lowest score = -8, Highest score = 17
*/
int apam250[450] = {
 2,
-2, 6,
 0, 0, 2,
 0,-1, 2, 4,
-2,-4,-4,-5,12,
 0, 1, 1, 2,-5, 4,
 0,-1, 1, 3,-5, 2, 4,
 1,-3, 0, 1,-3,-1, 0, 5,
-1, 2, 2, 1,-3, 3, 1,-2, 6,
-1,-2,-2,-2,-2,-2,-2,-3,-2, 5,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
-1, 3, 1, 0,-5, 1, 0,-2, 0,-2,-3, 5,
-1, 0,-2,-3,-5,-1,-2,-3,-2, 2, 4, 0, 6,
-4,-4,-4,-6,-4,-5,-5,-5,-2, 1, 2,-5, 0, 9,
 1, 0,-1,-1,-3, 0,-1,-1, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 0, 0,-1, 0, 1,-1,-1,-3, 0,-2,-3, 1, 2,
 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 3,
-6, 2,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 0,-6,-2,-5,17,
-3,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-4,-2, 7,-5,-3,-3, 0,10,
 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
 0,-1, 2, 3,-4, 1, 2, 0, 1,-2,-3, 1,-2,-5,-1, 0, 0,-5,-3,-2, 2,
 0, 0, 1, 3,-5, 3, 3,-1, 2,-2,-3, 0,-2,-5, 0, 0,-1,-6,-4,-2, 2, 3,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1, 8};

/*
 This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
 PAM 120 substitution matrix, scale = ln(2)/2 = 0.346574
 Expected score = -1.64, Entropy = 0.979 bits
 Lowest score = -8, Highest score = 12
*/
int apam120[450] = {
  3,
 -3, 6,
  0,-1, 4,
  0,-3, 2, 5,
 -3,-4,-5,-7, 9,
 -1, 1, 0, 1,-7, 6,
  0,-3, 1, 3,-7, 2, 5,
  1,-4, 0, 0,-5,-3,-1, 5,
 -3, 1, 2, 0,-4, 3,-1,-4, 7,
 -1,-2,-2,-3,-3,-3,-3,-4,-4, 6,
 -3,-4,-4,-5,-7,-2,-4,-5,-3, 1, 5,
 -2, 2, 1,-1,-7, 0,-1,-3,-2,-2,-4, 5,
 -2,-1,-3,-4,-6,-1,-4,-4,-4, 1, 3, 0, 8,
 -4,-4,-4,-7,-6,-6,-6,-5,-2, 0, 0,-6,-1, 8,
  1,-1,-2,-2,-3, 0,-1,-2,-1,-3,-3,-2,-3,-5, 6,
  1,-1, 1, 0,-1,-2,-1, 1,-2,-2,-4,-1,-2,-3, 1, 3,
  1,-2, 0,-1,-3,-2,-2,-1,-3, 0,-3,-1,-1,-4,-1, 2, 4,
 -7, 1,-5,-8,-8,-6,-8,-8,-5,-7,-5,-5,-7,-1,-7,-2,-6, 12,
 -4,-6,-2,-5,-1,-5,-4,-6,-1,-2,-3,-6,-4, 4,-6,-3,-3,-1, 8,
  0,-3,-3,-3,-2,-3,-3,-2,-3, 3, 1,-4, 1,-3,-2,-2, 0,-8,-3, 5,
  0,-2, 3, 4,-6, 0, 3, 0, 1,-3,-4, 0,-4,-5,-2, 0, 0,-6,-3,-3, 4,
 -1,-1, 0, 3,-7, 4, 4,-2, 1,-3,-3,-1,-2,-6,-1,-1,-2,-7,-5,-3, 2, 4,
 -1,-2,-1,-2,-4,-1,-1,-2,-2,-1,-2,-2,-2,-3,-2,-1,-1,-5,-3,-1,-1,-1,-2,
 -1,-2,-1,-2,-4,-1,-1,-2,-2,-1,-2,-2,-2,-3,-2,-1,-1,-5,-3,-1,-1,-1,-2, 6};

/*
#
#  VTML_10
#
# This matrix was produced from: vtml_10qij.mat using robinson2.back background frequencies
#
# VTML_10 substitution matrix, Units = bits/2.0
# Expected score = -3.859581 bits; Entropy = 3.462930 bits
# Target fraction identity = 0.9107
# Lowest Score = -20, Highest Score= 12
#
*/
int a_vt10[450] = {
   7,
  -9,   8,
  -8,  -7,   9,
  -8, -16,  -3,   8,
  -5,  -9, -10, -18,  11,
  -7,  -4,  -6,  -6, -17,   9,
  -7, -14,  -7,  -3, -18,  -3,   8,
  -6,  -9,  -7,  -8, -10, -10,  -8,   7,
  -9,  -5,  -4,  -6,  -9,  -4,  -8,  -9,  11,
  -9, -10, -11, -15,  -8, -12, -12, -19, -11,   8,
  -9, -10, -11, -19, -17,  -8, -10, -13,  -8,  -3,   7,
  -8,  -2,  -5,  -7, -17,  -4,  -4,  -9,  -7, -10, -10,   8,
  -7,  -8,  -9, -11,  -7,  -6, -10, -12, -15,  -3,  -2,  -7,  11,
 -10, -12, -13, -20, -17, -10, -18, -13,  -6,  -6,  -5, -18,  -4,   9,
  -6,  -8, -10,  -8, -11,  -7,  -8, -10,  -8, -12,  -9,  -7, -12, -10,   8,
  -4,  -7,  -4,  -7,  -5,  -6,  -6,  -6,  -6, -11, -10,  -7, -10,  -8,  -6,   7,
  -5,  -8,  -5,  -8,  -8,  -7,  -7, -10,  -7,  -6,  -9,  -6,  -6, -10,  -8,  -3,   8,
 -11, -10, -12, -12, -20, -19, -20, -11,  -8,  -8,  -8, -10, -16,  -4, -11, -10, -19,  12,
 -10,  -9,  -8, -17,  -7, -16,  -9, -13,  -3,  -9,  -8, -10, -15,  -1, -19,  -8, -10,  -4,  10,
  -5, -11, -11, -11,  -6,  -9,  -9, -12, -10,  -1,  -5,  -9,  -5,  -8, -10, -10,  -6, -17,  -9,   8,
  -8, -11,   3,   2, -14,  -6,  -5,  -7,  -5, -13, -15,  -6, -10, -16,  -9,  -5,  -6, -12, -12, -11,   8,
  -7,  -9,  -6,  -4, -17,   3,   2,  -9,  -6, -12,  -9,  -4,  -8, -14,  -7,  -6,  -7, -19, -12,  -9,  -4,   8,
  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   -1
};

/*
#
#  VTML_20
#
# This matrix was produced from: vtml_20qij.mat using robinson2.back background frequencies
#
# VTML_20 substitution matrix, Units = bits/2.0
# Expected score = -2.889610 bits; Entropy = 2.921119 bits
# Target fraction identity = 0.8312
# Lowest Score = -16, Highest Score= 12
#
*/
int a_vt20[450] = {
   7,
  -7,   8,
  -6,  -5,   8,
  -6, -12,  -1,   8,
  -3,  -7,  -8, -14,  11,
  -5,  -2,  -4,  -4, -13,   8,
  -5, -10,  -5,  -1, -14,  -1,   7,
  -4,  -7,  -5,  -6,  -8,  -8,  -6,   7,
  -7,  -3,  -3,  -5,  -7,  -2,  -6,  -7,  10,
  -7,  -8,  -9, -13,  -6, -10, -10, -15,  -9,   8,
  -7,  -8,  -9, -15, -13,  -7,  -8, -11,  -7,  -1,   6,
  -6,   0,  -3,  -5, -14,  -2,  -2,  -7,  -5,  -8,  -8,   8,
  -5,  -6,  -7,  -9,  -5,  -5,  -8, -10, -12,  -1,   0,  -5,  10,
  -8, -10, -10, -16, -13,  -8, -14, -11,  -5,  -4,  -3, -14,  -2,   9,
  -4,  -6,  -8,  -6,  -9,  -5,  -6,  -8,  -6, -10,  -7,  -6, -10,  -8,   8,
  -2,  -6,  -2,  -5,  -4,  -4,  -5,  -4,  -4,  -9,  -8,  -5,  -8,  -6,  -4,   7,
  -3,  -6,  -4,  -6,  -6,  -5,  -6,  -8,  -5,  -4,  -7,  -4,  -4,  -8,  -6,  -1,   8,
  -9,  -8, -10, -11, -16, -15, -16,  -9,  -6,  -6,  -6,  -8, -12,  -3,  -9,  -8, -15,  12,
  -8,  -7,  -6, -14,  -5, -12,  -7, -10,  -1,  -7,  -6,  -8, -11,   1, -15,  -6,  -8,  -2,   9,
  -3,  -9,  -9,  -9,  -4,  -7,  -7, -10,  -8,   1,  -3,  -8,  -3,  -6,  -8,  -8,  -4, -13,  -7,   7,
  -6,  -8,   3,   3, -11,  -4,  -3,  -5,  -4, -11, -12,  -4,  -8, -13,  -7,  -3,  -5, -10, -10,  -9,   8,
  -5,  -6,  -4,  -3, -13,   3,   3,  -7,  -4, -10,  -7,  -2,  -6, -11,  -5,  -4,  -5, -15,  -9,  -7,  -2,   7,
  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   -1
};

/*
#
#  VTML_40
#
# This matrix was produced from: vtml_40qij.mat using robinson2.back background frequencies
#
# VTML_40 substitution matrix, Units = bits/2.0
# Expected score = -1.963330 bits; Entropy = 2.266217 bits
# Target fraction identity = 0.6968
# Lowest Score = -13, Highest Score= 12
#
*/
int a_vt40[450] = {
   6,
  -5,   8,
  -4,  -3,   8,
  -4,  -8,   0,   7,
  -1,  -5,  -6, -10,  11,
  -3,   0,  -2,  -3, -10,   8,
  -3,  -7,  -3,   1, -11,   0,   7,
  -2,  -5,  -3,  -4,  -6,  -6,  -5,   7,
  -5,  -1,  -1,  -3,  -5,   0,  -4,  -5,  10,
  -5,  -6,  -7, -10,  -4,  -7,  -8, -12,  -7,   7,
  -5,  -6,  -7, -11,  -9,  -5,  -7,  -9,  -5,   1,   6,
  -4,   2,  -2,  -3, -10,  -1,  -1,  -5,  -3,  -6,  -6,   7,
  -4,  -4,  -5,  -7,  -3,  -3,  -6,  -8,  -8,   0,   1,  -4,   9,
  -6,  -8,  -8, -13, -10,  -7, -11,  -9,  -3,  -2,  -1, -10,  -1,   9,
  -3,  -5,  -6,  -4,  -7,  -4,  -4,  -6,  -4,  -8,  -5,  -4,  -7,  -7,   8,
   0,  -4,  -1,  -3,  -2,  -3,  -3,  -3,  -3,  -6,  -6,  -3,  -6,  -5,  -3,   6,
  -1,  -4,  -2,  -4,  -4,  -3,  -4,  -6,  -3,  -3,  -5,  -3,  -2,  -6,  -4,   0,   7,
  -7,  -6,  -8,  -9, -12, -12, -12,  -7,  -4,  -4,  -4,  -7,  -9,  -1,  -7,  -6, -11,  12,
  -6,  -5,  -4, -10,  -3,  -9,  -5,  -8,   0,  -5,  -4,  -6,  -7,   2, -11,  -5,  -6,   0,   9,
  -1,  -7,  -7,  -7,  -2,  -5,  -6,  -8,  -6,   3,  -1,  -6,  -1,  -4,  -6,  -6,  -2, -10,  -5,   7,
  -4,  -5,   4,   3,  -8,  -2,  -1,  -3,  -2,  -8,  -9,  -2,  -6, -10,  -5,  -2,  -3,  -8,  -7,  -7,   7,
  -3,  -4,  -2,  -1, -10,   4,   3,  -5,  -2,  -7,  -6,  -1,  -4,  -9,  -4,  -3,  -3, -12,  -7,  -5,   0,   7,
  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   -1
};

/*
#
#  VTML_80
#
# This matrix was produced from: vtml_80qij.mat using robinson2.back background frequencies
#
# VTML_80 substitution matrix, Units = bits/2.0
# Expected score = -1.137019 bits; Entropy = 1.390771 bits
# Target fraction identity = 0.5024
# Lowest Score = -9, Highest Score= 12
#
*/
int a_vt80[450] = {
   5,
  -3,   7,
  -2,  -1,   7,
  -2,  -5,   1,   7,
   0,  -4,  -4,  -7,  10,
  -2,   1,  -1,  -1,  -6,   6,
  -2,  -3,  -1,   2,  -7,   1,   6,
  -1,  -3,  -1,  -2,  -4,  -4,  -3,   6,
  -3,   0,   0,  -1,  -3,   0,  -2,  -4,   9,
  -3,  -5,  -5,  -7,  -2,  -5,  -5,  -8,  -4,   6,
  -3,  -4,  -5,  -8,  -6,  -3,  -5,  -7,  -3,   2,   5,
  -2,   3,  -1,  -2,  -6,   0,   0,  -3,  -1,  -4,  -4,   6,
  -2,  -3,  -4,  -5,  -2,  -2,  -4,  -6,  -5,   2,   2,  -2,   8,
  -4,  -5,  -6,  -9,  -6,  -5,  -7,  -7,  -1,  -1,   0,  -7,   0,   8,
  -1,  -3,  -4,  -3,  -5,  -2,  -2,  -4,  -3,  -5,  -4,  -2,  -5,  -5,   7,
   1,  -2,   0,  -1,  -1,  -2,  -1,  -1,  -1,  -4,  -4,  -1,  -4,  -3,  -1,   5,
   0,  -2,  -1,  -2,  -2,  -2,  -2,  -4,  -2,  -1,  -3,  -1,  -1,  -4,  -3,   1,   6,
  -5,  -4,  -6,  -7,  -9,  -8,  -8,  -5,  -2,  -2,  -2,  -5,  -5,   1,  -6,  -5,  -8,  12,
  -4,  -3,  -3,  -7,  -2,  -6,  -4,  -6,   2,  -3,  -2,  -4,  -4,   3,  -8,  -3,  -4,   1,   8,
   0,  -4,  -5,  -5,  -1,  -4,  -4,  -6,  -4,   3,   0,  -4,   0,  -2,  -4,  -4,  -1,  -6,  -4,   6,
  -2,  -3,   4,   4,  -5,  -1,   0,  -1,   0,  -6,  -6,  -1,  -4,  -7,  -3,   0,  -1,  -6,  -5,  -5,   7,
  -2,  -1,  -1,   0,  -6,   4,   3,  -3,  -1,  -5,  -4,   0,  -3,  -6,  -2,  -1,  -2,  -8,  -5,  -4,   0,   6,
  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   -1
};

/*
#
#  VTML_120
#
# This matrix was produced from: vtml_120qij.mat using robinson2.back background frequencies
#
# VTML_120 substitution matrix, Units = bits/2.0
# Expected score = -0.723803 bits; Entropy = 0.938201 bits
# Target fraction identity = 0.3748
# Lowest Score = -7, Highest Score= 11
#
*/
int a_vt120[450] = {
   4,
  -2,   6,
  -1,  -1,   6,
  -1,  -3,   2,   6,
   0,  -3,  -3,  -5,   9,
  -1,   1,   0,   0,  -5,   5,
  -1,  -2,   0,   2,  -5,   1,   5,
   0,  -2,  -1,  -1,  -3,  -3,  -2,   6,
  -2,   0,   1,  -1,  -3,   1,  -1,  -3,   8,
  -2,  -3,  -4,  -5,  -1,  -4,  -4,  -6,  -3,   5,
  -2,  -3,  -4,  -6,  -4,  -3,  -4,  -5,  -2,   2,   5,
  -1,   3,   0,  -1,  -5,   1,   1,  -2,   0,  -3,  -3,   5,
  -1,  -2,  -3,  -4,  -1,  -2,  -3,  -5,  -3,   2,   2,  -2,   7,
  -3,  -4,  -4,  -7,  -5,  -4,  -5,  -5,   0,   0,   1,  -5,   1,   7,
  -1,  -2,  -2,  -2,  -4,  -1,  -2,  -3,  -2,  -4,  -3,  -1,  -4,  -4,   7,
   1,  -1,   1,  -1,   0,  -1,  -1,  -1,  -1,  -3,  -3,  -1,  -2,  -2,  -1,   4,
   0,  -2,   0,  -1,  -1,  -1,  -1,  -2,  -1,   0,  -2,  -1,  -1,  -3,  -2,   1,   5,
  -4,  -3,  -5,  -6,  -7,  -6,  -6,  -4,  -1,  -2,  -2,  -4,  -4,   2,  -5,  -4,  -6,  11,
  -3,  -2,  -2,  -5,  -1,  -4,  -3,  -5,   2,  -2,  -1,  -3,  -3,   4,  -6,  -2,  -3,   2,   8,
   0,  -3,  -4,  -4,   0,  -3,  -3,  -4,  -3,   3,   1,  -3,   1,  -1,  -3,  -3,   0,  -4,  -2,   5,
  -1,  -2,   4,   4,  -4,   0,   1,  -1,   0,  -4,  -5,   0,  -3,  -5,  -2,   0,   0,  -5,  -3,  -4,   6,
  -1,   0,   0,   0,  -5,   3,   3,  -2,   0,  -4,  -3,   1,  -2,  -4,  -1,  -1,  -1,  -6,  -3,  -3,   0,   5,
  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   -1
};

/*
#     VTML160
#
# This matrix was produced with scripts written by
# Tobias Mueller and Sven Rahmann [June-2001].
#
# VTML160 substitution matrix, Units = Third-Bits
# Expected Score = -1.297840 Third-Bits
# Lowest Score = -7, Highest Score = 16
#
# Entropy H = 0.562489 Bits
#
# 30-Jun-2001
*/
int a_vt160[450] = {
  5,
 -2, 7,
 -1, 0, 7,
 -1,-3, 3, 7,
  1,-3,-3,-5,13,
 -1, 2, 0, 1,-4, 6,
 -1,-1, 0, 3,-5, 2, 6,
  0,-3, 0,-1,-2,-3,-2, 8,
 -2, 1, 1, 0,-2, 2,-1,-3, 9,
 -1,-4,-4,-6,-1,-4,-5,-7,-4, 6,
 -2,-3,-4,-6,-4,-2,-4,-6,-3, 3, 6,
 -1, 4, 0, 0,-4, 2, 1,-2, 0,-4,-3, 5,
 -1,-2,-3,-5,-1,-1,-3,-5,-3, 2, 4,-2, 8,
 -3,-5,-5,-7,-4,-4,-6,-6, 0, 0, 2,-5, 1, 9,
  0,-2,-2,-1,-3,-1,-1,-3,-2,-4,-3,-1,-4,-5, 9,
  1,-1, 1, 0, 1, 0, 0, 0,-1,-3,-3,-1,-3,-3, 0, 4,
  1,-1, 0,-1, 0,-1,-1,-2,-1,-1,-2,-1,-1,-3,-1, 2, 5,
 -5,-4,-5,-7,-7,-6,-7,-5,-1,-2,-1,-5,-4, 3,-5,-4,-6,16,
 -3,-3,-2,-5,-1,-4,-3,-5, 3,-2,-1,-3,-2, 6,-6,-2,-3, 4,10,
  0,-4,-4,-4, 1,-3,-3,-5,-3, 4, 2,-3, 1,-1,-3,-2, 0,-5,-3, 5,
 -1,-2, 5, 6,-4, 0, 2,-1, 0,-5,-5, 0,-4,-6,-2, 1, 0,-6,-3,-4, 5,
 -1, 0, 0, 3,-5, 4, 5,-2, 0,-4,-3, 2,-3,-5,-1, 0,-1,-7,-4,-3, 2, 5,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 -7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 6};

/*
#
#  VTML_200
#
# This matrix was produced from: vtml_200qij.mat using vtml_P.mat background frequencies
#
# VTML_200 substitution matrix, Units = bits/3.0
# Expected score = -0.358430 bits; Entropy = 0.412084 bits
# Target fraction identity = 0.2295
# Lowest Score = -6, Highest Score= 15
#
*/
int a_vt200[450] = {
  4,
 -2,  7,
 -1,  0,  6,
 -1, -2,  3,  6,
  1, -3, -2, -4, 12,
 -1,  2,  1,  1, -3,  5,
 -1, -1,  1,  3, -4,  2,  5,
  0, -2,  0, -1, -2, -2, -1,  8,
 -2,  1,  1,  0, -2,  2,  0, -2,  8,
 -1, -3, -4, -5,  0, -3, -4, -6, -3,  5,
 -2, -3, -4, -5, -3, -2, -4, -5, -2,  3,  5,
 -1,  4,  1,  0, -4,  2,  1, -2,  0, -3, -3,  5,
 -1, -2, -3, -4, -1, -1, -3, -4, -3,  2,  3, -2,  6,
 -3, -4, -4, -6, -3, -3, -5, -5,  0,  0,  2, -5,  1,  8,
  0, -1, -2, -1, -3, -1, -1, -2, -2, -4, -3, -1, -3, -4,  9,
  1, -1,  1,  0,  1,  0,  0,  0,  0, -3, -3,  0, -2, -3,  0,  4,
  1, -1,  0, -1,  0,  0, -1, -2, -1, -1, -2,  0, -1, -3, -1,  2,  4,
 -4, -3, -5, -6, -6, -6, -6, -5, -1, -2, -1, -4, -3,  3, -4, -4, -5, 15,
 -3, -2, -2, -4,  0, -3, -3, -5,  3, -2, -1, -3, -2,  5, -5, -2, -3,  4,  9,
  0, -3, -3, -4,  1, -2, -3, -4, -3,  4,  2, -3,  2, -1, -3, -2,  0, -4, -2,  4,
 -1, -1,  4,  4, -3,  1,  2,  0,  0, -4, -4,  0, -3, -5, -1,  0,  0, -5, -3, -3,  6,
 -1,  0,  1,  2, -3,  3,  3, -1,  1, -3, -3,  1, -2, -4, -1,  0,  0, -6, -3, -2,  2,  5,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  -1
};

/*
  Matrix made by matblas from blosum50.iij
  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
  Blocks Database = /data/blocks_5.0/blocks.dat
  Cluster Percentage: >= 50
  Entropy =   0.4808, Expected =  -0.3573
*/
/*
 A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  B  Z  X  * */
int abl50[450] = {
  5,
 -2, 7,
 -1,-1, 7,
 -2,-2, 2, 8,
 -1,-4,-2,-4,13,
 -1, 1, 0, 0,-3, 7,
 -1, 0, 0, 2,-3, 2, 6,
  0,-3, 0,-1,-3,-2,-3, 8,
 -2, 0, 1,-1,-3, 1, 0,-2,10,
 -1,-4,-3,-4,-2,-3,-4,-4,-4, 5,
 -2,-3,-4,-4,-2,-2,-3,-4,-3, 2, 5,
 -1, 3, 0,-1,-3, 2, 1,-2, 0,-3,-3, 6,
 -1,-2,-2,-4,-2, 0,-2,-3,-1, 2, 3,-2, 7,
 -3,-3,-4,-5,-2,-4,-3,-4,-1, 0, 1,-4, 0, 8,
 -1,-3,-2,-1,-4,-1,-1,-2,-2,-3,-4,-1,-3,-4,10,
  1,-1, 1, 0,-1, 0,-1, 0,-1,-3,-3, 0,-2,-3,-1, 5,
  0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 2, 5,
 -3,-3,-4,-5,-5,-1,-3,-3,-3,-3,-2,-3,-1, 1,-4,-4,-3,15,
 -2,-1,-2,-3,-3,-1,-2,-3, 2,-1,-1,-2, 0, 4,-3,-2,-2, 2, 8,
  0,-3,-3,-4,-1,-3,-3,-4,-4, 4, 1,-3, 1,-1,-3,-2, 0,-3,-1, 5,
 -2,-1, 4, 5,-3, 0, 1,-1, 0,-4,-4, 0,-3,-4,-2, 0, 0,-5,-3,-4, 5,
 -1, 0, 0, 1,-3, 4, 5,-2, 0,-3,-3, 1,-1,-4,-1, 0,-1,-2,-2,-3, 2, 5,
 -1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1, 0,-3,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1, 0,-3,-1,-1,-1,-1,-1, 7};

/*
  A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   * */
int a_md10[450]= {
 11,	/* A */
-12, 12,	/* R */
-12,-13, 13,	/* N */
-11,-18, -3, 12,	/* D */
-13,-10,-14,-20, 17,	/* C */
-13, -5,-11,-13,-19, 13,	/* Q */
-10,-15,-12, -2,-22, -5, 12,	/* E */
 -8, -9,-11, -9,-12,-16, -9, 11,	/* G */
-16, -5, -5,-10,-12, -3,-15,-16, 16,	/* H */
-13,-17,-14,-19,-17,-20,-19,-21,-18, 12,	/* I */
-15,-14,-19,-21,-16,-12,-20,-21,-13, -7, 10,	/* L */
-14, -2, -6,-15,-21, -6, -8,-15,-13,-17,-18, 12,	/* K */
-13,-14,-15,-18,-15,-14,-18,-19,-15, -4, -4,-12, 16,	/* M */
-18,-22,-19,-22,-11,-22,-23,-22,-14,-11, -6,-23,-14, 14,	/* F */
 -7,-12,-17,-18,-18, -8,-17,-16,-10,-19,-10,-16,-17,-17, 13,	/* P */
 -5,-10, -4,-12, -7,-13,-15, -7,-11,-14,-13,-13,-15,-11, -6, 11,	/* S */
 -4,-12, -7,-14,-14,-13,-15,-14,-13, -7,-16,-10, -7,-19, -9, -4, 12,	/* T */
-21, -9,-21,-21,-10,-17,-21,-13,-21,-21,-13,-21,-17,-13,-21,-15,-18, 18,	/* W */
-20,-17,-12,-13, -7,-16,-21,-20, -3,-15,-16,-20,-17, -3,-20,-12,-17,-12, 15,	/* Y */
 -6,-17,-17,-15,-12,-17,-14,-13,-19, -1, -8,-18, -5,-12,-16,-14,-10,-16,-18, 11,	/* V */
-12,-15,  5,  5,-17,-12, -7,-10, -7,-16,-20,-11,-17,-21,-17, -8,-10,-22,-13,-16, 13,	/* B */
-16,-18,-17, -8,-32,  1,  9,-17,-17,-29,-26,-11,-24,-34,-21,-21,-21,-29,-29,-22, -9, 13, /* Z */
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,	/* X */
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9};	/* * */

int a_md20[450] = {
 10,
-10, 12,
 -9,-10, 13,
 -8,-14, -1, 12,
-10, -7,-11,-16, 17,
-10, -3, -8, -9,-16, 13,
 -7,-11, -9,  1,-19, -3, 11,
 -5, -6, -8, -6, -9,-12, -7, 11,
-12, -3, -2, -7, -9,  0,-12,-13, 15,
-10,-14,-11,-16,-14,-16,-16,-17,-14, 12,
-12,-11,-15,-18,-13, -9,-17,-18,-10, -4, 10,
-11,  0, -4,-12,-17, -3, -5,-12, -9,-14,-15, 12,
 -9,-11,-12,-15,-12,-11,-15,-16,-12, -1, -2, -9, 15,
-15,-19,-16,-19, -8,-18,-20,-19,-11, -8, -4,-19,-10, 13,
 -5, -9,-13,-15,-14, -5,-14,-12, -7,-15, -7,-13,-14,-14, 12,
 -2, -8, -1, -9, -4,-10,-12, -5, -8,-11,-10,-10,-12, -8, -3, 10,
 -1, -9, -4,-11,-10,-10,-12,-11,-10, -4,-12, -7, -4,-15, -7, -1, 11,
-17, -6,-18,-18, -7,-14,-18,-10,-17,-17,-10,-17,-14,-10,-18,-12,-15, 18,
-16,-14, -9,-11, -4,-12,-18,-17,  0,-12,-12,-17,-14,  0,-16, -9,-13, -9, 14,
 -3,-14,-14,-12, -9,-14,-11,-11,-15,  2, -5,-15, -2, -9,-13,-11, -7,-13,-14, 11,
 -9,-12,  6,  6,-14, -9, -4, -7, -4,-13,-17, -8,-13,-18,-14, -5, -7,-19,-10,-13, 12,
-12,-13,-13, -4,-27,  4, 10,-13,-12,-24,-21, -6,-20,-29,-17,-17,-17,-24,-24,-18, -6, 12,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9 };

int a_md40[450] = {
  9,
 -7, 11,
 -6, -6, 12,
 -6,-10,  1, 11,
 -7, -5, -8,-13, 16,
 -7,  0, -5, -6,-12, 12,
 -5, -8, -5,  3,-15,  0, 11,
 -3, -4, -5, -4, -7, -9, -4, 10,
 -9,  0,  0, -4, -6,  2, -8,-10, 14,
 -6,-10, -8,-12,-11,-12,-12,-13,-11, 11,
 -9, -9,-12,-14,-10, -6,-13,-14, -7, -1,  9,
 -8,  3, -1, -8,-12, -1, -3, -9, -6,-11,-12, 11,
 -6, -8, -9,-12, -9, -8,-11,-12, -9,  1,  1, -7, 14,
-11,-15,-12,-15, -5,-14,-16,-15, -7, -5, -1,-16, -7, 13,
 -2, -6, -9,-11,-11, -3,-11, -9, -4,-11, -5,-10,-10,-11, 12,
  0, -5,  1, -6, -2, -7, -8, -2, -6, -8, -7, -7, -8, -6, -1,  9,
  1, -6, -2, -8, -7, -7, -8, -7, -7, -2, -9, -5, -2,-11, -4,  1, 10,
-14, -4,-14,-15, -4,-11,-15, -7,-13,-13, -8,-13,-11, -7,-14, -9,-12, 18,
-13,-10, -6, -8, -2, -9,-14,-13,  2, -9, -9,-13,-11,  2,-13, -7,-10, -6, 14,
 -1,-11,-10, -9, -7,-11, -8, -8,-12,  4, -2,-12,  0, -6, -9, -7, -4,-10,-11, 10,
 -6, -8,  6,  6,-10, -6, -1, -4, -2,-10,-13, -5,-10,-14,-10, -3, -5,-15, -7,-10, 11,
 -8, -8, -8,  0,-21,  6, 10, -8, -7,-18,-16, -3,-15,-23,-12,-12,-12,-19,-18,-14, -3, 11,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9};

/*
  Matrix made by matblas from blosum62.iij
  * column uses minimum score
  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
  Blocks Database = /data/blocks_5.0/blocks.dat
  Cluster Percentage: >= 62
  Entropy =   0.6979, Expected =  -0.5209
*/

int abl62[450] = {
  4,
 -1, 5,
 -2, 0, 6,
 -2,-2, 1, 6,
  0,-3,-3,-3, 9,
 -1, 1, 0, 0,-3, 5,
 -1, 0, 0, 2,-4, 2, 5,
  0,-2, 0,-1,-3,-2,-2, 6,
 -2, 0, 1,-1,-3, 0, 0,-2, 8,
 -1,-3,-3,-3,-1,-3,-3,-4,-3, 4,
 -1,-2,-3,-4,-1,-2,-3,-4,-3, 2, 4,
 -1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-2, 5,
 -1,-1,-2,-3,-1, 0,-2,-3,-2, 1, 2,-1, 5,
 -2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
 -1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,
  1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4,
  0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,
 -3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1, 1,-4,-3,-2,11,
 -2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
  0,-3,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
 -2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4,
 -1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-3, 1,-1,-3,-1, 0,-1,-3,-2,-2, 1, 4,
  0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
  0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1, 6};

/* blosum80 in 1/2 bit units (previous versions had 1/3 bit units) */
/*
  Matrix made by matblas from blosum80.iij
  * column uses minimum score
  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
  Blocks Database = /data/blocks_5.0/blocks.dat
  Cluster Percentage: >= 80
  Entropy =   0.9868, Expected =  -0.7442
*/

int abl80[450] = {
  5,
 -2, 6,
 -2,-1, 6,
 -2,-2, 1, 6,
 -1,-4,-3,-4, 9,
 -1, 1, 0,-1,-4, 6,
 -1,-1,-1, 1,-5, 2, 6,
  0,-3,-1,-2,-4,-2,-3, 6,
 -2, 0, 0,-2,-4, 1, 0,-3, 8,
 -2,-3,-4,-4,-2,-3,-4,-5,-4, 5,
 -2,-3,-4,-5,-2,-3,-4,-4,-3, 1, 4,
 -1, 2, 0,-1,-4, 1, 1,-2,-1,-3,-3, 5,
 -1,-2,-3,-4,-2, 0,-2,-4,-2, 1, 2,-2, 6,
 -3,-4,-4,-4,-3,-4,-4,-4,-2,-1, 0,-4, 0, 6,
 -1,-2,-3,-2,-4,-2,-2,-3,-3,-4,-3,-1,-3,-4, 8,
  1,-1, 0,-1,-2, 0, 0,-1,-1,-3,-3,-1,-2,-3,-1, 5,
  0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-2, 1, 5,
 -3,-4,-4,-6,-3,-3,-4,-4,-3,-3,-2,-4,-2, 0,-5,-4,-4,11,
 -2,-3,-3,-4,-3,-2,-3,-4, 2,-2,-2,-3,-2, 3,-4,-2,-2, 2, 7,
  0,-3,-4,-4,-1,-3,-3,-4,-4, 3, 1,-3, 1,-1,-3,-2, 0,-3,-2, 4,
 -2,-2, 4, 4,-4, 0, 1,-1,-1,-4,-4,-1,-3,-4,-2, 0,-1,-5,-3,-4, 4,
 -1, 0, 0, 1,-4, 3, 4,-3, 0,-4,-3, 1,-2,-4,-2, 0,-1,-4,-3,-3, 0, 4,
 -1,-1,-1,-2,-3,-1,-1,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1,
 -1,-1,-1,-2,-3,-1,-1,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1, 6};

/* OPTIMA_5 matrix: Kann et al. (2000) Proteins 41:498-503 */

int aopt5[450] = {
  7,
 -2,11,
 -4, 1,12,
 -4,-4, 4,13,
  1,-6,-6,-6,20,
 -1, 2, 0, 0,-6, 9,
 -2, 0, 1, 4,-8, 4, 8,
  1,-4, 1,-2,-6,-4,-5,13,
 -4, 1, 2,-2,-6, 0, 0,-4,17,
 -1,-6,-6,-7,-1,-6,-7,-8,-6, 7,
 -1,-4,-7,-9,-1,-5,-6,-8,-5, 6, 6,
 -2, 6, 0,-1,-6, 3, 3,-4,-1,-6,-4, 7,
 -2,-2,-4,-6,-2, 0,-4,-6,-4, 2, 5,-2,10,
 -4,-6,-6,-7,-4,-6,-6,-6,-2, 1, 3,-6, 0,11,
 -1,-4,-4,-1,-6,-2,-1,-4,-4,-6,-7,-2,-4,-8,15,
  2,-2, 2, 1,-2, 0, 0, 0,-2,-4,-4, 1,-2,-4,-2, 7,
  0,-2, 0,-2,-2,-2,-1,-3,-4,-2,-3,-2,-1,-4,-2, 4, 9,
 -6,-6,-8,-8,-4,-4,-6,-4,-4,-6,-3,-6,-2, 3,-8,-6,-4,22,
 -4,-3,-4,-4,-4,-2,-4,-6, 4,-2, 0,-4,-2, 7,-6,-4,-4, 4,14,
  1,-7,-6,-6,-1,-4,-6,-6,-6, 7, 3,-5, 2, 0,-4,-5, 1,-6,-2, 8,
 -4,-1, 8,10,-6, 0, 3, 0, 1,-7,-8, 0,-5,-6,-2, 1,-1,-8,-4,-6, 9,
 -1, 1, 0, 3,-7, 6, 6,-4, 0,-6,-6, 3,-2,-6,-2, 0,-1,-5,-3,-5, 2, 6,
 -2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
 -2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,10};

/*	DNA alphabet

	A, C, G, T, U   1-4, 5
	R, Y            6, 7
	M (A or C)	8
	W (A or T)	9
	S (C or G)	10
	K (G or T)	11
	D (not C)	12
	H (not G)	13
	V (not T)	14
	B (not A)	15
	N		16
	X 		17
*/

char nt[MAXSQ+1] ={"\0ACGTURYMWSKDHVBNXACGTURYMWSKDHVBNX\0"};
char ntx[MAXSQ+1]={"\0ACGTURYMWSKDHVBNXacgturymwskdhvbnx\0"};
char ntc[MAXSQ+1]={"\0TGCAAYRKWSMHDBVNXtgcaayrkwsmhdbvnx\0"};

/* nt complement to encoding */
                     /* A:T C:G G:C T:A U:A */
int gc_nt[MAXSQ+1]={ 0,  4,  3,  2,  1,  1,
                     /* R:Y Y:R M:K W:W */
 		         7,  6, 11,  9,
                     /* S:S K:M D:H H:D */
		        10,  8, 13, 12,
                     /* B:V V:B N:N X:X */
		        15, 14, 16, 16};

int nnt = 17;
int nntx = 34;

int hnt[MAXSQ+1] = {
  NMAP,0,1,2,3,3,0,1,0,0,1,2,0,0,0,1,NMAP,
  NMAP,0,1,2,3,3,0,1,0,0,1,2,0,0,0,1,NMAP,NMAP};
int hntx[MAXSQ+1] = {
  NMAP,0,1,2,3,3,0,1,0,0,1,2,0,0,0,1,NMAP,
  NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,
  NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP};

int npam[450] = {
/*       A  C  G  T  U  R  Y  M  W  S  K  D  H  V  B  N  X  */
	 5,						/* A */
	-4, 5,						/* C */
	-4,-4, 5,					/* G */
	-4,-4,-4, 5,					/* T */
	-4,-4,-4, 5, 5,					/* U */
	 2,-1, 2,-1,-1, 2,				/* R (A G)*/
	-1, 2,-1, 2, 2,-2, 2,				/* Y (C T)*/
	 2, 2,-1,-1,-1,-1,-1, 2,			/* M (A C)*/
	 2,-1,-1, 2, 2, 1, 1, 1, 2,			/* W (A T)*/
	-1, 2, 2,-1,-1, 1, 1, 1,-1, 2,			/* S (C G)*/
	-1,-1, 2, 2, 2, 1, 1,-1, 1, 1, 2,		/* K (G T)*/
	 1,-2, 1, 1, 1, 1,-1,-1, 1,-1, 1, 1,		/* D (!C) */
	 1, 1,-2, 1, 1,-1, 1, 1, 1,-1,-1,-1, 1,		/* H (!G) */
	 1, 1, 1,-2,-2, 1,-1, 1,-1, 1,-1,-1,-1, 1,	/* V (!T) */
	-2, 1, 1, 1, 1,-1, 1,-1,-1, 1, 1,-1,-1,-1, 1,	/* B (!A) */
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, /* N */
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1}; /* X */
/*       A  C  G  T  U  R  Y  M  W  S  K  D  H  V  B  N  */

int *pam;			/* Pam matrix- 1D */
/* int *pam12; */
/* int *pam12x; */
int pamh1[MAXSQ+1];		/* used for kfact replacement */

/* according to Reese and Pearson (2002) Bioinformatics 18:1500-1507
the most effective gap penalties for matrices in 1/3 bit united are:
 open = 25 - 0.1 * Pam_distance; ext = 5
*/

/* 16-Nov-2010 modified for modern gap open/gap extend
 */


/* must be ordered by entropy to adjust scoring matrix for query
   length */

#include <math.h>
#ifndef M_LN2
#define M_LN2 0.69314718055994530942
#endif

#define BIT2_SCALE M_LN2/2.0
#define BIT3_SCALE M_LN2/3.0
#define BIT5_SCALE M_LN2/5.0

/* abbrev, name, matrix, scale, ulambda, entropy, tfract_id, gopen, gext */
struct std_pam_str std_pams[] = {
  {"VT10", "VT10",   a_vt10,  BIT2_SCALE, 0.2299, 3.4474, 0.9107, -16, -2},
  {"P10",  "MD10",   a_md10,  BIT3_SCALE, 0.2299, 3.4474, 0.9107, -23, -4},
  {"M10",  "MD10",   a_md10,  BIT3_SCALE, 0.2299, 3.4474, 0.9107, -23, -4},
  {"MD10", "MD10",   a_md10,  BIT3_SCALE, 0.2299, 3.46293, 0.9107, -23, -4},
  {"VT20", "VT20",   a_vt20,  BIT2_SCALE, 0.2300, 2.921119, 0.8312, -15, -2},
  {"P20",  "MD20",   a_md20,  BIT3_SCALE, 0.2300, 2.9397, 0.822, -22, -4},
  {"M20",  "MD20",   a_md20,  BIT3_SCALE, 0.2300, 2.9397, 0.822, -22, -4},
  {"MD20", "MD20",   a_md20,  BIT3_SCALE, 0.2300, 2.9397, 0.822, -22, -4},
  {"VT40", "VT40",   a_vt40,  BIT2_SCALE, 0.2305, 2.266217, 0.6968, -14, -2},
  {"P40",  "MD40",   a_md40,  BIT3_SCALE, 0.2305, 2.2284, 0.679, -21, -4},
  {"M40",  "MD40",   a_md40,  BIT3_SCALE, 0.2305, 2.2284, 0.679, -21, -4},
  {"MD40", "MD40",   a_md40,  BIT3_SCALE, 0.2305, 2.2284, 0.679, -21, -4},
  {"VT80", "VT80",   a_vt80,  BIT2_SCALE, 0.2305, 1.390771, 0.5024, -14, -2},
  {"BL80", "BL80",    abl80,  BIT2_SCALE, 0.2259, 0.9128, 0.392, -10, -2},
  {"VT120","VT120", a_vt120,  BIT2_SCALE, 0.3416, 0.938201, 0.3748,  -10, -1},
  {"P120","PAM120", apam120,  BIT3_SCALE, 0.3416, 0.9062, 0.353,  -14, -3},
  {"BL62", "BL62",    abl62,  BIT2_SCALE, 0.3716, 0.6979, 0.302, -11, -1},
  {"BP62", "BL62",    abl62,  BIT2_SCALE, 0.3716, 0.6979, 0.302, -11, -1},
  {"VT160","VT160", a_vt160,  BIT3_SCALE, 0.2263, 0.617215, 0.2884, -12, -2},
  {"BL50", "BL50",    abl50,  BIT3_SCALE, 0.2318, 0.4850, 0.273, -10, -2},
  {"OPT5","OPTIMA5",  aopt5,  BIT5_SCALE, 0.1432, 0.4560, 0.262, -18, -2},
  {"VT200","VTM200",a_vt200,  BIT3_SCALE, 0.2252, 0.4121, 0.2295, -10, -2},
  {"P250", "PAM250",apam250,  BIT3_SCALE, 0.2252, 0.3207, 0.185, -10, -2},
  {"\0",   "\0",       NULL,  0.0,         0.0,    0.0,   0.0,   0,  0}
};

/* Robinson & Robinson counts (based on old aa[] ordering) */
long rrcounts[25] = {
  0,
  35155,	/* A */
  23105,	/* R */
  20212,	/* N */
  24161,	/* D */
  8669,		/* C */
  19208,	/* Q */
  28354,	/* E */
  33229,	/* G */
  9906,		/* H */
  23161,	/* I */
  40625,	/* L */
  25872,	/* K */
  10101,	/* M */
  17367,	/* F */
  23435,	/* P */
  32070,	/* S */
  26311,	/* T */
  5990,		/* W */
  14488,	/* Y */
  29012,	/* V */
  0,		/* B */
  0,		/* Z */
  0,		/* X */
  0 		/* * */
};

long rrtotal = 450431;
#else

/* extern char sqnam[]; */
/* extern char sqtype[]; */
/* extern int gdelval, ggapval; */
extern int pamoff;

extern char *NCBIstdaa;
extern char *NCBIstdaa_l;
extern char NCBIstdaa_n;
extern char *NCBIstdaa_ext;
extern char NCBIstdaa_ext_n;
extern char *pam_sq;
extern char *apam_sq;
extern char *npam_sq;
extern int  pam_sq_n;
extern int  apam_sq_n;
extern int  npam_sq_n;

/*
extern char aa[MAXSQ+1];
extern char aax[MAXSQ+1];
*/
extern char pssm_aa[26];
extern char othx[MAXSQ+1];
extern char nt[MAXSQ+1];
extern char ntx[MAXSQ+1];
extern char ntc[MAXSQ+1];
extern int gc_nt[MAXSQ+1];

extern  int naa;
extern  int naax;
extern  int noth;
extern  int nothx;
extern  int nnt;
extern  int nntx;

extern int h_NCBIstdaa[MAXSQ+1];
extern int h_NCBIstdaa_ext[MAXSQ+1];
/*
extern  int haa[MAXSQ+1];
extern  int haax[MAXSQ+1];
*/
extern  int hnt[MAXSQ+1];
extern  int hntx[MAXSQ+1];
/* extern  int had[MAXSQ+1]; */

extern  int apam250[450];
extern  int apam120[450];
extern  int a_vt10[450];
extern  int a_vt20[450];
extern  int a_vt40[450];
extern  int a_vt80[450];
extern  int a_vt120[450];
extern  int a_vt160[450];
extern  int a_vt200[450];
extern	int a_md10[450];
extern  int a_md20[450];
extern  int a_md40[450];
extern  int abl50[450];
extern  int abl62[450];
extern  int abl80[450];
extern  int aopt5[450];
extern	int npam[450];
extern	int *pam;
/* extern  int *pam12; */
/* extern  int *pam12x; */
extern	int pamh1[MAXSQ+1];
extern  long rrcounts[25];
extern  long rrtotal;

extern struct std_pam_str std_pams[];
#endif
#endif
