
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/SeqCompareMain.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt;


import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.actions.*;
import edu.virginia.bioch.util.*;

import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;

public class SeqCompareMain extends JFrame
			implements ActionListener
{
	protected SaveTextAlignmentAction saveTextAlignmentAction;
	protected SaveSVGAlignmentAction saveSVGAlignmentAction;
	protected SaveSVGPathGraphAction saveSVGPathGraphAction;
	protected SaveAlignmentSetAction saveAlignmentSetAction;
	protected SaveOptionSetAction saveOptionSetAction;
	protected ShowPathDisplayAction showPathDisplayAction;
	protected AddOptionSetAction addOptionSetAction;
	protected StartNewAction createSeqCompare;
	protected BufferedReader alignmentSet;
	protected BufferedReader gffSet;

	public static void main( String[] args ) 
    {

		System.out.println("SeqCompareMain main");

		try {
				UIManager
						.setLookAndFeel(UIManager
						.getCrossPlatformLookAndFeelClassName());
		} catch (Exception e) {
				e.printStackTrace();
				System.exit(1);
		}

		//Create the top-level container and add contents to it.
		try {
			JFrame frame = new SeqCompareMain(args);
			frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			frame.pack();
			frame.setTitle("Near Optimal Alignment Display");
			frame.setVisible(true);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public SeqCompareMain( String[] args )
		throws Exception
	{
		System.out.println("SeqCompareMain constructor");

		setBackground( Color.white );

		alignmentSet = null;
		gffSet = null;

		processArgs( args );

		saveTextAlignmentAction = new SaveTextAlignmentAction( this );
		saveSVGAlignmentAction = new SaveSVGAlignmentAction( this );
		saveSVGPathGraphAction = new SaveSVGPathGraphAction( this );
		saveAlignmentSetAction = new SaveAlignmentSetAction( this );
		saveOptionSetAction = new SaveOptionSetAction( this );

		addOptionSetAction = new AddOptionSetAction( this );

		createSeqCompare = new StartNewAction( this, 
				                               alignmentSet, 
											   gffSet,
											   "application",
											   addOptionSetAction );

		createSeqCompare.addPropertyChangeListener( saveTextAlignmentAction );
		createSeqCompare.addPropertyChangeListener( saveSVGAlignmentAction );
		createSeqCompare.addPropertyChangeListener( saveSVGPathGraphAction );
		createSeqCompare.addPropertyChangeListener( saveAlignmentSetAction );
		createSeqCompare.addPropertyChangeListener( saveOptionSetAction );
		createSeqCompare.addPropertyChangeListener( addOptionSetAction );

		createSeqCompare.updateProperties();

		createMenus();
	}

	protected void processArgs( String[] args )
	{
		try { 

		if ( args.length == 0 )
		{
			alignmentSet = null;
			gffSet = null;
			
			// print a brief usage
			System.out.println(" ");
			System.out.println("Command line USAGE: ");
			System.out.println(" ");
			System.out.println("\tjava -jar noptdisplay.jar " + 
			                   "[-a <alignment set file>] [-f <gff file>]");
			System.out.println(" ");
			System.out.println("Now use the File menu to specify " + 
			                   "alignment sets and gff feature files... ");
			System.out.println(" ");

			return;
		}

		if ( args.length != 2 && args.length != 4 )
			throw new Exception("Incorrect number of arguments: "+args.length);

		for ( int i = 0; i < args.length; i++ )
		{
			// alignment set
			if ( args[i].equals( "-a" ) )
				alignmentSet = GenericReader.getFileReader( args[++i] );

			else if ( args[i].equals( "-A" ) )
				alignmentSet = GenericReader.getURLReader( args[++i] );

			// gff set
			else if ( args[i].equals( "-f" ) )
				gffSet = GenericReader.getFileReader( args[++i] );

			else if ( args[i].equals( "-F" ) )
				gffSet = GenericReader.getURLReader( args[++i] );

			else
				throw new Exception("Unrecognized Argument: " + args[i]);
		}

		} catch ( Exception e ) 
		{
			JOptionPane.showMessageDialog( this,
					  "Failed to properly process arguments! \n"
					                    + e.getMessage(),
									"Argument failure!",
									JOptionPane.ERROR_MESSAGE );
			alignmentSet = null;
			gffSet = null;
		}
	}


    protected void createMenus()
    {
        JMenuBar menuBar = new JMenuBar();
        setJMenuBar(menuBar);

        JMenu fileMenu = new JMenu("File");
        menuBar.add( fileMenu );
		fileMenu.setMnemonic(KeyEvent.VK_F);

		JMenuItem saveTextAlignment = new JMenuItem( saveTextAlignmentAction );
		fileMenu.add( saveTextAlignment );
		saveTextAlignment.setMnemonic(KeyEvent.VK_T);
		saveTextAlignment.setAccelerator(KeyStroke.getKeyStroke(
		                KeyEvent.VK_T, ActionEvent.ALT_MASK));

		JMenuItem saveSVGAlignment = new JMenuItem( saveSVGAlignmentAction );
		fileMenu.add( saveSVGAlignment );
		saveSVGAlignment.setMnemonic(KeyEvent.VK_X);
		saveSVGAlignment.setAccelerator(KeyStroke.getKeyStroke(
		                KeyEvent.VK_X, ActionEvent.ALT_MASK));

		JMenuItem saveSVGPathGraph = new JMenuItem( saveSVGPathGraphAction );
		fileMenu.add( saveSVGPathGraph );
		saveSVGPathGraph.setMnemonic(KeyEvent.VK_P);
		saveSVGPathGraph.setAccelerator(KeyStroke.getKeyStroke(
		                KeyEvent.VK_P, ActionEvent.ALT_MASK));

		JSeparator sep1 = new JSeparator();
		fileMenu.add( sep1 );

		JMenuItem saveAllAlignments = new JMenuItem( saveAlignmentSetAction );
		fileMenu.add( saveAllAlignments );
		saveAllAlignments.setMnemonic(KeyEvent.VK_S);
		saveAllAlignments.setAccelerator(KeyStroke.getKeyStroke(
		                KeyEvent.VK_S, ActionEvent.ALT_MASK));

		JMenuItem saveOptionSet = new JMenuItem( saveOptionSetAction );
		fileMenu.add( saveOptionSet );
		saveOptionSet.setMnemonic(KeyEvent.VK_O);
		saveOptionSet.setAccelerator(KeyStroke.getKeyStroke(
		                KeyEvent.VK_1, ActionEvent.ALT_MASK));

		JSeparator sep2 = new JSeparator();
		fileMenu.add( sep2 );

		JMenuItem loadOptions = new JMenuItem( addOptionSetAction );
		fileMenu.add( loadOptions );
		loadOptions.setMnemonic(KeyEvent.VK_A);
		loadOptions.setAccelerator(KeyStroke.getKeyStroke(
		                KeyEvent.VK_A, ActionEvent.ALT_MASK));

		JMenuItem load = new JMenuItem( createSeqCompare );
		fileMenu.add( load );
		load.setMnemonic(KeyEvent.VK_L);
		load.setAccelerator(KeyStroke.getKeyStroke(
		                KeyEvent.VK_L, ActionEvent.ALT_MASK));

		JSeparator sep3 = new JSeparator();
		fileMenu.add( sep3 );

        JMenuItem quitItem = new JMenuItem("Exit");
        fileMenu.add( quitItem );
        quitItem.addActionListener( this );
        quitItem.setActionCommand("quit");
		quitItem.setMnemonic(KeyEvent.VK_Q);
		quitItem.setAccelerator(KeyStroke.getKeyStroke(
		                KeyEvent.VK_Q, ActionEvent.ALT_MASK));

	}

	public void actionPerformed(ActionEvent e)
	{
		Object o = e.getSource();
		if ( o instanceof JMenuItem ) 
		{
			String command = e.getActionCommand();
			if ( command.equals("quit") )
				System.exit(0);
		}
	}

	public void repaint()
	{
		super.repaint();
		System.out.println("frame repaint");
	}
}	
