
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/actions/SaveSVGAlignmentAction.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.actions;


import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.scoringmatrices.*;

import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;
import java.beans.*;

import org.apache.batik.svggen.*;
import org.apache.batik.dom.*;
import org.apache.batik.dom.svg.*;
import org.w3c.dom.*;


public class SaveSVGAlignmentAction
	extends AbstractAction
	implements PropertyChangeListener
{
	protected JFileChooser fc;
	protected Component frame;
	protected AlignmentDisplayPanel adp;
	
	public SaveSVGAlignmentAction( Component f )
	{ 
		super("Save Current Alignment As SVG");
		fc = new JFileChooser();
		frame = f;
		adp = null;	
		setEnabled( false );
	}

	public void propertyChange(PropertyChangeEvent e)
	{
		if ( e.getPropertyName().equals( "setSeqCompare" ) )
		{
			SeqCompare sc = (SeqCompare)e.getNewValue();
			SeqComparePanel scp = sc.getSeqComparePanel();
			adp = scp.getAlignmentDisplayPanel();
			setEnabled( true );
		}
	}

	public void actionPerformed( ActionEvent e )
	{
		SwingUtilities.invokeLater( new Runnable() { public void run() {

		if (fc.showSaveDialog( frame ) == JFileChooser.APPROVE_OPTION)
		{
	        // Get a DOMImplementation
			DOMImplementation domImpl =
				GenericDOMImplementation.getDOMImplementation();
			
			// Create an instance of org.w3c.dom.Document
			Document document = domImpl.createDocument(null, "svg", null);

			// Create an instance of the SVG Generator
			SVGGeneratorContext ctx = 
					SVGGeneratorContext.createDefault(document);
			ctx.setEmbeddedFontsOn(true);
			SVGGenerator svgGenerator = new SVGGenerator(ctx,false);

			// Ask the AlignmentDisplayPanel to render into the 
			// SVG Graphics2D implementation
			adp.paintComponent(svgGenerator);

            // Stream out SVG to the standard output using UTF-8
            // character to byte encoding
			try {
				Writer out = new OutputStreamWriter(
				new FileOutputStream(fc.getSelectedFile()), "UTF-8");
				//FileWriter out = new FileWriter( fc.getSelectedFile() );

				svgGenerator.stream(out);
			} 
			catch (SVGGraphics2DIOException e)
			{ 
				System.err.println("Couldn't write SVG file");
				e.printStackTrace();
			}
			catch (IOException e) 
			{ 
				System.err.println("Couldn't save file");
				e.printStackTrace();
			}
		}
		}});
	}
}
