
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/conditions/Condition.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.conditions;


import java.lang.*;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import javax.swing.event.*;
import javax.swing.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.conditions.*;
import edu.virginia.bioch.nopt.conditions.types.*;
import edu.virginia.bioch.util.*;


public class Condition
	implements ItemListener
{

	protected boolean _on;
	protected String _name;
	protected String _type;
	protected String _desc;
	protected Vector _meetsCondition;

	protected boolean _selected;


	public void turnOn() { _on = true; }	
	public void turnOff() { _on = false; }	

	public Condition( String t, String n, String d )
	{
		System.out.println("Condition constructor");
		_type = t;
		_name = n;
		_desc = d;
		_on = false;
		_meetsCondition = new Vector();
		_selected = false;
	}

	//
	// For a new condition, override this method
	//
	public boolean addAlignment( Alignment a )
	{
		//
		//
		//
		_meetsCondition.add( new Boolean( true ) );
		return true;
	}

	public boolean conditionMet( int i )
	{
		// only consider a condition if it is turned on
		if ( _on )
		{
			boolean meets = ((Boolean)_meetsCondition.get(i)).booleanValue();
			if ( meets )
				return true;
			else
				return false;
		}
		else
			return true;
	}

	protected Vector getMeets()
	{ return _meetsCondition; }

	public String getName()
	{ return _name; }

	public String getDescription()
	{ return _desc; }

    public void itemStateChanged(ItemEvent e)
    {
		JCheckBox source = (JCheckBox)e.getItemSelectable();

		if ( (source.getName()).equals( _name ) )
		{
			if ( !_on )
				turnOn();
			else
				turnOff();
		}
	}

	public String toString()
	{
		String s = "Condition Name: " + _name + 
		           "   Type: " + _type ; 
		return s;
	}

	public String getType()
	{ return _type; }

	public boolean isSelected()
	{ return _selected; }

	public void setSelected( boolean b )
	{ _selected = b; }
}
