
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/conditions/types/LikeThisCondition.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.conditions.types;



import java.lang.*;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import javax.swing.event.*;
import javax.swing.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;


public class LikeThisCondition extends Condition
{

	protected Vector likeThisEdges;

	public static String getTypeId( )
	{ return "Align Like This Filter"; }

	public LikeThisCondition( String n, String d, Vector edges )
		throws Exception
	{
		super( LikeThisCondition.getTypeId(), n, d );
		System.out.println("LikeThisCondition constructor");
		likeThisEdges = edges;
	}

	//
	// This is where the actual condition is applied...
	//
	public boolean addAlignment( Alignment a )
	{
		Vector edges = a.getEdges();
	
		boolean meets = false;

		Iterator it = edges.iterator();
		int meetCount = 0;
		int meetLength = likeThisEdges.size();
		// if the alignment contains all of the edges in the likeThis list,
		// then we meet the condition
		while ( it.hasNext() )
		{
			EdgeKey key = (EdgeKey)it.next();

			Iterator itt = likeThisEdges.iterator();
			while (itt.hasNext())
			{
				EdgeKey likeKey = (EdgeKey)itt.next();

				if ( likeKey.equals( key ) )
				{
					meetCount++;
					break;
				}
			}
		}

		if ( meetCount == meetLength )
			meets = true;

		System.out.println( "   LikeThisCondition " + _name + " is " + meets ); 
		_meetsCondition.add( new Boolean( meets ) );

		return meets;
	}
}
