
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/conditions/types/ScoreCondition.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.conditions.types;



import java.lang.*;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import javax.swing.event.*;
import javax.swing.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;


public class ScoreCondition extends Condition
{

	protected float lowerBound;
	protected float upperBound;

	public static String getTypeId( )
	{ return "Score Filter"; }

	public ScoreCondition( String n, String d, float l, float u )
		throws Exception
	{
		super( ScoreCondition.getTypeId(), n, d );
		System.out.println("ScoreCondition constructor");
		lowerBound = l;
		upperBound = u;

		sanityCheck();
	}

	private void sanityCheck()
		throws Exception
	{
		if ( lowerBound < 0 || lowerBound > 1.0f  )
			throw( new Exception("lowerBound not between 1 and 0!"));

		if ( upperBound < 0 || upperBound > 1.0f ) 
			throw( new Exception("upperBound not between 1 and 0!"));

		if ( upperBound <= lowerBound  ) 
			throw( new Exception("upperBound <= lowerBound!"));
	}

	//
	// This is where the actual condition is applied...
	//
	public boolean addAlignment( Alignment a )
	{
		float score = (float)(a.getScore());
		float optimalScore = (float)(a.getAlignmentParameters()
									   .getOptimalScore());

		float lower = optimalScore * lowerBound;
		float upper = optimalScore * upperBound;

		if ( score >= lower && score <= upper )
		{
			_meetsCondition.add( new Boolean( true ) );
			return true;
		}
		else
		{
			_meetsCondition.add( new Boolean( false ) );
			return false;
		}
	}
}
