
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/display/ControlPanel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.display;


import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.actions.*;
import edu.virginia.bioch.nopt.editor.*;


class ControlPanel extends JPanel
	implements ActionListener
{
	protected JButton startPause;
	protected JButton stepForward;
	protected JButton stepBackward;
	protected JLabel jumpTo;
	protected JLabel speedLabel;
	protected JTextField location;
	protected JSlider positionSlider;
	protected ImageIcon playIcon;
	protected ImageIcon pauseIcon;
	protected ImageIcon stepForwardIcon;
	protected ImageIcon stepBackIcon;
	protected JRadioButton slowButton;
	protected JRadioButton medButton;
	protected JRadioButton fastButton;
	protected Color backgroundColor;
	protected JButton asText;
	protected AlignmentHandler ah;
	protected OptionHandler oh;
	protected Component parent;

	public ControlPanel( AlignmentHandler ah, 
	                     FontHandler fh, 
						 OptionHandler oh, 
						 Component parent )
	{
		System.out.println("ControlPanel constructor");
		this.ah = ah;
		this.oh = oh;
		this.parent = parent;
		
		//backgroundColor = new Color(240,250,240);
		backgroundColor = Color.white; 

		setLayout(new FlowLayout(FlowLayout.LEFT));

		playIcon = createIcon("images/play.png","Play");
		pauseIcon = createIcon("images/pause.png","Pause");
		stepForwardIcon = createIcon("images/stepForward.png","Step Forward");
		stepBackIcon = createIcon("images/stepBackward.png","Step Backward");

		stepBackward = new JButton(stepBackIcon); 
		stepBackward.setActionCommand("Step Backward"); 
		add(stepBackward);
		stepBackward.addActionListener(this);
		stepBackward.setToolTipText("Step backward one alignment and pause.");

		startPause = new JButton(playIcon); 
		startPause.setActionCommand("Play");
		add(startPause);
		startPause.addActionListener(this);
		startPause.setToolTipText("Start Animation");

		stepForward = new JButton(stepForwardIcon); 
		stepForward.setActionCommand("Step Forward"); 
		add(stepForward);
		stepForward.addActionListener(this);
		stepForward.setToolTipText("Step forward one alignment and pause.");

		// figure out the tick spacing
		int numAlignments = ah.getNumAlignments();
		int factor = 1;
		while ( numAlignments/factor > 10 ) 
			factor *= 10; 
		if ( numAlignments > 20 )
			factor *= 2;
	
		positionSlider = new JSlider(JSlider.HORIZONTAL, 0, 
	                             ah.getNumAlignments(), 0);
		positionSlider.setMajorTickSpacing(factor);
        positionSlider.setPaintTicks(true);
        positionSlider.setPaintLabels(true);
		Dimension dim = new Dimension(300,50);
		positionSlider.setSize(dim);
		positionSlider.setBackground(backgroundColor);
		positionSlider.setToolTipText("Drag slider to desired alignment.");
		add(positionSlider);

		jumpTo = new JLabel("Jump to:");
		add(jumpTo);

		location = new JTextField("0",4);
		location.setHorizontalAlignment(JTextField.TRAILING);
		location.setToolTipText("Type in desired alignment number.");
		add(location);
		location.setActionCommand("Location");

		int maxSpeed = 30;
		int currSpeed = 20;
		int minSpeed = 10;

		speedLabel = new JLabel("Speed:");
		speedLabel.setToolTipText("Click to change animation speed.");
		add(speedLabel);

		JPanel speedPanel = new JPanel();
		speedPanel.setBackground(backgroundColor);
		ButtonGroup speedGroup = new ButtonGroup();

		slowButton = new JRadioButton("Slow",false);
		slowButton.setActionCommand("Slow");	
		slowButton.setBackground(backgroundColor);
		speedPanel.add(slowButton);
		speedGroup.add(slowButton);

		medButton = new JRadioButton("Medium",true);
		medButton.setActionCommand("Medium");	
		medButton.setBackground(backgroundColor);
		speedPanel.add(medButton);
		speedGroup.add(medButton);

		fastButton = new JRadioButton("Fast",false);
		fastButton.setActionCommand("Fast");	
		fastButton.setBackground(backgroundColor);
		speedPanel.add(fastButton);
		speedGroup.add(fastButton);

		add(speedPanel);

		EditContainer eap = new EditContainer( ah, fh, oh );
		JButton editAlignment = new JButton( new EditSelectionAction(
                                       parent, ah, eap, 
									   "Create new alignment") );
			
		add(editAlignment);
	}

	public void addChangeListener( ChangeListener a )
	{
		positionSlider.addChangeListener(a);
	}
		
	public void addActionListener( ActionListener a )
	{
		stepBackward.addActionListener(a);
		startPause.addActionListener(a);
		stepForward.addActionListener(a);
		location.addActionListener(a);
		slowButton.addActionListener(a);	
		medButton.addActionListener(a);	
		fastButton.addActionListener(a);	
	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		setBackground(backgroundColor);
		location.setText( Integer.toString(ah.getCurrentIndex()) );

		// emits a stateChanged event
		positionSlider.setValue( ah.getCurrentIndex() );
	}

	public void actionPerformed(ActionEvent e) 
	{
		Object source = e.getSource();
		if ( source == startPause ) 
		{
			if ( startPause.getIcon() == playIcon )
			{
				startPause.setIcon(pauseIcon);
				startPause.setActionCommand("Pause");
				startPause.setToolTipText("Pause Animation");
			}
			else
			{
				startPause.setIcon(playIcon);	
				startPause.setActionCommand("Play");
				startPause.setToolTipText("Start Animation");
			}
		}
		else if ( source == stepForward || source == stepBackward ) 
		{
			startPause.setIcon(playIcon);
			startPause.setActionCommand("Play");
		}
	} 

	// This is a hack because applets can seem to use getResource
	// normally.
	protected ImageIcon createIcon(String iconName, String title)
	{
		ClassLoader cl = this.getClass().getClassLoader();
		System.out.println("good " + iconName);
		InputStream is = cl.getResourceAsStream(iconName);
		ImageIcon icon;
		try {
			byte[] buffer = new byte[is.available()];
			is.read(buffer);
			icon = new ImageIcon(buffer, title);

		} catch (IOException e)
		{
			System.out.println("Couldn't create icon " + iconName );
			icon = new ImageIcon();
		}
		return icon;
	}
}


