
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/display/path/PFastPath.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 



package edu.virginia.bioch.nopt.display.path;

import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.text.*;
import java.util.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;

import edu.umd.cs.piccolo.nodes.PPath;

public class PFastPath extends PPath 
{

	protected GeneralPath myPath;

	public PFastPath()
	{
		super();
		myPath = getPathReference();
	}

	public void fastMoveTo(float x, float y)
	{
		myPath.moveTo(x,y);
	}

	public void fastLineTo(float x, float y)
	{
		myPath.lineTo(x,y);
	}

	public void fastFinish()
	{
		firePropertyChange(PROPERTY_PATH, null, myPath);
		updateBoundsFromPath();
		invalidatePaint();
	}
}
