
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/display/path/PSpacedSequence.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.display.path;

import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.text.*;
import java.util.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;

abstract public class PSpacedSequence extends PNode 
{

	protected String seq;
	protected int offset;
	protected int edgeLen;
	protected int center;
	protected Font normalFont;
	protected String smallFontName;
	protected int smallFontSize;
	protected int charWidth;

	public PSpacedSequence( String s, int off, int el, 
			                int cent, int cw, Font nf )
	{
		super();
		seq = s;
		offset = off;
		edgeLen = el;
		center = cent;
		charWidth = cw;
		normalFont = nf;
		smallFontName = "Serif";
		smallFontSize = 8;
	}


	protected void paint(PPaintContext paintContext) 
	{
		super.paint(paintContext);

		Graphics2D g2 = paintContext.getGraphics();
		FontRenderContext frc = g2.getFontRenderContext();
		GlyphVector gv = normalFont.createGlyphVector(frc,seq);

		g2.setPaint(Color.black);


		for ( int i = 0; i < seq.length(); i++ )
		{
			Point2D pt = new Point2D.Double( getX(i) , getY(i) );
			gv.setGlyphPosition( i, pt );

			if ( i % 10 == 0 && i > 0 )
			{
				AttributedString at = 
							new AttributedString( Integer.toString( i ) );
				at.addAttribute(TextAttribute.FAMILY, smallFontName);
				at.addAttribute(TextAttribute.SIZE, 
						        new java.lang.Float(smallFontSize));
				at.addAttribute(TextAttribute.FOREGROUND, Color.blue );
				g2.drawString(at.getIterator(), 
						      (float)(pt.getX() + getXNumOffset() ), 
						      (float)(pt.getY() + getYNumOffset() ) );
			}
		}

		g2.drawGlyphVector(gv,offset,offset);		
	}

	//
	// Override these to get the proper placement behavior.
	//
	abstract public double getX( int i );
	abstract public double getY( int i );

	abstract public int getXNumOffset();
	abstract public int getYNumOffset();
}
