
/* 
 * Copyright (C) 2002-@year@ by University of Maryland, College Park, MD 20742, USA 
 * All rights reserved. 
 * 
 * Piccolo was written at the Human-Computer Interaction Laboratory 
 * www.cs.umd.edu/hcil by Jesse Grosjean under the supervision of Ben Bederson. 
 * The Piccolo website is www.cs.umd.edu/hcil/piccolo 
 */
package edu.virginia.bioch.nopt.display.path; 

import java.awt.event.InputEvent;
import java.awt.geom.Point2D;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.event.*;

/**
 * <b>ZoomHandler</b> 
 *
 * @author Mike Smoot based on Jesse Grosjean's code
 */
public class ZoomHandler extends PZoomEventHandler {
	
	private Point2D myZoomPoint;

	protected PCamera horCam;
	protected PCamera vertCam;

	public ZoomHandler( PCamera hor, PCamera vert ) 
	{
		super();
		horCam = hor;
		vertCam = vert;
	}

    protected void dragActivityFirstStep(PInputEvent aEvent) 
	{
		myZoomPoint = aEvent.getPosition();
		super.dragActivityFirstStep(aEvent);
    }

	protected void dragActivityStep(PInputEvent aEvent) 
	{
		PCamera camera = aEvent.getCamera();

		if ( camera == horCam || camera == vertCam )
			return;

		double dx = aEvent.getCanvasPosition().getX() - 
		            getMousePressedCanvasPoint().getX();
		double scaleDelta = (1.0 + (0.001 * dx));

		double currentScale = camera.getViewScale();
		double newScale = currentScale * scaleDelta;
		double myMinScale = 0.05; //getMinScale();
		double myMaxScale = 2.0; //getMaxScale();

		if (newScale < myMinScale ) 
			scaleDelta = myMinScale / currentScale;

		if ( (myMaxScale > 0) && ( newScale > myMaxScale) )
			scaleDelta = myMaxScale / currentScale;

		camera.scaleViewAboutPoint(scaleDelta, myZoomPoint.getX(), 
				                               myZoomPoint.getY());

		vertCam.scaleViewAboutPoint(scaleDelta, 0, myZoomPoint.getY());
		horCam.scaleViewAboutPoint(scaleDelta, myZoomPoint.getX(), 0);
	}

}
