
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/editor/EditContainer.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.editor;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.Thread.*;
import java.util.*;
import java.lang.Exception.*;
import java.io.IOException;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.actions.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.options.styles.*;
import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;
import edu.virginia.bioch.nopt.editor.*;
import edu.virginia.bioch.nopt.display.*;

import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.text.*;

public class EditContainer extends JPanel
	implements SelectionPanel
{
	protected EditAlignmentPanel eap;
	protected JScrollPane jsp;
	public EditContainer( AlignmentHandler ah, FontHandler fh, OptionHandler oh)
	{
		super();
		System.out.println("EditContainer constructor");

		eap = new EditAlignmentPanel( ah, fh, oh );
		jsp = new JScrollPane( eap );
		add( jsp );
	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
	}

	public void prepareSelections()
	{
		eap.setString();
		jsp.setPreferredSize( new Dimension(450,150) );
	}

	public boolean processSelections()
	{
		return eap.process();
	}
}
