
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/IconComboBoxRenderer.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.options; 

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import edu.virginia.bioch.nopt.options.*; 
import edu.virginia.bioch.nopt.options.styles.*; 

public class IconComboBoxRenderer extends JLabel
                           		  implements ListCellRenderer 
{
	protected Map icons; 

   	public IconComboBoxRenderer( Map iconMap ) 
	{
		setOpaque(true);
		setHorizontalAlignment(LEFT);
		setVerticalAlignment(CENTER);
		setToolTipText("Click to choose highlight icon");

		icons = iconMap;
   	}

   	public Component getListCellRendererComponent( JList list, 
			                                       Object value,
                                                   int index, 
												   boolean isSelected,
                                                   boolean cellHasFocus) 
	{
		if (isSelected) 
		{
			setBackground(list.getSelectionBackground());
			setForeground(list.getSelectionForeground());
		} 
		else 
		{
			setBackground(list.getBackground());
			setForeground(list.getForeground());
		}

		String name = (String) value;
		setBorder( BorderFactory.createLineBorder(Color.lightGray) );

		Object o = icons.get( name );
		if ( o != null )
			setIcon((ImageIcon)o);

		setText(name);

   		return this;
	}
}
