
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/Option.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options;



import java.lang.*;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import javax.swing.event.*;
import javax.swing.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.options.styles.*;
import edu.virginia.bioch.util.*;


public class Option
	implements ItemListener
{



	//==================================================================
	//
	protected static FontMetrics normalFontMetrics;
	protected static FontMetrics smallFontMetrics;
	protected static int _ascent;
	protected static int _descent;
	protected static int _smallAscent;
	protected static int _smallDescent;
	protected static int _separation;
	protected static int _glyphWidth;
	protected static int _smallSeparation;
	protected static int _smallGlyphWidth;
	protected static Font normalFont;
	protected static Font smallFont;
	protected static String normalFontName;
	protected static String smallFontName;
	protected static float normalFontSize;
	protected static float smallFontSize;

	protected static String _seq1Id;
	protected static String _seq2Id;
	protected static String _bothId;


	//
	// This exists so that we can re-initialize this class.
	//
	static 
	{
		normalFontMetrics = null;
		smallFontMetrics = null;
		_ascent = 0;
		_descent = 0;
		_separation = 0;
		_glyphWidth = 0;
		_smallAscent = 0;
		_smallDescent = 0;
		_smallGlyphWidth = 0;
		_smallSeparation = 0;
		_seq1Id = "Seq 1";
		_seq2Id = "Seq 2";
		_bothId = "Both";
	}

	public static void setFonts( FontHandler fh )
	{
		normalFont = fh.getNormalFont();
		smallFont = fh.getSmallFont();

		normalFontName = normalFont.getFontName();
		smallFontName = smallFont.getFontName();

		normalFontSize = normalFont.getSize();
		smallFontSize = smallFont.getSize();

		normalFontMetrics = fh.getNormalFontMetrics();
		smallFontMetrics = fh.getSmallFontMetrics();

		_ascent = normalFontMetrics.getMaxAscent();
		_descent = normalFontMetrics.getMaxDescent();

		_smallAscent = smallFontMetrics.getMaxAscent();
		_smallDescent = smallFontMetrics.getMaxAscent();

		int[] widths = normalFontMetrics.getWidths();
		_glyphWidth = 0;
		for ( int i = 0; i < widths.length; i++ )
				_glyphWidth = Math.max( _glyphWidth, widths[i] );
		_glyphWidth *= 1.5;
		_separation = normalFontMetrics.getMaxAscent()/2;

		int[] swidths = smallFontMetrics.getWidths();
		_smallGlyphWidth = 0;
		for ( int i = 0; i < swidths.length; i++ )
				_smallGlyphWidth = Math.max( _smallGlyphWidth, swidths[i] );
		_smallSeparation = smallFontMetrics.getMaxAscent()/2;

		// TODO figure out why this hack is needed 
		_smallGlyphWidth = 4;

	}

	public static int getSeparation()
	{ return _separation; }

	public static int getGlyphWidth()
	{ return _glyphWidth; }

	public static int getSmallGlyphWidth()
	{ return _smallGlyphWidth; }

	public static int getSmallSeparation()
	{ return _smallSeparation; }

	public static final String gap = "-";

	public static Option create( String optionString, AlignmentHandler ah )
	{
		StringTokenizer t = new StringTokenizer( optionString, "|" );
		String annType = t.nextToken();
		String name = t.nextToken();
		String rangeString = t.nextToken();
		String appSeq = t.nextToken();

		return Option.create( name, rangeString, appSeq, annType, ah );
	}

	public static Option create( String name, String rangeString,
			                     String appSeq, String annType, 
								 AlignmentHandler ah )
	{
		if ( annType.equals( HelixOption.getTitle() ) )
			return new HelixOption( name, rangeString, appSeq, ah,
					                annType + ": " + rangeString );

		else if ( annType.equals( StrandOption.getTitle() ) )
			return new StrandOption( name, rangeString, appSeq, ah,
					                 annType + ": " + rangeString );

		else if ( annType.equals( UserOption.getTitle() ) )
			return new UserOption( name, rangeString, appSeq, ah ,
					                 annType + ": " + rangeString );

		else if ( annType.equals( CircleOption.getTitle() ) )
			return new CircleOption( name, rangeString, appSeq, ah,
					                 annType + ": " + rangeString );

		else if ( annType.equals( SquareOption.getTitle() ) )
			return new SquareOption( name, rangeString, appSeq, ah,
					                 annType + ": " + rangeString );

		else if ( annType.equals( TriangleOption.getTitle() ) )
			return new TriangleOption( name, rangeString, appSeq, ah,
					                 annType + ": " + rangeString );

		else 
			return new Option( name, rangeString, appSeq, 
					           Option.getTitle(), ah, "Null Option" );

	}


	//============================================================
	//
	// non static
	//

	protected boolean _on;
	protected String _type;
	protected String _name;
	protected String _rangeString;
	protected HashMap _edgesToDraw;
	protected HashMap _conditionalEdges;
	protected Vector _seq1Ranges;
	protected Vector _seq2Ranges;
	protected String _applicableSeq;
	protected String _description;
	protected AlignmentHandler _ah;

	public void turnOn() { _on = true; }	
	public void turnOff() { _on = false; }	

	public Option( String n, String r, String as, String t, 
			       AlignmentHandler ah, String d )
	{
		System.out.println("Option constructor");
		_ah = ah;
		_name = n;
		_rangeString = r;
		_applicableSeq = as;
		_type = t;
		_description = d;
		_on = false;
		_edgesToDraw = new HashMap();
		_conditionalEdges = new HashMap();

		_seq1Ranges = new Vector();
		_seq2Ranges = new Vector();

		if ( _applicableSeq.equals( Option._seq1Id ) )
			addRange( _rangeString, _seq1Ranges );

		if ( _applicableSeq.equals( Option._seq2Id ) )
			addRange( _rangeString, _seq2Ranges );

		if ( _applicableSeq.equals( Option._bothId ) )
		{
			addRange( _rangeString, _seq1Ranges );
			addRange( _rangeString, _seq2Ranges );
		}
	}

	// Should be overridden to draw highlight. 
	//
	// Coordinate stack:
	//
	// --- top of first string
	// _ascent
	// --- yPos --- bottom of first string
	// _descent
	// _separation
	// _ascent
	// --- yPos - (_descent+_separation+_ascent) --- bottom of 2 string
	// _descent
	// --- bottom of second string
	//
	public void draw(EdgeKey key, int i, double xPos, double yPos, Graphics2D g,
		                 String c1, String c2, int count1, int count2)
	{
		//if ( ((Boolean)_edgesToDraw.get( key )).booleanValue() && _on )
	}


	// 
	// The default addKey only checks to see if the key is within an
	// applicable range and adds it if it is.  Can be overridden for
	// Options with different needs.
	//
	public void addKey( EdgeKey key )
	{
		if ( !_edgesToDraw.containsKey( key ) )
		{
			String char1 = key.getTopCharString();
			String char2 = key.getBotCharString();

			int x = key.getEndX();
			int y = key.getEndY();

			if ( _applicableSeq.equals( Option._seq1Id ) && 
				 !char1.equals( gap ) )
				_putKey( x, key, _seq1Ranges.iterator() );

			else if ( _applicableSeq.equals( Option._seq2Id ) && 
					  !char2.equals( gap ) )
				_putKey( y, key, _seq2Ranges.iterator() );

			else if ( _applicableSeq.equals( Option._bothId ) && 
							!char1.equals( gap ) &&
							!char2.equals( gap ) )
			{
				_putKey( x, key, _seq1Ranges.iterator() );
				_putKey( y, key, _seq2Ranges.iterator() );
			}					
			else
				_edgesToDraw.put( key, new Boolean( false ) );
		}					
	}

	public void setConditionalEdge( EdgeKey key, Boolean b )
	{
		_conditionalEdges.put( key, b );
	}

	public void addConditionalEdges( HashMap h )
	{
		Set keys = h.keySet();
		Iterator it = keys.iterator();

		while ( it.hasNext() )
		{
			EdgeKey key = (EdgeKey)it.next();

			if ( ((Boolean)_edgesToDraw.get( key )).booleanValue() &&
			     ((Boolean)h.get( key )).booleanValue() )
				_conditionalEdges.put( key, new Boolean( true ) );
	//		else
	//			_conditionalEdges.put( key, new Boolean( false ) );
		}
	}

	private void _putKey( int val, EdgeKey key, Iterator it )
	{
		boolean b = false;
		while ( it.hasNext() )
		{
			if ( ((Range)it.next()).inRange( val ) )
			{
				b = true;
				break;
			}
		}					
		_edgesToDraw.put( key, new Boolean( b ) );
	}

	// 
	// Adds a range object to the range list
	//
	public void addRange( String rs, Vector rangeList )
	{
		if ( !rs.equals("") )
		{
			StringTokenizer st = new StringTokenizer(rs,",");
			while ( st.hasMoreTokens() )
				rangeList.add( new Range( st.nextToken() ) );
		}
	}

	public String getName()
	{ return _name; }


    public void itemStateChanged(ItemEvent e)
    {
		JCheckBox source = (JCheckBox)e.getItemSelectable();

		if ( (source.getName()).equals( _name ) )
		{
			if ( !_on )
				turnOn();
			else
				turnOff();
		}
	}

	public String toString()
	{
		String s = "Option Name: " + _name + "   Ranges: " + _rangeString +
		           "   Applicable seq: " + _applicableSeq + "   Type: " +
				   _type;
		return s;
	}

	public String getType()
	{ return _type; }

	public HashMap getEdges()
	{ return _edgesToDraw; }

	public boolean typeEquals( Option o )
	{
		if ( this._type.equals( o.getType() ) )
			return true;
		else
			return false;
	}

	public String getDescription() { return _description; }
	public static String getTitle() { return "Null Option"; }
	public static String getSeq1Id() { return _seq1Id; }
	public static String getSeq2Id() { return _seq2Id; }
	public static String getBothId() { return _bothId; }

	protected static ImageIcon createIcon(String path,String title)
	{
		java.net.URL imgURL = ClassLoader.getSystemResource(path);
		ImageIcon icon;

		try {
			if (imgURL != null) 
				icon = new ImageIcon(imgURL);
			else 
			{
				System.err.println("Couldn't find file: " + path);
				icon = null; 
			}
		}
		catch (NullPointerException e)
		{
			System.out.println("Couldn't create icon " + path );
			icon = null; 
		}

		return icon;
	}


	/* This works, if imperfectly
	protected static ImageIcon createIcon(String path,String title)
	{
	//ClassLoader cl = this.getClass().getClassLoader();
		System.out.println("asdf " + path);
		InputStream is = ClassLoader.getSystemResourceAsStream(path);
		ImageIcon icon;
		try {
			byte[] buffer = new byte[is.available()];
			is.read(buffer);
			icon = new ImageIcon(buffer, title);
		
		} 
		catch (IOException e)
		{
			System.out.println("Couldn't create icon " + path );
			icon = null; 
		}
		catch (NullPointerException e)
		{
			System.out.println("Couldn't create icon " + path );
			icon = null; 
		}
		return icon;
	}
	*/


}
