
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/OptionHandler.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options;



import java.lang.*;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import javax.swing.event.*;
import javax.swing.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.styles.*;
import edu.virginia.bioch.util.*;


public class OptionHandler
{

	//==================================================================
	//
	protected Vector optionList;
	protected int beginOptional;
	protected AlignmentHandler ah;

	public OptionHandler( AlignmentHandler ah )
	{
		this.ah = ah;
		optionList = null;
		optionList = new Vector();

		addOption( new SteadyOption( ah ) );
		addOption( new ConservedOption( ah ) );
		addOption( new RobustOption( ah ) );
		addOption( new NumberOption( ah ) );
		addOption( new NameOption( ah ) );
		// Similarity has to come before identity so that it will be
		// drawn under identity.
		addOption( new SimilarityOption( ah ) );
		addOption( new IdentityOption( ah ) );
	
		// add any fixed options before this...
		beginOptional = optionList.size();
		System.out.println("OptionHandler optional annotations begin at:" + 
				           beginOptional );

		initializeOptions();
	}

	public int getNumFixedOptions()
	{ return beginOptional; }

	public Vector getOptionVector()
	{ return optionList; }

	public void addOption( Option o )
	{ optionList.add( o ); } // placing new option at bottom
	//{ optionList.add( 0, o ); } // placing new option at top

	public void clearOptions()
	{ 
		for ( int i = optionList.size()-1; i >= beginOptional ; i-- )
			optionList.remove(i); // placing new option at bottom
			//optionList.remove(0); // placing new option at top
	}

	public void initializeOptions()	
	{
		System.out.println("OptionHandler initializing annotations");
		Set edges = ah.getAllEdges();

		Iterator it = optionList.iterator();

		// First add all the edges to the list of options .
		while ( it.hasNext() )
		{
			Option o = (Option)it.next();

			Iterator itt = edges.iterator();

			while ( itt.hasNext() )
			{
				EdgeKey s = (EdgeKey)itt.next();
				o.addKey( s );

				// initially set all conditions to false
				o.setConditionalEdge( s, new Boolean(false) );
			}
		}


		it = optionList.iterator();
		
		// Now add options of the same type to one another to get
		// conditional behavior.
		while ( it.hasNext() )
		{
			Option o = (Option)it.next();

			Iterator it2 = optionList.iterator();

			while ( it2.hasNext() )
			{
				Option o2 = (Option)it2.next();
				
				if ( o != o2 && o2.typeEquals( o ) )
					o.addConditionalEdges( o2.getEdges() );
			}
		}
	}
}
