
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/OptionLoaderPanel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.Thread.*;
import java.util.*;
import java.lang.Exception.*;
import java.io.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.styles.*;
import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.actions.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;

public class OptionLoaderPanel extends JPanel
{

	protected JButton loadButton; 

	public OptionLoaderPanel( AddOptionSetAction aos )
	{
		//setBackground( new Color(240,255,240) );
		setBackground( Color.white ); 

		loadButton = new JButton( aos );
		add( loadButton );

		setBorder( BorderFactory.createTitledBorder("Load a GFF file") );
	}

	public void addActionListener(ActionListener a)
	{
		loadButton.addActionListener( a );
	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		setBackground(Color.white);
	}

}
