
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/OptionSelectionPanel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options;



import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.Thread.*;
import java.util.*;
import java.lang.Exception.*;
import java.io.IOException;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.actions.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.styles.*;
import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;

import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;

public class OptionSelectionPanel extends JPanel
	implements ActionListener, SelectionPanel
{

	protected OptionTableModel otm; 
	protected OptionTable optionTable; 
	protected OptionHandler oh; 
	protected AlignmentHandler ah; 
	protected OptionCreatorPanel ocp; 
	protected OptionLoaderPanel olp; 
	protected String executionContext;

	public OptionSelectionPanel( OptionHandler oh, 
			                     OptionTableModel otm, 
								 AlignmentHandler ah,
								 String ex,
								 AddOptionSetAction aos )
	{
		System.out.println("OptionSelectionPanel constructor");

		this.oh = oh;
		this.otm = otm;
		executionContext = ex;

		//Color backColor = new Color( 255,240,240 );
		Color backColor = Color.white; 
		setBackground( backColor );
		setLayout( new BoxLayout( this, BoxLayout.Y_AXIS ) );

		ocp = new OptionCreatorPanel();
		ocp.addActionListener( this );
		add( ocp );

		ConditionalRenderer cr = new ConditionalRenderer();
		optionTable = new OptionTable( otm, cr );
		optionTable.setBackground( backColor );
		otm.addTableModelListener( optionTable );

		setupSeqColumn( optionTable.getColumnModel().getColumn(1) );
		setupIconColumn( optionTable.getColumnModel().getColumn(2) );

		optionTable.setPreferredScrollableViewportSize(new Dimension(800,100));
		JScrollPane tableScroll = new JScrollPane( optionTable );
		tableScroll.setBorder( 
				BorderFactory.createTitledBorder("Select Annotations") );
		tableScroll.setBackground( backColor );
		tableScroll.getViewport().setBackground( backColor );

		JPanel table = new JPanel();
		table.setBackground( backColor );
		table.setLayout(new BorderLayout());
		table.add(optionTable.getTableHeader(), BorderLayout.NORTH);
		table.add(tableScroll, BorderLayout.CENTER);

		if ( !executionContext.equals( "applet" ) )
		{
			if ( aos != null )
			{
				olp = new OptionLoaderPanel( aos );
				add( olp );
			}
		}

		add(table);

	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
	}


	public void actionPerformed(ActionEvent e)
	{
		if ( e.getActionCommand().equals( "add new option to list" ) )
		{
			try { 

			String name = ocp.getNameString();
			String range = ocp.getRange();
			
			otm.addRow( otm.createRow( 
						   new OptionKey(name,"none","user created"), range ));

			ocp.clear();

			} catch ( Exception ex )
			{
				JOptionPane.showMessageDialog( this,
						"Failed to create annotation!\n" + ex.getMessage(),
						"Annotation create failure", 
						JOptionPane.ERROR_MESSAGE );
			}
		}
	}

	public void prepareSelections()
	{
	}

	public boolean processSelections()
	{
		System.out.println("OptionSelectionPanel adding selected " + 
				           "annotations to OptionHandler");
		oh.clearOptions();

		int rows = otm.getRowCount();
		for ( int i = 0; i < rows; i ++ )
		{
			Boolean b = (Boolean)otm.getValueAt(i,(int)0);
			if ( b.booleanValue() )
			{
				String appSeq = (String)otm.getValueAt(i,(int)1);
				String type = ((String)otm.getValueAt(i,(int)2)).toString();
				String name = (String)otm.getValueAt(i,(int)3);
				String range = (String)otm.getValueAt(i,(int)4);
					
				System.out.println("OptionSelectionPanel selected type " + 
							           type);

				if ( appSeq.equals( otm.getUnselectedSeq() ) )
				{
					System.err.println("No sequence selected for " +
							           "annotation: " + name + 
									   "   Ignoring!");
					continue;
				}

				if ( type.equals( otm.getUnselectedType() ) )
				{
					System.err.println("No highlight type selected for " +
							           "annotation: " + name + 
										   "   Ignoring!");
					continue;
				}

				oh.addOption(Option.create(name, range, appSeq, type, ah));		
			}
		}
		oh.initializeOptions();

		return true;
	}


	public void setupIconColumn( TableColumn col ) 
	{
		HashMap iconMap = new HashMap();
		Vector iconNames = new Vector();

		iconMap.put( HelixOption.getTitle(), HelixOption.getIcon() );
		iconNames.add( HelixOption.getTitle() );

		iconMap.put( StrandOption.getTitle(), StrandOption.getIcon() );
		iconNames.add( StrandOption.getTitle() );

		iconMap.put( CircleOption.getTitle(), CircleOption.getIcon() );
		iconNames.add( CircleOption.getTitle() );

		iconMap.put( SquareOption.getTitle(), SquareOption.getIcon() );
		iconNames.add( SquareOption.getTitle() );

		iconMap.put( TriangleOption.getTitle(), TriangleOption.getIcon() );
		iconNames.add( TriangleOption.getTitle() );

		JComboBox icons = new JComboBox(iconNames);
		IconComboBoxRenderer renderer= new IconComboBoxRenderer( iconMap );
		icons.setRenderer( renderer);
		icons.setMaximumRowCount( 6 );
		col.setCellEditor(new DefaultCellEditor(icons));
		
        TableCellRenderer headerRenderer = col.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) 
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText(
                     "Click cell to choose highlight icon");
    }

	public void setupSeqColumn(TableColumn col ) 
	{
		JComboBox comboBox = new JComboBox();
		comboBox.addItem( Option.getSeq1Id() );
		comboBox.addItem( Option.getSeq2Id() );
        col.setCellEditor(new DefaultCellEditor(comboBox));
		
        DefaultTableCellRenderer renderer =
                new DefaultTableCellRenderer();
        renderer.setToolTipText("Click cell to choose applicable sequence");
        col.setCellRenderer(renderer);

        TableCellRenderer headerRenderer = col.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) 
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText(
                     "Click to choose applicable sequence");
    }
}
