
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/styles/HelixOption.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options.styles;



import java.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import java.lang.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.util.*;



public class HelixOption extends Option
{
	protected Color displayColor;
	protected Color origColor;
	protected QuadCurve2D.Double nIcon;
	protected QuadCurve2D.Double leftXIcon;
	protected QuadCurve2D.Double rightXIcon;

	public static String getTitle() { return "Helix Option" ; }	
	public static ImageIcon getIcon()
	{
		return Option.createIcon("images/HelixOption.icon.png", 
				                 "Helix Option"); 
	}


	public HelixOption(String n, String rs, String app, AlignmentHandler ah,
			           String d ) 
    {
		super( n, rs, app, "HELIX", ah, d );
		System.out.println("HelixOption constructor");

		//
		// Note that the middle point of QuadCurve2D is calculated 
		// by the function. So the middle point specified here is 
		// really only the direction the fuction should head, not where 
		// the middle of the curve will actually fall. For these
		// functions the value of _descent is what we offset the 
		// middle value by to get the proper location and shape.
		//
		nIcon = new QuadCurve2D.Double( _glyphWidth*0.2, 
										_descent + (_separation/2), 
										_glyphWidth*0.5,
					                    0 - _descent, 
										_glyphWidth*0.8, 
										_descent + (_separation/2));

		// from bottom left to top right
		leftXIcon = new QuadCurve2D.Double( 0, 
											2*_descent + _separation,
											_glyphWidth*0.4,
					                        2*_descent + _separation,
											_glyphWidth*0.8, 
					                        _descent + (_separation/2));
		// from top left to bottom right
		rightXIcon = new QuadCurve2D.Double( _glyphWidth*0.2, 
											 _descent + (_separation/2), 
											 _glyphWidth*0.6,
					                         2*_descent + _separation,
											 _glyphWidth, 
											 2*_descent + _separation);

	}

	public void draw(EdgeKey key, int i, double xPos, double yPos, Graphics2D g,
	                 String c1, String c2, int count1, int count2)
	{
		if ( ((Boolean)_edgesToDraw.get( key )).booleanValue() && _on )
		{
			displayColor = Color.gray;

			if ( ((Boolean)_conditionalEdges.get( key )).booleanValue() &&
					_conditionalCount > 1 )
				displayColor = Color.magenta;

			origColor = g.getColor();
			g.setColor(displayColor);

			if ( _applicableSeq.equals(Option._seq1Id) ) 
			{
				// This draws the "n" (upside down u)
				g.draw(nIcon);
			}

			if ( _applicableSeq.equals(Option._seq2Id) ) 
			{
				// This draws the "x" 
				g.draw(leftXIcon);
				g.draw(rightXIcon);
			}

			g.setColor(origColor);
		}
	}

	// Note that the conditionalCount stuff must be local to this class,
	// we can generalize and put it in Option because the count is specific
	// to this class.
	static int _conditionalCount;

	static
	{
		_conditionalCount = 0;
	}

	public void turnOff()
	{
		super.turnOff();
		_conditionalCount--;
	}

	public void turnOn()
	{
		super.turnOn();
		_conditionalCount++;
	}
}
