
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/styles/RobustOption.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options.styles;


import java.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Ellipse2D.*;
import java.awt.geom.Line2D.*;
import java.lang.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.util.*;


public class RobustOption extends Option
{
	protected int maxCount;
	protected int power;
	protected Ellipse2D.Double r1; 
	protected Color[] greens;
	protected Color origColor;
	protected int numColors;

	public static String getTitle() { return "Robust Option" ; }
	public static ImageIcon getIcon()
	{
		return Option.createIcon("images/RobustOption.icon.png", 
				                 "Robust Option"); 
	}

	public RobustOption( AlignmentHandler ah )
	{
		super("Robustness Highlight","",Option._bothId, 
			  "ROBUST", ah, "Highlight robust regions of alignment." );
		System.out.println("RobustOption constructor");

		maxCount = _ah.getMaxCount(); 

		r1 = new Ellipse2D.Double( -4,
						             -_ascent,
									 _glyphWidth + 2, 
									 _ascent + 
										    _descent + 
										    _separation +
										    _ascent + 
										    _descent  );

		// Keep an array of colors around to avoid creating new Color objects
		// all of the time.
		numColors = 10;
		greens = new Color[numColors+1];
		greens[0] = Color.white; 
		for ( int i = 1; i < greens.length; i++ )
			greens[i] = new Color( Color.HSBtoRGB((float)0.35,
												   (float)i/(float)numColors,
												   (float)0.95));
		origColor = Color.white;

		// power affects the variation of the saturation. The higher the
		// power the greater the difference between conserved and 
		// unconserved.
		power = 2;
	}

	public void addKey( EdgeKey key )
	{
		// don't add any keys as everything gets colored according to
		// the current count for the key
	}

	public void draw(EdgeKey key, int i, double xPos, double yPos, Graphics2D g,
                     String char1, String char2, int s1Count, int s2Count)
	{
		if ( _on ) 
		{
			// save original state
			origColor = g.getColor();
			//_origTransform = g.getTransform();
			
			float sat = 1;
			for ( int x = 0; x < power; x++ )
				sat *= (float)(_ah.getRobustness( key ));

			int satIndex = Math.round( sat*((float)numColors) );

			g.setColor( greens[satIndex] );
			g.fill( r1 );

			g.setColor( origColor );
        }
	}
}


