
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/styles/StrandOption.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options.styles;



import java.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import java.lang.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.util.*;


public class StrandOption extends Option
{
	protected Color displayColor;
	protected Color origColor;
	protected GeneralPath gpTop;
	protected GeneralPath gpBot;

	public static String getTitle() { return "Strand Option" ; }
	public static ImageIcon getIcon()
	{
		return Option.createIcon("images/StrandOption.icon.png", 
				                 "Strand Option"); 
	}

	public StrandOption(String n, String rs, String app, AlignmentHandler ah,
			            String d )
    {
		super( n, rs, app, "STRAND", ah, d ); 
		System.out.println("StrandOption constructor");

		gpTop = new GeneralPath();
		gpTop.moveTo(0f, 0f);
		gpTop.lineTo((float)(_glyphWidth*0.8), 0f);
		gpTop.lineTo((float)_glyphWidth, _descent + _separation/2);
		gpTop.lineTo((float)(_glyphWidth*0.2), _descent + _separation/2);
		gpTop.lineTo(0f, 0f);

		gpBot = new GeneralPath();
		gpBot.moveTo((float)(_glyphWidth*0.2), _descent + _separation/2  );
		gpBot.lineTo((float)_glyphWidth, 0f + _descent + _separation/2 );
		gpBot.lineTo((float)(_glyphWidth*0.8), 2*_descent + _separation );
		gpBot.lineTo(0f, 2*_descent + _separation );
		gpBot.lineTo((float)(_glyphWidth*0.2), _descent + _separation/2 );

	}

	// use the default addRange
	
	public void draw(EdgeKey key,int i, double xPos, double yPos, Graphics2D g,
	                 String c1, String c2, int count1, int count2)
	{
		if ( ((Boolean)_edgesToDraw.get( key )).booleanValue() && _on )
		{
            displayColor = Color.lightGray;

           if ( ((Boolean)_conditionalEdges.get( key )).booleanValue() &&
						                    _conditionalCount > 1 )
                displayColor = new Color( 0.6f, 1.0f, 0.4f ); // greenish

			origColor = g.getColor();
			g.setColor(displayColor);

			if ( _applicableSeq.equals( Option._seq1Id ) ) 
			{
				g.fill( gpTop );
				g.draw( gpTop );
			}

			if ( _applicableSeq.equals( Option._seq2Id ) ) 
			{
				g.fill( gpBot );
				g.draw( gpBot );
			}
			
			g.setColor(origColor);
		}
	}

    static int _conditionalCount;

    static
    {
        _conditionalCount = 0;
    }

    public void turnOff()
    {
        super.turnOff();
        _conditionalCount--;
    }

    public void turnOn()
    {
        super.turnOn();
        _conditionalCount++;
    }
}
