
/*
 * 
 *  file:  ./src/edu/virginia/bioch/scoringmatrices/ScoringMatrix.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.scoringmatrices;


import java.lang.*;
import java.lang.reflect.*;
import java.util.*;
import edu.virginia.bioch.scoringmatrices.*;

public class ScoringMatrix 
	implements BlosumMatrices,
	           PamMatrices1,
	           PamMatrices2,
	           PamCdiMatrices,
			   DnaMatrices,
			   OtherMatrices
{
	int[][] _sm;

	String _matrixName;
	String _alphabet;

	protected HashMap charMap;

	public ScoringMatrix( String name )
		throws IllegalAccessException,
		       ClassNotFoundException,
			   NoSuchFieldException,
			   SecurityException
	{
		System.out.println("ScoringMatrix constructor");
		//System.out.println("matrix name: " + name);
		_matrixName = name.toLowerCase();
		_alphabet = null;

		if ( _matrixName.equals("dna") )
			_matrixName = "nuc_4_4";

		String alName = _matrixName + "_Alphabet";

		// Reflect and get the requested matrix, assuming it exists 
		Class c = Class.forName("edu.virginia.bioch.scoringmatrices.ScoringMatrix");

		Field matField = c.getField( _matrixName );
		Field alField = c.getField( alName );

		// actually create the scoring matrix
		_createSM( (int[])matField.get( this ), (String)alField.get( this ) );
		
		if ( _alphabet == null )
			System.out.println("Null alphabet specified!");	

		charMap = new HashMap( _alphabet.length() );

		for ( int i = 0; i < _alphabet.length(); i++ )
			charMap.put(_alphabet.substring(i,i+1), new Integer(i) );	
	}

	public int score(String A, String B)
	{
		A = A.toUpperCase();
		B = B.toUpperCase();

		int indexA = ((Integer)charMap.get( A )).intValue();
		int indexB = ((Integer)charMap.get( B )).intValue();

		return _sm[ indexA ][ indexB ];
	}

	public int score(char a, char b)
	{
		String A = Character.toString( Character.toUpperCase( a ) );
		String B = Character.toString( Character.toUpperCase( b ) );

		int indexA = ((Integer)charMap.get( A )).intValue();
		int indexB = ((Integer)charMap.get( B )).intValue();

		return _sm[ indexA ][ indexB ];
	}

	public String getName() { return _matrixName; }

	protected void _createSM(int[] sm, String al)
	{
		_alphabet = al;
		//System.out.println("createSM: " + _alphabet);
		int len = _alphabet.length();
		_sm = new int[ len ] [ len ];

		int k = 0;
		for (int i = 0; i < len; i++)
			for (int j = 0; j <= i; j++)
				_sm[i][j] = _sm[j][i] = sm[k++];
	}
}
