
/*
 * 
 *  file:  ./test/AllTests.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


import junit.framework.*;

/**
 * TestSuite that runs all the sample tests.  
 * This is really superfluous since ant will run everything from the junit
 * task.  This is used to run tests independently of ant.
 */
public class AllTests 
{
	public static void main (String[] args) 
	{
		junit.textui.TestRunner.run( suite() );
	}

	public static Test suite ( ) 
	{
		TestSuite suite= new TestSuite("All JUnit Tests");
		suite.addTest(edu.virginia.bioch.nopt.alignments.EdgeKeyTest.suite());
		suite.addTest(edu.virginia.bioch.nopt.options.OptionTest.suite());
		suite.addTest(edu.virginia.bioch.util.RangeTest.suite());
		suite.addTest(edu.virginia.bioch.util.CounterTest.suite());
		suite.addTest(edu.virginia.bioch.util.FastaReaderTest.suite());
	    return suite;
	}
}
