
/*
 * 
 *  file:  ./test/edu/virginia/bioch/util/CounterTest.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.util;

import junit.framework.*;
import edu.virginia.bioch.util.*;


public class CounterTest extends TestCase
{
	private Counter c1;
	private Counter c2;

	public CounterTest( String name )
	{
		super(name);
	}

	public static void main(String args[])
	{
		junit.textui.TestRunner.run( suite() );
	}

	public static Test suite() 
	{
		return new TestSuite( CounterTest.class );
	}

	protected void setUp()
	{
		c1 = new Counter(0);
		c2 = new Counter();
	}

	public void testEquals()
	{
		assertTrue( c1.equals( c2 ) );
		c1.increment();
		assertTrue( !c1.equals( c2 ) );
		c1.decrement();
		assertTrue( c1.getCount() == c2.getCount() );
		assertTrue( !c1.equals( new Object() ) );
	}

	public void testIncrement()
	{
		c1.setCount( 0 );
		c2.setCount( 0 );
		c1.increment();
		assertTrue( !c1.equals( c2 ) );
		c2.increment();
		assertTrue( c1.equals( c2 ) );
		c1.incrementBy(10);
		assertTrue( !c1.equals( c2 ) );
		c2.incrementBy(10);
		assertTrue( c1.equals( c2 ) );
		c1.increment();
		c1.increment();
		assertTrue( !c1.equals( c2 ) );
		c2.increment();
		c2.increment();
		assertTrue( c1.equals( c2 ) );
	}

	public void testDecrement()
	{
		c1.setCount( 0 );
		c2.setCount( 0 );
		c1.decrement();
		assertTrue( !c1.equals( c2 ) );
		c2.decrement();
		assertTrue( c1.equals( c2 ) );
		c1.decrementBy(10);
		assertTrue( !c1.equals( c2 ) );
		c2.decrementBy(10);
		assertTrue( c1.equals( c2 ) );
		c1.decrement();
		c1.decrement();
		assertTrue( !c1.equals( c2 ) );
		c2.decrement();
		c2.decrement();
		assertTrue( c1.equals( c2 ) );
	}
}
