
/*
 * 
 *  file:  ./test/edu/virginia/bioch/util/RangeTest.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.util;

import junit.framework.*;
import edu.virginia.bioch.util.*;


public class RangeTest extends TestCase
{
	private Range r1;
	private Range r2;
	private Range r3;
	private Range r4;
	private Range r5;
	private Range r6;
	private Range r7;
	private Range r8;
	private Range r9;
	private Range r10;

	public RangeTest( String name )
	{
		super(name);
	}

	public static void main(String args[])
	{
		junit.textui.TestRunner.run( suite() );
	}

	public static Test suite() 
	{
		return new TestSuite( RangeTest.class );
	}

	protected void setUp()
	{
		r1 = new Range("10-20");
		r2 = new Range("1-3");
		r3 = new Range(10,20);
		r4 = new Range("2-4");
		r5 = new Range("2-9");
		r6 = new Range(15,25);
		r7 = new Range(25,15);
		r8 = new Range("5");
		r9 = new Range( 5 );
		r10 = new Range("5-5");
	}

	public void testEquals()
	{
		assertTrue( r1.equals( r3 ) );
		assertTrue( !r1.equals( r2 ) );
		assertTrue( r6.equals( r7 ) );
		assertTrue( !r6.equals( new Object() ) );
		assertTrue( r8.equals( r9 ) );
		assertTrue( r9.equals( r10 ) );
	}

	public void testSameLength()
	{
		assertTrue( r6.sameLength( r1 ) );
		assertTrue( r2.sameLength( r2 ) );
		assertTrue( !r4.sameLength( r5 ) );
	}

	public void testInRange()
	{
		assertTrue( r1.inRange( 12 ) );
		assertTrue( !r1.inRange( 2 ) );
		assertTrue( r1.inRange( 10 ) );
		assertTrue( r1.inRange( 20 ) );
		assertTrue( r1.inRange( r1.getBegin() ) );
		assertTrue( r1.inRange( r1.getEnd() ) );
	}

	public void testParsing()
	{
		try {
			Range rx = new Range("broken");			
			fail( "Should raise NumberFormatException");
		}
		catch ( NumberFormatException e ){ };

		try {
			Range rx = new Range("7 -9");			
			fail( "Should raise NumberFormatException");
		}
		catch ( NumberFormatException e ){ };
		
		try {
			Range rx = new Range("7=9");			
			fail( "Should raise NumberFormatException");
		}
		catch ( NumberFormatException e ){ };

		try {
			Range rx = new Range("7-t");			
			fail( "Should raise NumberFormatException");
		}
		catch ( NumberFormatException e ){ };

	}
}
