
/****************************************************************************** 
 * 
 *  file:  SaqiSternbergGenerator.h
 * 
 *  Copyright (c) 2003,  University of Virginia..
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#ifndef SAQISTERNBERGGENERATOR_H
#define SAQISTERNBERGGENERATOR_H

#include <string>
#include <cstdlib>
#include <algorithm>
#include <fstream>
#include <vector>
#include <list>
#include <ScoringMatrix.h> 
#include <GenericException.h> 
#include <XMLable.h> 
#include <XML.h> 
#include <Tostring.h> 
#include <time.h> 
#include "Alignment.h" 
#include "Whence.h" 
#include "AlignmentGenerator.h" 

using namespace std;

namespace NOPT {

class SaqiSternbergGenerator : public AlignmentGenerator
{
	public:
					
		SaqiSternbergGenerator(int gapCreate, int gapExtend, ScoringMatrix* sm,
						   bool isDNA, const string& seq1, 
						   const string& seq2, float lowerbound, 
						   float upperbound, int debug, int numToGen );

		~SaqiSternbergGenerator();


//		void getAscii(bool compress = true) const; 

	protected:
		void _generate();
		void _updateWeights( const Alignment& a );
		Alignment& _createAlignment();

		// ss specific
		vector< vector<int> > _scores;
		vector< vector<Whence> > _directions;
		map<string, int> _weights;
		int _numToGenerate;
		int _numAlignments;

};

}

#endif
