
/****************************************************************************** 
 * 
 *  file:  Whence.cpp
 * 
 *  Copyright (c) 2003,  University of Virginia..
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 



#include "Whence.h"

namespace NOPT {

Whence::Whence(int bitMask, int downIndex, int acrossIndex)
: _bitMask(bitMask),
  _downIndex(downIndex),
  _acrossIndex(acrossIndex)
{ }

Whence& Whence::operator=(const Whence& w)
{ 
    if ( &w != this )
	{
		_bitMask = w._bitMask;
		_downIndex = w._downIndex;
		_acrossIndex = w._acrossIndex;
	}

	return *this;
}

bool Whence::operator==(const Whence& w)
{
	if ( _bitMask == w._bitMask &&
		 _downIndex == w._downIndex &&
		 _acrossIndex == w._acrossIndex )
		return true;
	else
		return false;
}

ostream& operator<<(ostream& os, const Whence& w)
{
	os << w._bitMask << "," << w._downIndex << "," << w._acrossIndex;
	return os;
}


int Whence::getAcrossIndex() const { return _acrossIndex; }
int Whence::getDownIndex() const { return _downIndex; }
int Whence::getDirection() const { return _bitMask; }

void Whence::setDirection( int x ) { _bitMask = x; }
void Whence::setDownIndex( int x ) { _downIndex = x; }
void Whence::setAcrossIndex( int x ) { _acrossIndex = x; }

}
