
/****************************************************************************** 
 * 
 *  file:  bitscore.cpp
 * 
 *  Copyright (c) 2003,  University of Virginia..
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#include "Alignment.h"
#include <AltshulGishParams.h>
#include <tclap/CmdLine.h>

using namespace NOPT;
using namespace TCLAP;
using namespace std;


int _gapCreate;
int _gapExtend;
string _smName;
bool _debug;
int _score;

void parseOptions(int argc, char** argv);

int main(int argc, char** argv)
{
	try {

	parseOptions(argc,argv);

	cout << "alignment-score: " << _score << endl;
	cout << "scoring-matrix:  " << _smName << endl;
	cout << "gap-open:        " << _gapCreate << endl;
	cout << "gap-extend:      " << _gapExtend << endl;
	cout.flush();

	float bs = Alignment::BitScore( _score, _smName, 
	                               _gapCreate, _gapExtend, _debug );

	cout << "bit-score:       " << bs << endl;

	} catch (GenericException e) 
	{ 
			cout << "ERROR: " << e.errorData() << endl; 
			return 1;
	}

	return 0;
}


void parseOptions(int argc, char** argv)
{
	try { 

	//
	// Define all possible command line arguments.  Note that last arg
	// in the constructor is the default value for that particular 
	// argument.
	//
	ValueArg<int> gapCreate("f","gapCreate", "The cost of creating a gap", 
								 true, -10,"negative int");

	ValueArg<int> gapExtend("g","gapExtend",
					        "The cost for each extension of a gap", 
	                         true, -2,"negative int"); 

	ValueArg<int> alignmentScore("a","alignmentScore",
					        "The score to calculate the bit score for", 
	                         true, 0,"int"); 

	ValueArg<string> scoringMatrixName("s","scoringMatrix", 
					                   "Scoring Matrix name", 
							           true,"BLOSUM50","name string"); 

	SwitchArg deb ("d","debug","print debug messages", false);

	string message = 
"This is a simple program the bit score for an alignment given its gap penalties, scoring matrix and alignment score.";

	// Parse the command line.
	//
	CmdLine cmd(argv[0], message, "rel-2-1"); 
	cmd.add(gapCreate);
	cmd.add(gapExtend);
	cmd.add(scoringMatrixName);
	cmd.add(alignmentScore);
	cmd.add(deb);
	cmd.parse(argc,argv);

	//
	// Set variables
	//
	_gapCreate = gapCreate.getValue();
	_gapExtend = gapExtend.getValue();
	_score = alignmentScore.getValue();
	_smName = scoringMatrixName.getValue();
	_debug = deb.getValue();

	} catch (ArgException e)  
	{ 
		cerr << "error: " << e.error() << " for arg " << e.argId() << endl; 
		exit(1);
	}
}

