
/****************************************************************************** 
 * 
 *  file:  AltshulGishParams.h
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#ifndef ALTSHULGISHPARAMS_H
#define ALTSHULGISHPARAMS_H

#include <string>
#include <map>
#include <cctype>
#include <algorithm>
#include <iostream>
#include "GenericException.h" 
#include "Tostring.h" 
#include "FASTA_AltshulGishData.h" 

using namespace std;

namespace NOPT {

class AltshulGishParams
{
    public:
		AltshulGishParams(const string& name, int gapCreate, int gapExtend);

		float K() { return _K; };
		float H() { return _H; };
		float Lambda() { return _Lambda; };

		string& getMatrixName() { return _matrixName; }
		int getGapCreate() { return _gapCreate; }
		int getGapExtend() { return _gapExtend; }

	private:
		string _matrixName;
		int _gapCreate; 
		int _gapExtend; 

		float _K; 
		float _H; 
		float _Lambda; 

		void _create(const FASTA::alt_p params[], const int size);
};

}

#endif
