
/****************************************************************************** 
 * 
 *  file:  BLAST_ScoringMatrices.h
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 

//===========================================================================
//
// Scoring Matrices delivered with the BLAST package and transformed into
// usable arrays.
//
//===========================================================================

using namespace std;

namespace BLAST {

//  Matrix made by matblas from blosum100_3.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 100
//  Entropy =   1.4516, Expected =  -1.0948
const char blosum100_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum100_50[325] =  { 
 8,
-3, 10,
-4,-2, 11,
-5,-5, 1, 10,
-2,-8,-5,-8, 14,
-2, 0,-1,-2,-7, 11,
-3,-2,-2, 2,-9, 2, 10,
-1,-6,-2,-4,-7,-5,-6, 9,
-4,-1, 0,-3,-8, 1,-2,-6, 13,
-4,-7,-7,-8,-3,-6,-7,-9,-7, 8,
-4,-6,-7,-8,-5,-5,-7,-8,-6, 2, 8,
-2, 3,-1,-3,-8, 2, 0,-5,-3,-6,-6, 10,
-3,-4,-5,-8,-4,-2,-5,-7,-5, 1, 3,-4, 12,
-5,-6,-7,-8,-4,-6,-8,-8,-4,-2, 0,-6,-1, 11,
-2,-5,-5,-5,-8,-4,-4,-6,-5,-7,-7,-3,-5,-7, 12,
 1,-3, 0,-2,-3,-2,-2,-2,-3,-5,-6,-2,-4,-5,-3, 9,
-1,-3,-1,-4,-3,-3,-3,-5,-4,-3,-4,-3,-2,-5,-4, 2, 9,
-6,-7,-8,-10,-7,-5,-8,-7,-5,-6,-5,-8,-4, 0,-8,-7,-7, 17,
-5,-5,-5,-7,-6,-4,-7,-8, 1,-4,-4,-5,-5, 4,-7,-5,-5, 2, 12,
-2,-6,-7,-8,-3,-5,-5,-8,-7, 4, 0,-5, 0,-3,-6,-4,-1,-5,-5, 8,
-4,-4, 5, 6,-7,-2, 0,-3,-2,-8,-8,-2,-7,-7,-5,-1,-2,-9,-6,-7, 6,
-2,-1,-2, 0,-8, 5, 7,-5,-1,-7,-6, 0,-4,-7,-4,-2,-3,-7,-6,-5, 0, 6,
-2,-3,-3,-4,-5,-2,-3,-4,-4,-3,-3,-3,-3,-4,-4,-2,-2,-6,-4,-3,-4,-2,-3,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};


//  Matrix made by matblas from blosum100_3.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 100
//  Entropy =   1.4516, Expected =  -1.0948
const char blosum100_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum100[325] =  { 
 8,
-3, 10,
-4,-2, 11,
-5,-5, 1, 10,
-2,-8,-5,-8, 14,
-2, 0,-1,-2,-7, 11,
-3,-2,-2, 2,-9, 2, 10,
-1,-6,-2,-4,-7,-5,-6, 9,
-4,-1, 0,-3,-8, 1,-2,-6, 13,
-4,-7,-7,-8,-3,-6,-7,-9,-7, 8,
-4,-6,-7,-8,-5,-5,-7,-8,-6, 2, 8,
-2, 3,-1,-3,-8, 2, 0,-5,-3,-6,-6, 10,
-3,-4,-5,-8,-4,-2,-5,-7,-5, 1, 3,-4, 12,
-5,-6,-7,-8,-4,-6,-8,-8,-4,-2, 0,-6,-1, 11,
-2,-5,-5,-5,-8,-4,-4,-6,-5,-7,-7,-3,-5,-7, 12,
 1,-3, 0,-2,-3,-2,-2,-2,-3,-5,-6,-2,-4,-5,-3, 9,
-1,-3,-1,-4,-3,-3,-3,-5,-4,-3,-4,-3,-2,-5,-4, 2, 9,
-6,-7,-8,-10,-7,-5,-8,-7,-5,-6,-5,-8,-4, 0,-8,-7,-7, 17,
-5,-5,-5,-7,-6,-4,-7,-8, 1,-4,-4,-5,-5, 4,-7,-5,-5, 2, 12,
-2,-6,-7,-8,-3,-5,-5,-8,-7, 4, 0,-5, 0,-3,-6,-4,-1,-5,-5, 8,
-4,-4, 5, 6,-7,-2, 0,-3,-2,-8,-8,-2,-7,-7,-5,-1,-2,-9,-6,-7, 6,
-2,-1,-2, 0,-8, 5, 7,-5,-1,-7,-6, 0,-4,-7,-4,-2,-3,-7,-6,-5, 0, 6,
-2,-3,-3,-4,-5,-2,-3,-4,-4,-3,-3,-3,-3,-4,-4,-2,-2,-6,-4,-3,-4,-2,-3,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};


//  Matrix made by matblas from blosum30.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/5 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 30
//  Entropy =   0.1424, Expected =  -0.1074
const char blosum30_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum30_50[325] =  { 
 4,
-1, 8,
 0,-2, 8,
 0,-1, 1, 9,
-3,-2,-1,-3, 17,
 1, 3,-1,-1,-2, 8,
 0,-1,-1, 1, 1, 2, 6,
 0,-2, 0,-1,-4,-2,-2, 8,
-2,-1,-1,-2,-5, 0, 0,-3, 14,
 0,-3, 0,-4,-2,-2,-3,-1,-2, 6,
-1,-2,-2,-1, 0,-2,-1,-2,-1, 2, 4,
 0, 1, 0, 0,-3, 0, 2,-1,-2,-2,-2, 4,
 1, 0, 0,-3,-2,-1,-1,-2, 2, 1, 2, 2, 6,
-2,-1,-1,-5,-3,-3,-4,-3,-3, 0, 2,-1,-2, 10,
-1,-1,-3,-1,-3, 0, 1,-1, 1,-3,-3, 1,-4,-4, 11,
 1,-1, 0, 0,-2,-1, 0, 0,-1,-1,-2, 0,-2,-1,-1, 4,
 1,-3, 1,-1,-2, 0,-2,-2,-2, 0, 0,-1, 0,-2, 0, 2, 5,
-5, 0,-7,-4,-2,-1,-1, 1,-5,-3,-2,-2,-3, 1,-3,-3,-5, 20,
-4, 0,-4,-1,-6,-1,-2,-3, 0,-1, 3,-1,-1, 3,-2,-2,-1, 5, 9,
 1,-1,-2,-2,-2,-3,-3,-3,-3, 4, 1,-2, 0, 1,-4,-1, 1,-3, 1, 5,
 0,-2, 4, 5,-2,-1, 0, 0,-2,-2,-1, 0,-2,-3,-2, 0, 0,-5,-3,-2, 5,
 0, 0,-1, 0, 0, 4, 5,-2, 0,-3,-1, 1,-1,-4, 0,-1,-1,-1,-2,-3, 0, 4,
 0,-1, 0,-1,-2, 0,-1,-1,-1, 0, 0, 0, 0,-1,-1, 0, 0,-2,-1, 0,-1, 0,-1,
-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
};


//  Matrix made by matblas from blosum30.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/5 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 30
//  Entropy =   0.1424, Expected =  -0.1074
const char blosum30_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum30[325] =  { 
 4,
-1, 8,
 0,-2, 8,
 0,-1, 1, 9,
-3,-2,-1,-3, 17,
 1, 3,-1,-1,-2, 8,
 0,-1,-1, 1, 1, 2, 6,
 0,-2, 0,-1,-4,-2,-2, 8,
-2,-1,-1,-2,-5, 0, 0,-3, 14,
 0,-3, 0,-4,-2,-2,-3,-1,-2, 6,
-1,-2,-2,-1, 0,-2,-1,-2,-1, 2, 4,
 0, 1, 0, 0,-3, 0, 2,-1,-2,-2,-2, 4,
 1, 0, 0,-3,-2,-1,-1,-2, 2, 1, 2, 2, 6,
-2,-1,-1,-5,-3,-3,-4,-3,-3, 0, 2,-1,-2, 10,
-1,-1,-3,-1,-3, 0, 1,-1, 1,-3,-3, 1,-4,-4, 11,
 1,-1, 0, 0,-2,-1, 0, 0,-1,-1,-2, 0,-2,-1,-1, 4,
 1,-3, 1,-1,-2, 0,-2,-2,-2, 0, 0,-1, 0,-2, 0, 2, 5,
-5, 0,-7,-4,-2,-1,-1, 1,-5,-3,-2,-2,-3, 1,-3,-3,-5, 20,
-4, 0,-4,-1,-6,-1,-2,-3, 0,-1, 3,-1,-1, 3,-2,-2,-1, 5, 9,
 1,-1,-2,-2,-2,-3,-3,-3,-3, 4, 1,-2, 0, 1,-4,-1, 1,-3, 1, 5,
 0,-2, 4, 5,-2,-1, 0, 0,-2,-2,-1, 0,-2,-3,-2, 0, 0,-5,-3,-2, 5,
 0, 0,-1, 0, 0, 4, 5,-2, 0,-3,-1, 1,-1,-4, 0,-1,-1,-1,-2,-3, 0, 4,
 0,-1, 0,-1,-2, 0,-1,-1,-1, 0, 0, 0, 0,-1,-1, 0, 0,-2,-1, 0,-1, 0,-1,
-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
};


//  Matrix made by matblas from blosum35.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 35
//  Entropy =   0.2111, Expected =  -0.1550
const char blosum35_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum35_50[325] =  { 
 5,
-1, 8,
-1,-1, 7,
-1,-1, 1, 8,
-2,-3,-1,-3, 15,
 0, 2, 1,-1,-3, 7,
-1,-1,-1, 2,-1, 2, 6,
 0,-2, 1,-2,-3,-2,-2, 7,
-2,-1, 1, 0,-4,-1,-1,-2, 12,
-1,-3,-1,-3,-4,-2,-3,-3,-3, 5,
-2,-2,-2,-2,-2,-2,-1,-3,-2, 2, 5,
 0, 2, 0,-1,-2, 0, 1,-1,-2,-2,-2, 5,
 0, 0,-1,-3,-4,-1,-2,-1, 1, 1, 3, 0, 6,
-2,-1,-1,-3,-4,-4,-3,-3,-3, 1, 2,-1, 0, 8,
-2,-2,-2,-1,-4, 0, 0,-2,-1,-1,-3, 0,-3,-4, 10,
 1,-1, 0,-1,-3, 0, 0, 1,-1,-2,-2, 0,-1,-1,-2, 4,
 0,-2, 0,-1,-1, 0,-1,-2,-2,-1, 0, 0, 0,-1, 0, 2, 5,
-2, 0,-2,-3,-5,-1,-1,-1,-4,-1, 0, 0, 1, 1,-4,-2,-2, 16,
-1, 0,-2,-2,-5, 0,-1,-2, 0, 0, 0,-1, 0, 3,-3,-1,-2, 3, 8,
 0,-1,-2,-2,-2,-3,-2,-3,-4, 4, 2,-2, 1, 1,-3,-1, 1,-2, 0, 5,
-1,-1, 4, 5,-2, 0, 0, 0, 0,-2,-2, 0,-2,-2,-1, 0,-1,-3,-2,-2, 5,
-1, 0, 0, 1,-2, 4, 5,-2,-1,-3,-2, 1,-2,-3, 0, 0,-1,-1,-1,-2, 0, 4,
 0,-1, 0,-1,-2,-1,-1,-1,-1, 0, 0, 0, 0,-1,-1, 0, 0,-1,-1, 0,-1, 0,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum35.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 35
//  Entropy =   0.2111, Expected =  -0.1550
const char blosum35_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum35[325] =  { 
 5,
-1, 8,
-1,-1, 7,
-1,-1, 1, 8,
-2,-3,-1,-3, 15,
 0, 2, 1,-1,-3, 7,
-1,-1,-1, 2,-1, 2, 6,
 0,-2, 1,-2,-3,-2,-2, 7,
-2,-1, 1, 0,-4,-1,-1,-2, 12,
-1,-3,-1,-3,-4,-2,-3,-3,-3, 5,
-2,-2,-2,-2,-2,-2,-1,-3,-2, 2, 5,
 0, 2, 0,-1,-2, 0, 1,-1,-2,-2,-2, 5,
 0, 0,-1,-3,-4,-1,-2,-1, 1, 1, 3, 0, 6,
-2,-1,-1,-3,-4,-4,-3,-3,-3, 1, 2,-1, 0, 8,
-2,-2,-2,-1,-4, 0, 0,-2,-1,-1,-3, 0,-3,-4, 10,
 1,-1, 0,-1,-3, 0, 0, 1,-1,-2,-2, 0,-1,-1,-2, 4,
 0,-2, 0,-1,-1, 0,-1,-2,-2,-1, 0, 0, 0,-1, 0, 2, 5,
-2, 0,-2,-3,-5,-1,-1,-1,-4,-1, 0, 0, 1, 1,-4,-2,-2, 16,
-1, 0,-2,-2,-5, 0,-1,-2, 0, 0, 0,-1, 0, 3,-3,-1,-2, 3, 8,
 0,-1,-2,-2,-2,-3,-2,-3,-4, 4, 2,-2, 1, 1,-3,-1, 1,-2, 0, 5,
-1,-1, 4, 5,-2, 0, 0, 0, 0,-2,-2, 0,-2,-2,-1, 0,-1,-3,-2,-2, 5,
-1, 0, 0, 1,-2, 4, 5,-2,-1,-3,-2, 1,-2,-3, 0, 0,-1,-1,-1,-2, 0, 4,
 0,-1, 0,-1,-2,-1,-1,-1,-1, 0, 0, 0, 0,-1,-1, 0, 0,-1,-1, 0,-1, 0,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum40.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 40
//  Entropy =   0.2851, Expected =  -0.2090
const char blosum40_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum40_50[325] =  { 
 5,
-2, 9,
-1, 0, 8,
-1,-1, 2, 9,
-2,-3,-2,-2, 16,
 0, 2, 1,-1,-4, 8,
-1,-1,-1, 2,-2, 2, 7,
 1,-3, 0,-2,-3,-2,-3, 8,
-2, 0, 1, 0,-4, 0, 0,-2, 13,
-1,-3,-2,-4,-4,-3,-4,-4,-3, 6,
-2,-2,-3,-3,-2,-2,-2,-4,-2, 2, 6,
-1, 3, 0, 0,-3, 1, 1,-2,-1,-3,-2, 6,
-1,-1,-2,-3,-3,-1,-2,-2, 1, 1, 3,-1, 7,
-3,-2,-3,-4,-2,-4,-3,-3,-2, 1, 2,-3, 0, 9,
-2,-3,-2,-2,-5,-2, 0,-1,-2,-2,-4,-1,-2,-4, 11,
 1,-1, 1, 0,-1, 1, 0, 0,-1,-2,-3, 0,-2,-2,-1, 5,
 0,-2, 0,-1,-1,-1,-1,-2,-2,-1,-1, 0,-1,-1, 0, 2, 6,
-3,-2,-4,-5,-6,-1,-2,-2,-5,-3,-1,-2,-2, 1,-4,-5,-4, 19,
-2,-1,-2,-3,-4,-1,-2,-3, 2, 0, 0,-1, 1, 4,-3,-2,-1, 3, 9,
 0,-2,-3,-3,-2,-3,-3,-4,-4, 4, 2,-2, 1, 0,-3,-1, 1,-3,-1, 5,
-1,-1, 4, 6,-2, 0, 1,-1, 0,-3,-3, 0,-3,-3,-2, 0, 0,-4,-3,-3, 5,
-1, 0, 0, 1,-3, 4, 5,-2, 0,-4,-2, 1,-2,-4,-1, 0,-1,-2,-2,-3, 2, 5,
 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1, 0,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
};


//  Matrix made by matblas from blosum40.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 40
//  Entropy =   0.2851, Expected =  -0.2090
const char blosum40_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum40[325] =  { 
 5,
-2, 9,
-1, 0, 8,
-1,-1, 2, 9,
-2,-3,-2,-2, 16,
 0, 2, 1,-1,-4, 8,
-1,-1,-1, 2,-2, 2, 7,
 1,-3, 0,-2,-3,-2,-3, 8,
-2, 0, 1, 0,-4, 0, 0,-2, 13,
-1,-3,-2,-4,-4,-3,-4,-4,-3, 6,
-2,-2,-3,-3,-2,-2,-2,-4,-2, 2, 6,
-1, 3, 0, 0,-3, 1, 1,-2,-1,-3,-2, 6,
-1,-1,-2,-3,-3,-1,-2,-2, 1, 1, 3,-1, 7,
-3,-2,-3,-4,-2,-4,-3,-3,-2, 1, 2,-3, 0, 9,
-2,-3,-2,-2,-5,-2, 0,-1,-2,-2,-4,-1,-2,-4, 11,
 1,-1, 1, 0,-1, 1, 0, 0,-1,-2,-3, 0,-2,-2,-1, 5,
 0,-2, 0,-1,-1,-1,-1,-2,-2,-1,-1, 0,-1,-1, 0, 2, 6,
-3,-2,-4,-5,-6,-1,-2,-2,-5,-3,-1,-2,-2, 1,-4,-5,-4, 19,
-2,-1,-2,-3,-4,-1,-2,-3, 2, 0, 0,-1, 1, 4,-3,-2,-1, 3, 9,
 0,-2,-3,-3,-2,-3,-3,-4,-4, 4, 2,-2, 1, 0,-3,-1, 1,-3,-1, 5,
-1,-1, 4, 6,-2, 0, 1,-1, 0,-3,-3, 0,-3,-3,-2, 0, 0,-4,-3,-3, 5,
-1, 0, 0, 1,-3, 4, 5,-2, 0,-4,-2, 1,-2,-4,-1, 0,-1,-2,-2,-3, 2, 5,
 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1, 0,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
};


//  Matrix made by matblas from blosum45.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 45
//  Entropy =   0.3795, Expected =  -0.2789
const char blosum45_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum45_50[325] =  { 
 5,
-2, 7,
-1, 0, 6,
-2,-1, 2, 7,
-1,-3,-2,-3, 12,
-1, 1, 0, 0,-3, 6,
-1, 0, 0, 2,-3, 2, 6,
 0,-2, 0,-1,-3,-2,-2, 7,
-2, 0, 1, 0,-3, 1, 0,-2, 10,
-1,-3,-2,-4,-3,-2,-3,-4,-3, 5,
-1,-2,-3,-3,-2,-2,-2,-3,-2, 2, 5,
-1, 3, 0, 0,-3, 1, 1,-2,-1,-3,-3, 5,
-1,-1,-2,-3,-2, 0,-2,-2, 0, 2, 2,-1, 6,
-2,-2,-2,-4,-2,-4,-3,-3,-2, 0, 1,-3, 0, 8,
-1,-2,-2,-1,-4,-1, 0,-2,-2,-2,-3,-1,-2,-3, 9,
 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-3,-1,-2,-2,-1, 4,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-1,-1, 2, 5,
-2,-2,-4,-4,-5,-2,-3,-2,-3,-2,-2,-2,-2, 1,-3,-4,-3, 15,
-2,-1,-2,-2,-3,-1,-2,-3, 2, 0, 0,-1, 0, 3,-3,-2,-1, 3, 8,
 0,-2,-3,-3,-1,-3,-3,-3,-3, 3, 1,-2, 1, 0,-3,-1, 0,-3,-1, 5,
-1,-1, 4, 5,-2, 0, 1,-1, 0,-3,-3, 0,-2,-3,-2, 0, 0,-4,-2,-3, 4,
-1, 0, 0, 1,-3, 4, 4,-2, 0,-3,-2, 1,-1,-3,-1, 0,-1,-2,-2,-3, 2, 4,
 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 0, 0,-2,-1,-1,-1,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum45.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 45
//  Entropy =   0.3795, Expected =  -0.2789
const char blosum45_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum45[325] =  { 
 5,
-2, 7,
-1, 0, 6,
-2,-1, 2, 7,
-1,-3,-2,-3, 12,
-1, 1, 0, 0,-3, 6,
-1, 0, 0, 2,-3, 2, 6,
 0,-2, 0,-1,-3,-2,-2, 7,
-2, 0, 1, 0,-3, 1, 0,-2, 10,
-1,-3,-2,-4,-3,-2,-3,-4,-3, 5,
-1,-2,-3,-3,-2,-2,-2,-3,-2, 2, 5,
-1, 3, 0, 0,-3, 1, 1,-2,-1,-3,-3, 5,
-1,-1,-2,-3,-2, 0,-2,-2, 0, 2, 2,-1, 6,
-2,-2,-2,-4,-2,-4,-3,-3,-2, 0, 1,-3, 0, 8,
-1,-2,-2,-1,-4,-1, 0,-2,-2,-2,-3,-1,-2,-3, 9,
 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-3,-1,-2,-2,-1, 4,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-1,-1, 2, 5,
-2,-2,-4,-4,-5,-2,-3,-2,-3,-2,-2,-2,-2, 1,-3,-4,-3, 15,
-2,-1,-2,-2,-3,-1,-2,-3, 2, 0, 0,-1, 0, 3,-3,-2,-1, 3, 8,
 0,-2,-3,-3,-1,-3,-3,-3,-3, 3, 1,-2, 1, 0,-3,-1, 0,-3,-1, 5,
-1,-1, 4, 5,-2, 0, 1,-1, 0,-3,-3, 0,-2,-3,-2, 0, 0,-4,-2,-3, 4,
-1, 0, 0, 1,-3, 4, 4,-2, 0,-3,-2, 1,-1,-3,-1, 0,-1,-2,-2,-3, 2, 4,
 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 0, 0,-2,-1,-1,-1,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum50.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 50
//  Entropy =   0.4808, Expected =  -0.3573
const char blosum50_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum50_50[325] =  { 
 5,
-2, 7,
-1,-1, 7,
-2,-2, 2, 8,
-1,-4,-2,-4, 13,
-1, 1, 0, 0,-3, 7,
-1, 0, 0, 2,-3, 2, 6,
 0,-3, 0,-1,-3,-2,-3, 8,
-2, 0, 1,-1,-3, 1, 0,-2, 10,
-1,-4,-3,-4,-2,-3,-4,-4,-4, 5,
-2,-3,-4,-4,-2,-2,-3,-4,-3, 2, 5,
-1, 3, 0,-1,-3, 2, 1,-2, 0,-3,-3, 6,
-1,-2,-2,-4,-2, 0,-2,-3,-1, 2, 3,-2, 7,
-3,-3,-4,-5,-2,-4,-3,-4,-1, 0, 1,-4, 0, 8,
-1,-3,-2,-1,-4,-1,-1,-2,-2,-3,-4,-1,-3,-4, 10,
 1,-1, 1, 0,-1, 0,-1, 0,-1,-3,-3, 0,-2,-3,-1, 5,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 2, 5,
-3,-3,-4,-5,-5,-1,-3,-3,-3,-3,-2,-3,-1, 1,-4,-4,-3, 15,
-2,-1,-2,-3,-3,-1,-2,-3, 2,-1,-1,-2, 0, 4,-3,-2,-2, 2, 8,
 0,-3,-3,-4,-1,-3,-3,-4,-4, 4, 1,-3, 1,-1,-3,-2, 0,-3,-1, 5,
-2,-1, 4, 5,-3, 0, 1,-1, 0,-4,-4, 0,-3,-4,-2, 0, 0,-5,-3,-4, 5,
-1, 0, 0, 1,-3, 4, 5,-2, 0,-3,-3, 1,-1,-4,-1, 0,-1,-2,-2,-3, 2, 5,
-1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1, 0,-3,-1,-1,-1,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum50.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 50
//  Entropy =   0.4808, Expected =  -0.3573
const char blosum50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum50[325] =  { 
 5,
-2, 7,
-1,-1, 7,
-2,-2, 2, 8,
-1,-4,-2,-4, 13,
-1, 1, 0, 0,-3, 7,
-1, 0, 0, 2,-3, 2, 6,
 0,-3, 0,-1,-3,-2,-3, 8,
-2, 0, 1,-1,-3, 1, 0,-2, 10,
-1,-4,-3,-4,-2,-3,-4,-4,-4, 5,
-2,-3,-4,-4,-2,-2,-3,-4,-3, 2, 5,
-1, 3, 0,-1,-3, 2, 1,-2, 0,-3,-3, 6,
-1,-2,-2,-4,-2, 0,-2,-3,-1, 2, 3,-2, 7,
-3,-3,-4,-5,-2,-4,-3,-4,-1, 0, 1,-4, 0, 8,
-1,-3,-2,-1,-4,-1,-1,-2,-2,-3,-4,-1,-3,-4, 10,
 1,-1, 1, 0,-1, 0,-1, 0,-1,-3,-3, 0,-2,-3,-1, 5,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 2, 5,
-3,-3,-4,-5,-5,-1,-3,-3,-3,-3,-2,-3,-1, 1,-4,-4,-3, 15,
-2,-1,-2,-3,-3,-1,-2,-3, 2,-1,-1,-2, 0, 4,-3,-2,-2, 2, 8,
 0,-3,-3,-4,-1,-3,-3,-4,-4, 4, 1,-3, 1,-1,-3,-2, 0,-3,-1, 5,
-2,-1, 4, 5,-3, 0, 1,-1, 0,-4,-4, 0,-3,-4,-2, 0, 0,-5,-3,-4, 5,
-1, 0, 0, 1,-3, 4, 5,-2, 0,-3,-3, 1,-1,-4,-1, 0,-1,-2,-2,-3, 2, 5,
-1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1, 0,-3,-1,-1,-1,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum55.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 55
//  Entropy =   0.5637, Expected =  -0.4179
const char blosum55_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum55_50[325] =  { 
 5,
-2, 8,
-2,-1, 8,
-2,-2, 2, 8,
 0,-4,-3,-4, 13,
-1, 1, 0, 0,-4, 7,
-1, 0, 0, 2,-4, 2, 7,
 0,-3, 0,-2,-3,-2,-3, 8,
-2, 0, 1,-1,-4, 1,-1,-2, 11,
-2,-4,-4,-4,-2,-4,-4,-5,-4, 6,
-2,-3,-4,-5,-2,-3,-4,-5,-3, 2, 6,
-1, 3, 0,-1,-4, 2, 1,-2, 0,-4,-3, 6,
-1,-2,-3,-4,-2, 0,-3,-3,-2, 2, 3,-2, 8,
-3,-3,-4,-5,-3,-4,-4,-4,-1, 0, 1,-4, 0, 9,
-1,-3,-2,-2,-3,-1,-1,-3,-3,-3,-4,-1,-3,-5, 10,
 2,-1, 1, 0,-1, 0, 0, 0,-1,-3,-3, 0,-2,-3,-1, 5,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-3,-1, 2, 6,
-4,-3,-5,-5,-4,-2,-3,-3,-3,-3,-3,-4,-2, 2,-5,-4,-3, 15,
-2,-2,-2,-3,-3,-1,-2,-4, 2,-1,-1,-2,-1, 4,-4,-2,-2, 3, 9,
 0,-3,-4,-4,-1,-3,-3,-4,-4, 4, 1,-3, 1,-1,-3,-2, 0,-4,-2, 5,
-2,-1, 4, 5,-4, 0, 1,-1, 0,-4,-4, 0,-3,-5,-2, 0,-1,-5,-3,-4, 5,
-1, 0, 0, 1,-4, 4, 5,-3, 0,-4,-3, 1,-2,-4,-1, 0,-1,-3,-2,-3, 2, 5,
-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-3,-1,-1,-1,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum55.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 55
//  Entropy =   0.5637, Expected =  -0.4179
const char blosum55_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum55[325] =  { 
 5,
-2, 8,
-2,-1, 8,
-2,-2, 2, 8,
 0,-4,-3,-4, 13,
-1, 1, 0, 0,-4, 7,
-1, 0, 0, 2,-4, 2, 7,
 0,-3, 0,-2,-3,-2,-3, 8,
-2, 0, 1,-1,-4, 1,-1,-2, 11,
-2,-4,-4,-4,-2,-4,-4,-5,-4, 6,
-2,-3,-4,-5,-2,-3,-4,-5,-3, 2, 6,
-1, 3, 0,-1,-4, 2, 1,-2, 0,-4,-3, 6,
-1,-2,-3,-4,-2, 0,-3,-3,-2, 2, 3,-2, 8,
-3,-3,-4,-5,-3,-4,-4,-4,-1, 0, 1,-4, 0, 9,
-1,-3,-2,-2,-3,-1,-1,-3,-3,-3,-4,-1,-3,-5, 10,
 2,-1, 1, 0,-1, 0, 0, 0,-1,-3,-3, 0,-2,-3,-1, 5,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-3,-1, 2, 6,
-4,-3,-5,-5,-4,-2,-3,-3,-3,-3,-3,-4,-2, 2,-5,-4,-3, 15,
-2,-2,-2,-3,-3,-1,-2,-4, 2,-1,-1,-2,-1, 4,-4,-2,-2, 3, 9,
 0,-3,-4,-4,-1,-3,-3,-4,-4, 4, 1,-3, 1,-1,-3,-2, 0,-4,-2, 5,
-2,-1, 4, 5,-4, 0, 1,-1, 0,-4,-4, 0,-3,-5,-2, 0,-1,-5,-3,-4, 5,
-1, 0, 0, 1,-4, 4, 5,-3, 0,-4,-3, 1,-2,-4,-1, 0,-1,-3,-2,-3, 2, 5,
-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-3,-1,-1,-1,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum60.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 60
//  Entropy =   0.6603, Expected =  -0.4917
const char blosum60_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum60_50[325] =  { 
 4,
-1, 5,
-1, 0, 6,
-2,-1, 1, 6,
 0,-3,-2,-3, 9,
-1, 1, 0, 0,-3, 5,
-1, 0, 0, 2,-3, 2, 5,
 0,-2, 0,-1,-2,-2,-2, 6,
-2, 0, 1,-1,-3, 1, 0,-2, 7,
-1,-3,-3,-3,-1,-3,-3,-3,-3, 4,
-1,-2,-3,-3,-1,-2,-3,-4,-3, 2, 4,
-1, 2, 0,-1,-3, 1, 1,-1,-1,-3,-2, 4,
-1,-1,-2,-3,-1, 0,-2,-2,-1, 1, 2,-1, 5,
-2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,
 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 4,
-3,-3,-4,-4,-2,-2,-3,-2,-2,-2,-2,-3,-1, 1,-4,-3,-2, 10,
-2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 6,
 0,-2,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-3, 0,-3,-3,-2, 0, 0,-4,-2,-3, 4,
-1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-2, 1,-1,-3,-1, 0,-1,-2,-2,-2, 1, 3,
 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4, 1
};


//  Matrix made by matblas from blosum60.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 60
//  Entropy =   0.6603, Expected =  -0.4917
const char blosum60_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum60[325] =  { 
 4,
-1, 5,
-1, 0, 6,
-2,-1, 1, 6,
 0,-3,-2,-3, 9,
-1, 1, 0, 0,-3, 5,
-1, 0, 0, 2,-3, 2, 5,
 0,-2, 0,-1,-2,-2,-2, 6,
-2, 0, 1,-1,-3, 1, 0,-2, 7,
-1,-3,-3,-3,-1,-3,-3,-3,-3, 4,
-1,-2,-3,-3,-1,-2,-3,-4,-3, 2, 4,
-1, 2, 0,-1,-3, 1, 1,-1,-1,-3,-2, 4,
-1,-1,-2,-3,-1, 0,-2,-2,-1, 1, 2,-1, 5,
-2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,
 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 4,
-3,-3,-4,-4,-2,-2,-3,-2,-2,-2,-2,-3,-1, 1,-4,-3,-2, 10,
-2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 6,
 0,-2,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-3, 0,-3,-3,-2, 0, 0,-4,-2,-3, 4,
-1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-2, 1,-1,-3,-1, 0,-1,-2,-2,-2, 1, 3,
 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4, 1
};


//  Matrix made by matblas from blosum62.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 62
//  Entropy =   0.6979, Expected =  -0.5209
const char blosum62_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum62_50[325] =  { 
 4,
-1, 5,
-2, 0, 6,
-2,-2, 1, 6,
 0,-3,-3,-3, 9,
-1, 1, 0, 0,-3, 5,
-1, 0, 0, 2,-4, 2, 5,
 0,-2, 0,-1,-3,-2,-2, 6,
-2, 0, 1,-1,-3, 0, 0,-2, 8,
-1,-3,-3,-3,-1,-3,-3,-4,-3, 4,
-1,-2,-3,-4,-1,-2,-3,-4,-3, 2, 4,
-1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-2, 5,
-1,-1,-2,-3,-1, 0,-2,-3,-2, 1, 2,-1, 5,
-2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,
 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,
-3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1, 1,-4,-3,-2, 11,
-2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
 0,-3,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4,
-1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-3, 1,-1,-3,-1, 0,-1,-3,-2,-2, 1, 4,
 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4, 1
};


//  Matrix made by matblas from blosum62.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 62
//  Entropy =   0.6979, Expected =  -0.5209
const char blosum62_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum62[325] =  { 
 4,
-1, 5,
-2, 0, 6,
-2,-2, 1, 6,
 0,-3,-3,-3, 9,
-1, 1, 0, 0,-3, 5,
-1, 0, 0, 2,-4, 2, 5,
 0,-2, 0,-1,-3,-2,-2, 6,
-2, 0, 1,-1,-3, 0, 0,-2, 8,
-1,-3,-3,-3,-1,-3,-3,-4,-3, 4,
-1,-2,-3,-4,-1,-2,-3,-4,-3, 2, 4,
-1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-2, 5,
-1,-1,-2,-3,-1, 0,-2,-3,-2, 1, 2,-1, 5,
-2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,
 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,
-3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1, 1,-4,-3,-2, 11,
-2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
 0,-3,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4,
-1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-3, 1,-1,-3,-1, 0,-1,-3,-2,-2, 1, 4,
 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4, 1
};


//  Matrix made by matblas from blosum65.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 65
//  Entropy =   0.7576, Expected =  -0.5675
const char blosum65_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum65_50[325] =  { 
 4,
-1, 6,
-2, 0, 6,
-2,-2, 1, 6,
 0,-4,-3,-4, 9,
-1, 1, 0, 0,-3, 6,
-1, 0, 0, 2,-4, 2, 5,
 0,-2,-1,-1,-3,-2,-2, 6,
-2, 0, 1,-1,-3, 1, 0,-2, 8,
-1,-3,-3,-3,-1,-3,-3,-4,-3, 4,
-2,-2,-4,-4,-1,-2,-3,-4,-3, 2, 4,
-1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-3, 5,
-1,-2,-2,-3,-2, 0,-2,-3,-2, 1, 2,-2, 6,
-2,-3,-3,-4,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
-1,-2,-2,-2,-3,-1,-1,-2,-2,-3,-3,-1,-3,-4, 8,
 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-3, 0,-2,-2,-1, 4,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,
-3,-3,-4,-5,-2,-2,-3,-3,-2,-2,-2,-3,-2, 1,-4,-3,-3, 10,
-2,-2,-2,-3,-2,-2,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
 0,-3,-3,-3,-1,-2,-3,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4,
-1, 0, 0, 1,-4, 3, 4,-2, 0,-3,-3, 1,-2,-3,-1, 0,-1,-3,-2,-2, 1, 4,
-1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum65.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 65
//  Entropy =   0.7576, Expected =  -0.5675
const char blosum65_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum65[325] =  { 
 4,
-1, 6,
-2, 0, 6,
-2,-2, 1, 6,
 0,-4,-3,-4, 9,
-1, 1, 0, 0,-3, 6,
-1, 0, 0, 2,-4, 2, 5,
 0,-2,-1,-1,-3,-2,-2, 6,
-2, 0, 1,-1,-3, 1, 0,-2, 8,
-1,-3,-3,-3,-1,-3,-3,-4,-3, 4,
-2,-2,-4,-4,-1,-2,-3,-4,-3, 2, 4,
-1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-3, 5,
-1,-2,-2,-3,-2, 0,-2,-3,-2, 1, 2,-2, 6,
-2,-3,-3,-4,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
-1,-2,-2,-2,-3,-1,-1,-2,-2,-3,-3,-1,-3,-4, 8,
 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-3, 0,-2,-2,-1, 4,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,
-3,-3,-4,-5,-2,-2,-3,-3,-2,-2,-2,-3,-2, 1,-4,-3,-3, 10,
-2,-2,-2,-3,-2,-2,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
 0,-3,-3,-3,-1,-2,-3,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4,
-1, 0, 0, 1,-4, 3, 4,-2, 0,-3,-3, 1,-2,-3,-1, 0,-1,-3,-2,-2, 1, 4,
-1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum70.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 70
//  Entropy =   0.8391, Expected =  -0.6313
const char blosum70_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum70_50[325] =  { 
 4,
-2, 6,
-2,-1, 6,
-2,-2, 1, 6,
-1,-4,-3,-4, 9,
-1, 1, 0,-1,-3, 6,
-1, 0, 0, 1,-4, 2, 5,
 0,-3,-1,-2,-3,-2,-2, 6,
-2, 0, 0,-1,-4, 1, 0,-2, 8,
-2,-3,-4,-4,-1,-3,-4,-4,-4, 4,
-2,-3,-4,-4,-2,-2,-3,-4,-3, 2, 4,
-1, 2, 0,-1,-4, 1, 1,-2,-1,-3,-3, 5,
-1,-2,-2,-3,-2, 0,-2,-3,-2, 1, 2,-2, 6,
-2,-3,-3,-4,-2,-3,-4,-4,-1, 0, 0,-3, 0, 6,
-1,-2,-2,-2,-3,-2,-1,-3,-2,-3,-3,-1,-3,-4, 8,
 1,-1, 0, 0,-1, 0, 0,-1,-1,-3,-3, 0,-2,-3,-1, 4,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-1, 1, 5,
-3,-3,-4,-5,-3,-2,-4,-3,-2,-3,-2,-3,-2, 1,-4,-3,-3, 11,
-2,-2,-2,-4,-3,-2,-3,-4, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
 0,-3,-3,-4,-1,-2,-3,-4,-3, 3, 1,-3, 1,-1,-3,-2, 0,-3,-2, 4,
-2,-1, 3, 4,-4, 0, 1,-1,-1,-4,-4,-1,-3,-4,-2, 0,-1,-4,-3,-3, 4,
-1, 0, 0, 1,-4, 3, 4,-2, 0,-3,-3, 1,-2,-4,-1, 0,-1,-3,-2,-3, 0, 4,
-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-3,-2,-1,-1,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum70.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 70
//  Entropy =   0.8391, Expected =  -0.6313
const char blosum70_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum70[325] =  { 
 4,
-2, 6,
-2,-1, 6,
-2,-2, 1, 6,
-1,-4,-3,-4, 9,
-1, 1, 0,-1,-3, 6,
-1, 0, 0, 1,-4, 2, 5,
 0,-3,-1,-2,-3,-2,-2, 6,
-2, 0, 0,-1,-4, 1, 0,-2, 8,
-2,-3,-4,-4,-1,-3,-4,-4,-4, 4,
-2,-3,-4,-4,-2,-2,-3,-4,-3, 2, 4,
-1, 2, 0,-1,-4, 1, 1,-2,-1,-3,-3, 5,
-1,-2,-2,-3,-2, 0,-2,-3,-2, 1, 2,-2, 6,
-2,-3,-3,-4,-2,-3,-4,-4,-1, 0, 0,-3, 0, 6,
-1,-2,-2,-2,-3,-2,-1,-3,-2,-3,-3,-1,-3,-4, 8,
 1,-1, 0, 0,-1, 0, 0,-1,-1,-3,-3, 0,-2,-3,-1, 4,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-1, 1, 5,
-3,-3,-4,-5,-3,-2,-4,-3,-2,-3,-2,-3,-2, 1,-4,-3,-3, 11,
-2,-2,-2,-4,-3,-2,-3,-4, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
 0,-3,-3,-4,-1,-2,-3,-4,-3, 3, 1,-3, 1,-1,-3,-2, 0,-3,-2, 4,
-2,-1, 3, 4,-4, 0, 1,-1,-1,-4,-4,-1,-3,-4,-2, 0,-1,-4,-3,-3, 4,
-1, 0, 0, 1,-4, 3, 4,-2, 0,-3,-3, 1,-2,-4,-1, 0,-1,-3,-2,-3, 0, 4,
-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-3,-2,-1,-1,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum75.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 75
//  Entropy =   0.9077, Expected =  -0.6845
const char blosum75_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum75_50[325] =  { 
 4,
-2, 6,
-2,-1, 6,
-2,-2, 1, 6,
-1,-4,-3,-4, 9,
-1, 1, 0,-1,-3, 6,
-1, 0,-1, 1,-5, 2, 5,
 0,-3,-1,-2,-3,-2,-3, 6,
-2, 0, 0,-1,-4, 1, 0,-2, 8,
-2,-3,-4,-4,-1,-3,-4,-5,-4, 4,
-2,-3,-4,-4,-2,-3,-4,-4,-3, 1, 4,
-1, 2, 0,-1,-4, 1, 1,-2,-1,-3,-3, 5,
-1,-2,-3,-4,-2, 0,-2,-3,-2, 1, 2,-2, 6,
-3,-3,-4,-4,-2,-4,-4,-4,-2, 0, 0,-4, 0, 6,
-1,-2,-3,-2,-4,-2,-1,-3,-2,-3,-3,-1,-3,-4, 8,
 1,-1, 0,-1,-1, 0, 0,-1,-1,-3,-3, 0,-2,-3,-1, 5,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-1, 1, 5,
-3,-3,-4,-5,-3,-2,-4,-3,-2,-3,-2,-4,-2, 1,-5,-3,-3, 11,
-2,-2,-3,-4,-3,-2,-3,-4, 2,-2,-1,-2,-2, 3,-4,-2,-2, 2, 7,
 0,-3,-3,-4,-1,-2,-3,-4,-4, 3, 1,-3, 1,-1,-3,-2, 0,-3,-2, 4,
-2,-1, 3, 4,-4, 0, 1,-1,-1,-4,-4,-1,-3,-4,-2, 0,-1,-5,-3,-4, 4,
-1, 0, 0, 1,-4, 3, 4,-2, 0,-4,-3, 1,-2,-4,-2, 0,-1,-3,-3,-3, 0, 4,
-1,-1,-1,-2,-2,-1,-1,-2,-1,-2,-1,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum75.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 75
//  Entropy =   0.9077, Expected =  -0.6845
const char blosum75_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum75[325] =  { 
 4,
-2, 6,
-2,-1, 6,
-2,-2, 1, 6,
-1,-4,-3,-4, 9,
-1, 1, 0,-1,-3, 6,
-1, 0,-1, 1,-5, 2, 5,
 0,-3,-1,-2,-3,-2,-3, 6,
-2, 0, 0,-1,-4, 1, 0,-2, 8,
-2,-3,-4,-4,-1,-3,-4,-5,-4, 4,
-2,-3,-4,-4,-2,-3,-4,-4,-3, 1, 4,
-1, 2, 0,-1,-4, 1, 1,-2,-1,-3,-3, 5,
-1,-2,-3,-4,-2, 0,-2,-3,-2, 1, 2,-2, 6,
-3,-3,-4,-4,-2,-4,-4,-4,-2, 0, 0,-4, 0, 6,
-1,-2,-3,-2,-4,-2,-1,-3,-2,-3,-3,-1,-3,-4, 8,
 1,-1, 0,-1,-1, 0, 0,-1,-1,-3,-3, 0,-2,-3,-1, 5,
 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-1, 1, 5,
-3,-3,-4,-5,-3,-2,-4,-3,-2,-3,-2,-4,-2, 1,-5,-3,-3, 11,
-2,-2,-3,-4,-3,-2,-3,-4, 2,-2,-1,-2,-2, 3,-4,-2,-2, 2, 7,
 0,-3,-3,-4,-1,-2,-3,-4,-4, 3, 1,-3, 1,-1,-3,-2, 0,-3,-2, 4,
-2,-1, 3, 4,-4, 0, 1,-1,-1,-4,-4,-1,-3,-4,-2, 0,-1,-5,-3,-4, 4,
-1, 0, 0, 1,-4, 3, 4,-2, 0,-4,-3, 1,-2,-4,-2, 0,-1,-3,-3,-3, 0, 4,
-1,-1,-1,-2,-2,-1,-1,-2,-1,-2,-1,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1,
-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
};


//  Matrix made by matblas from blosum80_3.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 80
//  Entropy =   0.9868, Expected =  -0.7442
const char blosum80_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum80_50[325] =  { 
 7,
-3, 9,
-3,-1, 9,
-3,-3, 2, 10,
-1,-6,-5,-7, 13,
-2, 1, 0,-1,-5, 9,
-2,-1,-1, 2,-7, 3, 8,
 0,-4,-1,-3,-6,-4,-4, 9,
-3, 0, 1,-2,-7, 1, 0,-4, 12,
-3,-5,-6,-7,-2,-5,-6,-7,-6, 7,
-3,-4,-6,-7,-3,-4,-6,-7,-5, 2, 6,
-1, 3, 0,-2,-6, 2, 1,-3,-1,-5,-4, 8,
-2,-3,-4,-6,-3,-1,-4,-5,-4, 2, 3,-3, 9,
-4,-5,-6,-6,-4,-5,-6,-6,-2,-1, 0,-5, 0, 10,
-1,-3,-4,-3,-6,-3,-2,-5,-4,-5,-5,-2,-4,-6, 12,
 2,-2, 1,-1,-2,-1,-1,-1,-2,-4,-4,-1,-3,-4,-2, 7,
 0,-2, 0,-2,-2,-1,-2,-3,-3,-2,-3,-1,-1,-4,-3, 2, 8,
-5,-5,-7,-8,-5,-4,-6,-6,-4,-5,-4,-6,-3, 0,-7,-6,-5, 16,
-4,-4,-4,-6,-5,-3,-5,-6, 3,-3,-2,-4,-3, 4,-6,-3,-3, 3, 11,
-1,-4,-5,-6,-2,-4,-4,-6,-5, 4, 1,-4, 1,-2,-4,-3, 0,-5,-3, 7,
-3,-2, 5, 6,-6,-1, 1,-2,-1,-6,-7,-1,-5,-6,-4, 0,-1,-8,-5,-6, 6,
-2, 0,-1, 1,-7, 5, 6,-4, 0,-6,-5, 1,-3,-6,-2,-1,-2,-5,-4,-4, 0, 6,
-1,-2,-2,-3,-4,-2,-2,-3,-2,-2,-2,-2,-2,-3,-3,-1,-1,-5,-3,-2,-3,-1,-2,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//  Matrix made by matblas from blosum80_3.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 80
//  Entropy =   0.9868, Expected =  -0.7442
const char blosum80_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum80[325] =  { 
 7,
-3, 9,
-3,-1, 9,
-3,-3, 2, 10,
-1,-6,-5,-7, 13,
-2, 1, 0,-1,-5, 9,
-2,-1,-1, 2,-7, 3, 8,
 0,-4,-1,-3,-6,-4,-4, 9,
-3, 0, 1,-2,-7, 1, 0,-4, 12,
-3,-5,-6,-7,-2,-5,-6,-7,-6, 7,
-3,-4,-6,-7,-3,-4,-6,-7,-5, 2, 6,
-1, 3, 0,-2,-6, 2, 1,-3,-1,-5,-4, 8,
-2,-3,-4,-6,-3,-1,-4,-5,-4, 2, 3,-3, 9,
-4,-5,-6,-6,-4,-5,-6,-6,-2,-1, 0,-5, 0, 10,
-1,-3,-4,-3,-6,-3,-2,-5,-4,-5,-5,-2,-4,-6, 12,
 2,-2, 1,-1,-2,-1,-1,-1,-2,-4,-4,-1,-3,-4,-2, 7,
 0,-2, 0,-2,-2,-1,-2,-3,-3,-2,-3,-1,-1,-4,-3, 2, 8,
-5,-5,-7,-8,-5,-4,-6,-6,-4,-5,-4,-6,-3, 0,-7,-6,-5, 16,
-4,-4,-4,-6,-5,-3,-5,-6, 3,-3,-2,-4,-3, 4,-6,-3,-3, 3, 11,
-1,-4,-5,-6,-2,-4,-4,-6,-5, 4, 1,-4, 1,-2,-4,-3, 0,-5,-3, 7,
-3,-2, 5, 6,-6,-1, 1,-2,-1,-6,-7,-1,-5,-6,-4, 0,-1,-8,-5,-6, 6,
-2, 0,-1, 1,-7, 5, 6,-4, 0,-6,-5, 1,-3,-6,-2,-1,-2,-5,-4,-4, 0, 6,
-1,-2,-2,-3,-4,-2,-2,-3,-2,-2,-2,-2,-2,-3,-3,-1,-1,-5,-3,-2,-3,-1,-2,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//  Matrix made by matblas from blosum85.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 85
//  Entropy =   1.0805, Expected =  -0.8153
const char blosum85_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum85_50[325] =  { 
 5,
-2, 6,
-2,-1, 7,
-2,-2, 1, 7,
-1,-4,-4,-5, 9,
-1, 1, 0,-1,-4, 6,
-1,-1,-1, 1,-5, 2, 6,
 0,-3,-1,-2,-4,-3,-3, 6,
-2, 0, 0,-2,-5, 1,-1,-3, 8,
-2,-4,-4,-5,-2,-4,-4,-5,-4, 5,
-2,-3,-4,-5,-2,-3,-4,-5,-3, 1, 4,
-1, 2, 0,-1,-4, 1, 0,-2,-1,-3,-3, 6,
-2,-2,-3,-4,-2, 0,-3,-4,-3, 1, 2,-2, 7,
-3,-4,-4,-4,-3,-4,-4,-4,-2,-1, 0,-4,-1, 7,
-1,-2,-3,-2,-4,-2,-2,-3,-3,-4,-4,-2,-3,-4, 8,
 1,-1, 0,-1,-2,-1,-1,-1,-1,-3,-3,-1,-2,-3,-1, 5,
 0,-2, 0,-2,-2,-1,-1,-2,-2,-1,-2,-1,-1,-3,-2, 1, 5,
-3,-4,-5,-6,-4,-3,-4,-4,-3,-3,-3,-5,-2, 0,-5,-4,-4, 11,
-3,-3,-3,-4,-3,-2,-4,-5, 2,-2,-2,-3,-2, 3,-4,-2,-2, 2, 7,
-1,-3,-4,-4,-1,-3,-3,-4,-4, 3, 0,-3, 0,-1,-3,-2, 0,-3,-2, 5,
-2,-2, 4, 4,-4,-1, 0,-1,-1,-5,-5,-1,-4,-4,-3, 0,-1,-5,-4,-4, 4,
-1, 0,-1, 1,-5, 4, 4,-3, 0,-4,-4, 1,-2,-4,-2,-1,-1,-4,-3,-3, 0, 4,
-1,-2,-2,-2,-3,-1,-1,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-2,
-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
};


//  Matrix made by matblas from blosum85.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 85
//  Entropy =   1.0805, Expected =  -0.8153
const char blosum85_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum85[325] =  { 
 5,
-2, 6,
-2,-1, 7,
-2,-2, 1, 7,
-1,-4,-4,-5, 9,
-1, 1, 0,-1,-4, 6,
-1,-1,-1, 1,-5, 2, 6,
 0,-3,-1,-2,-4,-3,-3, 6,
-2, 0, 0,-2,-5, 1,-1,-3, 8,
-2,-4,-4,-5,-2,-4,-4,-5,-4, 5,
-2,-3,-4,-5,-2,-3,-4,-5,-3, 1, 4,
-1, 2, 0,-1,-4, 1, 0,-2,-1,-3,-3, 6,
-2,-2,-3,-4,-2, 0,-3,-4,-3, 1, 2,-2, 7,
-3,-4,-4,-4,-3,-4,-4,-4,-2,-1, 0,-4,-1, 7,
-1,-2,-3,-2,-4,-2,-2,-3,-3,-4,-4,-2,-3,-4, 8,
 1,-1, 0,-1,-2,-1,-1,-1,-1,-3,-3,-1,-2,-3,-1, 5,
 0,-2, 0,-2,-2,-1,-1,-2,-2,-1,-2,-1,-1,-3,-2, 1, 5,
-3,-4,-5,-6,-4,-3,-4,-4,-3,-3,-3,-5,-2, 0,-5,-4,-4, 11,
-3,-3,-3,-4,-3,-2,-4,-5, 2,-2,-2,-3,-2, 3,-4,-2,-2, 2, 7,
-1,-3,-4,-4,-1,-3,-3,-4,-4, 3, 0,-3, 0,-1,-3,-2, 0,-3,-2, 5,
-2,-2, 4, 4,-4,-1, 0,-1,-1,-5,-5,-1,-4,-4,-3, 0,-1,-5,-4,-4, 4,
-1, 0,-1, 1,-5, 4, 4,-3, 0,-4,-4, 1,-2,-4,-2,-1,-1,-4,-3,-3, 0, 4,
-1,-2,-2,-2,-3,-1,-1,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-2,
-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
};


//  Matrix made by matblas from blosum90.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 90
//  Entropy =   1.1806, Expected =  -0.8887
const char blosum90_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum90_50[325] =  { 
 5,
-2, 6,
-2,-1, 7,
-3,-3, 1, 7,
-1,-5,-4,-5, 9,
-1, 1, 0,-1,-4, 7,
-1,-1,-1, 1,-6, 2, 6,
 0,-3,-1,-2,-4,-3,-3, 6,
-2, 0, 0,-2,-5, 1,-1,-3, 8,
-2,-4,-4,-5,-2,-4,-4,-5,-4, 5,
-2,-3,-4,-5,-2,-3,-4,-5,-4, 1, 5,
-1, 2, 0,-1,-4, 1, 0,-2,-1,-4,-3, 6,
-2,-2,-3,-4,-2, 0,-3,-4,-3, 1, 2,-2, 7,
-3,-4,-4,-5,-3,-4,-5,-5,-2,-1, 0,-4,-1, 7,
-1,-3,-3,-3,-4,-2,-2,-3,-3,-4,-4,-2,-3,-4, 8,
 1,-1, 0,-1,-2,-1,-1,-1,-2,-3,-3,-1,-2,-3,-2, 5,
 0,-2, 0,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1,-3,-2, 1, 6,
-4,-4,-5,-6,-4,-3,-5,-4,-3,-4,-3,-5,-2, 0,-5,-4,-4, 11,
-3,-3,-3,-4,-4,-3,-4,-5, 1,-2,-2,-3,-2, 3,-4,-3,-2, 2, 8,
-1,-3,-4,-5,-2,-3,-3,-5,-4, 3, 0,-3, 0,-2,-3,-2,-1,-3,-3, 5,
-2,-2, 4, 4,-4,-1, 0,-2,-1,-5,-5,-1,-4,-4,-3, 0,-1,-6,-4,-4, 4,
-1, 0,-1, 0,-5, 4, 4,-3, 0,-4,-4, 1,-2,-4,-2,-1,-1,-4,-3,-3, 0, 4,
-1,-2,-2,-2,-3,-1,-2,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-2,-2,-1,-2,
-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
};


//  Matrix made by matblas from blosum90.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= 90
//  Entropy =   1.1806, Expected =  -0.8887
const char blosum90_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosum90[325] =  { 
 5,
-2, 6,
-2,-1, 7,
-3,-3, 1, 7,
-1,-5,-4,-5, 9,
-1, 1, 0,-1,-4, 7,
-1,-1,-1, 1,-6, 2, 6,
 0,-3,-1,-2,-4,-3,-3, 6,
-2, 0, 0,-2,-5, 1,-1,-3, 8,
-2,-4,-4,-5,-2,-4,-4,-5,-4, 5,
-2,-3,-4,-5,-2,-3,-4,-5,-4, 1, 5,
-1, 2, 0,-1,-4, 1, 0,-2,-1,-4,-3, 6,
-2,-2,-3,-4,-2, 0,-3,-4,-3, 1, 2,-2, 7,
-3,-4,-4,-5,-3,-4,-5,-5,-2,-1, 0,-4,-1, 7,
-1,-3,-3,-3,-4,-2,-2,-3,-3,-4,-4,-2,-3,-4, 8,
 1,-1, 0,-1,-2,-1,-1,-1,-2,-3,-3,-1,-2,-3,-2, 5,
 0,-2, 0,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1,-3,-2, 1, 6,
-4,-4,-5,-6,-4,-3,-5,-4,-3,-4,-3,-5,-2, 0,-5,-4,-4, 11,
-3,-3,-3,-4,-4,-3,-4,-5, 1,-2,-2,-3,-2, 3,-4,-3,-2, 2, 8,
-1,-3,-4,-5,-2,-3,-3,-5,-4, 3, 0,-3, 0,-2,-3,-2,-1,-3,-3, 5,
-2,-2, 4, 4,-4,-1, 0,-2,-1,-5,-5,-1,-4,-4,-3, 0,-1,-6,-4,-4, 4,
-1, 0,-1, 0,-5, 4, 4,-3, 0,-4,-4, 1,-2,-4,-2,-1,-1,-4,-3,-3, 0, 4,
-1,-2,-2,-2,-3,-1,-2,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-2,-2,-1,-2,
-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
};


//  Matrix made by matblas from blosumn.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= -2
//  Entropy =   1.5172, Expected =  -1.1484
const char blosumn_50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosumn_50[325] =  { 
 6,
-2, 7,
-2,-1, 7,
-3,-3, 1, 7,
-2,-6,-4,-6, 9,
-1, 0,-1,-2,-5, 7,
-2,-2,-1, 1,-7, 1, 6,
-1,-4,-2,-3,-5,-4,-4, 6,
-3,-1, 0,-2,-6, 0,-1,-4, 9,
-3,-5,-5,-6,-2,-4,-5,-6,-5, 6,
-3,-4,-5,-6,-3,-3,-5,-6,-4, 1, 5,
-2, 2,-1,-2,-5, 1, 0,-3,-2,-4,-4, 6,
-2,-3,-4,-5,-3,-1,-4,-5,-3, 1, 2,-2, 8,
-4,-4,-5,-5,-3,-4,-5,-5,-3,-1, 0,-4,-1, 7,
-1,-3,-4,-3,-5,-2,-3,-4,-4,-5,-5,-2,-4,-5, 8,
 1,-2, 0,-2,-2,-1,-1,-1,-2,-4,-4,-1,-3,-4,-2, 6,
-1,-2,-1,-2,-2,-2,-2,-3,-3,-2,-3,-2,-2,-3,-3, 1, 6,
-4,-5,-6,-7,-5,-4,-5,-5,-4,-4,-4,-6,-2, 0,-5,-4,-5, 11,
-4,-4,-4,-5,-4,-3,-4,-6, 1,-3,-3,-4,-3, 3,-5,-3,-3, 1, 8,
-1,-4,-4,-5,-2,-4,-4,-5,-5, 2, 0,-4, 0,-2,-4,-3,-1,-3,-3, 5,
-3,-2, 4, 4,-5,-1, 0,-2,-1,-5,-5,-1,-5,-5,-4,-1,-2,-6,-4,-5, 4,
-2,-1,-1, 0,-6, 4, 5,-4,-1,-5,-4, 0,-3,-5,-3,-1,-2,-4,-4,-4, 1, 4,
-1,-2,-2,-3,-4,-2,-2,-3,-3,-2,-2,-2,-2,-3,-3,-1,-1,-4,-3,-2,-2,-2,-2,
-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
};


//  Matrix made by matblas from blosumn.iij
//  * column uses minimum score
//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
//  Blocks Database = /data/blocks_5.0/blocks.dat
//  Cluster Percentage: >= -2
//  Entropy =   1.5172, Expected =  -1.1484
const char blosumn_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int blosumn[325] =  { 
 6,
-2, 7,
-2,-1, 7,
-3,-3, 1, 7,
-2,-6,-4,-6, 9,
-1, 0,-1,-2,-5, 7,
-2,-2,-1, 1,-7, 1, 6,
-1,-4,-2,-3,-5,-4,-4, 6,
-3,-1, 0,-2,-6, 0,-1,-4, 9,
-3,-5,-5,-6,-2,-4,-5,-6,-5, 6,
-3,-4,-5,-6,-3,-3,-5,-6,-4, 1, 5,
-2, 2,-1,-2,-5, 1, 0,-3,-2,-4,-4, 6,
-2,-3,-4,-5,-3,-1,-4,-5,-3, 1, 2,-2, 8,
-4,-4,-5,-5,-3,-4,-5,-5,-3,-1, 0,-4,-1, 7,
-1,-3,-4,-3,-5,-2,-3,-4,-4,-5,-5,-2,-4,-5, 8,
 1,-2, 0,-2,-2,-1,-1,-1,-2,-4,-4,-1,-3,-4,-2, 6,
-1,-2,-1,-2,-2,-2,-2,-3,-3,-2,-3,-2,-2,-3,-3, 1, 6,
-4,-5,-6,-7,-5,-4,-5,-5,-4,-4,-4,-6,-2, 0,-5,-4,-5, 11,
-4,-4,-4,-5,-4,-3,-4,-6, 1,-3,-3,-4,-3, 3,-5,-3,-3, 1, 8,
-1,-4,-4,-5,-2,-4,-4,-5,-5, 2, 0,-4, 0,-2,-4,-3,-1,-3,-3, 5,
-3,-2, 4, 4,-5,-1, 0,-2,-1,-5,-5,-1,-5,-5,-4,-1,-2,-6,-4,-5, 4,
-2,-1,-1, 0,-6, 4, 5,-4,-1,-5,-4, 0,-3,-5,-3,-1,-2,-4,-4,-4, 1, 4,
-1,-2,-2,-3,-4,-2,-2,-3,-3,-2,-2,-2,-2,-3,-3,-1,-1,-4,-3,-2,-2,-2,-2,
-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
};


//Date: Wed, 18 Sep 91 17:36:51 EDT
//From: altschul@ray.nlm.nih.gov (Stephen Altschul)
//To: gish@ray.nlm.nih.gov
//Subject: Vanilla-flavored PAM-250
//
// substitution scores for B, Z, X, and * were obtained with "pam" version 1.0.5
//
const char dayhoff_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int dayhoff[325] =  { 
 2,
-2, 6,
 0, 0, 2,
 0,-1, 2, 4,
-2,-4,-4,-5, 12,
 0, 1, 1, 2,-5, 4,
 0,-1, 1, 3,-5, 2, 4,
 1,-3, 0, 1,-3,-1, 0, 5,
-1, 2, 2, 1,-3, 3, 1,-2, 6,
-1,-2,-2,-2,-2,-2,-2,-3,-2, 5,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
-1, 3, 1, 0,-5, 1, 0,-2, 0,-2,-3, 5,
-1, 0,-2,-3,-5,-1,-2,-3,-2, 2, 4, 0, 6,
-4,-4,-4,-6,-4,-5,-5,-5,-2, 1, 2,-5, 0, 9,
 1, 0,-1,-1,-3, 0,-1,-1, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 0, 0,-1, 0, 1,-1,-1,-3, 0,-2,-3, 1, 2,
 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 3,
-6, 2,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 0,-6,-2,-5, 17,
-3,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-4,-2, 7,-5,-3,-3, 0, 10,
 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
 0,-1, 2, 3,-4, 1, 3, 0, 1,-2,-3, 1,-2,-4,-1, 0, 0,-5,-3,-2, 3,
 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-3, 0,-2,-5, 0, 0,-1,-6,-4,-2, 2, 3,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


// PAM 250 matrix recommended by Gonnet, Cohen & Benner
// Science June 5, 1992.
// Values rounded to nearest integer
const char gonnet_Alphabet[23] = {"CSTPAGNDEQHRKMILVFYWX*"};
const int gonnet[325] =  { 
 12,
 0, 2,
 0, 2, 2,
-3, 0, 0, 8,
 0, 1, 1, 0, 2,
-2, 0,-1,-2, 0, 7,
-2, 1, 0,-1, 0, 0, 4,
-3, 0, 0,-1, 0, 0, 2, 5,
-3, 0, 0, 0, 0,-1, 1, 3, 4,
-2, 0, 0, 0, 0,-1, 1, 1, 2, 3,
-1, 0, 0,-1,-1,-1, 1, 0, 0, 1, 6,
-2, 0, 0,-1,-1,-1, 0, 0, 0, 2, 1, 5,
-3, 0, 0,-1, 0,-1, 1, 0, 1, 2, 1, 3, 3,
-1,-1,-1,-2,-1,-4,-2,-3,-2,-1,-1,-2,-1, 4,
-1,-2,-1,-3,-1,-4,-3,-4,-3,-2,-2,-2,-2, 2, 4,
-2,-2,-1,-2,-1,-4,-3,-4,-3,-2,-2,-2,-2, 3, 3, 4,
 0,-1, 0,-2, 0,-3,-2,-3,-2,-2,-2,-2,-2, 2, 3, 2, 3,
-1,-3,-2,-4,-2,-5,-3,-4,-4,-3, 0,-3,-3, 2, 1, 2, 0, 7,
 0,-2,-2,-3,-2,-4,-1,-3,-3,-2, 2,-2,-2, 0,-1, 0,-1, 5, 8,
-1,-3,-4,-5,-4,-4,-4,-5,-4,-3,-1,-2,-4,-1,-2,-1,-3, 4, 4, 14,
-3, 0, 0,-1, 0,-1, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-4,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


const char identity_Alphabet[25] = {"ARNBDCQZEGHILKMFPSTWYVX*"};
const int identity[325] =  { 
 1,
-10000, 1,
-10000,-10000, 1,
-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 0,
-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 0
};


const char match_Alphabet[25] = {"ARNBDCQZEGHILKMFPSTWYVX*"};
const int match[325] =  { 
 1,
-1, 1,
-1,-1, 1,
-1,-1,-1, 1,
-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 0,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 0
};


//
// This matrix was created by Todd Lowe   12/10/92
//
// Uses ambiguous nucleotide codes, probabilities rounded to
//  nearest integer
//
// Lowest score = -4, Highest score = 5
//
//const char nuc_4.2_Alphabet[5] = {"ATGC"};
//const int nuc_4.2[325] =  { 
// 5,
//-4, 5,
//-4,-4, 5,
//-4,-4,-4, 5
//-4,-4, 1, 1
// 1, 1,-4,-4
// 1,-4, 1,-4
//-4, 1,-4, 1
//-4, 1, 1,-4
// 1,-4,-4, 1
//-4,-1,-1,-1
//-1,-4,-1,-1
//-1,-1,-4,-1
//-1,-1,-1,-4
//-2,-2,-2,-2
//};


//
// This matrix was created by Todd Lowe   12/10/92
//
// Uses ambiguous nucleotide codes, probabilities rounded to
//  nearest integer
//
// Lowest score = -4, Highest score = 5
//
const char nuc_4_4_Alphabet[16] = {"ATGCSWRYKMBVHDN"};
const int nuc_4_4[325] =  { 
 5,
-4, 5,
-4,-4, 5,
-4,-4,-4, 5,
-4,-4, 1, 1,-1,
 1, 1,-4,-4,-4,-1,
 1,-4, 1,-4,-2,-2,-1,
-4, 1,-4, 1,-2,-2,-4,-1,
-4, 1, 1,-4,-2,-2,-2,-2,-1,
 1,-4,-4, 1,-2,-2,-2,-2,-4,-1,
-4,-1,-1,-1,-1,-3,-3,-1,-1,-3,-1,
-1,-4,-1,-1,-1,-3,-1,-3,-3,-1,-2,-1,
-1,-1,-4,-1,-3,-1,-3,-1,-3,-1,-2,-2,-1,
-1,-1,-1,-4,-3,-1,-1,-3,-1,-3,-2,-2,-2,-1,
-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 10 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -8.27, Entropy = 3.43 bits
//
// Lowest score = -23, Highest score = 13
//
const char pam10_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam10[325] =  { 
 7,
-10, 9,
-7,-9, 9,
-6,-17,-1, 8,
-10,-11,-17,-21, 10,
-7,-4,-7,-6,-20, 9,
-5,-15,-5, 0,-20,-1, 8,
-4,-13,-6,-6,-13,-10,-7, 7,
-11,-4,-2,-7,-10,-2,-9,-13, 10,
-8,-8,-8,-11,-9,-11,-8,-17,-13, 9,
-9,-12,-10,-19,-21,-8,-13,-14,-9,-4, 7,
-10,-2,-4,-8,-20,-6,-7,-10,-10,-9,-11, 7,
-8,-7,-15,-17,-20,-7,-10,-12,-17,-3,-2,-4, 12,
-12,-12,-12,-21,-19,-19,-20,-12,-9,-5,-5,-20,-7, 9,
-4,-7,-9,-12,-11,-6,-9,-10,-7,-12,-10,-10,-11,-13, 8,
-3,-6,-2,-7,-6,-8,-7,-4,-9,-10,-12,-7,-8,-9,-4, 7,
-3,-10,-5,-8,-11,-9,-9,-10,-11,-5,-10,-6,-7,-12,-7,-2, 8,
-20,-5,-11,-21,-22,-19,-23,-21,-10,-20,-9,-18,-19,-7,-20,-8,-19, 13,
-11,-14,-7,-17,-7,-18,-11,-20,-6,-9,-10,-12,-17,-1,-20,-10,-9,-8, 10,
-5,-11,-12,-11,-9,-10,-10,-9,-9,-1,-5,-13,-4,-12,-9,-10,-6,-22,-10, 8,
-6,-11, 7, 7,-18,-6,-1,-6,-4,-9,-12,-5,-16,-14,-10,-4,-6,-13,-9,-11, 7,
-6,-7,-6,-1,-20, 7, 7,-8,-4,-9,-10,-6,-8,-20,-7,-8,-9,-21,-13,-10,-3, 7,
-6,-9,-6,-9,-13,-8,-8,-8,-8,-8,-9,-8,-9,-12,-8,-6,-7,-16,-11,-8,-8,-8,-8,
-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 100 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -1.99, Entropy = 1.18 bits
//
// Lowest score = -9, Highest score = 12
//
const char pam100_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam100[325] =  { 
 4,
-3, 7,
-1,-2, 5,
-1,-4, 3, 5,
-3,-5,-5,-7, 9,
-2, 1,-1, 0,-8, 6,
 0,-3, 1, 4,-8, 2, 5,
 1,-5,-1,-1,-5,-3,-1, 5,
-3, 1, 2,-1,-4, 3,-1,-4, 7,
-2,-3,-3,-4,-3,-4,-3,-5,-4, 6,
-3,-5,-4,-6,-8,-2,-5,-6,-3, 1, 6,
-3, 2, 1,-1,-8, 0,-1,-3,-2,-3,-4, 5,
-2,-1,-4,-5,-7,-2,-4,-4,-4, 1, 3, 0, 9,
-5,-6,-5,-8,-7,-7,-8,-6,-3, 0, 0,-7,-1, 8,
 1,-1,-2,-3,-4,-1,-2,-2,-1,-4,-4,-3,-4,-6, 7,
 1,-1, 1,-1,-1,-2,-1, 0,-2,-3,-4,-1,-3,-4, 0, 4,
 1,-3, 0,-2,-4,-2,-2,-2,-3, 0,-3,-1,-1,-5,-1, 2, 5,
-7, 1,-5,-9,-9,-7,-9,-9,-4,-7,-3,-6,-6,-1,-7,-3,-7, 12,
-4,-6,-2,-6,-1,-6,-5,-7,-1,-3,-3,-6,-5, 4,-7,-4,-4,-2, 9,
 0,-4,-3,-4,-3,-3,-3,-3,-3, 3, 0,-4, 1,-3,-3,-2, 0,-9,-4, 5,
-1,-3, 4, 4,-6, 0, 3,-1, 1,-3,-5, 0,-4,-6,-3, 0,-1,-6,-4,-4, 4,
-1,-1, 0, 3,-8, 5, 4,-2, 1,-3,-4,-1,-2,-7,-1,-2,-2,-8,-6,-3, 2, 5,
-1,-2,-1,-2,-5,-2,-2,-2,-2,-2,-3,-2,-2,-4,-2,-1,-1,-6,-4,-2,-2,-2,-2,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 110 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -1.81, Entropy = 1.07 bits
//
// Lowest score = -9, Highest score = 12
//
const char pam110_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam110[325] =  { 
 3,
-3, 7,
-1,-1, 4,
-1,-4, 2, 5,
-3,-4,-5,-7, 9,
-1, 1, 0, 1,-7, 6,
 0,-3, 1, 4,-7, 2, 5,
 1,-4, 0, 0,-5,-3,-1, 5,
-3, 1, 2, 0,-4, 3,-1,-4, 7,
-1,-3,-2,-3,-3,-3,-3,-4,-4, 6,
-3,-4,-4,-6,-8,-2,-5,-6,-3, 1, 6,
-3, 2, 1,-1,-7, 0,-1,-3,-2,-3,-4, 5,
-2,-1,-3,-5,-7,-1,-3,-4,-4, 1, 3, 0, 8,
-4,-5,-4,-7,-6,-6,-7,-5,-3, 0, 0,-7,-1, 8,
 1,-1,-2,-3,-4, 0,-2,-2,-1,-4,-4,-3,-4,-6, 6,
 1,-1, 1,-1,-1,-2,-1, 0,-2,-3,-4,-1,-2,-4, 0, 3,
 1,-2, 0,-1,-3,-2,-2,-2,-3, 0,-3,-1,-1,-4,-1, 2, 5,
-7, 1,-5,-8,-9,-6,-9,-8,-4,-7,-3,-5,-6,-1,-7,-3,-6, 12,
-4,-5,-2,-5,-1,-6,-5,-7,-1,-2,-3,-5,-5, 4,-7,-3,-3,-2, 8,
 0,-4,-3,-4,-3,-3,-3,-2,-3, 3, 1,-4, 1,-3,-2,-2, 0,-8,-4, 5,
-1,-2, 3, 4,-6, 0, 3, 0, 1,-3,-5, 0,-4,-6,-2, 0,-1,-6,-3,-3, 4,
-1,-1, 0, 3,-7, 4, 4,-2, 1,-3,-3,-1,-2,-7,-1,-1,-2,-7,-5,-3, 2, 4,
-1,-2,-1,-2,-4,-1,-2,-2,-2,-2,-2,-2,-2,-4,-2,-1,-1,-5,-3,-2,-1,-2,-2,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 120 substitution matrix, scale = 0.0693200
//
// Expected score = -8.22, Entropy = 0.979 bits
//
// Lowest score = -42, Highest score = 62
//
const char pam120_cdi_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam120_cdi[325] =  { 
 16,
-14, 32,
-3,-6, 20,
-2,-16, 12, 25,
-14,-20,-23,-33, 44,
-6, 3,-1, 4,-33, 28,
-1,-14, 4, 17,-33, 12, 24,
 3,-20,-2,-2,-22,-13,-4, 25,
-13, 4, 8,-2,-20, 13,-3,-18, 35,
-6,-12,-12,-16,-14,-16,-13,-20,-19, 28,
-14,-20,-18,-27,-37,-11,-22,-26,-13, 6, 27,
-12, 12, 4,-5,-34, 0,-5,-15,-8,-13,-19, 25,
-9,-5,-15,-21,-32,-7,-15,-19,-19, 7, 13, 2, 40,
-21,-25,-21,-35,-29,-30,-34,-26,-13, 1, 2,-33,-4, 38,
 3,-4,-8,-13,-18,-2,-9,-9,-5,-17,-17,-12,-16,-26, 31,
 6,-4, 5,-2,-2,-8,-5, 3,-9,-12,-19,-4,-11,-17, 3, 16,
 6,-10, 1,-6,-16,-9,-8,-7,-13,-1,-13,-3,-6,-20,-3, 8, 21,
-33, 4,-22,-39,-42,-30,-42,-39,-17,-32,-13,-24,-28,-5,-33,-12,-30, 62,
-20,-26,-10,-26,-4,-26,-24,-32,-3,-11,-12,-25,-21, 22,-31,-16,-16,-8, 42,
 0,-17,-15,-17,-13,-14,-13,-11,-15, 17, 3,-19, 5,-13,-11,-10,-1,-38,-17, 25,
-2,-11, 16, 20,-28, 2, 13,-2, 4,-14,-22, 0,-18,-27,-11, 1,-2,-29,-16,-16, 18,
-3,-4, 2, 13,-33, 21, 20,-8, 6,-14,-16,-3,-11,-32,-5,-6,-9,-35,-25,-14, 9, 21,
-4,-9,-4,-8,-20,-6,-7,-9,-8,-7,-11,-8,-8,-17,-8,-3,-4,-25,-16,-7,-6,-7,-8,
-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42,-42, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 120 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -1.64, Entropy = 0.979 bits
//
// Lowest score = -8, Highest score = 12
//
const char pam120_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam120[325] =  { 
 3,
-3, 6,
-1,-1, 4,
 0,-3, 2, 5,
-3,-4,-5,-7, 9,
-1, 1, 0, 1,-7, 6,
 0,-3, 1, 3,-7, 2, 5,
 1,-4, 0, 0,-4,-3,-1, 5,
-3, 1, 2, 0,-4, 3,-1,-4, 7,
-1,-2,-2,-3,-3,-3,-3,-4,-4, 6,
-3,-4,-4,-5,-7,-2,-4,-5,-3, 1, 5,
-2, 2, 1,-1,-7, 0,-1,-3,-2,-3,-4, 5,
-2,-1,-3,-4,-6,-1,-3,-4,-4, 1, 3, 0, 8,
-4,-5,-4,-7,-6,-6,-7,-5,-3, 0, 0,-7,-1, 8,
 1,-1,-2,-3,-4, 0,-2,-2,-1,-3,-3,-2,-3,-5, 6,
 1,-1, 1, 0, 0,-2,-1, 1,-2,-2,-4,-1,-2,-3, 1, 3,
 1,-2, 0,-1,-3,-2,-2,-1,-3, 0,-3,-1,-1,-4,-1, 2, 4,
-7, 1,-4,-8,-8,-6,-8,-8,-3,-6,-3,-5,-6,-1,-7,-2,-6, 12,
-4,-5,-2,-5,-1,-5,-5,-6,-1,-2,-2,-5,-4, 4,-6,-3,-3,-2, 8,
 0,-3,-3,-3,-3,-3,-3,-2,-3, 3, 1,-4, 1,-3,-2,-2, 0,-8,-3, 5,
 0,-2, 3, 4,-6, 0, 3, 0, 1,-3,-4, 0,-4,-5,-2, 0, 0,-6,-3,-3, 4,
-1,-1, 0, 3,-7, 4, 4,-2, 1,-3,-3,-1,-2,-6,-1,-1,-2,-7,-5,-3, 2, 4,
-1,-2,-1,-2,-4,-1,-1,-2,-2,-1,-2,-2,-2,-3,-2,-1,-1,-5,-3,-1,-1,-1,-2,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 130 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -1.48, Entropy = 0.895 bits
//
// Lowest score = -8, Highest score = 12
//
const char pam130_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam130[325] =  { 
 3,
-3, 6,
 0,-1, 4,
 0,-3, 2, 5,
-3,-4,-4,-6, 9,
-1, 1, 0, 1,-6, 5,
 0,-3, 1, 3,-6, 2, 5,
 1,-4, 0, 0,-4,-2,-1, 5,
-2, 1, 2, 0,-4, 3, 0,-3, 7,
-1,-2,-2,-3,-3,-3,-2,-4,-3, 5,
-3,-4,-3,-5,-7,-2,-4,-5,-3, 1, 5,
-2, 2, 1,-1,-6, 0,-1,-3,-1,-2,-4, 5,
-2,-1,-3,-4,-6,-1,-3,-4,-3, 2, 3, 0, 8,
-4,-5,-4,-7,-5,-6,-6,-5,-2, 0, 1,-6,-1, 7,
 1,-1,-1,-2,-3, 0,-2,-2,-1,-3,-3,-2,-3,-5, 6,
 1,-1, 1, 0, 0,-1,-1, 1,-2,-2,-4,-1,-2,-3, 1, 3,
 1,-2, 0,-1,-3,-2,-1,-1,-2, 0,-2, 0,-1,-4,-1, 2, 4,
-6, 1,-4,-7,-8,-6,-8,-7,-3,-6,-2,-5,-5,-1,-6,-2,-6, 12,
-4,-5,-2,-5,-1,-5,-5,-6, 0,-2,-2,-5,-4, 4,-6,-3,-3,-1, 8,
 0,-3,-3,-3,-2,-3,-3,-2,-3, 3, 1,-4, 1,-2,-2,-2, 0,-7,-3, 5,
 0,-2, 3, 4,-5, 0, 2, 0, 1,-3,-4, 0,-3,-5,-2, 0, 0,-5,-3,-3, 3,
 0,-1, 0, 3,-6, 4, 4,-1, 1,-3,-3, 0,-2,-6,-1,-1,-2,-7,-5,-3, 2, 4,
-1,-2,-1,-1,-4,-1,-1,-2,-1,-1,-2,-1,-1,-3,-1,-1,-1,-5,-3,-1,-1,-1,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 140 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -1.35, Entropy = 0.820 bits
//
// Lowest score = -8, Highest score = 12
//
const char pam140_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam140[325] =  { 
 3,
-2, 6,
 0,-1, 3,
 0,-3, 2, 4,
-2,-4,-4,-6, 9,
-1, 1, 0, 1,-6, 5,
 0,-2, 1, 3,-6, 2, 4,
 1,-4, 0, 0,-4,-2,-1, 5,
-2, 1, 2, 0,-4, 3, 0,-3, 6,
-1,-2,-2,-3,-3,-3,-2,-4,-3, 5,
-2,-4,-3,-5,-7,-2,-4,-5,-2, 1, 5,
-2, 3, 1,-1,-6, 0,-1,-3,-1,-2,-3, 5,
-2,-1,-2,-4,-6,-1,-3,-3,-3, 2, 3, 0, 7,
-4,-5,-4,-6,-5,-5,-6,-5,-2, 0, 1,-6,-1, 7,
 1,-1,-1,-2,-3, 0,-1,-1,-1,-3,-3,-2,-3,-5, 6,
 1,-1, 1, 0, 0,-1,-1, 1,-1,-2,-3,-1,-2,-3, 1, 3,
 1,-2, 0,-1,-3,-2,-1,-1,-2, 0,-2, 0,-1,-4, 0, 2, 4,
-6, 1,-4,-7,-8,-5,-8,-7,-3,-6,-2,-4,-5,-1,-6,-2,-5, 12,
-4,-5,-2,-5,-1,-5,-4,-6, 0,-2,-2,-5,-4, 4,-6,-3,-3,-1, 8,
 0,-3,-2,-3,-2,-2,-2,-2,-3, 3, 1,-3, 1,-2,-2,-2, 0,-7,-3, 5,
 0,-2, 3, 4,-5, 1, 2, 0, 1,-2,-4, 0,-3,-5,-2, 0, 0,-5,-3,-3, 3,
 0,-1, 1, 3,-6, 4, 4,-1, 1,-2,-3, 0,-2,-6,-1,-1,-1,-6,-4,-2, 2, 4,
-1,-1,-1,-1,-4,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0,-1,-5,-3,-1,-1,-1,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 150 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -1.25, Entropy = 0.754 bits
//
// Lowest score = -7, Highest score = 12
//
const char pam150_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam150[325] =  { 
 3,
-2, 6,
 0,-1, 3,
 0,-2, 2, 4,
-2,-4,-4,-6, 9,
-1, 1, 0, 1,-6, 5,
 0,-2, 1, 3,-6, 2, 4,
 1,-3, 0, 0,-4,-2,-1, 4,
-2, 1, 2, 0,-3, 3, 0,-3, 6,
-1,-2,-2,-3,-2,-3,-2,-3,-3, 5,
-2,-3,-3,-5,-6,-2,-4,-4,-2, 1, 5,
-2, 3, 1,-1,-6, 0,-1,-2,-1,-2,-3, 4,
-1,-1,-2,-3,-5,-1,-2,-3,-3, 2, 3, 0, 7,
-4,-4,-4,-6,-5,-5,-6,-5,-2, 0, 1,-6,-1, 7,
 1,-1,-1,-2,-3, 0,-1,-1,-1,-3,-3,-2,-3,-5, 6,
 1,-1, 1, 0, 0,-1,-1, 1,-1,-2,-3,-1,-2,-3, 1, 2,
 1,-2, 0,-1,-3,-1,-1,-1,-2, 0,-2, 0,-1,-3, 0, 1, 4,
-6, 1,-4,-7,-7,-5,-7,-7,-3,-5,-2,-4,-5,-1,-6,-2,-5, 12,
-3,-4,-2,-4, 0,-4,-4,-5, 0,-2,-2,-4,-3, 5,-5,-3,-3,-1, 8,
 0,-3,-2,-3,-2,-2,-2,-2,-3, 3, 1,-3, 1,-2,-2,-1, 0,-6,-3, 4,
 0,-2, 3, 3,-5, 1, 2, 0, 1,-2,-4, 0,-3,-5,-2, 0, 0,-5,-3,-2, 3,
 0, 0, 1, 2,-6, 4, 4,-1, 1,-2,-3, 0,-2,-5,-1,-1,-1,-6,-4,-2, 2, 4,
-1,-1,-1,-1,-3,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0,-1,-4,-3,-1,-1,-1,-1,
-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 160 substitution matrix, scale = 0.0693200
//
// Expected score = -5.73, Entropy = 0.694 bits
//
// Lowest score = -35, Highest score = 60
//
const char pam160_cdi_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam160_cdi[325] =  { 
 12,
-10, 28,
-1,-3, 14,
-1,-11, 10, 20,
-11,-17,-18,-26, 43,
-4, 4, 1, 5,-27, 23,
 0,-9, 5, 16,-27, 11, 20,
 4,-15, 0, 0,-17,-9,-2, 22,
-9, 5, 8, 1,-16, 12, 0,-13, 30,
-4,-10,-9,-13,-11,-12,-10,-15,-14, 23,
-10,-16,-15,-21,-30,-8,-17,-21,-11, 8, 25,
-8, 13, 4,-2,-27, 1,-3,-11,-4,-10,-15, 22,
-7,-3,-11,-15,-26,-5,-12,-15,-14, 8, 14, 2, 34,
-17,-21,-17,-28,-23,-24,-27,-22,-10, 2, 4,-26,-2, 35,
 4,-3,-5,-8,-15, 0,-6,-6,-3,-12,-13,-8,-12,-22, 27,
 5,-3, 4,-1,-1,-5,-2, 3,-6,-9,-15,-3,-9,-15, 3, 11,
 6,-7, 2,-3,-12,-6,-5,-3,-9, 0,-10,-1,-4,-16,-1, 7, 16,
-27, 6,-19,-32,-35,-24,-34,-33,-14,-26,-10,-19,-22,-3,-27,-11,-25, 60,
-17,-21,-9,-21,-2,-21,-20,-26,-1,-8,-8,-21,-16, 23,-25,-13,-13,-5, 39,
 0,-14,-11,-13,-10,-11,-10,-8,-12, 16, 5,-14, 6,-9,-8,-7, 0,-31,-14, 21,
-1,-7, 12, 16,-22, 3, 12, 0, 4,-11,-18, 1,-13,-22,-7, 2,-1,-24,-14,-12, 15,
-1,-2, 3, 12,-27, 17, 17,-5, 7,-11,-13,-1,-8,-26,-3,-4,-6,-29,-20,-10, 9, 17,
-2,-6,-2,-5,-16,-4,-5,-6,-5,-5,-8,-6,-5,-13,-5,-2,-2,-20,-13,-5,-4,-4,-6,
-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35,-35, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 160 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -1.14, Entropy = 0.694 bits
//
// Lowest score = -7, Highest score = 12
//
const char pam160_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam160[325] =  { 
 2,
-2, 6,
 0,-1, 3,
 0,-2, 2, 4,
-2,-3,-4,-5, 9,
-1, 1, 0, 1,-5, 5,
 0,-2, 1, 3,-5, 2, 4,
 1,-3, 0, 0,-3,-2, 0, 4,
-2, 1, 2, 0,-3, 2, 0,-3, 6,
-1,-2,-2,-3,-2,-2,-2,-3,-3, 5,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 5,
-2, 3, 1, 0,-5, 0,-1,-2,-1,-2,-3, 4,
-1,-1,-2,-3,-5,-1,-2,-3,-3, 2, 3, 0, 7,
-3,-4,-3,-6,-5,-5,-5,-4,-2, 0, 1,-5, 0, 7,
 1,-1,-1,-2,-3, 0,-1,-1,-1,-2,-3,-2,-2,-4, 5,
 1,-1, 1, 0, 0,-1, 0, 1,-1,-2,-3,-1,-2,-3, 1, 2,
 1,-1, 0,-1,-2,-1,-1,-1,-2, 0,-2, 0,-1,-3, 0, 1, 3,
-5, 1,-4,-6,-7,-5,-7,-7,-3,-5,-2,-4,-4,-1,-5,-2,-5, 12,
-3,-4,-2,-4, 0,-4,-4,-5, 0,-2,-2,-4,-3, 5,-5,-3,-3,-1, 8,
 0,-3,-2,-3,-2,-2,-2,-2,-2, 3, 1,-3, 1,-2,-2,-1, 0,-6,-3, 4,
 0,-1, 2, 3,-4, 1, 2, 0, 1,-2,-4, 0,-3,-4,-1, 0, 0,-5,-3,-2, 3,
 0, 0, 1, 2,-5, 3, 3,-1, 1,-2,-3, 0,-2,-5,-1,-1,-1,-6,-4,-2, 2, 3,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-4,-3,-1,-1,-1,-1,
-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 170 substitution matrix, scale = ln(2)/3 = 0.231049
//
// Expected score = -1.57, Entropy = 0.640 bits
//
// Lowest score = -10, Highest score = 18
//
const char pam170_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam170[325] =  { 
 3,
-3, 8,
 0,-1, 4,
 0,-3, 3, 6,
-3,-5,-5,-7, 13,
-1, 1, 0, 2,-8, 6,
 0,-2, 2, 5,-8, 3, 6,
 1,-4, 0, 0,-5,-2, 0, 6,
-3, 2, 2, 0,-5, 4, 0,-4, 9,
-1,-3,-3,-4,-3,-3,-3,-4,-4, 7,
-3,-4,-4,-6,-9,-2,-5,-6,-3, 2, 7,
-2, 4, 1,-1,-8, 0,-1,-3,-1,-3,-4, 6,
-2,-1,-3,-4,-7,-1,-3,-4,-4, 2, 4, 1, 10,
-5,-6,-5,-8,-6,-7,-8,-6,-3, 1, 1,-8, 0, 10,
 1,-1,-1,-2,-4, 0,-1,-2,-1,-3,-4,-2,-3,-6, 8,
 2,-1, 1, 0, 0,-1,-1, 1,-2,-2,-4,-1,-2,-4, 1, 3,
 2,-2, 0,-1,-3,-2,-1,-1,-2, 0,-3, 0,-1,-5, 0, 2, 5,
-8, 2,-5,-9,-10,-7,-10,-9,-4,-7,-3,-5,-6,-1,-8,-3,-7, 18,
-5,-6,-3,-6, 0,-6,-6,-7, 0,-2,-2,-6,-4, 7,-7,-4,-4,-1, 12,
 0,-4,-3,-4,-3,-3,-3,-2,-3, 5, 2,-4, 2,-2,-2,-2, 0,-9,-4, 6,
 0,-2, 3, 5,-6, 1, 3, 0, 1,-3,-5, 0,-4,-6,-2, 1, 0,-7,-4,-3, 4,
 0, 0, 1, 4,-8, 5, 5,-1, 2,-3,-4, 0,-2,-7,-1,-1,-1,-8,-6,-3, 3, 5,
-1,-2,-1,-1,-4,-1,-1,-2,-1,-1,-2,-2,-1,-4,-1, 0,-1,-6,-4,-1,-1,-1,-2,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 180 substitution matrix, scale = ln(2)/3 = 0.231049
//
// Expected score = -1.51, Entropy = 0.591 bits
//
// Lowest score = -10, Highest score = 18
//
const char pam180_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam180[325] =  { 
 3,
-3, 8,
 0,-1, 4,
 0,-3, 3, 5,
-3,-5,-5,-7, 13,
-1, 1, 0, 2,-7, 6,
 0,-2, 2, 4,-7, 3, 5,
 1,-4, 0, 0,-5,-2, 0, 6,
-2, 2, 2, 0,-4, 4, 0,-3, 8,
-1,-3,-3,-3,-3,-3,-3,-4,-4, 6,
-3,-4,-4,-6,-8,-2,-5,-6,-3, 2, 7,
-2, 4, 1, 0,-7, 0,-1,-3,-1,-3,-4, 6,
-2,-1,-3,-4,-7,-1,-3,-4,-3, 2, 4, 1, 9,
-5,-6,-5,-8,-6,-6,-7,-6,-3, 1, 1,-7, 0, 10,
 1,-1,-1,-2,-4, 0,-1,-1,-1,-3,-4,-2,-3,-6, 8,
 1,-1, 1, 0, 0,-1,-1, 1,-2,-2,-4,-1,-2,-4, 1, 3,
 2,-2, 0,-1,-3,-2,-1,-1,-2, 0,-3, 0,-1,-4, 0, 2, 4,
-8, 2,-5,-9,-10,-6,-9,-9,-4,-7,-3,-5,-6, 0,-7,-3,-7, 18,
-5,-6,-2,-6, 0,-6,-6,-7, 0,-2,-2,-6,-4, 7,-7,-4,-4,-1, 11,
 0,-4,-3,-3,-3,-3,-3,-2,-3, 5, 2,-4, 2,-2,-2,-2, 0,-8,-4, 6,
 0,-2, 3, 4,-6, 1, 3, 0, 1,-3,-5, 0,-3,-6,-2, 1, 0,-7,-4,-3, 4,
 0, 0, 1, 3,-7, 5, 5,-1, 2,-3,-3, 0,-2,-7,-1,-1,-1,-8,-6,-3, 3, 5,
-1,-2,-1,-1,-4,-1,-1,-2,-1,-1,-2,-1,-1,-3,-1, 0,-1,-6,-3,-1,-1,-1,-1,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 190 substitution matrix, scale = ln(2)/3 = 0.231049
//
// Expected score = -1.35, Entropy = 0.547 bits
//
// Lowest score = -9, Highest score = 18
//
const char pam190_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam190[325] =  { 
 3,
-2, 8,
 0,-1, 3,
 0,-2, 3, 5,
-3,-5,-5,-7, 13,
-1, 1, 1, 2,-7, 6,
 0,-2, 2, 4,-7, 3, 5,
 1,-4, 0, 0,-4,-2, 0, 6,
-2, 2, 2, 0,-4, 3, 0,-3, 8,
-1,-3,-2,-3,-3,-3,-3,-4,-3, 6,
-3,-4,-4,-5,-8,-2,-4,-5,-3, 2, 7,
-2, 4, 1, 0,-7, 1,-1,-3,-1,-3,-4, 6,
-2,-1,-3,-4,-7,-1,-3,-4,-3, 2, 4, 1, 9,
-5,-6,-4,-7,-6,-6,-7,-6,-2, 1, 2,-7, 0, 10,
 1, 0,-1,-2,-4, 0,-1,-1,-1,-3,-3,-2,-3,-6, 7,
 1,-1, 1, 0, 0,-1, 0, 1,-1,-2,-4, 0,-2,-4, 1, 3,
 2,-2, 0,-1,-3,-1,-1,-1,-2, 0,-2, 0,-1,-4, 0, 2, 4,
-7, 2,-5,-8,-9,-6,-9,-9,-3,-7,-3,-5,-6, 0,-7,-3,-6, 18,
-4,-5,-2,-5, 0,-5,-5,-7, 0,-2,-2,-6,-4, 7,-6,-4,-3,-1, 11,
 0,-3,-3,-3,-3,-3,-3,-2,-3, 4, 2,-3, 2,-2,-2,-2, 0,-8,-3, 6,
 0,-1, 3, 4,-6, 1, 3, 0, 1,-3,-5, 0,-3,-6,-1, 1, 0,-6,-4,-3, 4,
 0, 0, 1, 3,-7, 4, 4,-1, 2,-3,-3, 0,-2,-7,-1,-1,-1,-7,-5,-3, 2, 4,
 0,-1,-1,-1,-4,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 20 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -6.18, Entropy = 2.95 bits
//
// Lowest score = -19, Highest score = 13
//
const char pam20_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam20[325] =  { 
 6,
-8, 9,
-5,-7, 8,
-4,-12, 1, 8,
-8,-9,-13,-16, 10,
-5,-2,-5,-4,-16, 9,
-3,-11,-3, 2,-16, 0, 8,
-3,-11,-4,-4,-11,-8,-5, 7,
-8,-3,-1,-5,-8, 0,-6,-10, 9,
-6,-6,-6,-9,-7,-9,-6,-13,-11, 9,
-7,-10,-8,-15,-17,-6,-10,-12,-7,-2, 7,
-8,-1,-2,-6,-16,-4,-5,-8,-8,-7,-9, 7,
-6,-5,-11,-13,-16,-5,-8,-10,-13,-2, 0,-3, 11,
-9,-10,-10,-17,-15,-15,-16,-10,-7,-3,-4,-16,-5, 9,
-2,-5,-7,-9,-9,-4,-7,-7,-5,-10,-8,-8,-9,-11, 8,
-1,-4,-1,-5,-4,-6,-5,-3,-7,-8,-9,-5,-6,-7,-3, 7,
-1,-8,-3,-6,-9,-7,-7,-7,-8,-3,-8,-4,-5,-10,-5, 0, 7,
-16,-3,-9,-17,-18,-15,-19,-17,-8,-16,-7,-14,-15,-6,-16,-6,-15, 13,
-9,-11,-5,-13,-5,-14,-9,-16,-4,-7,-8,-10,-13, 1,-16,-8,-7,-6, 10,
-3,-9,-9,-9,-7,-8,-8,-7,-7, 1,-3,-10,-2,-9,-7,-8,-4,-18,-8, 7,
-5,-9, 6, 6,-14,-4, 0,-4,-2,-7,-10,-3,-12,-12,-8,-2,-4,-11,-7,-9, 6,
-4,-5,-4, 0,-16, 7, 6,-6,-2,-7,-8,-5,-6,-16,-5,-6,-7,-17,-11,-8,-1, 6,
-4,-7,-4,-7,-11,-6,-6,-6,-6,-6,-7,-6,-6,-9,-6,-4,-5,-13,-9,-6,-6,-6,-6,
-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 200 substitution matrix, scale = 0.0693200
//
// Expected score = -4.12, Entropy = 0.507 bits
//
// Lowest score = -30, Highest score = 59
//
const char pam200_cdi_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam200_cdi[325] =  { 
 9,
-7, 24,
 0,-1, 10,
 0,-7, 9, 16,
-9,-15,-15,-21, 41,
-3, 4, 2, 6,-22, 18,
 1,-6, 5, 14,-22, 10, 16,
 4,-12, 1, 1,-14,-6, 0, 19,
-7, 5, 7, 2,-14, 11, 1,-10, 26,
-3,-8,-8,-10,-9,-9,-9,-12,-11, 19,
-8,-13,-12,-17,-25,-7,-14,-17,-9, 8, 22,
-6, 12, 4,-1,-22, 2,-1,-8,-2,-8,-12, 19,
-5,-2,-8,-12,-22,-4,-9,-12,-10, 8, 13, 2, 28,
-14,-18,-14,-23,-18,-19,-22,-19,-8, 3, 5,-22,-1, 33,
 4,-1,-3,-5,-12, 0,-4,-3,-2,-9,-11,-6,-9,-18, 23,
 5,-2, 3, 0,-1,-3,-1, 4,-4,-6,-12,-1,-7,-13, 3, 8,
 5,-5, 2,-2,-10,-4,-3,-1,-6, 0,-8,-1,-3,-13, 0, 6, 12,
-23, 7,-16,-27,-30,-20,-28,-28,-11,-21,-8,-15,-18,-1,-23,-9,-21, 59,
-14,-17,-8,-17, 0,-17,-17,-22,-1,-5,-5,-18,-12, 23,-20,-11,-11,-2, 37,
 1,-11,-8,-10,-8,-8,-8,-6,-10, 14, 6,-11, 6,-6,-6,-5, 1,-26,-11, 18,
 0,-4, 9, 13,-18, 4, 10, 1, 4,-9,-15, 1,-10,-18,-4, 2, 0,-21,-12,-9, 12,
-1,-1, 4, 11,-22, 14, 14,-3, 7,-9,-11, 0,-7,-21,-2,-2,-3,-24,-17,-8, 8, 14,
-1,-4,-2,-4,-13,-3,-3,-4,-3,-3,-6,-4,-3,-10,-3,-1,-1,-17,-10,-3,-3,-3,-4,
-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 200 substitution matrix, scale = ln(2)/3 = 0.231049
//
// Expected score = -1.23, Entropy = 0.507 bits
//
// Lowest score = -9, Highest score = 18
//
const char pam200_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam200[325] =  { 
 3,
-2, 7,
 0, 0, 3,
 0,-2, 3, 5,
-3,-4,-5,-6, 12,
-1, 1, 1, 2,-7, 5,
 0,-2, 2, 4,-7, 3, 5,
 1,-4, 0, 0,-4,-2, 0, 6,
-2, 2, 2, 0,-4, 3, 0,-3, 8,
-1,-2,-2,-3,-3,-3,-3,-3,-3, 6,
-2,-4,-4,-5,-7,-2,-4,-5,-3, 2, 7,
-2, 4, 1, 0,-7, 1, 0,-2,-1,-2,-4, 6,
-2,-1,-2,-4,-6,-1,-3,-4,-3, 2, 4, 1, 8,
-4,-5,-4,-7,-6,-6,-7,-6,-2, 1, 2,-7, 0, 10,
 1, 0,-1,-2,-4, 0,-1,-1,-1,-3,-3,-2,-3,-6, 7,
 1,-1, 1, 0, 0,-1, 0, 1,-1,-2,-4, 0,-2,-4, 1, 2,
 1,-1, 0, 0,-3,-1,-1, 0,-2, 0,-2, 0,-1,-4, 0, 2, 4,
-7, 2,-5,-8,-9,-6,-9,-8,-3,-6,-2,-4,-5, 0,-7,-3,-6, 18,
-4,-5,-2,-5, 0,-5,-5,-6, 0,-2,-2,-5,-3, 7,-6,-3,-3,-1, 11,
 0,-3,-2,-3,-2,-3,-2,-2,-3, 4, 2,-3, 2,-2,-2,-1, 0,-8,-3, 5,
 0,-1, 3, 4,-5, 1, 3, 0, 1,-3,-4, 0,-3,-6,-1, 1, 0,-6,-4,-3, 3,
 0, 0, 1, 3,-7, 4, 4,-1, 2,-3,-3, 0,-2,-6,-1,-1,-1,-7,-5,-2, 2, 4,
 0,-1, 0,-1,-4,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 210 substitution matrix, scale = ln(2)/3 = 0.231049
//
// Expected score = -1.12, Entropy = 0.470 bits
//
// Lowest score = -9, Highest score = 18
//
const char pam210_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam210[325] =  { 
 2,
-2, 7,
 0, 0, 3,
 0,-2, 2, 5,
-2,-4,-4,-6, 12,
-1, 1, 1, 2,-6, 5,
 0,-2, 2, 4,-6, 3, 5,
 1,-3, 0, 0,-4,-2, 0, 5,
-2, 2, 2, 1,-4, 3, 0,-3, 8,
-1,-2,-2,-3,-3,-3,-2,-3,-3, 5,
-2,-4,-3,-5,-7,-2,-4,-5,-2, 2, 7,
-2, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
-1,-1,-2,-3,-6,-1,-3,-3,-3, 2, 4, 1, 8,
-4,-5,-4,-7,-5,-6,-6,-5,-2, 1, 2,-6, 0, 10,
 1, 0,-1,-1,-3, 0,-1,-1, 0,-3,-3,-2,-3,-5, 7,
 1, 0, 1, 0, 0,-1, 0, 1,-1,-2,-3, 0,-2,-4, 1, 2,
 1,-1, 0, 0,-3,-1,-1, 0,-2, 0,-2, 0,-1,-4, 0, 2, 3,
-7, 2,-5,-8,-9,-6,-8,-8,-3,-6,-2,-4,-5, 0,-7,-3,-6, 18,
-4,-5,-2,-5, 0,-5,-5,-6, 0,-1,-1,-5,-3, 7,-6,-3,-3,-1, 11,
 0,-3,-2,-3,-2,-2,-2,-2,-3, 4, 2,-3, 2,-2,-2,-1, 0,-7,-3, 5,
 0,-1, 3, 4,-5, 1, 3, 0, 1,-3,-4, 0,-3,-5,-1, 1, 0,-6,-4,-2, 3,
 0, 0, 1, 3,-6, 4, 4,-1, 2,-3,-3, 0,-2,-6, 0, 0,-1,-7,-5,-2, 2, 4,
 0,-1, 0,-1,-4,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 220 substitution matrix, scale = ln(2)/3 = 0.231049
//
// Expected score = -1.06, Entropy = 0.437 bits
//
// Lowest score = -8, Highest score = 17
//
const char pam220_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam220[325] =  { 
 2,
-2, 7,
 0, 0, 3,
 0,-2, 2, 4,
-2,-4,-4,-6, 12,
-1, 1, 1, 2,-6, 5,
 0,-1, 2, 4,-6, 3, 4,
 1,-3, 0, 0,-4,-2, 0, 5,
-2, 2, 2, 1,-4, 3, 1,-3, 7,
-1,-2,-2,-3,-3,-2,-2,-3,-3, 5,
-2,-3,-3,-5,-7,-2,-4,-5,-2, 2, 6,
-1, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
-1,-1,-2,-3,-6,-1,-2,-3,-3, 2, 4, 1, 8,
-4,-5,-4,-6,-5,-5,-6,-5,-2, 1, 2,-6, 0, 10,
 1, 0,-1,-1,-3, 0,-1,-1, 0,-2,-3,-1,-2,-5, 7,
 1, 0, 1, 0, 0,-1, 0, 1,-1,-2,-3, 0,-2,-4, 1, 2,
 1,-1, 0, 0,-3,-1,-1, 0,-2, 0,-2, 0,-1,-4, 0, 2, 3,
-6, 2,-4,-8,-8,-5,-8,-8,-3,-6,-2,-4,-5, 0,-6,-3,-6, 17,
-4,-5,-2,-5, 0,-5,-5,-6, 0,-1,-1,-5,-3, 7,-6,-3,-3, 0, 11,
 0,-3,-2,-3,-2,-2,-2,-2,-3, 4, 2,-3, 2,-2,-1,-1, 0,-7,-3, 5,
 0,-1, 2, 4,-5, 1, 3, 0, 1,-2,-4, 0,-3,-5,-1, 0, 0,-6,-3,-2, 3,
 0, 0, 1, 3,-6, 4, 4,-1, 2,-2,-3, 0,-2,-6, 0, 0,-1,-7,-5,-2, 2, 4,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 230 substitution matrix, scale = ln(2)/3 = 0.231049
//
// Expected score = -0.991, Entropy = 0.407 bits
//
// Lowest score = -8, Highest score = 17
//
const char pam230_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam230[325] =  { 
 2,
-2, 7,
 0, 0, 2,
 0,-2, 2, 4,
-2,-4,-4,-6, 12,
-1, 1, 1, 2,-6, 5,
 0,-1, 1, 4,-6, 3, 4,
 1,-3, 0, 1,-4,-1, 0, 5,
-2, 2, 2, 1,-4, 3, 1,-2, 7,
-1,-2,-2,-3,-2,-2,-2,-3,-3, 5,
-2,-3,-3,-4,-7,-2,-4,-4,-2, 2, 6,
-1, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
-1,-1,-2,-3,-6,-1,-2,-3,-2, 2, 4, 0, 7,
-4,-5,-4,-6,-5,-5,-6,-5,-2, 1, 2,-6, 0, 9,
 1, 0,-1,-1,-3, 0,-1,-1, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 0, 0,-1, 0, 1,-1,-2,-3, 0,-2,-3, 1, 2,
 1,-1, 0, 0,-2,-1,-1, 0,-2, 0,-2, 0,-1,-3, 0, 2, 3,
-6, 2,-4,-7,-8,-5,-8,-7,-3,-6,-2,-4,-5, 0,-6,-3,-6, 17,
-4,-5,-2,-5, 0,-4,-5,-6, 0,-1,-1,-5,-3, 7,-5,-3,-3, 0, 10,
 0,-3,-2,-2,-2,-2,-2,-2,-2, 4, 2,-3, 2,-1,-1,-1, 0,-7,-3, 5,
 0,-1, 2, 3,-5, 1, 3, 0, 1,-2,-4, 1,-2,-5,-1, 0, 0,-6,-3,-2, 3,
 0, 0, 1, 3,-6, 4, 4,-1, 2,-2,-3, 0,-2,-6, 0, 0,-1,-6,-5,-2, 2, 4,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-4,-3,-1,-1,-1,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 240 substitution matrix, scale = ln(2)/3 = 0.231049
//
// Expected score = -0.923, Entropy = 0.379 bits
//
// Lowest score = -8, Highest score = 17
//
const char pam240_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam240[325] =  { 
 2,
-2, 6,
 0, 0, 2,
 0,-1, 2, 4,
-2,-4,-4,-5, 12,
 0, 1, 1, 2,-6, 4,
 0,-1, 1, 4,-6, 3, 4,
 1,-3, 0, 1,-4,-1, 0, 5,
-1, 2, 2, 1,-4, 3, 1,-2, 7,
-1,-2,-2,-2,-2,-2,-2,-3,-3, 5,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
-1, 3, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
-1, 0,-2,-3,-5,-1,-2,-3,-2, 2, 4, 0, 7,
-4,-5,-4,-6,-5,-5,-6,-5,-2, 1, 2,-5, 0, 9,
 1, 0,-1,-1,-3, 0,-1,-1, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 0, 0,-1, 0, 1,-1,-1,-3, 0,-2,-3, 1, 2,
 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 3,
-6, 2,-4,-7,-8,-5,-7,-7,-3,-5,-2,-4,-4, 0,-6,-3,-5, 17,
-4,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-5,-3, 7,-5,-3,-3, 0, 10,
 0,-3,-2,-2,-2,-2,-2,-1,-2, 4, 2,-3, 2,-1,-1,-1, 0,-6,-3, 4,
 0,-1, 2, 3,-5, 1, 3, 0, 1,-2,-4, 1,-2,-5,-1, 0, 0,-5,-3,-2, 3,
 0, 0, 1, 3,-6, 3, 3, 0, 2,-2,-3, 0,-2,-5, 0, 0,-1,-6,-4,-2, 2, 3,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 250 substitution matrix, scale = 0.0693200
//
// Expected score = -2.81, Entropy = 0.354 bits
//
// Lowest score = -26, Highest score = 57
//
const char pam250_cdi_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam250_cdi[325] =  { 
 6,
-5, 20,
 1, 0, 7,
 1,-4, 7, 13,
-7,-12,-12,-17, 40,
-1, 4, 3, 5,-18, 13,
 1,-4, 5, 11,-18, 8, 13,
 4,-8, 1, 2,-11,-4, 1, 16,
-4, 5, 5, 2,-11, 10, 2,-7, 22,
-2,-7,-6,-8,-8,-7,-7,-8,-8, 15,
-6,-10,-10,-13,-20,-6,-11,-13,-7, 8, 20,
-4, 11, 3, 0,-18, 2, 0,-6, 0,-6,-9, 15,
-4,-1,-6,-9,-17,-3,-7,-9,-7, 7, 12, 1, 21,
-12,-15,-12,-19,-14,-15,-18,-16,-6, 3, 6,-17, 1, 30,
 4,-1,-2,-3,-9, 1,-2,-2,-1,-7,-8,-4,-7,-15, 19,
 4,-1, 2, 1, 0,-2, 0, 4,-3,-5,-9,-1,-5,-11, 3, 5,
 4,-3, 1, 0,-7,-3,-1, 0,-4, 0,-6, 0,-2,-10, 1, 4, 9,
-19, 7,-13,-22,-26,-16,-23,-23,-9,-17,-6,-12,-14, 1,-19,-8,-17, 57,
-12,-14,-7,-14, 1,-13,-14,-17, 0,-3,-3,-15,-8, 23,-16,-9,-9, 0, 34,
 1,-8,-6,-7,-6,-6,-6,-4,-7, 12, 6,-8, 6,-4,-4,-3, 1,-21,-8, 14,
 1,-2, 7, 10,-15, 4, 9, 2, 4,-7,-11, 2,-7,-15,-2, 2, 0,-18,-10,-6, 9,
 0, 0, 4, 9,-18, 11, 11,-1, 6,-7,-9, 1,-5,-17,-1,-1,-2,-19,-14,-6, 7, 11,
-1,-3,-1,-2,-10,-2,-2,-3,-2,-2,-4,-3,-2,-8,-2,-1,-1,-13,-8,-2,-2,-2,-3,
-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 250 substitution matrix, scale = ln(2)/3 = 0.231049
//
// Expected score = -0.844, Entropy = 0.354 bits
//
// Lowest score = -8, Highest score = 17
//
const char pam250_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam250[325] =  { 
 2,
-2, 6,
 0, 0, 2,
 0,-1, 2, 4,
-2,-4,-4,-5, 12,
 0, 1, 1, 2,-5, 4,
 0,-1, 1, 3,-5, 2, 4,
 1,-3, 0, 1,-3,-1, 0, 5,
-1, 2, 2, 1,-3, 3, 1,-2, 6,
-1,-2,-2,-2,-2,-2,-2,-3,-2, 5,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
-1, 3, 1, 0,-5, 1, 0,-2, 0,-2,-3, 5,
-1, 0,-2,-3,-5,-1,-2,-3,-2, 2, 4, 0, 6,
-3,-4,-3,-6,-4,-5,-5,-5,-2, 1, 2,-5, 0, 9,
 1, 0, 0,-1,-3, 0,-1, 0, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 0, 0,-1, 0, 1,-1,-1,-3, 0,-2,-3, 1, 2,
 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 3,
-6, 2,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 0,-6,-2,-5, 17,
-3,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-4,-2, 7,-5,-3,-3, 0, 10,
 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
 0,-1, 2, 3,-4, 1, 3, 0, 1,-2,-3, 1,-2,-4,-1, 0, 0,-5,-3,-2, 3,
 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-3, 0,-2,-5, 0, 0,-1,-6,-4,-2, 2, 3,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 260 substitution matrix, scale = ln(2)/3 = 0.231049
//
// Expected score = -0.794, Entropy = 0.330 bits
//
// Lowest score = -7, Highest score = 17
//
const char pam260_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam260[325] =  { 
 2,
-1, 6,
 0, 0, 2,
 0,-1, 2, 4,
-2,-4,-3,-5, 12,
 0, 1, 1, 2,-5, 4,
 0,-1, 1, 3,-5, 2, 4,
 1,-2, 0, 1,-3,-1, 0, 5,
-1, 2, 2, 1,-3, 3, 1,-2, 6,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
-1, 3, 1, 0,-5, 1, 0,-2, 0,-2,-3, 4,
-1, 0,-2,-2,-5,-1,-2,-3,-2, 2, 4, 0, 6,
-3,-4,-3,-5,-4,-4,-5,-5,-2, 1, 2,-5, 0, 9,
 1, 0, 0,-1,-3, 0, 0, 0, 0,-2,-2,-1,-2,-4, 6,
 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-1,-3, 1, 1,
 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 2,
-6, 2,-4,-6,-7,-5,-7,-7,-3,-5,-2,-3,-4, 0,-5,-2,-5, 17,
-3,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-4,-2, 7,-5,-3,-3, 0, 10,
 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
 0,-1, 2, 3,-4, 1, 3, 1, 1,-2,-3, 1,-2,-4,-1, 0, 0,-5,-3,-2, 3,
 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-2, 0,-2,-5, 0, 0, 0,-6,-4,-2, 2, 3,
 0,-1, 0,-1,-3, 0,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1, 0,-1,-1,
-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 270 substitution matrix, scale = ln(2)/4 = 0.173287
//
// Expected score = -0.969, Entropy = 0.309 bits
//
// Lowest score = -10, Highest score = 23
//
const char pam270_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam270[325] =  { 
 2,
-2, 8,
 0, 0, 2,
 0,-1, 2, 5,
-2,-5,-4,-6, 16,
 0, 2, 1, 2,-7, 5,
 0,-1, 2, 4,-6, 3, 5,
 2,-3, 1, 1,-4,-1, 0, 6,
-2, 2, 2, 1,-4, 4, 1,-2, 8,
-1,-2,-2,-3,-3,-2,-2,-3,-3, 5,
-2,-4,-3,-5,-7,-2,-4,-5,-3, 3, 8,
-1, 4, 1, 0,-7, 1, 0,-2, 0,-2,-3, 6,
-1,-1,-2,-3,-6,-1,-3,-3,-3, 3, 5, 0, 8,
-4,-5,-4,-7,-5,-6,-7,-6,-2, 1, 2,-6, 0, 12,
 1, 0, 0,-1,-3, 0,-1, 0, 0,-2,-3,-1,-2,-6, 7,
 1, 0, 1, 0, 0,-1, 0, 1,-1,-2,-3, 0,-2,-4, 1, 2,
 1,-1, 1, 0,-3,-1, 0, 0,-1, 0,-2, 0,-1,-4, 0, 2, 3,
-7, 3,-5,-8,-10,-6,-9,-9,-3,-6,-2,-4,-5, 1,-7,-3,-6, 23,
-4,-5,-3,-5, 1,-5,-5,-6, 0,-1,-1,-5,-3, 9,-6,-4,-3, 0, 13,
 0,-3,-2,-3,-2,-2,-2,-2,-3, 5, 2,-3, 2,-1,-1,-1, 0,-8,-3, 5,
 0,-1, 2, 4,-5, 2, 3, 1, 1,-3,-4, 1,-3,-6,-1, 1, 0,-7,-4,-2, 3,
 0, 0, 2, 3,-7, 4, 4, 0, 2,-2,-3, 0,-2,-6, 0, 0,-1,-7,-5,-2, 3, 4,
 0,-1, 0,-1,-4,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 280 substitution matrix, scale = ln(2)/4 = 0.173287
//
// Expected score = -0.916, Entropy = 0.289 bits
//
// Lowest score = -9, Highest score = 22
//
const char pam280_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam280[325] =  { 
 2,
-2, 7,
 0, 0, 2,
 0,-1, 2, 4,
-2,-4,-4,-6, 15,
 0, 2, 1, 2,-6, 4,
 0,-1, 2, 4,-6, 3, 4,
 2,-3, 1, 1,-4,-1, 0, 6,
-1, 2, 2, 1,-4, 3, 1,-2, 8,
-1,-2,-2,-3,-3,-2,-2,-3,-3, 5,
-2,-3,-3,-5,-7,-2,-4,-5,-2, 3, 7,
-1, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 6,
-1, 0,-2,-3,-6,-1,-2,-3,-2, 3, 5, 0, 7,
-4,-5,-4,-7,-5,-5,-6,-6,-2, 1, 2,-6, 0, 11,
 1, 0, 0,-1,-3, 0, 0, 0, 0,-2,-3,-1,-2,-5, 7,
 1, 0, 1, 0, 0, 0, 0, 1,-1,-2,-3, 0,-2,-4, 1, 2,
 1,-1, 1, 0,-3,-1, 0, 0,-1, 0,-2, 0,-1,-4, 1, 1, 3,
-7, 3,-5,-8,-9,-6,-8,-8,-3,-6,-2,-4,-5, 1,-7,-3,-6, 22,
-4,-5,-3,-5, 1,-5,-5,-6, 0,-1,-1,-5,-3, 9,-6,-3,-3, 0, 13,
 0,-3,-2,-2,-2,-2,-2,-1,-3, 4, 2,-3, 2,-1,-1,-1, 0,-7,-3, 5,
 0,-1, 2, 4,-5, 2, 3, 1, 1,-2,-4, 1,-2,-5,-1, 1, 0,-6,-4,-2, 3,
 0, 0, 1, 3,-6, 4, 4, 0, 2,-2,-3, 1,-2,-6, 0, 0, 0,-7,-5,-2, 2, 4,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 290 substitution matrix, scale = ln(2)/4 = 0.173287
//
// Expected score = -0.877, Entropy = 0.271 bits
//
// Lowest score = -9, Highest score = 22
//
const char pam290_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam290[325] =  { 
 2,
-2, 7,
 0, 0, 2,
 0,-1, 2, 4,
-2,-4,-4,-6, 15,
 0, 2, 1, 2,-6, 4,
 0,-1, 2, 4,-6, 3, 4,
 2,-3, 1, 1,-4,-1, 0, 5,
-1, 2, 2, 1,-4, 3, 1,-2, 7,
-1,-2,-2,-3,-3,-2,-2,-3,-3, 5,
-2,-3,-3,-4,-7,-2,-4,-4,-2, 3, 7,
-1, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
-1, 0,-2,-3,-6,-1,-2,-3,-2, 3, 5, 0, 7,
-4,-5,-4,-6,-5,-5,-6,-6,-2, 1, 3,-6, 0, 11,
 1, 0, 0,-1,-3, 0, 0, 0, 0,-2,-3,-1,-2,-5, 7,
 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-2,-4, 1, 2,
 1,-1, 1, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 1, 1, 3,
-7, 3,-5,-8,-9,-5,-8,-8,-3,-6,-2,-4,-5, 1,-6,-3,-6, 22,
-4,-5,-3,-5, 1,-5,-5,-6, 0,-1,-1,-5,-2, 9,-6,-3,-3, 0, 13,
 0,-3,-2,-2,-2,-2,-2,-1,-2, 4, 2,-3, 2,-1,-1,-1, 0,-7,-3, 5,
 0, 0, 2, 3,-5, 2, 3, 1, 1,-2,-4, 1,-2,-5,-1, 1, 0,-6,-4,-2, 3,
 0, 0, 1, 3,-6, 3, 4, 0, 2,-2,-3, 1,-2,-6, 0, 0, 0,-7,-5,-2, 2, 4,
 0,-1, 0,-1,-3, 0,-1,-1,-1,-1,-1,-1,-1,-3,-1, 0, 0,-5,-2,-1, 0,-1,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 30 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -5.06, Entropy = 2.57 bits
//
// Lowest score = -17, Highest score = 13
//
const char pam30_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam30[325] =  { 
 6,
-7, 8,
-4,-6, 8,
-3,-10, 2, 8,
-6,-8,-11,-14, 10,
-4,-2,-3,-2,-14, 8,
-2,-9,-2, 2,-14, 1, 8,
-2,-9,-3,-3,-9,-7,-4, 6,
-7,-2, 0,-4,-7, 1,-5,-9, 9,
-5,-5,-5,-7,-6,-8,-5,-11,-9, 8,
-6,-8,-7,-12,-15,-5,-9,-10,-6,-1, 7,
-7, 0,-1,-4,-14,-3,-4,-7,-6,-6,-8, 7,
-5,-4,-9,-11,-13,-4,-7,-8,-10,-1, 1,-2, 11,
-8,-9,-9,-15,-13,-13,-14,-9,-6,-2,-3,-14,-4, 9,
-2,-4,-6,-8,-8,-3,-5,-6,-4,-8,-7,-6,-8,-10, 8,
 0,-3, 0,-4,-3,-5,-4,-2,-6,-7,-8,-4,-5,-6,-2, 6,
-1,-6,-2,-5,-8,-5,-6,-6,-7,-2,-7,-3,-4,-9,-4, 0, 7,
-13,-2,-8,-15,-15,-13,-17,-15,-7,-14,-6,-12,-13,-4,-14,-5,-13, 13,
-8,-10,-4,-11,-4,-12,-8,-14,-3,-6,-7,-9,-11, 2,-13,-7,-6,-5, 10,
-2,-8,-8,-8,-6,-7,-6,-5,-6, 2,-2,-9,-1,-8,-6,-6,-3,-15,-7, 7,
-3,-7, 6, 6,-12,-3, 1,-3,-1,-6,-9,-2,-10,-10,-7,-1,-3,-10,-6,-8, 6,
-3,-4,-3, 1,-14, 6, 6,-5,-1,-6,-7,-4,-5,-13,-4,-5,-6,-14,-9,-6, 0, 6,
-3,-6,-3,-5,-9,-5,-5,-5,-5,-5,-6,-5,-5,-8,-5,-3,-4,-11,-7,-5,-5,-5,-5,
-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 300 substitution matrix, scale = ln(2)/4 = 0.173287
//
// Expected score = -0.835, Entropy = 0.254 bits
//
// Lowest score = -9, Highest score = 22
//
const char pam300_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam300[325] =  { 
 2,
-1, 7,
 0, 0, 2,
 0,-1, 2, 4,
-2,-4,-4,-6, 15,
 0, 2, 1, 2,-6, 4,
 0,-1, 2, 4,-6, 3, 4,
 2,-2, 1, 1,-4,-1, 0, 5,
-1, 2, 2, 1,-4, 3, 1,-2, 7,
 0,-2,-2,-2,-3,-2,-2,-3,-2, 5,
-2,-3,-3,-4,-7,-2,-4,-4,-2, 3, 7,
-1, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
-1, 0,-2,-3,-6,-1,-2,-3,-2, 3, 4, 0, 6,
-4,-5,-4,-6,-5,-5,-6,-5,-2, 1, 3,-6, 1, 11,
 1, 0, 0,-1,-3, 0, 0, 0, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-2,-4, 1, 1,
 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 1, 1, 2,
-6, 3,-5,-7,-9,-5,-8,-8,-3,-6,-2,-4,-5, 1,-6,-3,-6, 22,
-4,-5,-2,-5, 1,-4,-5,-6, 0,-1, 0,-5,-2, 9,-5,-3,-3, 0, 12,
 0,-3,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-7,-3, 5,
 0, 0, 2, 3,-5, 2, 3, 1, 1,-2,-4, 1,-2,-5, 0, 1, 0,-6,-4,-2, 3,
 0, 0, 1, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-6,-5,-2, 2, 3,
 0,-1, 0,-1,-3, 0,-1,-1, 0,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2, 0, 0,-1,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 310 substitution matrix, scale = ln(2)/4 = 0.173287
//
// Expected score = -0.779, Entropy = 0.238 bits
//
// Lowest score = -9, Highest score = 22
//
const char pam310_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam310[325] =  { 
 2,
-1, 6,
 0, 0, 2,
 0,-1, 2, 4,
-2,-4,-4,-5, 15,
 0, 1, 1, 2,-6, 4,
 0,-1, 2, 4,-6, 3, 4,
 1,-2, 1, 1,-3,-1, 1, 5,
-1, 2, 2, 1,-4, 3, 1,-2, 7,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 7,
-1, 4, 1, 0,-6, 1, 0,-1, 0,-2,-3, 5,
-1, 0,-2,-2,-6,-1,-2,-3,-2, 3, 4, 0, 6,
-4,-5,-4,-6,-4,-5,-6,-5,-2, 1, 3,-5, 1, 11,
 1, 0, 0,-1,-3, 0, 0, 0, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-2,-4, 1, 1,
 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 1, 1, 2,
-6, 3,-4,-7,-9,-5,-7,-8,-3,-5,-2,-3,-4, 1,-6,-3,-6, 22,
-4,-4,-2,-5, 1,-4,-5,-6, 0,-1, 0,-5,-2, 9,-5,-3,-3, 0, 12,
 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-7,-2, 4,
 0, 0, 2, 3,-5, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 3,
 0, 0, 1, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-6,-4,-2, 2, 3,
 0,-1, 0,-1,-3, 0,-1,-1, 0,-1,-1,-1,-1,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 320 substitution matrix, scale = ln(2)/4 = 0.173287
//
// Expected score = -0.741, Entropy = 0.224 bits
//
// Lowest score = -8, Highest score = 22
//
const char pam320_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam320[325] =  { 
 1,
-1, 6,
 0, 0, 2,
 1,-1, 2, 4,
-2,-4,-4,-5, 15,
 0, 1, 1, 2,-5, 4,
 0,-1, 2, 3,-5, 2, 4,
 1,-2, 1, 1,-3,-1, 1, 5,
-1, 2, 2, 1,-4, 3, 1,-2, 6,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 7,
-1, 4, 1, 0,-6, 1, 0,-1, 0,-2,-3, 5,
-1, 0,-2,-2,-5,-1,-2,-3,-2, 2, 4, 0, 6,
-4,-5,-4,-6,-4,-5,-5,-5,-2, 1, 3,-5, 1, 11,
 1, 0, 0, 0,-3, 0, 0, 0, 0,-2,-2,-1,-2,-5, 6,
 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-1,-3, 1, 1,
 1,-1, 0, 0,-2, 0, 0, 0,-1, 0,-2, 0,-1,-3, 1, 1, 2,
-6, 3,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 1,-6,-3,-5, 22,
-4,-4,-2,-5, 1,-4,-5,-5, 0,-1, 0,-5,-2, 9,-5,-3,-3, 1, 12,
 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
 0, 0, 2, 3,-4, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-3,-2, 2,
 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-6,-4,-2, 2, 3,
 0,-1, 0,-1,-3, 0, 0,-1, 0, 0,-1,-1, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 330 substitution matrix, scale = ln(2)/4 = 0.173287
//
// Expected score = -0.693, Entropy = 0.210 bits
//
// Lowest score = -8, Highest score = 22
//
const char pam330_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam330[325] =  { 
 1,
-1, 6,
 0, 0, 2,
 1,-1, 2, 3,
-2,-4,-4,-5, 15,
 0, 1, 1, 2,-5, 3,
 0,-1, 2, 3,-5, 2, 3,
 1,-2, 1, 1,-3,-1, 1, 5,
-1, 2, 1, 1,-3, 3, 1,-2, 6,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 6,
-1, 4, 1, 0,-5, 1, 0,-1, 0,-2,-3, 5,
-1, 0,-1,-2,-5,-1,-2,-2,-2, 2, 4, 0, 5,
-3,-4,-3,-5,-4,-4,-5,-5,-2, 1, 3,-5, 1, 10,
 1, 0, 0, 0,-3, 0, 0, 0, 0,-2,-2,-1,-2,-5, 6,
 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-1,-3, 1, 1,
 1,-1, 0, 0,-2, 0, 0, 0,-1, 0,-1, 0, 0,-3, 1, 1, 2,
-6, 3,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 1,-6,-3,-5, 22,
-3,-4,-2,-4, 1,-4,-4,-5, 0, 0, 0,-4,-2, 9,-5,-3,-3, 1, 12,
 0,-2,-1,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
 0, 0, 2, 3,-4, 1, 2, 1, 1,-2,-3, 1,-2,-4, 0, 1, 0,-5,-3,-2, 2,
 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-2, 2, 3,
 0,-1, 0, 0,-3, 0, 0,-1, 0, 0,-1,-1, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 340 substitution matrix, scale = ln(2)/4 = 0.173287
//
// Expected score = -0.680, Entropy = 0.198 bits
//
// Lowest score = -8, Highest score = 22
//
const char pam340_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam340[325] =  { 
 1,
-1, 6,
 0, 0, 1,
 1,-1, 2, 3,
-2,-4,-3,-5, 15,
 0, 1, 1, 2,-5, 3,
 0, 0, 1, 3,-5, 2, 3,
 1,-2, 1, 1,-3,-1, 1, 4,
-1, 2, 1, 1,-3, 3, 1,-2, 6,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 6,
-1, 4, 1, 0,-5, 1, 0,-1, 0,-2,-3, 4,
-1, 0,-1,-2,-5,-1,-2,-2,-2, 2, 4, 0, 5,
-3,-4,-3,-5,-4,-4,-5,-5,-2, 1, 3,-5, 1, 10,
 1, 0, 0, 0,-3, 0, 0, 0, 0,-2,-2,-1,-2,-4, 5,
 1, 0, 1, 0, 0, 0, 0, 1, 0,-1,-2, 0,-1,-3, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 0,-1, 0,-1, 0, 0,-3, 1, 1, 2,
-6, 3,-4,-7,-8,-5,-7,-7,-2,-5,-2,-3,-4, 1,-5,-3,-5, 22,
-3,-4,-2,-4, 1,-4,-4,-5, 0, 0, 0,-4,-2, 9,-5,-3,-3, 1, 12,
 0,-2,-1,-2,-2,-2,-1,-1,-2, 3, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
 0, 0, 2, 3,-4, 1, 2, 1, 1,-2,-3, 1,-2,-4, 0, 1, 0,-5,-3,-2, 2,
 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-2, 2, 3,
 0,-1, 0, 0,-3, 0, 0,-1, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 350 substitution matrix, scale = ln(2)/5 = 0.138629
//
// Expected score = -0.701, Entropy = 0.186 bits
//
// Lowest score = -10, Highest score = 27
//
const char pam350_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam350[325] =  { 
 2,
-1, 7,
 0, 1, 2,
 1,-1, 2, 4,
-2,-4,-4,-6, 18,
 0, 2, 1, 2,-6, 4,
 1, 0, 2, 4,-6, 3, 4,
 2,-2, 1, 1,-4,-1, 1, 5,
-1, 2, 2, 1,-4, 3, 1,-2, 7,
 0,-2,-2,-2,-3,-2,-2,-2,-2, 5,
-2,-3,-3,-4,-7,-2,-4,-4,-2, 4, 8,
-1, 4, 1, 1,-6, 1, 0,-1, 1,-2,-3, 5,
-1, 0,-2,-3,-6,-1,-2,-3,-2, 3, 5, 0, 6,
-4,-5,-4,-6,-5,-5,-6,-6,-2, 2, 3,-6, 1, 13,
 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 1, 0, 0, 0, 1,-1,-1,-3, 0,-2,-4, 1, 1,
 1,-1, 1, 0,-2, 0, 0, 1,-1, 0,-2, 0,-1,-3, 1, 1, 2,
-7, 4,-5,-8,-10,-5,-8,-8,-3,-6,-2,-4,-5, 1,-7,-3,-6, 27,
-4,-5,-3,-5, 1,-5,-5,-6, 0, 0, 0,-5,-2, 11,-6,-3,-3, 1, 14,
 0,-3,-2,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2,-1,-1,-1, 0,-7,-2, 5,
 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-4, 1,-2,-5, 0, 1, 0,-6,-4,-2, 3,
 0, 1, 2, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-6, 0, 0, 0,-7,-5,-2, 2, 3,
 0,-1, 0,-1,-3, 0, 0,-1, 0, 0,-1,-1, 0,-2, 0, 0, 0,-5,-2, 0, 0, 0,-1,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 360 substitution matrix, scale = ln(2)/5 = 0.138629
//
// Expected score = -0.697, Entropy = 0.175 bits
//
// Lowest score = -9, Highest score = 27
//
const char pam360_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam360[325] =  { 
 1,
-1, 6,
 0, 1, 2,
 1,-1, 2, 4,
-2,-4,-4,-6, 18,
 0, 2, 1, 2,-6, 3,
 1, 0, 2, 4,-6, 3, 4,
 2,-2, 1, 1,-4,-1, 1, 5,
-1, 2, 2, 1,-4, 3, 1,-2, 7,
 0,-2,-2,-2,-3,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-7,-2,-3,-4,-2, 3, 7,
-1, 4, 1, 1,-6, 1, 0,-1, 1,-2,-3, 5,
-1, 0,-2,-2,-6,-1,-2,-3,-2, 3, 5, 0, 6,
-4,-5,-4,-6,-4,-5,-6,-6,-2, 2, 3,-6, 1, 12,
 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 1, 0, 0, 0, 1, 0,-1,-3, 0,-2,-4, 1, 1,
 1, 0, 1, 0,-2, 0, 0, 1,-1, 0,-2, 0,-1,-3, 1, 1, 2,
-7, 4,-5,-8,-9,-5,-8,-8,-3,-6,-2,-4,-4, 2,-6,-3,-6, 27,
-4,-5,-3,-5, 1,-4,-5,-6, 0, 0, 0,-5,-2, 11,-5,-3,-3, 1, 14,
 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2,-1,-1,-1, 0,-7,-2, 4,
 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-4, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
 0, 1, 2, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-7,-5,-2, 2, 3,
 0,-1, 0, 0,-3, 0, 0,-1, 0, 0,-1,-1, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 370 substitution matrix, scale = ln(2)/5 = 0.138629
//
// Expected score = -0.649, Entropy = 0.165 bits
//
// Lowest score = -9, Highest score = 27
//
const char pam370_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam370[325] =  { 
 1,
-1, 6,
 0, 1, 2,
 1, 0, 2, 4,
-2,-4,-4,-5, 18,
 0, 2, 1, 2,-6, 3,
 1, 0, 2, 3,-6, 2, 3,
 2,-2, 1, 1,-3,-1, 1, 5,
-1, 2, 2, 1,-4, 3, 1,-2, 6,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 7,
-1, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 5,
-1, 0,-2,-2,-6,-1,-2,-3,-2, 3, 5, 0, 5,
-4,-5,-4,-6,-4,-5,-6,-5,-2, 2, 3,-6, 1, 12,
 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 1, 0, 0, 0, 1, 0,-1,-3, 0,-1,-4, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 2,
-7, 3,-5,-7,-9,-5,-8,-8,-3,-5,-2,-3,-4, 2,-6,-3,-6, 27,
-4,-4,-3,-5, 1,-4,-5,-6, 0, 0, 0,-5,-2, 11,-5,-3,-3, 1, 14,
 0,-2,-1,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-7,-2, 4,
 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
 0, 1, 1, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-6,-5,-2, 2, 3,
 0,-1, 0, 0,-3, 0, 0,-1, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 380 substitution matrix, scale = ln(2)/5 = 0.138629
//
// Expected score = -0.612, Entropy = 0.156 bits
//
// Lowest score = -9, Highest score = 26
//
const char pam380_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam380[325] =  { 
 1,
-1, 6,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-4,-5, 17,
 0, 2, 1, 2,-5, 3,
 1, 0, 2, 3,-5, 2, 3,
 2,-2, 1, 1,-3,-1, 1, 5,
-1, 2, 1, 1,-4, 3, 1,-1, 6,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 7,
-1, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 5,
-1, 0,-1,-2,-5,-1,-2,-2,-2, 3, 4, 0, 5,
-4,-5,-4,-6,-4,-5,-5,-5,-2, 2, 3,-5, 1, 12,
 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-2, 0,-2,-5, 5,
 1, 0, 1, 1, 0, 0, 0, 1, 0,-1,-3, 0,-1,-4, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 2,
-6, 3,-5,-7,-9,-5,-7,-8,-3,-5,-2,-3,-4, 2,-6,-3,-6, 26,
-4,-4,-3,-5, 1,-4,-5,-5, 0, 0, 0,-5,-2, 10,-5,-3,-3, 1, 13,
 0,-2,-1,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-6,-2, 4,
 1, 0, 2, 3,-4, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
 0, 1, 1, 3,-5, 3, 3, 0, 2,-2,-3, 1,-1,-5, 0, 0, 0,-6,-4,-2, 2, 3,
 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 390 substitution matrix, scale = ln(2)/5 = 0.138629
//
// Expected score = -0.581, Entropy = 0.147 bits
//
// Lowest score = -9, Highest score = 26
//
const char pam390_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam390[325] =  { 
 1,
-1, 6,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-4,-5, 17,
 0, 1, 1, 2,-5, 3,
 1, 0, 2, 3,-5, 2, 3,
 1,-2, 1, 1,-3, 0, 1, 5,
-1, 2, 1, 1,-4, 3, 1,-1, 6,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 7,
-1, 4, 1, 1,-5, 1, 1,-1, 1,-2,-3, 4,
-1, 0,-1,-2,-5,-1,-2,-2,-2, 3, 4, 0, 5,
-3,-5,-4,-5,-4,-4,-5,-5,-2, 2, 3,-5, 1, 12,
 1, 0, 0, 0,-3, 0, 0, 0, 0,-1,-2, 0,-2,-5, 5,
 1, 0, 1, 1, 0, 0, 0, 1, 0,-1,-2, 0,-1,-3, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
-6, 3,-4,-7,-9,-5,-7,-7,-3,-5,-2,-3,-4, 2,-6,-3,-5, 26,
-4,-4,-3,-5, 1,-4,-5,-5, 0, 0, 0,-5,-1, 10,-5,-3,-3, 1, 13,
 0,-2,-1,-2,-2,-1,-1,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-6,-2, 4,
 1, 0, 2, 3,-4, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
 0, 1, 1, 3,-5, 3, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-1, 2, 3,
 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 40 substitution matrix, scale = 0.0693200
//
// Expected score = -21.3, Entropy = 2.26 bits
//
// Lowest score = -74, Highest score = 64
//
const char pam40_cdi_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam40_cdi[325] =  { 
 28,
-30, 41,
-14,-23, 36,
-13,-43, 10, 37,
-17,-5,-14,-8,-61,
-8,-38,-7, 15,-62, 8,
-5,-41,-12,-13,-41,-30,-17,
-31,-4, 4,-15,-33, 7,-20,-38,
-19,-23,-22,-32,-27,-33,-24,-46,-39,
-27,-38,-31,-54,-66,-21,-41,-47,-26,-3,
-29, 5,-2,-18,-62,-10,-18,-31,-25,-26,-36,
-20,-17,-37,-47,-59,-16,-30,-37,-44, 0, 6,-5,
-37,-42,-38,-64,-56,-57,-62,-41,-25,-8,-9,-61,-16,
-4,-15,-24,-33,-35,-11,-23,-26,-17,-37,-31,-28,-35,-44,
 1,-12, 2,-14,-11,-22,-18,-5,-25,-29,-36,-16,-23,-28,-5,
 0,-27,-6,-19,-34,-23,-25,-24,-31,-9,-29,-12,-16,-38,-17, 4,
-59,-6,-36,-67,-70,-56,-74,-67,-32,-60,-26,-51,-55,-18,-60,-22,-56,
-8,-33,-33,-35,-25,-29,-28,-24,-28, 12,-8,-39,-3,-33,-24,-26,-10,-68,
-14,-30, 28, 29,-53,-10, 8,-12,-3,-26,-39,-9,-41,-47,-28,-5,-12,-45,-28,
-12,-15,-10, 8,-62, 30, 29,-21,-2,-27,-29,-14,-22,-60,-16,-19,-24,-63,-42,-28,
-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,-74,
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 40 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -4.27, Entropy = 2.26 bits
//
// Lowest score = -15, Highest score = 13
//
const char pam40_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam40[325] =  { 
 6,
-6, 8,
-3,-5, 7,
-3,-9, 2, 7,
-6,-7,-9,-12, 9,
-3,-1,-3,-2,-12, 8,
-2,-8,-1, 3,-12, 2, 7,
-1,-8,-2,-3,-8,-6,-3, 6,
-6,-1, 1,-3,-7, 1,-4,-8, 9,
-4,-5,-4,-6,-5,-7,-5,-9,-8, 8,
-5,-8,-6,-11,-13,-4,-8,-9,-5,-1, 7,
-6, 1, 0,-4,-12,-2,-4,-6,-5,-5,-7, 6,
-4,-3,-7,-9,-12,-3,-6,-7,-9, 0, 1,-1, 11,
-7,-8,-8,-13,-11,-11,-12,-8,-5,-2,-2,-12,-3, 9,
-1,-3,-5,-7,-7,-2,-5,-5,-3,-7,-6,-6,-7,-9, 8,
 0,-2, 0,-3,-2,-4,-4,-1,-5,-6,-7,-3,-5,-6,-1, 6,
 0,-5,-1,-4,-7,-5,-5,-5,-6,-2,-6,-2,-3,-8,-3, 1, 7,
-12,-1,-7,-13,-14,-11,-15,-13,-6,-12,-5,-10,-11,-4,-12,-4,-11, 13,
-7,-9,-4,-10,-3,-10,-8,-12,-3,-5,-6,-8,-10, 2,-12,-6,-6,-4, 10,
-2,-7,-7,-7,-5,-6,-6,-5,-6, 2,-2,-8,-1,-7,-5,-5,-2,-14,-6, 7,
-3,-6, 6, 6,-11,-2, 2,-2,-1,-5,-8,-2,-8,-9,-6,-1,-2,-9,-6,-7, 6,
-2,-3,-2, 2,-12, 6, 6,-4, 0,-5,-6,-3,-4,-12,-3,-4,-5,-13,-8,-6, 1, 6,
-3,-5,-3,-5,-8,-4,-4,-4,-4,-4,-5,-4,-4,-7,-4,-2,-3,-9,-7,-4,-4,-4,-4,
-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 400 substitution matrix, scale = ln(2)/5 = 0.138629
//
// Expected score = -0.521, Entropy = 0.139 bits
//
// Lowest score = -8, Highest score = 26
//
const char pam400_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam400[325] =  { 
 1,
-1, 5,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-3,-5, 17,
 0, 1, 1, 2,-5, 3,
 1, 0, 2, 3,-5, 2, 3,
 1,-2, 1, 1,-3, 0, 1, 4,
-1, 2, 1, 1,-3, 3, 1,-1, 5,
 0,-2,-1,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-3,-6,-2,-3,-3,-2, 3, 7,
-1, 4, 1, 1,-5, 1, 1,-1, 1,-2,-2, 4,
-1, 0,-1,-2,-5,-1,-2,-2,-1, 2, 4, 0, 5,
-3,-4,-3,-5,-4,-4,-5,-5,-2, 2, 3,-5, 1, 11,
 1, 0, 0, 0,-2, 0, 0, 0, 0,-1,-2, 0,-1,-4, 5,
 1, 0, 1, 1, 0, 0, 0, 1, 0,-1,-2, 0,-1,-3, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
-6, 3,-4,-7,-8,-5,-7,-7,-2,-5,-2,-3,-4, 2,-6,-3,-5, 26,
-3,-4,-3,-4, 1,-4,-4,-5, 0, 0, 0,-4,-1, 10,-5,-3,-3, 1, 13,
 0,-2,-1,-2,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-2, 4,
 1, 0, 2, 2,-4, 2, 2, 1, 1,-2,-3, 1,-2,-4, 0, 1, 0,-5,-3,-1, 2,
 0, 1, 1, 2,-5, 2, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-1, 2, 3,
 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 410 substitution matrix, scale = ln(2)/6 = 0.115525
//
// Expected score = -0.617, Entropy = 0.131 bits
//
// Lowest score = -10, Highest score = 31
//
const char pam410_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam410[325] =  { 
 1,
-1, 6,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-4,-6, 20,
 0, 2, 1, 2,-6, 3,
 1, 0, 2, 3,-6, 2, 3,
 2,-2, 1, 1,-4, 0, 1, 5,
-1, 2, 1, 1,-4, 3, 1,-1, 6,
 0,-2,-2,-2,-3,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-7,-2,-3,-4,-2, 4, 8,
-1, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 5,
-1, 0,-2,-2,-6,-1,-2,-3,-2, 3, 5, 0, 5,
-4,-5,-4,-6,-4,-5,-6,-6,-2, 2, 4,-6, 1, 14,
 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-3, 0,-2,-5, 6,
 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-3, 0,-1,-4, 1, 1,
 1, 0, 1, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 2,
-7, 4,-5,-8,-10,-5,-8,-8,-3,-6,-2,-3,-4, 2,-7,-3,-6, 31,
-4,-5,-3,-5, 1,-4,-5,-6, 0, 0, 1,-5,-2, 12,-5,-3,-3, 2, 15,
 0,-2,-1,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-7,-2, 4,
 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
 0, 1, 2, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-7,-5,-2, 2, 3,
 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 420 substitution matrix, scale = ln(2)/6 = 0.115525
//
// Expected score = -0.599, Entropy = 0.124 bits
//
// Lowest score = -10, Highest score = 31
//
const char pam420_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam420[325] =  { 
 1,
-1, 6,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-4,-5, 20,
 0, 2, 1, 2,-6, 3,
 1, 0, 2, 3,-6, 2, 3,
 2,-2, 1, 1,-3, 0, 1, 5,
-1, 2, 1, 1,-4, 3, 1,-1, 6,
 0,-2,-2,-2,-3,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-7,-2,-3,-4,-2, 4, 7,
 0, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 5,
-1, 0,-1,-2,-6,-1,-2,-2,-2, 3, 5, 0, 5,
-4,-5,-4,-6,-4,-5,-6,-6,-2, 2, 4,-6, 1, 13,
 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-2, 0,-2,-5, 5,
 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-3, 0,-1,-4, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
-7, 4,-5,-8,-10,-5,-8,-8,-3,-6,-2,-3,-4, 2,-6,-3,-6, 31,
-4,-5,-3,-5, 1,-4,-5,-6, 0, 0, 1,-5,-1, 12,-5,-3,-3, 2, 15,
 0,-2,-1,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-7,-2, 4,
 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
 0, 1, 2, 3,-6, 3, 3, 0, 2,-2,-3, 1,-1,-5, 0, 0, 0,-7,-5,-2, 2, 3,
 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 430 substitution matrix, scale = ln(2)/6 = 0.115525
//
// Expected score = -0.543, Entropy = 0.117 bits
//
// Lowest score = -9, Highest score = 31
//
const char pam430_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam430[325] =  { 
 1,
-1, 6,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-4,-5, 20,
 0, 2, 1, 2,-6, 3,
 1, 0, 2, 3,-5, 2, 3,
 2,-2, 1, 1,-3, 0, 1, 5,
-1, 2, 1, 1,-4, 3, 1,-1, 5,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 4, 7,
 0, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 4,
-1, 0,-1,-2,-5,-1,-2,-2,-1, 3, 5, 0, 5,
-4,-5,-4,-6,-4,-5,-6,-5,-2, 2, 4,-5, 1, 13,
 1, 0, 0, 0,-3, 1, 0, 0, 0,-1,-2, 0,-2,-5, 5,
 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-4, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
-7, 4,-5,-7,-9,-5,-8,-8,-3,-5,-2,-3,-4, 2,-6,-3,-6, 31,
-4,-4,-3,-5, 1,-4,-5,-5, 0, 0, 1,-5,-1, 12,-5,-3,-3, 2, 15,
 0,-2,-1,-2,-2,-1,-1,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-7,-2, 4,
 1, 0, 2, 3,-4, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-1, 2,
 0, 1, 1, 3,-5, 3, 3, 0, 2,-2,-3, 1,-1,-5, 0, 0, 0,-6,-5,-1, 2, 3,
 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 440 substitution matrix, scale = ln(2)/6 = 0.115525
//
// Expected score = -0.529, Entropy = 0.111 bits
//
// Lowest score = -9, Highest score = 30
//
const char pam440_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam440[325] =  { 
 1,
-1, 5,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-4,-5, 20,
 0, 2, 1, 2,-5, 3,
 1, 0, 2, 3,-5, 2, 3,
 2,-2, 1, 1,-3, 0, 1, 4,
-1, 2, 1, 1,-4, 3, 1,-1, 5,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-3,-6,-2,-3,-4,-2, 4, 7,
 0, 4, 1, 1,-5, 1, 1,-1, 1,-2,-3, 4,
-1, 0,-1,-2,-5,-1,-2,-2,-1, 3, 5, 0, 4,
-4,-5,-4,-6,-4,-4,-5,-5,-2, 2, 4,-5, 1, 13,
 1, 0, 0, 0,-3, 1, 0, 0, 0,-1,-2, 0,-1,-5, 5,
 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-4, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
-6, 4,-5,-7,-9,-5,-7,-8,-3,-5,-2,-3,-4, 2,-6,-3,-6, 30,
-4,-4,-3,-5, 1,-4,-5,-5, 0, 0, 1,-5,-1, 12,-5,-3,-3, 2, 15,
 0,-2,-1,-2,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-2, 4,
 1, 0, 2, 2,-4, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-1, 2,
 0, 1, 1, 2,-5, 2, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-1, 2, 3,
 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 450 substitution matrix, scale = ln(2)/6 = 0.115525
//
// Expected score = -0.476, Entropy = 0.105 bits
//
// Lowest score = -9, Highest score = 30
//
const char pam450_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam450[325] =  { 
 1,
-1, 5,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-4,-5, 20,
 0, 2, 1, 2,-5, 3,
 1, 0, 2, 3,-5, 2, 3,
 1,-1, 1, 1,-3, 0, 1, 4,
-1, 2, 1, 1,-4, 3, 1,-1, 5,
 0,-2,-1,-2,-2,-1,-2,-2,-2, 4,
-2,-3,-2,-3,-6,-2,-3,-3,-2, 3, 7,
 0, 4, 1, 1,-5, 1, 1,-1, 1,-2,-2, 4,
-1, 0,-1,-2,-5,-1,-2,-2,-1, 3, 4, 0, 4,
-3,-4,-4,-5,-4,-4,-5,-5,-2, 2, 4,-5, 1, 13,
 1, 0, 0, 0,-2, 1, 0, 0, 0,-1,-2, 0,-1,-5, 5,
 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-3, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
-6, 4,-4,-7,-9,-5,-7,-8,-2,-5,-1,-3,-4, 2,-6,-3,-5, 30,
-4,-4,-3,-5, 1,-4,-5,-5, 0, 0, 1,-5,-1, 12,-5,-3,-3, 2, 14,
 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-2, 3,
 1, 0, 1, 2,-4, 2, 2, 1, 1,-2,-3, 1,-2,-4, 0, 1, 0,-6,-4,-1, 2,
 0, 1, 1, 2,-5, 2, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-1, 2, 2,
 0, 0, 0, 0,-2, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 460 substitution matrix, scale = ln(2)/6 = 0.115525
//
// Expected score = -0.429, Entropy = 0.0994 bits
//
// Lowest score = -9, Highest score = 30
//
const char pam460_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam460[325] =  { 
 1,
-1, 5,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-3,-5, 19,
 0, 1, 1, 2,-5, 2,
 1, 0, 1, 3,-5, 2, 3,
 1,-1, 1, 1,-3, 0, 1, 4,
 0, 2, 1, 1,-3, 2, 1,-1, 5,
 0,-2,-1,-2,-2,-1,-2,-2,-2, 3,
-1,-2,-2,-3,-6,-2,-3,-3,-2, 3, 7,
 0, 4, 1, 1,-5, 1, 1,-1, 1,-2,-2, 4,
-1, 0,-1,-2,-5,-1,-2,-2,-1, 2, 4, 0, 4,
-3,-4,-3,-5,-3,-4,-5,-5,-2, 2, 3,-5, 1, 12,
 1, 0, 0, 0,-2, 1, 0, 1, 0,-1,-2, 0,-1,-4, 4,
 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-3, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,
-6, 4,-4,-7,-9,-5,-7,-7,-2,-5,-1,-3,-4, 2,-6,-3,-5, 30,
-3,-4,-3,-4, 2,-4,-4,-5, 0, 0, 1,-4,-1, 11,-5,-3,-3, 2, 14,
 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-2, 3,
 1, 0, 1, 2,-4, 1, 2, 1, 1,-2,-3, 1,-2,-4, 0, 1, 0,-6,-4,-1, 2,
 0, 1, 1, 2,-5, 2, 2, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-1, 2, 2,
 0, 0, 0, 0,-2, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 470 substitution matrix, scale = ln(2)/7 = 0.0990210
//
// Expected score = -0.520, Entropy = 0.0942 bits
//
// Lowest score = -10, Highest score = 35
//
const char pam470_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam470[325] =  { 
 1,
-1, 6,
 1, 1, 1,
 1, 0, 2, 3,
-2,-4,-4,-5, 22,
 0, 2, 1, 2,-6, 3,
 1, 0, 2, 3,-5, 2, 3,
 2,-1, 1, 1,-3, 0, 1, 5,
-1, 2, 1, 1,-4, 3, 1,-1, 5,
 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 4, 8,
 0, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 4,
-1, 0,-1,-2,-6,-1,-2,-2,-1, 3, 5, 0, 4,
-4,-5,-4,-6,-4,-5,-6,-6,-2, 2, 4,-5, 1, 14,
 1, 0, 0, 0,-3, 1, 0, 1, 0,-1,-2, 0,-1,-5, 5,
 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-4, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,
-7, 4,-5,-8,-10,-5,-8,-8,-3,-5,-2,-3,-4, 3,-6,-4,-6, 35,
-4,-5,-3,-5, 2,-4,-5,-6, 0, 0, 1,-5,-1, 13,-5,-3,-3, 2, 16,
 0,-2,-1,-2,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-7,-2, 4,
 1, 0, 2, 3,-5, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-1, 2,
 0, 1, 1, 3,-6, 2, 3, 1, 2,-2,-3, 1,-1,-5, 1, 0, 0,-7,-5,-1, 2, 3,
 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 480 substitution matrix, scale = ln(2)/7 = 0.0990210
//
// Expected score = -0.494, Entropy = 0.0893 bits
//
// Lowest score = -10, Highest score = 35
//
const char pam480_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam480[325] =  { 
 1,
-1, 5,
 1, 1, 1,
 1, 0, 2, 3,
-2,-4,-4,-5, 22,
 0, 2, 1, 2,-5, 3,
 1, 0, 2, 3,-5, 2, 3,
 2,-1, 1, 1,-3, 0, 1, 4,
 0, 2, 1, 1,-4, 3, 1,-1, 5,
 0,-2,-1,-2,-2,-2,-2,-2,-2, 4,
-2,-3,-3,-3,-6,-2,-3,-4,-2, 4, 7,
 0, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 4,
-1, 0,-1,-2,-5,-1,-2,-2,-1, 3, 5, 0, 4,
-4,-5,-4,-6,-4,-5,-5,-5,-2, 2, 4,-5, 1, 14,
 1, 0, 0, 0,-3, 1, 0, 1, 0,-1,-2, 0,-1,-5, 5,
 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-4, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,
-7, 4,-5,-7,-10,-5,-8,-8,-3,-5,-2,-3,-4, 3,-6,-3,-6, 35,
-4,-4,-3,-5, 2,-4,-5,-5, 0, 0, 1,-5,-1, 13,-5,-3,-3, 2, 16,
 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-7,-2, 3,
 1, 0, 2, 2,-4, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-1, 2,
 0, 1, 1, 2,-5, 2, 3, 1, 2,-2,-3, 1,-1,-5, 1, 0, 0,-6,-5,-1, 2, 2,
 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 490 substitution matrix, scale = ln(2)/7 = 0.0990210
//
// Expected score = -0.431, Entropy = 0.0847 bits
//
// Lowest score = -9, Highest score = 34
//
const char pam490_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam490[325] =  { 
 1,
-1, 5,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-4,-5, 22,
 0, 2, 1, 2,-5, 2,
 1, 0, 2, 3,-5, 2, 3,
 2,-1, 1, 1,-3, 0, 1, 4,
 0, 2, 1, 1,-4, 2, 1,-1, 5,
 0,-2,-1,-2,-2,-1,-2,-2,-2, 3,
-1,-3,-2,-3,-6,-2,-3,-3,-2, 4, 7,
 0, 4, 1, 1,-5, 1, 1,-1, 1,-2,-2, 4,
-1, 0,-1,-2,-5,-1,-2,-2,-1, 3, 5, 0, 4,
-3,-5,-4,-5,-4,-4,-5,-5,-2, 2, 4,-5, 1, 14,
 1, 0, 0, 0,-3, 1, 0, 1, 0,-1,-2, 0,-1,-5, 4,
 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-4, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,
-6, 4,-5,-7,-9,-5,-7,-8,-3,-5,-1,-3,-4, 3,-6,-3,-6, 34,
-4,-4,-3,-5, 2,-4,-5,-5, 0, 0, 1,-5,-1, 13,-5,-3,-3, 2, 15,
 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-2, 3,
 1, 0, 1, 2,-4, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-1, 2,
 0, 1, 1, 2,-5, 2, 2, 1, 2,-2,-2, 1,-1,-5, 1, 0, 0,-6,-4,-1, 2, 2,
 0, 0, 0, 0,-2, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 50 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -3.70, Entropy = 2.00 bits
//
// Lowest score = -13, Highest score = 13
//
const char pam50_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam50[325] =  { 
 5,
-5, 8,
-2,-4, 7,
-2,-7, 2, 7,
-5,-6,-8,-11, 9,
-3, 0,-2,-1,-11, 8,
-1,-7,-1, 3,-11, 2, 7,
-1,-7,-2,-2,-7,-5,-3, 6,
-5, 0, 1,-2,-6, 2,-3,-7, 9,
-3,-4,-4,-6,-5,-6,-4,-8,-7, 8,
-5,-7,-6,-10,-12,-4,-7,-9,-5, 0, 6,
-5, 1, 0,-3,-11,-2,-3,-6,-4,-5,-6, 6,
-4,-3,-6,-8,-11,-3,-5,-7,-8, 0, 2,-1, 10,
-7,-8,-7,-12,-10,-10,-11,-8,-5,-1,-1,-11,-3, 9,
 0,-3,-4,-6,-6,-2,-4,-4,-3,-7,-6,-5,-6,-8, 8,
 0,-2, 1,-2,-2,-4,-3,-1,-4,-5,-7,-3,-4,-5,-1, 6,
 0,-5,-1,-3,-6,-4,-4,-4,-5,-1,-5,-2,-3,-7,-3, 1, 6,
-11,-1,-7,-12,-13,-10,-13,-12,-6,-11,-5,-9,-10,-3,-11,-4,-10, 13,
-6,-8,-3,-9,-3,-9,-7,-11,-2,-5,-5,-8,-8, 3,-11,-5,-5,-4, 9,
-1,-6,-6,-6,-5,-5,-5,-4,-5, 3,-1,-7, 0,-6,-4,-4,-2,-12,-6, 7,
-2,-5, 5, 6,-9,-2, 2,-2, 0,-5,-7,-1,-7,-9,-5,-1,-2,-8,-5,-6, 5,
-2,-2,-1, 2,-11, 6, 6,-4, 0,-5,-5,-2,-4,-11,-3,-3,-4,-11,-8,-5, 1, 6,
-2,-4,-2,-4,-7,-3,-3,-4,-4,-3,-5,-4,-4,-6,-4,-2,-2,-9,-6,-3,-3,-3,-4,
-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 500 substitution matrix, scale = ln(2)/7 = 0.0990210
//
// Expected score = -0.401, Entropy = 0.0803 bits
//
// Lowest score = -9, Highest score = 34
//
const char pam500_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam500[325] =  { 
 1,
-1, 5,
 0, 1, 1,
 1, 0, 2, 3,
-2,-4,-3,-5, 22,
 0, 2, 1, 2,-5, 2,
 1, 0, 1, 3,-5, 2, 3,
 1,-1, 1, 1,-3, 0, 1, 4,
 0, 2, 1, 1,-4, 2, 1,-1, 4,
 0,-2,-1,-2,-2,-1,-2,-2,-2, 3,
-1,-2,-2,-3,-6,-2,-3,-3,-2, 4, 7,
 0, 4, 1, 1,-5, 1, 1, 0, 1,-2,-2, 4,
-1, 0,-1,-2,-5,-1,-1,-2,-1, 3, 4, 0, 4,
-3,-4,-4,-5,-3,-4,-5,-5,-2, 2, 4,-5, 1, 13,
 1, 0, 0, 0,-2, 1, 0, 1, 0,-1,-2, 0,-1,-4, 4,
 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-3, 1, 1,
 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,
-6, 4,-5,-7,-9,-5,-7,-8,-2,-5,-1,-3,-4, 3,-6,-3,-6, 34,
-3,-4,-3,-5, 2,-4,-5,-5, 0, 0, 1,-5,-1, 13,-5,-3,-3, 2, 15,
 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-1, 3,
 1, 0, 1, 2,-4, 2, 2, 1, 1,-2,-3, 1,-1,-4, 0, 1, 0,-6,-4,-1, 2,
 0, 1, 1, 2,-5, 2, 2, 1, 2,-2,-2, 1,-1,-5, 1, 0, 0,-6,-4,-1, 2, 2,
 0, 0, 0, 0,-2, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 60 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -3.21, Entropy = 1.79 bits
//
// Lowest score = -12, Highest score = 13
//
const char pam60_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam60[325] =  { 
 5,
-5, 8,
-2,-3, 6,
-2,-6, 2, 7,
-5,-6,-7,-10, 9,
-3, 0,-2,-1,-10, 7,
-1,-6, 0, 3,-10, 2, 7,
 0,-7,-1,-2,-7,-5,-2, 6,
-5, 0, 1,-2,-6, 2,-3,-6, 8,
-3,-4,-4,-5,-4,-5,-4,-7,-6, 7,
-4,-6,-5,-9,-11,-3,-7,-8,-4, 0, 6,
-5, 2, 0,-2,-10,-1,-3,-5,-4,-4,-6, 6,
-3,-2,-6,-7,-10,-2,-5,-6,-7, 1, 2, 0, 10,
-6,-7,-6,-11,-9,-9,-10,-7,-4,-1,-1,-10,-2, 8,
 0,-2,-4,-5,-6,-1,-3,-4,-2,-6,-5,-4,-6,-7, 7,
 1,-2, 1,-2,-1,-3,-2, 0,-4,-4,-6,-2,-4,-5, 0, 5,
 1,-4,-1,-3,-5,-4,-4,-3,-5,-1,-5,-2,-2,-6,-2, 1, 6,
-10, 0,-6,-11,-12,-9,-12,-11,-5,-10,-4,-8,-9,-3,-10,-4,-9, 13,
-6,-8,-3,-8,-2,-8,-7,-10,-2,-4,-5,-7,-7, 3,-10,-5,-5,-3, 9,
-1,-5,-5,-6,-4,-5,-4,-4,-5, 3,-1,-6, 0,-5,-4,-4,-1,-11,-5, 6,
-2,-5, 5, 5,-9,-1, 2,-2, 0,-4,-7,-1,-6,-8,-4, 0,-2,-8,-5,-5, 5,
-2,-2,-1, 2,-10, 6, 5,-3, 0,-4,-5,-2,-4,-10,-2,-3,-4,-11,-7,-5, 1, 5,
-2,-4,-2,-3,-6,-3,-3,-3,-3,-3,-4,-3,-3,-5,-3,-2,-2,-8,-5,-3,-3,-3,-3,
-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 70 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -2.77, Entropy = 1.60 bits
//
// Lowest score = -11, Highest score = 13
//
const char pam70_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam70[325] =  { 
 5,
-4, 8,
-2,-3, 6,
-1,-6, 3, 6,
-4,-5,-7,-9, 9,
-2, 0,-1, 0,-9, 7,
-1,-5, 0, 3,-9, 2, 6,
 0,-6,-1,-1,-6,-4,-2, 6,
-4, 0, 1,-1,-5, 2,-2,-6, 8,
-2,-3,-3,-5,-4,-5,-4,-6,-6, 7,
-4,-6,-5,-8,-10,-3,-6,-7,-4, 1, 6,
-4, 2, 0,-2,-9,-1,-2,-5,-3,-4,-5, 6,
-3,-2,-5,-7,-9,-2,-4,-6,-6, 1, 2, 0, 10,
-6,-7,-6,-10,-8,-9,-9,-7,-4, 0,-1,-9,-2, 8,
 0,-2,-3,-4,-5,-1,-3,-3,-2,-5,-5,-4,-5,-7, 7,
 1,-1, 1,-1,-1,-3,-2, 0,-3,-4,-6,-2,-3,-4, 0, 5,
 1,-4, 0,-2,-5,-3,-3,-3,-4,-1,-4,-1,-2,-6,-2, 2, 6,
-9, 0,-6,-10,-11,-8,-11,-10,-5,-9,-4,-7,-8,-2,-9,-3,-8, 13,
-5,-7,-3,-7,-2,-8,-6,-9,-1,-4,-4,-7,-7, 4,-9,-5,-4,-3, 9,
-1,-5,-5,-5,-4,-4,-4,-3,-4, 3, 0,-6, 0,-5,-3,-3,-1,-10,-5, 6,
-1,-4, 5, 5,-8,-1, 2,-1, 0,-4,-6,-1,-6,-7,-4, 0,-1,-7,-4,-5, 5,
-1,-2,-1, 2,-9, 5, 5,-3, 1,-4,-4,-2,-3,-9,-2,-2,-3,-10,-7,-4, 1, 5,
-2,-3,-2,-3,-6,-2,-3,-3,-3,-3,-4,-3,-3,-5,-3,-1,-2,-7,-5,-2,-2,-3,-3,
-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 80 substitution matrix, scale = 0.0693200
//
// Expected score = -12.6, Entropy = 1.44 bits
//
// Lowest score = -53, Highest score = 63
//
const char pam80_cdi_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam80_cdi[325] =  { 
 21,
-19, 37,
-6,-12, 27,
-6,-25, 13, 30,
-19,-26,-31,-43, 46,
-10, 1,-5, 0,-43, 34,
-3,-22, 1, 18,-43, 12, 30,
 1,-28,-5,-5,-29,-19,-9, 28,
-20, 2, 8,-6,-24, 12,-9,-25, 39,
-10,-16,-15,-22,-19,-22,-17,-29,-26, 34,
-18,-26,-23,-37,-47,-14,-29,-34,-18, 4, 30,
-18, 10, 2,-9,-44,-4,-10,-21,-14,-18,-25, 28,
-13,-9,-22,-30,-42,-9,-21,-26,-27, 5, 12, 0, 47,
-27,-31,-27,-45,-39,-39,-44,-31,-17,-1,-1,-43,-8, 41,
 1,-8,-14,-20,-24,-4,-14,-15,-9,-24,-22,-18,-23,-33, 35,
 5,-6, 5,-6,-5,-13,-9, 0,-14,-18,-25,-8,-15,-21, 1, 22,
 5,-16,-1,-10,-22,-14,-14,-12,-19,-3,-19,-6,-9,-26,-8, 8, 27,
-42, 1,-27,-49,-52,-39,-53,-49,-22,-42,-17,-33,-37,-10,-43,-15,-39, 63,
-25,-33,-13,-34,-8,-35,-29,-42,-6,-16,-19,-31,-30, 19,-41,-21,-20,-12, 45,
-2,-23,-21,-23,-17,-19,-18,-15,-19, 16, 0,-26, 3,-20,-15,-15,-4,-49,-23, 29,
-6,-17, 21, 24,-36,-2, 12,-5, 2,-18,-29,-3,-26,-34,-17, 0,-5,-35,-20,-22, 23,
-5,-7,-1, 12,-43, 25, 24,-12, 4,-19,-20,-7,-15,-42,-9,-10,-14,-45,-31,-19, 8, 25,
-6,-14,-7,-13,-27,-10,-11,-13,-12,-11,-16,-13,-12,-23,-12,-6,-7,-33,-22,-11,-10,-11,-13,
-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53,-53, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 80 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -2.55, Entropy = 1.44 bits
//
// Lowest score = -11, Highest score = 13
//
const char pam80_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam80[325] =  { 
 4,
-4, 7,
-1,-2, 5,
-1,-5, 3, 6,
-4,-5,-6,-9, 9,
-2, 0,-1, 0,-9, 7,
-1,-4, 0, 4,-9, 2, 6,
 0,-6,-1,-1,-6,-4,-2, 6,
-4, 0, 2,-1,-5, 2,-2,-5, 8,
-2,-3,-3,-4,-4,-4,-3,-6,-5, 7,
-4,-5,-5,-7,-9,-3,-6,-7,-4, 1, 6,
-4, 2, 0,-2,-9,-1,-2,-4,-3,-4,-5, 6,
-3,-2,-4,-6,-8,-2,-4,-5,-5, 1, 2, 0, 9,
-5,-6,-5,-9,-8,-8,-9,-6,-3, 0, 0,-9,-2, 8,
 0,-2,-3,-4,-5,-1,-3,-3,-2,-5,-4,-4,-5,-7, 7,
 1,-1, 1,-1,-1,-3,-2, 0,-3,-4,-5,-2,-3,-4, 0, 4,
 1,-3, 0,-2,-4,-3,-3,-2,-4,-1,-4,-1,-2,-5,-2, 2, 5,
-8, 0,-5,-10,-10,-8,-11,-10,-4,-8,-3,-7,-7,-2,-9,-3,-8, 13,
-5,-7,-3,-7,-2,-7,-6,-8,-1,-3,-4,-6,-6, 4,-8,-4,-4,-2, 9,
 0,-5,-4,-5,-3,-4,-4,-3,-4, 3, 0,-5, 1,-4,-3,-3,-1,-10,-5, 6,
-1,-3, 4, 5,-7, 0, 2,-1, 0,-4,-6,-1,-5,-7,-3, 0,-1,-7,-4,-4, 5,
-1,-1, 0, 2,-9, 5, 5,-2, 1,-4,-4,-1,-3,-8,-2,-2,-3,-9,-6,-4, 2, 5,
-1,-3,-1,-3,-5,-2,-2,-3,-2,-2,-3,-3,-2,-5,-2,-1,-1,-7,-4,-2,-2,-2,-3,
-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11, 1
};


//
// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
//
// PAM 90 substitution matrix, scale = ln(2)/2 = 0.346574
//
// Expected score = -2.26, Entropy = 1.30 bits
//
// Lowest score = -10, Highest score = 13
//
const char pam90_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int pam90[325] =  { 
 4,
-4, 7,
-1,-2, 5,
-1,-5, 3, 6,
-3,-5,-6,-8, 9,
-2, 0,-1, 0,-8, 6,
 0,-4, 0, 4,-8, 2, 6,
 0,-5,-1,-1,-5,-3,-1, 5,
-4, 1, 2,-1,-5, 2,-1,-5, 8,
-2,-3,-3,-4,-3,-4,-3,-5,-5, 6,
-3,-5,-4,-7,-9,-3,-5,-6,-3, 1, 6,
-3, 2, 1,-2,-8,-1,-2,-4,-2,-3,-5, 5,
-2,-2,-4,-5,-8,-2,-4,-5,-5, 1, 2, 0, 9,
-5,-6,-5,-8,-7,-7,-8,-6,-3, 0, 0,-8,-1, 8,
 0,-1,-2,-4,-5,-1,-2,-3,-2,-4,-4,-3,-4,-6, 7,
 1,-1, 1,-1,-1,-2,-2, 0,-3,-3,-5,-1,-3,-4, 0, 4,
 1,-3, 0,-2,-4,-3,-2,-2,-3, 0,-3,-1,-2,-5,-1, 2, 5,
-8, 0,-5,-9,-10,-7,-10,-9,-4,-8,-3,-6,-7,-2,-8,-3,-7, 13,
-5,-6,-2,-6,-1,-6,-6,-8,-1,-3,-3,-6,-6, 4,-8,-4,-4,-2, 9,
 0,-4,-4,-4,-3,-4,-3,-3,-4, 3, 0,-5, 1,-4,-3,-3,-1,-9,-4, 6,
-1,-3, 4, 5,-7, 0, 2,-1, 1,-3,-5, 0,-5,-6,-3, 0,-1,-7,-4,-4, 4,
-1,-1, 0, 3,-8, 5, 5,-2, 1,-3,-4,-1,-3,-8,-2,-2,-2,-8,-6,-3, 2, 5,
-1,-2,-1,-2,-5,-2,-2,-2,-2,-2,-3,-2,-2,-4,-2,-1,-1,-6,-4,-2,-2,-2,-2,
-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
};

const char oldpam250_Alphabet[25] = {"ARNDCQEGHILKMFPSTWYVBZX*"};
const int oldpam250[325] = {
2,
-2, 6, 
0 ,0, 2,
0,-1, 2, 4,
-2,-4,-4,-5, 12,
0 ,1, 1, 2,-5, 4 ,
0,-1, 1, 3,-5, 2, 4,
1,-3, 0, 1,-3,-1, 0, 5,
-1, 2, 2, 1,-3, 3, 1,-2, 6,
-1,-2,-2,-2,-2,-2,-2,-3,-2, 5,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
-1, 3, 1, 0,-5, 1, 0,-2, 0,-2,-3, 5,
-1, 0,-2,-3,-5,-1,-2,-3,-2, 2, 4, 0, 6,
-3,-4,-3,-6,-4,-5,-5,-5,-2, 1, 2,-5, 0, 9,
1 ,0, 0,-1,-3, 0,-1, 0, 0,-2,-3,-1,-2,-5, 6, 
1 ,0, 1, 0, 0,-1, 0, 1,-1,-1,-3, 0,-2,-3, 1, 2 ,
1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 3 ,
-6, 2,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 0,-6,-2,-5, 17,
-3,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-4,-2, 7,-5,-3,-3, 0, 10,
0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
2, 1, 4, 5,-3, 3, 4, 2, 3,-1,-2, 2,-1,-3, 1, 2, 2,-4,-2, 0, 6,
1, 2, 3, 4,-4, 5, 5, 1, 3,-1,-1, 2, 0,-4, 1, 1, 1,-4,-3, 0, 5, 6,
0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1, 0,-1,
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
};


}
