
/****************************************************************************** 
 * 
 *  file:  StringDiff.h
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#ifndef __STRINGDIFF_H
#define __STRINGDIFF_H

#include <string>
#include <iostream>
#include <map>
#include <vector>
#include <algorithm>
#include <cstring>
#include <Tostring.h>
#include "ListElement.h"

using namespace std;

namespace NOPT {

class StringDiff
{
	public:
		//
		// returns string of diff tokens that convert base to newString 
		//
		static string diff(const string& base, const string& newString);

		//
		// given the base string and the diffs, it creates the second
		// string, as if a patch was made. 
		//
		static string patch( const string& base, string& diffs );

	protected:
		static void _getLongestCommonSubsequence( const string& a, 
				                                  const string& b, 
			                                      map<int, int>& m );
		static int _replaceNextLarger( vector<int>& array, 
						               int& aValue, 
									   int& high );
};

}

#endif

