#include <signal.h>
#include <fcntl.h>
#include <stdio.h>

static void SigAlrmHandler(int);
static void SigTermHandler(int);

static char FileName[128];

main(void) 
{
    FILE *fp, *pp;
    char tmp_buff[1024];
    int parent_pid;
    char *PidFile;

    int  i, bytes;
    char *ContentGif  =  "Content-type: image/gif\r\n\r\n";
    char *ContentText =  "Content-type: text/html\r\n\r\n";
    
    
    signal(SIGALRM, SigAlrmHandler); 
    signal(SIGTERM, SigTermHandler);
    signal(SIGPIPE, SigTermHandler);
    
    PidFile = (char *) getenv("QUERY_STRING"); 
    
    sprintf(FileName, "TmpGifs/%s", PidFile);
    
    if((pp = fopen(FileName, "r")) == NULL) {

        /* Just do nothing */
        sprintf(tmp_buff, "HTTP/1.0 204 Not Modified\n");
        write(1, tmp_buff, strlen(tmp_buff));
        sprintf(tmp_buff, "Server: %s\n", getenv("SERVER_SOFTWARE"));
        write(1, tmp_buff, strlen(tmp_buff));
        sprintf(tmp_buff, "MIME-Version: 1.0\n");
        write(1, tmp_buff, strlen(tmp_buff));
        write(1, ContentGif, strlen(ContentGif)); 
    } else {
        sprintf(tmp_buff, "HTTP/1.0 200 OK\r\n");
        write(1, tmp_buff, strlen(tmp_buff));
        sprintf(tmp_buff, "Server: %s\n", getenv("SERVER_SOFTWARE"));
        write(1, tmp_buff, strlen(tmp_buff));
        sprintf(tmp_buff, "MIME-Version: 1.0\r\n");
        write(1, tmp_buff, strlen(tmp_buff));
        write(1, ContentGif, strlen(ContentGif)); 
        
        while ((bytes =fread(tmp_buff, 1, 256, pp)) >0)
            write(1, tmp_buff, bytes); 
    }
    remove(FileName); 
    return 0;
}
static void SigAlrmHandler(int id)
{
    
    char tmp_buff[1024];
    char *ContentGif  =  "Content-type: image/gif\r\n\r\n";
    
    sprintf(tmp_buff, "HTTP/1.0 204 Not Modified\n");
    write(1, tmp_buff, strlen(tmp_buff));
    sprintf(tmp_buff, "Server: %s\n", getenv("SERVER_SOFTWARE"));
    write(1, tmp_buff, strlen(tmp_buff));
    sprintf(tmp_buff, "MIME-Version: 1.0\n");
    write(1, tmp_buff, strlen(tmp_buff));
    write(1, ContentGif, strlen(ContentGif)); 
    remove(FileName); 
    exit(1);   
}

static void SigTermHandler(int id)
{
    remove(FileName); 
    exit(1);
}















