/* $Id: wblast2.c,v 6.16 2001/03/14 16:43:11 dondosha Exp $
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
* File Name:  $RCSfile: wblast2.c,v $
*
* Initial Creation Date: 10/23/2000
*
* $Revision: 6.16 $
*
* File Description:
*        BLAST 2 Sequences CGI program
*
* $Log: wblast2.c,v $
* Revision 6.16  2001/03/14 16:43:11  dondosha
* Minor correction
*
* Revision 6.15  2001/03/02 20:48:55  dondosha
* Cosmetic changes suggested by Roma Tatusov
*
* Revision 6.14  2001/02/26 21:32:09  dondosha
* Do not remove non-alphanumeric characters from sequence in FastaCheckDna
*
* Revision 6.13  2001/02/16 20:21:01  dondosha
* 1. Added a strand option menu
* 2. Fixed bug in sequence id manipulation
*
* Revision 6.12  2001/01/09 21:01:20  dondosha
* For megablast, subtract 4 from wordsize when displaying next page
*
* Revision 6.11  2001/01/04 18:28:28  dondosha
* For tblastx, split seqalign into a linked list of seqaligns
*
* Revision 6.10  2000/12/21 15:57:32  dondosha
* Test chptr for being NULL
*
* Revision 6.9  2000/12/07 17:58:04  dondosha
* Enabled Mega BLAST extension choice for blastn program
*
* Revision 6.8  2000/11/22 19:35:11  dondosha
* Minor fixes of purify errors and memory leaks
*
* Revision 6.7  2000/11/16 23:27:50  dondosha
* Minor corrections from 11/07/2000
*
* Revision 6.6  2000/11/03 22:20:42  shavirin
* Added return value from Main() function.
*
* Revision 6.5  2000/11/03 20:46:41  dondosha
* A few bug fixes
*
* Revision 6.4  2000/11/03 16:39:17  shavirin
* Added alternative formating for Standalone WWW Blast server.
*
* Revision 6.3  2000/11/02 21:45:41  dondosha
* Removed printing content from code - should be done in the cgi script
*
* Revision 6.2  2000/11/02 20:51:00  dondosha
* Significant clean up of the code
*
* Revision 6.1  2000/10/31 19:37:31  dondosha
* Changed revision to 6.1
*
* Revision 1.4  2000/10/31 19:33:49  dondosha
* Changed gif images paths to current directory
*
* Revision 1.2  2000/10/23 21:22:31  dondosha
* Turned on CVS logging
*
* Revision 6.1
* Source code for the Blast 2 Sequences Web page
*
* ==========================================================================
*/

#include <ncbi.h>
#include <tofasta.h>
#include <wwwblast.h>
#include <id1arch.h>
/* For rlimit stuff. */
#if defined(OS_UNIX) && !defined(OS_UNIX_SUN) && !defined(OS_UNIX_LINUX)
#include <sys/resource.h>
#include <signal.h>
#endif


#define MY_BLOSUM62 0
#define MY_PAM30 1
#define MY_PAM70 2
#define MY_PAM250 3
#define MY_BLOSUM90 4
#define MY_BLOSUM50 5

#define NR_SIZE_NA 2385885539
#define NR_SIZE_AA 181542687

typedef struct prym{
	Int2		len;
	Int2		color;
	CharPtr 	sym;
	Boolean		noleft, noright;
} Prym, PNTR PrymPtr;


static void JavaScriptFun()
{
   printf("<SCRIPT LANGUAGE=\"Javascript\">\n");
   
   printf("<!-- HIDE\n");
   printf("function chan(a)\n");
   printf("{\n");
   printf("	if (a.value == 'off') {\n");
   printf("		document.bl2.gopen.value=11;\n");
   printf("		document.bl2.gext.value=1;\n");
   printf("		document.bl2.match.value=\"\";\n");
   printf("		document.bl2.msmatch.value=\"\";\n");
   printf("		a.value = 'on';\n");
   printf("	} else {\n");
   printf("		document.bl2.gopen.value=5;\n");
   printf("		document.bl2.gext.value=2;\n");
   printf("		document.bl2.match.value=\"1\";\n");
   printf("		document.bl2.msmatch.value=\"-2\";\n");
   printf("		a.value = 'off';\n");
   printf("	}\n");
   printf("}\n");
   
   printf("function chan_prog(a)\n");
   printf("{\n");
   printf("	if (a.selectedIndex == 0) {\n");
   printf("		document.bl2.gopen.value = 5;\n");
   printf("		document.bl2.gext.value = 2;\n");
   printf("		document.bl2.match.value=1;\n");
   printf("		document.bl2.msmatch.value=\"-2\";\n");
   printf("		document.bl2.word.value=\"11\";\n");
   printf("             document.bl2.matrix.options.length = 1;\n");
   printf("             document.bl2.matrix.options[0].text='Not Applicable';\n");
   printf("             document.bl2.matrix.options[0].value=-1;\n");
   printf("             document.bl2.strand.options.length = 3;");
   printf("             document.bl2.strand.options[0].text='Both strands';");
   printf("             document.bl2.strand.options[0].value=3;");
   printf("             document.bl2.strand.options[1].text='Top strand';");
   printf("             document.bl2.strand.options[1].value=1;");
   printf("             document.bl2.strand.options[2].text='Reverse strand';");
   printf("             document.bl2.strand.options[2].value=2;");
   printf("	} else if (a.selectedIndex >= 1) {\n");
   printf("             document.bl2.matrix.options.length = 6;\n");
   printf("             document.bl2.matrix.options[0].text='BLOSUM62';\n");
   printf("             document.bl2.matrix.options[0].value=0;\n");
   printf("             document.bl2.matrix.options[1].text='PAM30';\n");
   printf("             document.bl2.matrix.options[1].value=1;\n");
   printf("             document.bl2.matrix.options[2].text='PAM70';\n");
   printf("             document.bl2.matrix.options[2].value=2;\n");
   printf("             document.bl2.matrix.options[3].text='PAM250';\n");
   printf("             document.bl2.matrix.options[3].value=3;\n");
   printf("             document.bl2.matrix.options[4].text='BLOSUM90';\n");
   printf("             document.bl2.matrix.options[4].value=4;\n");
   printf("             document.bl2.matrix.options[5].text='BLOSUM50';\n");
   printf("             document.bl2.matrix.options[5].value=5;\n");
   printf("		document.bl2.word.value=\"3\";\n");
   printf("		if (document.bl2.matrix.selectedIndex == 1) {\n");
   printf("			document.bl2.gopen.value = 9;\n");
   printf("			document.bl2.gext.value = 1;\n");
   printf("		} else if (document.bl2.matrix.selectedIndex == 2) {\n");
   printf("			document.bl2.gopen.value = 10;\n");
   printf("			document.bl2.gext.value = 1;\n");
   printf("		} else if (document.bl2.matrix.selectedIndex == 3) {\n");
   printf("			document.bl2.gopen.value = 14;\n");
   printf("			document.bl2.gext.value = 2;\n");
   printf("		} else if (document.bl2.matrix.selectedIndex == 4) {\n");
   printf("			document.bl2.gopen.value =10;\n");
   printf("			document.bl2.gext.value = 1;\n");
   printf("		} else if (document.bl2.matrix.selectedIndex == 5) {\n");
   printf("			document.bl2.gopen.value = 13;\n");
   printf("			document.bl2.gext.value = 2;\n");
   printf("		} else {\n");
   printf("			document.bl2.gopen.value = 11;\n");
   printf("			document.bl2.gext.value = 1;\n");
   printf("		}\n"); 
   printf("		document.bl2.match.value=\"\";\n");
   printf("		document.bl2.msmatch.value=\"\";\n");
   printf("		document.bl2.megablast.checked = 0;\n");
   printf("             document.bl2.strand.options.length = 1;");
   printf("             document.bl2.strand.options[0].text='Not Applicable';");
   printf("             document.bl2.strand.options[0].value=0;");
   printf("	}\n");
   printf("}\n");
   
   printf("function update_mtrx(a)\n");
   printf("{\n");
   printf("	if (document.bl2.program.selectedIndex == 0) {\n");
   printf("		return;\n");
   printf("	}\n");
   printf("	if (a.selectedIndex == 0) {\n");
   printf("		document.bl2.gopen.value = 11;\n");
   printf("		document.bl2.gext.value = 1;\n");
   printf("	} else if (a.selectedIndex == 1) {\n");
   printf("		document.bl2.gopen.value = 9;\n");
   printf("		document.bl2.gext.value = 1;\n");
   printf("	} else if (a.selectedIndex == 2) {\n");
   printf("		document.bl2.gopen.value = 10;\n");
   printf("		document.bl2.gext.value = 1;\n");
   printf("	} else if (a.selectedIndex == 3) {\n");
   printf("		document.bl2.gopen.value = 14;\n");
   printf("		document.bl2.gext.value = 2;\n");
   printf("	} else if (a.selectedIndex == 4) {\n");
   printf("		document.bl2.gopen.value = 10;\n");
   printf("		document.bl2.gext.value = 1;\n");
   printf("	} else if (a.selectedIndex == 5) {\n");
   printf("		document.bl2.gopen.value = 13;\n");
   printf("		document.bl2.gext.value = 2;\n");
   printf("	}\n");
   printf("}\n");

   /* Function clear_sequence() */
   printf("function clear_sequence() {\n");
   printf("    document.bl2.seqfile1.value=''\n");
   printf("    document.bl2.seqfile2.value=''\n");
   printf("    document.bl2.sseq.value=''\n");
   printf("    document.bl2.seq.value=''\n");
   printf("    document.bl2.one.value=''\n");
   printf("    document.bl2.two.value=''\n");
   printf("    document.bl2.to.value=''\n");
   printf("    document.bl2.tto.value=''\n");
   printf("    document.bl2.from.value=''\n");
   printf("    document.bl2.ffrom.value=''\n");
   printf("    document.bl2.seq.focus()\n");
   printf("}\n");
   
   /* Function megablast_update(a) */
   printf("function megablast_update(a)\n");
   printf("{\n");
   printf("	if (a.checked == 0) {\n");
   printf("         document.bl2.word.value = 11;\n");
   printf("         document.bl2.gopen.value = 5;\n");
   printf("         document.bl2.gext.value = 2;\n");
   printf("	} else {\n");
   printf("         if (document.bl2.program.selectedIndex != 0) {");
   printf("            document.bl2.program.selectedIndex = 0;");     
   printf("            chan_prog(document.bl2.program);");
   printf("         }");
   printf("         document.bl2.word.value = 28;\n");
   printf("         document.bl2.gopen.value = \"\";\n");
   printf("         document.bl2.gext.value = \"\";\n");
   printf("     }\n");
   printf("}\n");

   printf("// -->\n");
    
   printf("</SCRIPT>\n");
   return;
}

static SeqAnnotPtr tie_next_annot(SeqAnnotPtr head, SeqAnnotPtr next)
{
   SeqAnnotPtr v;
   
   if (head == NULL) {
      return next;
   }
   for (v = head; v->next != NULL; v = v->next) {
      v = v;
   }
   v->next = next;
   return head;
}

static void AbortPage(CharPtr mess)
{
   printf("<TITLE>ERROR</TITLE>\n");
   printf("<h2>\n");
   printf("<img src='images/confused.gif' align=middle>\n");
   printf("%s</h2>\n", mess);
   exit(1);
}

static void TimeExpired(Int4 i)
{
   printf("<HTML>\n<HEAD>\n<TITLE>\nTime Expired\n</TITLE>\n</HEAD>\n");
   printf("<BODY>\n<H1>\nTime expired\n</H1>\n<HR>\n</BODY>\n</HTML>\n");
   exit(0);
}

#ifdef BL2SEQ_STANDALONE
static void	Blast2SeqMainPage(CharPtr warning, CharPtr seq1, CharPtr seq2, CharPtr one, CharPtr two, ValNodePtr error, Boolean is_prot, BLAST_OptionsBlkPtr options, Int2 mtrx, Int4 from, Int4 to, Int4 ffrom, Int4 tto, Int2 filter, Int2 pagecount) {
/*****************************************************************
	0 - no sequences
	1 - nucleotide sequences in protein alignment
	2 - non-nucleotide sequences in nucleotide alignment
	4 - BLAST Options error mesg handling
	5 - invalid location
	6 - No alignment found
*****************************************************************/
    ValNodePtr vnp;
    BlastErrorMsgPtr error_msg;
    Int4Ptr dgopen=NULL, dgext=NULL;
    Int4 gopen=0, gext=0;
    Uint1 prog_number;
    
    if (options)
        prog_number = BlastGetProgramNumber(options->program_name);
    else 
        prog_number = 1;
    
    switch (mtrx) {
    case MY_PAM30:
        BlastKarlinGetMatrixValues("PAM30", 
                                   &dgopen, &dgext, NULL, NULL, NULL, NULL);
        gopen  = 9;
        gext  = 1;
        break;
    case MY_PAM70:
        BlastKarlinGetMatrixValues("MY_PAM70", 
                                   &dgopen, &dgext, NULL, NULL, NULL, NULL);
        gopen  = 10;
        gext  = 1;
        break;
    case MY_PAM250:
        BlastKarlinGetMatrixValues("MY_PAM250", 
                                   &dgopen, &dgext, NULL, NULL, NULL, NULL);
        gopen  = 14;
        gext  = 2;
        break;
    case MY_BLOSUM90:
        BlastKarlinGetMatrixValues("MY_BLOSUM90", 
                                   &dgopen, &dgext, NULL, NULL, NULL, NULL);
        gopen  = 10;
        gext  = 1;
        break;
    case MY_BLOSUM50:
        BlastKarlinGetMatrixValues("MY_BLOSUM50", 
                                   &dgopen, &dgext, NULL, NULL, NULL, NULL);
        gopen  = 13;
        gext  = 2;
        break;
    case MY_BLOSUM62:
    default:
        BlastKarlinGetMatrixValues("MY_BLOSUM62", 
                                   &dgopen, &dgext, NULL, NULL, NULL, NULL);
        gopen  = 11;
        gext  = 1;
        break;
    }

    printf("<HTML>\n");
    printf("<HEAD>\n");
    printf("<title>BLAST 2 Sequences</title>\n");
    printf("<META NAME=\"keywords\" CONTENT=\"NCBI, BLAST, ORF, Bioinformatics\">\n");
    JavaScriptFun();
    printf("</HEAD>\n");

    printf("<BODY BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" "
           "VLINK=\"#660099\" ALINK=\"#660099\">\n");
    
    printf("<A HREF=\"blast_form.map\">"
           "<IMG SRC=\"images/bl2seq.gif\" BORDER=0 ISMAP></A>\n");
    
    printf("<FORM NAME=\"bl2\" method=\"POST\" "

#ifdef NCBI_ENTREZ_CLIENT
           "action=\"wblast2_cs.cgi?%d\" "
#else
           "action=\"wblast2.cgi?%d\" "
#endif
           "enctype=\"multipart/form-data\">\n", pagecount);
    
    if (warning) {
        printf("<h3><font color=#EE0000>WARNING:</font><font color=#0000EE> %s</font></h3>", warning);
    } else {
        for (vnp=error; vnp; vnp=vnp->next) {
            error_msg = vnp->data.ptrvalue;
            printf("<h3><font color=#EE0000>WARNING:</font><font color=#0000EE> %s</font></h3>", error_msg->msg);
        }
    }
    
    if (!options) {
        printf("This tool produces the alignment of two given sequences "
               "using BLAST<BR>engine for local alignment.<P>\n");
    }
    
    printf("<A HREF=\"docs/blast_program.html\">Program</A>\n");
    printf("<select name=\"program\" onChange=\"chan_prog(this)\">\n");
    printf("<option%s> blastn\n", (prog_number == blast_type_blastn) ? " SELECTED" : "");
    printf("<option%s> blastp\n", (prog_number == blast_type_blastp) ? " SELECTED" : "");
#if 1
    printf("<option%s> tblastn\n", (prog_number == blast_type_tblastn) ? " SELECTED" : "");
    printf("<option%s> blastx\n", (prog_number == blast_type_blastx) ? " SELECTED" : "");
    printf("<option%s> tblastx\n", (prog_number == blast_type_tblastx) ? " SELECTED" : "");
#endif
    printf("</select>\n");

    printf("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n"
           "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n"
           "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n"
           "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n");
    
    printf("<INPUT TYPE=\"submit\" VALUE=\"Align\">\n");
    printf("<INPUT TYPE=\"button\" VALUE=\"Clear sequence\" "
           "onClick=\"clear_sequence()\">\n");
    
    printf("<HR>\n");

    /* ------------- Input for the first sequence ---------------- */
    
    printf("<font color=ff0000>Sequence 1: </font>&nbsp;&nbsp;&nbsp;&nbsp;\n"
           "from: <INPUT type=text size=8 name=\"from\" value = %d> \n"
           "&nbsp;&nbsp; "
           "to: <INPUT type=text size=8 name=\"to\" value = %d>\n", from, to);
    printf("<BR>\n");
    
#ifdef NCBI_ENTREZ_CLIENT
    printf("Enter accession or GI <INPUT type=text size=8 name=\"one\" ");
    
    if (one) {
        printf("value=%s>\n", one);
    } else {
        printf(">\n");
    }
    printf(" or sequence in FASTA format\n");
#else
    printf("Enter sequence in FASTA format\n"); 
#endif
    
    printf("<textarea name=\"seq\" rows=6 cols=60>");
    if (seq1) {
        if (*seq1 == '>') {
            printf("&gt;");
            seq1++;
        }
        printf("%s</textarea>\n", seq1);
    } else {
        printf("</textarea>\n");
    }
    printf("<BR>\n");
    
    printf("or download from file <INPUT type=file name=\"seqfile1\">\n");
    printf("<P><HR>\n");

    /* ------------- Input for the second sequence ---------------- */

    printf("<font color=ff0000>Sequence 2: </font>&nbsp;&nbsp;&nbsp;&nbsp;\n"
           "from: <INPUT type=text size=8 name=\"ffrom\" value = %d> \n"
           "&nbsp;&nbsp; "
           "to: <INPUT type=text size=8 name=\"tto\" value = %d>\n", 
           ffrom, tto);
    printf("<BR>\n");
    
#ifdef NCBI_ENTREZ_CLIENT
    printf("Enter accession or GI <INPUT type=text size=8 name=\"two\" ");
    
    if (two) {
        printf("value=%s>\n", two);
    } else {
        printf(">\n");
    }
    printf(" or sequence in FASTA format\n");
#else
    printf("Enter sequence in FASTA format\n"); 
#endif

    printf("<textarea name=\"sseq\" rows=6 cols=60>");
    if (seq2) {
        if (*seq2 == '>') {
            printf("&gt;");
            seq2++;
        }
        printf("%s</textarea>\n", seq2);
    } else {
        printf("</textarea>\n");
    }
    
    printf("<BR>\n");

    printf("or download from file <INPUT type=file name=\"seqfile2\">\n");
    printf("<P><HR>\n");

    /* -------------------------------------------------- */

    printf("Parameters used in <A HREF=docs/full_options.html#blastn> "
           "BLASTN </A>program only:<BR>\n");
    
    printf("<strong>Match:</strong><INPUT type=text size=8 "
           "name=\"match\"%s>", (is_prot == FALSE) ? " value=1" : "");
    
    printf("<strong>Mismatch:</strong><INPUT type=text size=8 "
           "name=\"msmatch\"%s>", (is_prot == FALSE) ? " value=-2" : "");
    
    printf("<HR>\n");
    
    printf("<A HREF=docs/options.html#matrix>Matrix</A>\n");
    printf("<select name=\"matrix\" onChange=\"update_mtrx(this)\">\n");
    if (prog_number != blast_type_blastn) {
        printf("<option>0 BLOSUM62\n");
        printf("<option%s>1 PAM30\n", (mtrx == 1) ? " SELECTED" : "");
        printf("<option%s>2 PAM70\n", (mtrx == 2) ? " SELECTED" : "");
        printf("<option%s>3 PAM250\n", (mtrx == 3) ? " SELECTED" : "");
        printf("<option%s>4 BLOSUM90\n", (mtrx == 4) ? " SELECTED" : "");
        printf("<option%s>5 BLOSUM50\n", (mtrx == 5) ? " SELECTED" : "");
    } else 
        printf("<option> Not Applicable\n");
    printf("</select>\n");
    
    if (options) {

        printf("Open gap\n");
        printf("<INPUT type=text size=4 name=\"gopen\" value=%d>\n", 
               options->gap_open);
        printf("and extension gap\n");
        printf("<INPUT type=text size=4 name=\"gext\" value=%d> penalties<BR>\n", options->gap_extend);
        printf("gap x_dropoff\n");
        printf("<INPUT type=text size=4 name=\"dropoff\" value=%d>\n", options->gap_x_dropoff);
        printf(" expect\n");
        printf("<INPUT type=text size=4 name=\"expect\" value=%f>\n", options->expect_value);
        printf(" word size\n");
        if (options->is_megablast_search)
           printf("<INPUT type=text size=4 name=\"word\" value=%d>\n",
                  options->wordsize - 4);
        else
           printf("<INPUT type=text size=4 name=\"word\" value=%d>\n",
                  options->wordsize);
    } else {

        printf("Open gap\n");
        printf("<INPUT type=text size=4 name=\"gopen\" value=5>\n");
        printf("and extension gap\n");
        printf("<INPUT type=text size=4 name=\"gext\" value=2> penalties<BR>\n");
        printf("gap x_dropoff\n");
        printf("<INPUT type=text size=4 name=\"dropoff\" value=15>\n");
        printf(" expect\n");
        printf("<INPUT type=text size=4 name=\"expect\" value=10.0>\n");
        printf(" word size\n");
        printf("<INPUT type=text size=4 name=\"word\" value=11>\n");
    }
    printf("<a href=docs/newoptions.html#filter>Filter</a>\n");
    printf("<INPUT TYPE=checkbox NAME=Filter VALUE=%d", filter);
    if (filter == 1) {
        printf(" CHECKED>\n");
    } else {
        printf(">\n");
    }

    printf("<P>\n");

    printf("<INPUT TYPE=\"submit\" VALUE=\"Align\">\n");
    printf("<INPUT TYPE=\"reset\" VALUE=\"Reset form\">\n");
    printf("<INPUT TYPE=\"button\" VALUE=\"Clear sequence\" "
           "onClick=\"clear_sequence()\">\n");

    printf("<INPUT TYPE=hidden name=\"page\" value=\"%d\">\n", pagecount+1);
    if (options)
        printf("<INPUT TYPE=hidden name=\"program\" value=\"%s\">\n",
               options->program_name);
    else
        printf("<INPUT TYPE=hidden name=\"program\" value=\"blastn\">\n");
    
    printf("</form>\n");
    printf("<HR>\n");
    printf("<ADDRESS> Comments and suggestions to");
    printf(" <A HREF=\"mailto:blast-help@ncbi.nlm.nih.gov\">"
           "blast-help@ncbi.nlm.nih.gov</A>\n");
    printf("<BR>\n");
    printf("</body>\n");
    printf("</html>\n");
    fflush(stdout);
    exit (0);
}

static void CreateJavaHeadHTML(BioseqPtr query_bsp, BioseqPtr subject_bsp, Int4 from, Int4 to, Int4 ffrom, Int4 tto, Int4 len1, Int4 len2, CharPtr progname)
{
    static Char buf[41], tmp[128];
    ValNodePtr vnp;
    
    printf("<HTML>\n");
    printf("<HEAD>\n");
    printf("<title>Blast 2 sequences result</title>\n\n");
    printf("<META NAME=\"keywords\" CONTENT=\"NCBI, BLAST, ORF, Bioinformatics\">\n");
    
    JavaScriptFun();
    printf("</HEAD>\n");
    
    printf("<BODY BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" "
           "VLINK=\"#660099\" ALINK=\"#660099\">\n");
    
    printf("<A HREF=\"blast_form.map\">"
           "<IMG SRC=\"images/bl2seq.gif\" BORDER=0 ISMAP></A>\n");    
    
    printf("<P><PRE>\n");
    BlastPrintVersionInfo(progname, TRUE, stdout);
    printf("</PRE>\n");

    fflush(stdout);

    return;
}

#else /* --- BL2SEQ_STANDALONE --- */

static void	Blast2SeqMainPage(CharPtr warning, CharPtr seq1, CharPtr seq2, CharPtr one, CharPtr two, ValNodePtr error, Boolean is_prot, BLAST_OptionsBlkPtr options, Int2 mtrx, Int4 from, Int4 to, Int4 ffrom, Int4 tto, Int2 filter, Int2 pagecount) {
/*****************************************************************
	0 - no sequences
	1 - nucleotide sequences in protein alignment
	2 - non-nucleotide sequences in nucleotide alignment
	4 - BLAST Otions error mesg handling
	5 - invalid location
	6 - No alignment found
*****************************************************************/
	ValNodePtr vnp;
	BlastErrorMsgPtr error_msg;
	Int4Ptr dgopen=NULL, dgext=NULL;
	Int4 gopen=0, gext=0;
        Uint1 prog_number;

        if (options)
           prog_number = BlastGetProgramNumber(options->program_name);
        else 
           prog_number = 1;

	switch (mtrx)
	{
		case MY_PAM30:
			BlastKarlinGetMatrixValues("PAM30", 
						&dgopen, &dgext, NULL, NULL, NULL, NULL);
			gopen  = 9;
			gext  = 1;
			break;
		case MY_PAM70:
			BlastKarlinGetMatrixValues("MY_PAM70", 
						&dgopen, &dgext, NULL, NULL, NULL, NULL);
			gopen  = 10;
			gext  = 1;
			break;
		case MY_PAM250:
			BlastKarlinGetMatrixValues("MY_PAM250", 
						&dgopen, &dgext, NULL, NULL, NULL, NULL);
			gopen  = 14;
			gext  = 2;
			break;
		case MY_BLOSUM90:
			BlastKarlinGetMatrixValues("MY_BLOSUM90", 
						&dgopen, &dgext, NULL, NULL, NULL, NULL);
			gopen  = 10;
			gext  = 1;
			break;
		case MY_BLOSUM50:
			BlastKarlinGetMatrixValues("MY_BLOSUM50", 
						&dgopen, &dgext, NULL, NULL, NULL, NULL);
			gopen  = 13;
			gext  = 2;
			break;
		case MY_BLOSUM62:
		default:
			BlastKarlinGetMatrixValues("MY_BLOSUM62", 
						&dgopen, &dgext, NULL, NULL, NULL, NULL);
			gopen  = 11;
			gext  = 1;
			break;
	}
	printf("<html>\n");
	printf("<head>\n");
	printf("<title>Blast 2 Sequences</title>\n");
        printf("<META NAME=\"keywords\" CONTENT=\"NCBI, BLAST, ORF, Bioinformatics\">\n");
        printf("<link rel=\"stylesheet\" href=\"http://www.ncbi.nlm.nih.gov/ncbi.css\">\n");

	JavaScriptFun();
	printf("</HEAD>\n");

	printf("<body bgcolor=\"#f0f0fe\">\n");
#if 1
        if (options) {
        printf("<table border=0 width=600 cellspacing=0 cellpadding=0>\n");
        printf("<tr valign=center> \n");
        printf("<td width=140><A HREF=\"http://www.ncbi.nlm.nih.gov\"><img src=\"http://www.ncbi.nlm.nih.gov/corehtml/left.GIF\" width=130 height=45 border=0 ALT=\"NCBI logo\"></A></td>\n");
        printf("<td width=460 ><h1>Blast 2 Sequences</h1></td>\n");
        printf("</tr>\n");
        printf("</table>\n");
        
        printf("<!--  the quicklinks bar--> \n");
        printf("<table border=0 width=600 cellspacing=0 cellpadding=1 bgcolor=#003366>\n");
        printf("<tr align=\"center\">\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=PubMed\" class=\"BAR\"><FONT COLOR=#FFFFFF>PubMed</FONT></a></td>\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/Entrez/\" class=\"BAR\"><FONT COLOR=#FFFFFF>Entrez</FONT></a></td>\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/blast/\" class=\"BAR\"><FONT COLOR=#FFFFFF>BLAST</FONT></a></td>\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/omim/\" class=\"BAR\"><FONT COLOR=#FFFFFF>OMIM</FONT></a></td>\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/Taxonomy/taxonomyhome.html\" class=\"BAR\"><FONT COLOR=#FFFFFF>Taxonomy</FONT></a></td>\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/Structure/\" class=\"BAR\"><FONT COLOR=#FFFFFF>Structure</FONT></a></td>\n");
        printf("</tr></table>\n");
        } else {
#endif
        printf("<CENTER><TABLE CELLSPACING=2 CELLPADDING=2 WIDTH=100%%>\n");
        printf("<TR ALIGN=CENTER BaGCOLOR=#8dc7cc BGCOLOR=#0000ff><TD><B><I>\n");
        printf("<A HREF=http://www.ncbi.nlm.nih.gov/><font color=#ffffff>NCBI</font></A></I></B></TD>\n");
        printf("<TD><B><I>\n");
        printf("<A HREF=http://www.ncbi.nlm.nih.gov/Entrez><font color=#ffffff>Entrez</font></A>\n");
        printf("</I></B></TD>\n");
        printf("<TD><B><I><A HREF=bl2.html><font color=#ffffff>BLAST 2 sequences</font></A></I></B></TD>\n");
        printf("<TD><B><I><A HREF=http://www.ncbi.nlm.nih.gov/blast><font color=#ffffff>BLAST</font></A></I></B></TD>\n");
        printf("<TD><B><I><A HREF=bl2_seg.html><font color=#ffffff>Example</font></A></I></B></TD>\n");
        printf("<TD><B><I>\n");
        printf("<A HREF=http://www.ncbi.nlm.nih.gov/blast/blast_help.html><font color=#ffffff>Help</font></A>\n");
        printf("</I></B></TD></TR></TABLE></CENTER>\n");
#if 1
        }
#endif
        printf("<FORM NAME=\"bl2\" method=\"Post\" action=\"wblast2.cgi?%d\" enctype=\"multipart/form-data\">\n", pagecount);
        if (warning)
           printf("<h3><font color=#EE0000>WARNING:</font><font color=#0000EE> %s</font></h3>", warning);
        else {
           for (vnp=error; vnp; vnp=vnp->next) {
              error_msg = vnp->data.ptrvalue;
              printf("<h3><font color=#EE0000>WARNING:</font><font color=#0000EE> %s</font></h3>", error_msg->msg);
           }
        }
        if (!options) {
        printf("This tool produces the alignment of two given sequences using <A HREF=http://www.ncbi.nlm.nih.gov/blast/newblast.html TARGET=one>BLAST</A> engine for local alignment. <BR>The stand-alone executable for blasting two sequences (bl2seq) can be retrieved from <A HREF=ftp://ncbi.nlm.nih.gov/blast/temp/bl2seq.irix6> NCBI ftp site</A><br><b><A HREF=http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?uid=10339815&form=6&db=m&Dopt=b>Reference:</A></b> Tatiana A. Tatusova, Thomas L. Madden (1999), \"Blast 2 sequences - a new tool for comparing protein and nucleotide sequences\", FEMS Microbiol Lett. 174:247-250 \
<br><BR>");
        }
        printf("<A HREF=http://www.ncbi.nlm.nih.gov/blast/blast_program.html TARGET=one>Program</A>\n");
        printf("<select name=\"program\" onChange=\"chan_prog(this)\">\n");
        printf("<option%s> blastn\n", (prog_number == blast_type_blastn) ? " SELECTED" : "");
        printf("<option%s> blastp\n", (prog_number == blast_type_blastp) ? " SELECTED" : "");
#if 1
        printf("<option%s> tblastn\n", (prog_number == blast_type_tblastn) ? " SELECTED" : "");
        printf("<option%s> blastx\n", (prog_number == blast_type_blastx) ? " SELECTED" : "");
        printf("<option%s> tblastx\n", (prog_number == blast_type_tblastx) ? " SELECTED" : "");
#endif
        printf("</select>\n");
        printf("<A HREF=http://www.ncbi.nlm.nih.gov/blast/options.html#matrix TARGET=one>Matrix</A>\n");
        printf("<select name=\"matrix\" onChange=\"update_mtrx(this)\">\n");
        if (prog_number != blast_type_blastn) {
           printf("<option value=0>BLOSUM62\n");
           printf("<option value=1%s>PAM30\n", (mtrx == 1) ? " SELECTED" : "");
           printf("<option value=2%s>PAM70\n", (mtrx == 2) ? " SELECTED" : "");
           printf("<option value=3%s>PAM250\n", (mtrx == 3) ? " SELECTED" : "");
           printf("<option value=4%s>BLOSUM90\n", (mtrx == 4) ? " SELECTED" : "");
           printf("<option value=5%s>BLOSUM50\n", (mtrx == 5) ? " SELECTED" : "");
        } else 
           printf("<option> Not Applicable\n");
        printf("</select>\n");

        printf("<BR>\n");
        
        if (options) {
            printf("<strong>Match:</strong><INPUT type=text size=8 name=\"match\"%s>", 
                   (is_prot == FALSE) ? " value=1" : "");
            printf("<strong>Mismatch:</strong><INPUT type=text size=8 name=\"msmatch\"%s>",
                   (is_prot == FALSE) ? " value=-2" : "");
            printf("<BR>\n");
            printf("Open gap\n");
            printf("<INPUT type=text size=4 name=\"gopen\" value=%d>\n", 
                   options->gap_open);
            printf("and extension gap\n");
            printf("<INPUT type=text size=4 name=\"gext\" value=%d> penalties<BR>\n", options->gap_extend);
            printf("gap x_dropoff\n");
            printf("<INPUT type=text size=4 name=\"dropoff\" value=%d>\n", options->gap_x_dropoff);
            printf(" expect\n");
            printf("<INPUT type=text size=4 name=\"expect\" value=%f>\n", options->expect_value);
            printf(" word size\n");
            if (options->is_megablast_search)
               printf("<INPUT type=text size=4 name=\"word\" value=%d>\n",
                      options->wordsize - 4);
            else
               printf("<INPUT type=text size=4 name=\"word\" value=%d>\n",
                      options->wordsize);
        } else {
            printf("<strong>Reward for a match:</strong><INPUT type=text size=8 name=\"match\"%s>", 
                   (is_prot == FALSE) ? " value=1" : "");
            printf("<strong>Penalty for a mismatch:</strong><INPUT type=text size=8 name=\"msmatch\"%s>",
                   (is_prot == FALSE) ? " value=-2" : "");
            printf("<BR><BR>\n");
            printf("<INPUT type=checkbox NAME=megablast onClick=\"megablast_update(this)\"> Use <a href=\"megablast.html\">Mega BLAST</a>&nbsp;&nbsp;&nbsp;");
            printf("Search <select name=\"strand\">\n");
            printf("<option value=3 SELECTED> Both strands\n");
            printf("<option value=1> Forward strand\n");
            printf("<option value=2> Reverse strand\n");
            printf("</select><HR>\n");

            printf("Open gap\n");
            printf("<INPUT type=text size=4 name=\"gopen\" value=5>\n");
            printf("and extension gap\n");
            printf("<INPUT type=text size=4 name=\"gext\" value=2> penalties<BR>\n");
            printf("gap x_dropoff\n");
            printf("<INPUT type=text size=4 name=\"dropoff\" value=15>\n");
            printf(" expect\n");
            printf("<INPUT type=text size=4 name=\"expect\" value=10.0>\n");
            printf(" word size\n");
            printf("<INPUT type=text size=4 name=\"word\" value=11>\n");
        }
        printf("<a href=/blast/newoptions.html#filter>Filter</a>\n");
        printf("<INPUT TYPE=checkbox NAME=Filter VALUE=%d", filter);
        if (filter == 1) {
           printf(" CHECKED>\n");
        } else {
           printf(">\n");
        }
          printf("<INPUT TYPE=\"submit\" VALUE=\"Align\">\n");
        if (options)
          printf("<INPUT TYPE=\"reset\" VALUE=\"Clear Input\">\n");
        
        printf("<HR>\n");
#ifdef NCBI_ENTREZ_CLIENT
        printf("<font color=ff0000>Sequence 1</font> Enter accession or GI <INPUT type=text size=8 name=\"one\"");
        if (one) {
           printf("value=%s>\n", one);
        } else {
           printf(">\n");
        }
        printf("or download from file <INPUT type=file name=\"seqfile1\">");
#else
        printf("Download sequence from file <INPUT type=file name=\"seqfile1\">");
#endif

        printf("<BR>or sequence in FASTA format <font color=ff0000>from:<INPUT type=text size=8 name=\"from\" value=%d>to:<INPUT type=text size=8 name=\"to\" value=%d></font><BR>\n", from, to);
        
        printf("<textarea name=\"seq\" rows=6 cols=60>");
        if (seq1) {
           if (*seq1 == '>') {
              printf("&gt;");
              seq1++;
           }
           printf("%s</textarea>\n", seq1);
        } else {
           printf("</textarea>\n");
        }
        printf("<BR>\n");
#ifdef NCBI_ENTREZ_CLIENT
        printf("<font color=ff0000>Sequence 2</font> Enter accession or GI <INPUT type=text size=8 name=\"two\"");
        if (two) {
           printf("value=%s>\n", two);
        } else {
           printf(">\n");
        }
        printf("or download from file <INPUT type=file name=\"seqfile2\">");
#else
        printf("Download sequence from file <INPUT type=file name=\"seqfile2\">");
#endif

        printf("<BR>or sequence in FASTA format <font color=ff0000>from:<INPUT type=text size=8 name=\"ffrom\" value=%d>to:<INPUT type=text size=8 name=\"tto\" value=%d></font><BR>\n", ffrom, tto);
        printf("<textarea name=\"sseq\" rows=6 cols=60>");
        if (seq2) {
           if (*seq2 == '>') {
              printf("&gt;");
              seq2++;
           }
           printf("%s</textarea>\n", seq2);
        } else {
           printf("</textarea>\n");
        }

        printf("<BR>\n");
        printf("<INPUT TYPE=\"submit\" VALUE=\"Align\">\n");
        printf("<INPUT TYPE=\"reset\" VALUE=\"Clear Input\">\n");
        printf("<INPUT TYPE=hidden name=\"page\" value=\"%d\">\n", pagecount+1);
        if (options)
            printf("<INPUT TYPE=hidden name=\"program\" value=\"%s\">\n",
                   options->program_name);
        else
            printf("<INPUT TYPE=hidden name=\"program\" value=\"blastn\">\n");
	
        printf("</form>\n");
        printf("<HR>\n");
        printf("<ADDRESS> Comments and suggestions to");
        printf(" <A HREF=\"mailto:blast-help@ncbi.nlm.nih.gov\">blast-help@ncbi.nlm.nih.gov</A>\n");
        printf("<BR>\n");
        printf("</body>\n");
        printf("</html>\n");
        fflush(stdout);

        options = BLASTOptionDelete(options);

        exit (0);
}

static void CreateJavaHeadHTML(BioseqPtr query_bsp, BioseqPtr subject_bsp, Int4 from, Int4 to, Int4 ffrom, Int4 tto, Int4 len1, Int4 len2, CharPtr progname)
{
	static Char buf[41], tmp[128];
	ValNodePtr vnp;
		
	printf("<HTML>\n");
	printf("<head>\n");
	printf("<title>Blast Result</title>\n\n");
        printf("<META NAME=\"keywords\" CONTENT=\"NCBI, BLAST, ORF, Bioinformatics\">\n");
        printf("<link rel=\"stylesheet\" href=\"http://www.ncbi.nlm.nih.gov/ncbi.css\">\n");
	JavaScriptFun();
	printf("</head>\n");
	printf("<BODY bgcolor=\"#f0f0fe\">\n");
#if 1
        printf("<table border=0 width=600 cellspacing=0 cellpadding=0>\n");
        printf("<tr valign=center> \n");
        printf("<td width=140><A HREF=\"http://www.ncbi.nlm.nih.gov\"><img src=\"http://www.ncbi.nlm.nih.gov/corehtml/left.GIF\" width=130 height=45 border=0 ALT=\"NCBI logo\"></A></td>\n");
        printf("<td width=460 ><h1>Blast 2 Sequences results</h1></td>\n");
        printf("</tr>\n");
        printf("</table>\n");
        printf("<!--  the quicklinks bar--> \n");
        printf("<table border=0 width=600 cellspacing=0 cellpadding=1 bgcolor=#003366>\n");
        printf("<tr align=\"center\">\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=PubMed\" class=\"BAR\"><FONT COLOR=#FFFFFF>PubMed</FONT></a></td>\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/Entrez/\" class=\"BAR\"><FONT COLOR=#FFFFFF>Entrez</FONT></a></td>\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/blast/\" class=\"BAR\"><FONT COLOR=#FFFFFF>BLAST</FONT></a></td>\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/omim/\" class=\"BAR\"><FONT COLOR=#FFFFFF>OMIM</FONT></a></td>\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/Taxonomy/taxonomyhome.html\" class=\"BAR\"><FONT COLOR=#FFFFFF>Taxonomy</FONT></a></td>\n");
        printf("<td width=100><a href=\"http://www.ncbi.nlm.nih.gov/Structure/\" class=\"BAR\"><FONT COLOR=#FFFFFF>Structure</FONT></a></td>\n");
        printf("</tr></TABLE><p>\n");
#else
        printf("<CENTER><TABLE CELLSPACING=2 CELLPADDING=2 WIDTH=100%%>\n");
        printf("<TR ALIGN=CENTER BaGCOLOR=#8dc7cc BGCOLOR=#0000ff><TD><B><I>\n");
        printf("<A HREF=http://www.ncbi.nlm.nih.gov/><font color=#ffffff>NCBI</font></A></I></B></TD>\n");
        printf("<TD><B><I>\n");
        printf("<A HREF=http://www.ncbi.nlm.nih.gov/Entrez><font color=#ffffff>Entrez</font></A>\n");
        printf("</I></B></TD>\n");
        printf("<TD><B><I><A HREF=bl2.html><font color=#ffffff>BLAST 2 sequences</font></A></I></B></TD>\n");
        printf("<TD><B><I><A HREF=http://www.ncbi.nlm.nih.gov/blast><font color=#ffffff>BLAST</font></A></I></B></TD>\n");
        printf("<TD><B><I><A HREF=bl2_seg.html><font color=#ffffff>Example</font></A></I></B></TD>\n");
        printf("<TD><B><I>\n");
        printf("<A HREF=http://www.ncbi.nlm.nih.gov/blast/blast_help.html><font color=#ffffff>Help</font></A>\n");
        printf("</I></B></TD></TR></TABLE></CENTER>\n");
#endif
        
        init_buff();
   	sprintf(tmp, "BLAST 2 sequences results version %s", progname);
        BlastPrintVersionInfo(tmp, TRUE, stdout);
	printf("</font>\n");
	free_buff();

	return;
}
#endif  /* --- BL2SEQ_STANDALONE --- */
 
static void CreateTailHTML()
{
    printf("<br>\n");
    printf("</BODY>\n");
    printf("</HTML>\n");
}

static int NumToGun1(int n)
{
    return (n < 10) ? n+'0' : (n < 36) ? n-10+'A' : n-36+'a';
}

static CharPtr NumToGun(int n)
{
    static Char str[4];
    
    str[0] = NumToGun1(n/62);
    str[1] = NumToGun1(n%62);
    return str;
}

static int get_int(CharPtr val)
{
	CharPtr ch=NULL;
	
	if (val != NULL) {
		ch = val + 1;
		while (isspace(*ch)) {
			ch++;
		}
		if (*ch == '\0') {
			return 0;
		}
		return (atoi(ch));
	}
	return 0;
}
static FloatHi get_double(CharPtr val)
{
	CharPtr ch=NULL;
	
	if (val != NULL) {
		ch = val + 1;
		while (isspace(*ch)) {
			ch++;
		}
		if (*ch == '\0') {
			return 0;
		}
		return (atof(ch));
	}
	return 0;
}

static CharPtr get_char(CharPtr val)
{
	CharPtr ch=NULL;
	
	if (val != NULL) {
		ch = val + 1;
		while (isspace(*ch)) {
			ch++;
		}
		if (*ch == '\0') {
			ch = NULL;
		}
	}
	return ch;
}

static Boolean sum_for_DenseDiag(DenseDiagPtr ddp, AlignSumPtr asp)
/* special for blast 2 sequences */
{
	SeqInt msi, tsi;
	SeqLoc sl;
	Int2 i;
	Int4 j, x1, x2, y1, y2;
	Uint1 m_res, t_res;
	SeqIdPtr sip;
	SeqPortPtr m_spp, t_spp;
	Int2 dim;
	SeqPortPtr spp;

	if(ddp == NULL || asp == NULL)
		return FALSE;
	x1 = ddp->starts [0];
	y1 = ddp->starts [1];
	x2 = x1 + ddp->len - 1;
	y2 = y1 + ddp->len - 1;
	msi.id = ddp->id;
	msi.from = x1;
	msi.to = x2;
	if(ddp->strands != NULL)
		msi.strand = (ddp->strands == NULL) ? 0 : ddp->strands[0];
	sl.choice = SEQLOC_INT;
	sl.data.ptrvalue = &msi;
	m_spp = SeqPortNewByLoc(&sl, 
		(asp->is_aa) ? Seq_code_ncbieaa : Seq_code_iupacna);
	
	tsi.id = ddp->id;
	tsi.from = y1;
	tsi.to = y2;
	if(ddp->strands != NULL)
		tsi.strand = (ddp->strands == NULL) ? 0 : ddp->strands[1];
	sl.choice = SEQLOC_INT;
	sl.data.ptrvalue = &tsi;

	t_spp = SeqPortNewByLoc(&sl, 
		(asp->is_aa) ? Seq_code_ncbieaa : Seq_code_iupacna);

	for(i = 0; i < ddp->len; ++i) {
		m_res = SeqPortGetResidue(m_spp);
		if (!IS_residue(m_res)) {
			continue;
		}
		t_res = SeqPortGetResidue(t_spp);
		if (!IS_residue(t_res)) {
			continue;
		}
		if(m_res == t_res) {
			++(asp->identical);
		} else if(asp->matrix != NULL && asp->is_aa) {
			if(asp->matrix[m_res][t_res] > 0)
				++(asp->positive);
		}
	}

        if (!asp->is_aa && ddp->strands) {
           asp->m_strand = ddp->strands[0];
           asp->t_strand = ddp->strands[1];
        }
	asp->totlen = ddp->len;

	SeqPortFree(m_spp);
	SeqPortFree(t_spp);
	return TRUE;
}

static Boolean sum_for_DenseSeg(DenseSegPtr dsp, AlignSumPtr asp)
{
/* special for blast 2 sequences */
	SeqInt msi, tsi;
	SeqLoc sl;
	Int2 i, k;
	Int4 j, x1, x2, y1, y2;
	Uint1 m_res, t_res;
	SeqIdPtr sip;
	SeqPortPtr m_spp, t_spp;
	static Char buf[41];


	if(dsp == NULL || asp == NULL)
		return FALSE;
	for(i = 0; i < dsp->numseg; ++i) {
		x1 = dsp->starts[2*i];
		y1 = dsp->starts[2*i+1];
		x2 = x1 + dsp->lens[i] -1;
		y2 = y1 + dsp->lens[i] -1;
		msi.id = dsp->ids;
		msi.from = x1;
		msi.to = x2;
		msi.strand = (dsp->strands == NULL) ? 0 : dsp->strands[2*i];
                if (x1 != -1) {
                   sl.choice = SEQLOC_INT;
                   sl.data.ptrvalue = &msi;
                   m_spp = SeqPortNewByLoc(&sl, (asp->is_aa) ? Seq_code_ncbieaa
                                           : Seq_code_iupacna);
                } else 
                   m_spp = NULL;
		tsi.id = dsp->ids->next;
		tsi.from = y1;
		tsi.to = y2;
		tsi.strand = (dsp->strands == NULL) ? 0 :
                   dsp->strands[2*i+1];
                if (y1 != -1) {
                   sl.choice = SEQLOC_INT;
                   sl.data.ptrvalue = &tsi;
                   t_spp = SeqPortNewByLoc(&sl, (asp->is_aa) ? Seq_code_ncbieaa : Seq_code_iupacna);
                } else 
                   t_spp = NULL;
		if (x1 == -1 || y1 == -1) {
			asp->gaps += dsp->lens[i];
		} else {
			for(j = 0; j < dsp->lens[i]; ++j) {
				m_res = SeqPortGetResidue(m_spp);
				if (!IS_residue(m_res)) {
					continue;
				}
				t_res = SeqPortGetResidue(t_spp);
				if (!IS_residue(m_res)) {
					continue;
				}
				if(m_res == t_res) {
					++(asp->identical);
				} else if(asp->matrix != NULL && asp->is_aa) {
					if(asp->matrix[m_res][t_res] >0)
						++(asp->positive);
				}
			}
		}
		asp->totlen += dsp->lens[i];
                SeqPortFree(m_spp);
                SeqPortFree(t_spp);
	}
        asp->m_strand = msi.strand;
        asp->t_strand = tsi.strand;
        
	return TRUE;
}

/* static functions from txalign.c needed for SEG masking */
static void MaskWithLowComplexity(ByteStorePtr bsp, SeqLocPtr maskloc, Uint1 mol)
{
	SeqLocPtr slp = NULL;
	Int4 start, stop;
	Uint1 res = 'N';
	

	if(mol == Seq_mol_aa)
		res = 'X';

	while(maskloc)
	{
		slp = NULL;
 		while((slp = SeqLocFindNext(maskloc, slp))!=NULL)
		{
			start = SeqLocStart(slp);
			stop = SeqLocStop(slp);
			BSSeek(bsp, start, SEEK_SET);
			for(; start <=stop; ++start)
                BSPutByte(bsp, (Int2)res);
		}
		maskloc = maskloc->next;
	}
}

static ByteStorePtr create_byte_store_from_bsp (BioseqPtr bsp)
{
	SeqPortPtr spp;
	Uint1 code;
	ByteStorePtr b_store;
	Uint1 residue;

	if(bsp == NULL)
		return NULL;
	if(bsp->mol == Seq_mol_aa)
		code = Seq_code_iupacaa;
	else
		code = Seq_code_iupacna;

	spp = SeqPortNew(bsp, 0, bsp->length-1, Seq_strand_plus, code);
	b_store = BSNew(bsp->length +1);
	BSSeek(b_store, 0, SEEK_SET);
	while((residue = SeqPortGetResidue(spp)) != SEQPORT_EOF)
		BSPutByte(b_store, (Int2)residue);
	SeqPortFree(spp);
	return b_store;
}

static ValNodePtr CreateMaskByteStore (ValNodePtr mask_list)
{
	BioseqPtr bsp;
	SeqLocPtr slp;
	SeqIdPtr sip;
	ValNodePtr list, curr;
	ByteStorePtr b_store, c_store;
	Uint1 mol;

	list = NULL;
	b_store = NULL;
	while(mask_list)
	{
		curr = ValNodeNew(list);
		curr->choice = mask_list->choice;
		if(list == NULL)
			list = curr;
		slp = mask_list->data.ptrvalue;
		if(slp != NULL)
		{
			if(b_store == NULL)
			{
				sip = SeqLocId(slp);
				if(sip != NULL)
				{
					bsp = BioseqLockById(sip);
					if(bsp != NULL)
					{
						b_store = create_byte_store_from_bsp (bsp);
						mol = bsp->mol;
						BioseqUnlock(bsp);
					}
				}
			}
			if(b_store != NULL)
			{
				if(mask_list->next == NULL)
				{
					c_store = b_store;
					b_store = NULL;
				}
				else
					c_store = BSDup(b_store);
				MaskWithLowComplexity(c_store, slp, mol);
				curr->data.ptrvalue = c_store;
			}
		}

		mask_list = mask_list->next;
	}

	if(b_store != NULL)
		BSFree(b_store);
	return list;
}

static Boolean replace_bytestore_data (BioseqPtr bsp, ValNodePtr bs_list, Uint1 frame)
{
	ByteStorePtr b_store;
	Uint1 code;

	if(bsp == NULL)
		return FALSE;

	if(bsp->mol == Seq_mol_aa)
		code = Seq_code_iupacaa;
	else
		code = Seq_code_iupacna;

	while(bs_list)
	{
		if(bs_list->choice == frame)
		{
			b_store = bs_list->data.ptrvalue;
			if(b_store != NULL)
			{
				bsp->repr = Seq_repr_raw;
				bsp->seq_data = b_store;
				bsp->seq_data_type = code;
				return TRUE;
			}
		}
		bs_list = bs_list->next;
	}

	return FALSE;
}


/*******************************************************/

static void PrintOutScore(SeqAlignPtr sap, Boolean is_aa, Int4Ptr PNTR matrix, ValNodePtr mask_loc)
{
	Int4 number, score;
	Nlm_FloatHi bit_score, evalue; 
        CharPtr eval_buff_ptr;
	static Char eval_buff[10], bit_score_buff[10];
	ScorePtr sp;
	AlignSum as;
	AlignSumPtr asp;
	Int2 percent_identical, percent_positive;
	DenseSegPtr dsp;
	DenseDiagPtr  ddp;
        StdSegPtr ssp;

	printf("<pre>\n");
	GetScoreAndEvalue(sap, &score, &bit_score, &evalue, &number);

	eval_buff_ptr = eval_buff;
	if (evalue < 1.0e-180) {
		sprintf(eval_buff, "0.0");
	} else if (evalue < 1.0e-99) {
		sprintf(eval_buff, "%2.0le", evalue);
		eval_buff_ptr++;	/* Knock off digit. */
	} else if (evalue < 0.0009) {
		sprintf(eval_buff, "%3.0le", evalue);
	} else if (evalue < 0.1) {
		sprintf(eval_buff, "%4.3lf", evalue);
	} else if (evalue < 1.0) {
		sprintf(eval_buff, "%3.2lf", evalue);
	} else if (evalue < 10.0) {
		sprintf(eval_buff, "%2.1lf", evalue);
	} else {
		sprintf(eval_buff, "%5.0lf", evalue);
	}

	if (bit_score > 9999) {
		sprintf(bit_score_buff, "%4.3le", bit_score);
	} else if (bit_score > 99.9) {
		sprintf(bit_score_buff, "%4.0ld", (long) bit_score);
	} else {
		sprintf(bit_score_buff, "%4.1lf", bit_score);
	}

	if (number == 1) {
		printf("Score = %s bits (%ld), Expect = %s<BR>", 
			bit_score_buff, (long) score, eval_buff_ptr);
	} else {
		printf("Score = %s bits (%ld), Expect(%ld) = %s<BR>", 
			bit_score_buff, (long) score, (long) number, eval_buff_ptr);
	}
	asp = MemNew(sizeof(AlignSum));
	asp->matrix = NULL;
        if (is_aa) {
           if (matrix != NULL)
              asp->matrix = matrix;
           else
              asp->matrix = load_default_matrix();
	}
	asp->is_aa = is_aa;
	asp->totlen = 0;
	asp->positive = 0;
	asp->identical = 0;
	asp->gaps = 0;

	switch (sap->segtype) {
	case SAS_DENDIAG:
		ddp = sap->segs;
		for (ddp = sap->segs; ddp; ddp = ddp->next) {
			if(asp != NULL)
				sum_for_DenseDiag(ddp, asp);
		}
		break;
	case SAS_DENSEG:
		dsp = sap->segs;
		if(asp != NULL)
			sum_for_DenseSeg(dsp, asp);
                break;
	case SAS_STD:
                find_score_in_align(sap, 1, asp);
                break;
	default:
                break;
	}

	if (asp && asp->totlen > 0) {
           Char sign1, sign2;           

	   percent_identical = (100*asp->identical)/ (asp->totlen);
	   percent_positive = (100*asp->positive)/ (asp->totlen);
           if (asp->is_aa)
              printf("Identities = %ld/%ld (%ld%%), Positives = %ld/%ld (%ld%%)", (long) asp->identical, (long) asp->totlen, percent_identical,
                     (long) (asp->positive+asp->identical), (long)
                     asp->totlen, (percent_identical+percent_positive));
           else
              printf("Identities = %ld/%ld (%ld%%)", (long) asp->identical, (long) asp->totlen, percent_identical);
	   if (asp->gaps > 0) {
		printf(", Gaps = %ld/%ld (%ld%%)<BR>", (long) asp->gaps, 
			(long) asp->totlen, 
				(long) (100*asp->gaps)/(asp->totlen));
	   } else {
	   		printf("<BR>");
	   }
           
           sign1 = sign2 = '0';
           if (asp->m_frame > 0) sign1 = '+';
           else if (asp->m_frame < 0) sign1 = '-';
           if (asp->t_frame > 0) sign2 = '+';
           else if (asp->t_frame < 0) sign2 = '-';
           if (sign1 != '0' && sign2 != '0')
                 printf(" Frame = %c%d / %c%d", sign1, ABS(asp->m_frame),
                        sign2, ABS(asp->t_frame));
           else if (sign1 != '0')
              printf(" Frame = %c%d", sign1, ABS(asp->m_frame));
           else if (sign2 != '0')
              printf(" Frame = %c%d", sign2, ABS(asp->t_frame));
           else if (asp->m_strand != Seq_strand_unknown && asp->t_strand != Seq_strand_unknown) {
              if (asp->m_strand == Seq_strand_minus)
                 printf(" Strand = Plus / Minus");
              else
                 printf(" Strand = Plus / Plus");
           }
           printf("<BR><BR>");
	}
	printf("</pre>\n");		
        MemFree(asp);
}

static Int2 CreateRectAlign(SeqAlignPtr sap, PrymPtr PNTR rect, PrymPtr PNTR rectY, FloatHi scalex, FloatHi scaley, Int4 l1, Int4 l2, Int2 color, Int4 from, Int4 ffrom, Int4 to, Int4 tto)
{
	DenseDiagPtr  ddp;
	DenseSegPtr	dsp;
	Int4         index1, i2;
	Int4          x, y, x1, x2, y1, y2, xx, yy;
	Int2 			k, l, sx, sy;
	Boolean first = TRUE;

	if (sap == NULL) {
		return 0;
	}
	k = 0;

	if (sap->segtype == SAS_DENDIAG) {
		ddp = sap->segs;
		x2 = y2 = 0;
		first = TRUE;
	    while (ddp != NULL) {
			x1 = ddp->starts [0];
			y1 = ddp->starts [1];
			sx = ddp->strands[0];
			sy = ddp->strands[1];
			if (first) {
				if (sx == Seq_strand_plus) {
					x1 = ddp->starts[0] - from + 1;
				} else {
					x1 = to - (ddp->starts[0] +  ddp->len) + 1;
				}
				if (sy == Seq_strand_plus) {
					y1 = ddp->starts[1] - from + 1;
				} else {
					y1 = tto - (ddp->starts[1] +  ddp->len) + 1;
				}
				rect[k] = MemNew(sizeof(Prym));
				rect[k]->color = -1;
				rect[k]->len = 0;
				rectY[k] = MemNew(sizeof(Prym));
				rectY[k]->color = -1;
				rectY[k]->len = 0;
			     if (x1 < y1) {
				    rect[k]->len = (y1-x1)*scalex + 0.5;
			     } else {
				    rectY[k]->len = (x1-y1)*scalex + 0.5;
			     }
				 first = FALSE;
				k++;
			 }
			rect[k] = MemNew(sizeof(Prym));
			rect[k]->color = 0;
			rect[k]->len = (x1 - x2)*scalex + 0.5;
			rectY[k] = MemNew(sizeof(Prym));
			rectY[k]->color = 0;
			rectY[k]->len = (y1 - y2)*scaley + 0.5;
			k++;
		    x2 = ddp->starts [0] + ddp->len;
		    y2 = ddp->starts [1] + ddp->len;
			rect[k] = MemNew(sizeof(Prym));
			rect[k]->color = color;
			rect[k]->len = (x2 - x1)*scalex + 0.5;
			rectY[k] = MemNew(sizeof(Prym));
			rectY[k]->color = color;
			rectY[k]->len = (y2 - y1)*scaley + 0.5;
			k++;

		      ddp = ddp->next;
	    }
		rect[k] = MemNew(sizeof(Prym));
		rect[k]->color = 0;
		if (sx != Seq_strand_minus) {
			rect[k]->len = (to - x2)*scalex + 0.5;
		} else {
			rect[k]->len = (x1 - from +1)*scalex + 0.5;
		}
		rectY[k] = MemNew(sizeof(Prym));
		rectY[k]->color = 0;
		if (sy != Seq_strand_minus) {
			rectY[k]->len = (tto - y2)*scaley + 0.5;
		} else {
			rectY[k]->len = (y1 - ffrom +1)*scaley + 0.5;
		}
		k++;
	} else if (sap->segtype == SAS_DENSEG) {
		dsp = sap->segs;
		k = 0;
		for (index1=0; index1 < dsp->numseg; index1++) {
			x1 = dsp->starts[2*index1];
			y1 = dsp->starts[2*index1+1];
			sx = dsp->strands[2*index1];
			sy = dsp->strands[2*index1+1];
			x2 = x1 + dsp->lens[index1];
			y2 = y1 + dsp->lens[index1];
			if (index1 == 0) {
				if (sx == Seq_strand_minus) {
					x1 = to - (dsp->starts[0] +  dsp->lens[0]) + 1;
				} else {
					x1 = dsp->starts[0] - from + 1;
				}
				if (sy == Seq_strand_minus) {
					y1 = tto - (dsp->starts[1] + dsp->lens[0]) + 1;
				} else {
					y1 = dsp->starts[1] - ffrom + 1;
				}
				rect[k] = MemNew(sizeof(Prym));
				rect[k]->color = -1;
				rect[k]->len = 0;
				rectY[k] = MemNew(sizeof(Prym));
				rectY[k]->color = -1;
				rectY[k]->len = 0;
				if (x1 < y1) {
					rect[k]->len = (y1-x1)*scalex + 0.5;
				} else {
				    rectY[k]->len = (x1-y1)*scalex + 0.5;
				}
				k++;
				rect[k] = MemNew(sizeof(Prym));
				rect[k]->color = 0;
				rect[k]->len = x1*scalex + 0.5;
				rectY[k] = MemNew(sizeof(Prym));
				rectY[k]->color = 0;
				rectY[k]->len = y1*scalex + 0.5;
				k++;
			}
			rect[k] = MemNew(sizeof(Prym));
			if (x1 == -1) {
				rect[k]->color = 3;
			} else {
				rect[k]->color = color;
			}
			rect[k]->len = dsp->lens[index1]*scalex + 0.5;
			rectY[k] = MemNew(sizeof(Prym));
			if (y1 == -1) {
				rectY[k]->color = 3;
			} else {
				rectY[k]->color = color;
			}
			rectY[k]->len = dsp->lens[index1]*scalex + 0.5;
			k++;
		}
		rect[k] = MemNew(sizeof(Prym));
		rect[k]->color = 0;
		if (sx == Seq_strand_minus) {
			rect[k]->len = (x1 - from +1)*scalex + 0.5;
		} else {
			rect[k]->len = (to - x2)*scalex + 0.5;
		}
		rectY[k] = MemNew(sizeof(Prym));
		rectY[k]->color = 0;
		if (sy == Seq_strand_minus) {
			rectY[k]->len = (y1 - ffrom +1)*scaley + 0.5;
		} else {
			rectY[k]->len = (tto - y2)*scaley + 0.5;
		}
		k++;
	} else if (sap->segtype == SAS_STD) {
           StdSegPtr ssp = sap->segs;
           SeqLocPtr slp;

           while (ssp) {
              slp = ssp->loc;
              if (!slp || !slp->next) {
                 ssp = ssp->next;
                 continue;
              }
              if (slp->choice == SEQLOC_EMPTY) {
                 x1 = x2 = -1;
                 sx = Seq_strand_unknown;
              } else {
                 x1 = SeqLocStart(slp);
                 sx = SeqLocStrand(slp);
                 x2 = SeqLocStop(slp) + 1;
              }
              if (slp->next->choice == SEQLOC_EMPTY) {
                 y1 = y2 = -1;
                 sy = Seq_strand_unknown;
              } else {
                 y1 = SeqLocStart(slp->next);
                 sy = SeqLocStrand(slp->next);
                 y2 = SeqLocStop(slp->next) + 1;
              }

              if (first) { 
                 if (sx == Seq_strand_plus) {
                    x1 -= from - 1;
                 } else if (sx == Seq_strand_minus) {
                    x1 = to - x2 + 1;
                 }
                 if (sy == Seq_strand_plus) {
                    y1 -= ffrom - 1;
                 } else if (sy == Seq_strand_minus){
                    y1 = tto - y2 + 1;
                 }

                 rect[k] = MemNew(sizeof(Prym));
                 rect[k]->color = -1;
                 rect[k]->len = 0;
                 rectY[k] = MemNew(sizeof(Prym));
                 rectY[k]->color = -1;
                 rectY[k]->len = 0;
                 if (y1*scaley>x1*scalex)
                    rect[k]->len = y1*scaley - x1*scalex + 0.5;
                 else
                    rectY[k]->len = x1*scalex - y1*scaley + 0.5;
                 first = FALSE;
                 k++;
                 rect[k] = MemNew(sizeof(Prym));
                 rect[k]->color = 0;
                 rect[k]->len = x1*scalex + 0.5;
                 rectY[k] = MemNew(sizeof(Prym));
                 rectY[k]->color = 0;
                 rectY[k]->len = y1*scaley + 0.5;
                 k++;
              }
              rect[k] = MemNew(sizeof(Prym));
              if (x1 == -1) {
                 rect[k]->color = 3;
                 rect[k]->len = SeqLocLen(slp->next)*scaley + 0.5;
              } else {
                 rect[k]->color = color;
                 rect[k]->len = SeqLocLen(slp)*scalex + 0.5;
              }

              rectY[k] = MemNew(sizeof(Prym));
              if (y1 == -1) {
                 rectY[k]->color = 3;
                 rectY[k]->len = SeqLocLen(slp)*scalex + 0.5;
              } else {
                 rectY[k]->color = color;
                 rectY[k]->len = SeqLocLen(slp->next)*scaley + 0.5;
              }
              k++;
              ssp = ssp->next;
           }
           rect[k] = MemNew(sizeof(Prym));
           rect[k]->color = 0;
           if (sx != Seq_strand_minus) {
              rect[k]->len = (to - x2)*scalex + 0.5;
           } else {
              rect[k]->len = (x1 - from +1)*scalex + 0.5;
           }
           rectY[k] = MemNew(sizeof(Prym));
           rectY[k]->color = 0;
           if (sy != Seq_strand_minus) {
              rectY[k]->len = (tto - y2)*scaley + 0.5;
           } else {
              rectY[k]->len = (y1 - ffrom +1)*scaley + 0.5;
           }
           k++;
        }

	return k;
}

static void DrawRectAlign(PrymPtr PNTR rect, Int2 k, Int2 color, Int2 height, Int2 index)
{
	Int2 l;
	
	for (l=0; l < k; l++) {
		if (rect[l]->len <= 0) {
			if (l == 0 && rect[1] && rect[1]->len == 0) {
				printf("<img\n height=%d width=1 src='images/00.gif'>", height);
			}
                        MemFree(rect[l]);
			continue;
		}
		if (rect[l]->len-1 == 0) {
			rect[l]->len++;
		}
		if (rect[l]->color == -1) {
			printf("<img\n height=2 src='images/0.gif'");
			printf(" width=%d>", rect[l]->len);
		} else if (rect[l]->color == 3) {
			if (rect[l+1]->color == rect[l]->color) {
				printf("<img\n height=5 src='images/3.gif'");
				printf(" width=%d>", rect[l]->len);
			} else {
				printf("<img\n height=5 src='images/3.gif'");
				printf(" width=%d>", rect[l]->len-1);
				printf("<img\n height=%d width=1 src='images/00.gif'>", height);
			}
		} else if (rect[l]->color == 0) {
			if (rect[l+1] &&  rect[l+1]->color != -1) {
				printf("<img\n height=2 src='images/00.gif'");
				printf(" width=%d>", rect[l]->len-1);
				printf("<img\n height=%d width=1 src='images/00.gif'>", height);
			} else {
				printf("<img\n height=2 src='images/00.gif'");
				printf(" width=%d>", rect[l]->len);
			}
		} else if (rect[l]->len > 0) {
			if (rect[l+1]->color == rect[l]->color) {
				if (index != -1) {
				printf("<A HREF=#%d><img height=%d src='images/%d.gif' BORDER=0", 
													index, height, color);
					printf(" width=%d></a>", rect[l]->len);
				} else {
					printf("<img height=%d src='images/%d.gif'", 
													height, color);
					printf(" width=%d>", rect[l]->len);
				}
			} else {
				if (index != -1) {
				printf("<A HREF=#%d><img height=%d src='images/%d.gif' BORDER=0",
						index, height, color);
					printf(" width=%d></a>", rect[l]->len-1);
				} else {
					printf("<img height=%d src='images/%d.gif'",
						height, color);
					printf(" width=%d>", rect[l]->len-1);
				}
				printf("<img\n height=%d width=1 src='images/00.gif'>", height);
			}
		}
                MemFree(rect[l]);
	}
}

static void PrintRectAlign(PrymPtr PNTR rect, Int2 k, Int2 color, Int2 height, Int2 index)
{
	Int2 l;
	
	for (l=0; l < k; l++) {
		if (rect[l]->len <= 0) {
			continue;
		}
		if (rect[l]->len-1 == 0) {
			rect[l]->len++;
		}
		if (rect[l]->color == -1) {
			printf("images/0.gif");
			printf(" width=%d>", rect[l]->len);
		} else if (rect[l]->color == 3) {
			if (rect[l+1]->color == rect[l]->color) {
				printf("images/3.gif");
				printf(" width=%d", rect[l]->len);
			} else {
				printf("images/3.gif");
				printf(" width=%d>", rect[l]->len-1);
			}
		} else if (rect[l]->color == 0) {
			if (rect[l+1] &&  rect[l+1]->color != -1) {
				printf(" width=%d>", rect[l]->len-1);
			} else {
				printf(" width=%d>", rect[l]->len);
			}
		} else if (rect[l]->len > 0) {
			if (rect[l+1]->color == rect[l]->color) {
				if (index != -1) {
					printf(" RECT:width=%d></a>", rect[l]->len);
				} else {
					printf(" RECT:width=%d>", rect[l]->len);
				}
			} else {
				if (index != -1) {
					printf(" RECT width=%d></a>", rect[l]->len-1);
				} else {
					printf("RECT width=%d>", rect[l]->len-1);
				}
			}
		}
	}
}

static BioseqPtr FindSeqByAccession(CharPtr accver)
{
   CharPtr accession, new_defline;
   Int4 version=0, gi, number, title_length, id_length;
   SeqIdPtr sip = NULL;
   TextSeqIdPtr tsip;
   PDBSeqIdPtr  psip;
   BioseqPtr bsp = NULL;
   ObjectIdPtr  oid;
   SeqPortPtr spp;
   Int2 retval, buf_length=512;
   Uint1 buf[512];
   Char tmp[255];

#ifdef NCBI_ENTREZ_CLIENT

   ID1BioseqFetchEnable ("wblast2", TRUE);
      
   if ((gi = atoi(accver)) == 0) {
      accession = StringTokMT(accver, ".", &accver);
      
      if (accver)
         version = atoi(accver);

      if((sip = ValNodeNew (NULL)) == NULL)
         return NULL;
      if((tsip = TextSeqIdNew ()) == NULL)
         return NULL;
      
      tsip->accession = StringSave(accession);
      tsip->version = version;
      /* GenBank, EMBL, and DDBJ. */
      sip->choice = SEQID_GENBANK;
      sip->data.ptrvalue = (Pointer) tsip;

      gi = ID1FindSeqId (sip);
      
      if (gi == 0) {
         /* SwissProt. */
         sip->choice = SEQID_SWISSPROT;
         gi = ID1FindSeqId (sip);
      }
      if (gi == 0) {
         /* PIR */
         sip->choice = SEQID_PIR;
         gi = ID1FindSeqId (sip);
      }
      
      if (gi == 0) {
         /* PRF */
         sip->choice = SEQID_PRF;
         gi = ID1FindSeqId (sip);
      }
      
      if (gi == 0) {
         /* OTHER, probably 'ref' */
         sip->choice = SEQID_OTHER;
        gi = ID1FindSeqId (sip);
      }
      
      if(gi == 0) {
         /* OK. We failed to find gi using string as TextSeqId. Now trying
            last time - with PDBSeqIdPtr */
         
         if((psip = PDBSeqIdNew()) == NULL)
            return NULL;
         
         sip->choice = SEQID_PDB;
         tsip = TextSeqIdFree(tsip);
         sip->data.ptrvalue = psip;
         
         psip->mol = accession;
         psip->chain = version;
         
         gi = ID1FindSeqId (sip);
      }
    
      sip = SeqIdFree(sip);
   }
   if (gi > 0) {
      ValNodeAddInt(&sip, SEQID_GI, gi);
      bsp = BioseqLockById(sip);
   } 

   if (bsp == NULL)
      return NULL;

    if (ISA_na(bsp->mol)) {
       spp = SeqPortNew(bsp, 0, -1, Seq_strand_plus, 
                        Seq_code_iupacna);
       bsp->seq_data_type = Seq_code_iupacna;
    } else {
       spp = SeqPortNew(bsp, 0, -1, Seq_strand_unknown, 
                        Seq_code_ncbieaa);
       bsp->seq_data_type = Seq_code_ncbieaa;
    }
    
    SeqPortSet_do_virtual(spp, TRUE);
    number = 0;

    bsp->repr = Seq_repr_raw;
    bsp->seq_data = BSNew(bsp->length);
    
    while (number < bsp->length) {
       retval = SeqPortRead(spp, buf, buf_length);
       if (retval <= 0)
          break;
       BSWrite(bsp->seq_data, buf, retval);
       number += retval;
    }
    
    SeqPortFree(spp);
    ID1BioseqFetchDisable();
      
#endif

    return bsp;
}

static Boolean FastaCheckDna(CharPtr seq)
{
    Int2 len;
    
    if (*seq == '>') {
        for (++seq; *seq != NULLB && *seq != '\n'; seq++) ;
    }
    len = MIN(100, StringLen(seq));
    return (CheckDnaResidue(seq, len, NULL));
}

static void BLASTOptionValidateHTML(BLAST_OptionsBlkPtr options, CharPtr progname, CharPtr seq1, CharPtr seq2, CharPtr one, CharPtr two, Boolean is_prot, Int2 mtrx, Int2 from, Int2 to, Int2 ffrom, Int2 tto, Int2 filter, Int2 pagecount)
{
    Int2 status;
    ValNodePtr error_return=NULL;
    
    status = BLASTOptionValidateEx(options, progname, &error_return);
    if (status != 0) {
        Blast2SeqMainPage(NULL, seq1, seq2, one, two, error_return, is_prot, options, mtrx, from, to, ffrom, tto, filter, pagecount);
    }
    return;
}

static void PrintParam(Boolean is_prot, Int2 mtrx, Int2 ma, Int2 ms, BLAST_OptionsBlkPtr options, CharPtr seq_2, CharPtr seq_1, CharPtr one, CharPtr two, BioseqPtr query_bsp, BioseqPtr subject_bsp, Int4 len1, Int4 len2, Int4 from, Int4 to, Int4 ffrom, Int4 tto, Int2 pagecount)
{
    ValNodePtr vnp;
    CharPtr s;
    static Char buf[41];
    Int4 gi;
    
#if defined (BL2SEQ_STANDALONE) && defined (NCBI_ENTREZ_CLIENT)
    printf("<FORM NAME= bl2 method=\"POST\" action=\"wblast2_cs.cgi?%d\" enctype=\"multipart/form-data\">\n\n", pagecount);
#else 
    printf("<FORM NAME= bl2 method=\"POST\" action=\"wblast2.cgi?%d\" enctype=\"multipart/form-data\">\n\n", pagecount);
#endif

    printf("<INPUT TYPE=hidden name=\"page\" value=\"%d\">\n", pagecount+1);
    if (is_prot == TRUE) {
#if defined (BL2SEQ_STANDALONE)
        printf("<A HREF=docs/options.html#matrix>Matrix</A>\n");
#else
        printf("<A HREF=http://www.ncbi.nlm.nih.gov/BLAST/options.html#matrix TARGET=one>Matrix</A>\n");
#endif
        printf("<select name=\"matrix\" onChange=\"update_mtrx(this)\">\n");
        
        printf("<option value=0>BLOSUM62\n");
        printf("<option value=1%s>PAM30\n", (mtrx == 1) ? " SELECTED" : "");
        printf("<option value=2%s>PAM70\n", (mtrx == 2) ? " SELECTED" : "");
        printf("<option value=3%s>PAM250\n", (mtrx == 3) ? " SELECTED" : "");
        printf("<option value=4%s>BLOSUM90\n", (mtrx == 4) ? " SELECTED" : "");
        printf("<option value=5%s>BLOSUM50\n", (mtrx == 5) ? " SELECTED" : "");
        printf("</select>\n");
    } else {
       printf("Match:<INPUT TYPE=text name=match size=2 value=%d>\n", ma); 
       printf("Mismatch:<INPUT TYPE=text name=msmatch size=2 value=%d>\n", ms);
    }
    printf("gap open:<INPUT TYPE=text name=gopen size=2 value=%d>\n", options->gap_open);
    printf("gap extension: <INPUT TYPE=text size=2 name=\"gext\" value=%d> <BR>\n", options->gap_extend);
    printf("x_dropoff: <INPUT TYPE=text size=2 name=\"dropoff\" value=\"%d\">\n", options->gap_x_dropoff);
    printf("expect:<INPUT TYPE=text size=4 name=\"expect\" value=\"%f\">\n", options->expect_value);
    printf("wordsize: <INPUT type=text size=2 name=\"word\" "); 
    if (options->is_megablast_search)
       printf("value=%d>\n\n", options->wordsize - 4);
    else
       printf("value=%d>\n\n", options->wordsize);
#if defined (BL2SEQ_STANDALONE)
    printf("<a href=docs/newoptions.html#filter>Filter</a>");
#else
    printf("<a href=/BLAST/newoptions.html#filter>Filter</a>");
#endif

    printf(" <INPUT TYPE=checkbox NAME=Filter VALUE=1");
    if (options->filter == 1) {
        printf(" CHECKED>\n");
    } else {
        printf(">\n");
    }
    printf("<INPUT TYPE=hidden name=\"program\" value=\"%s\">\n",
           options->program_name);
    
    printf("<INPUT TYPE=hidden name=\"matrix\" value=\"%d\">\n", mtrx);
    
    printf("<INPUT TYPE=submit VALUE=Align><HR>\n");
    if (seq_1 != NULL && *seq_1 != NULLB) {
        printf("<INPUT TYPE=hidden name=\"seq\" value=\"");
        for (s = seq_1; *s != '\0'; s++) {
            if (*s == '>') {
                printf("&gt;");
            } else {
                printf("%c", *s);
            }
        }
        printf("\">\n");
    } else if (one != NULL) {
        printf("<INPUT TYPE=hidden name=\"one\" value=\"%s\">\n", one);
    }
    if (seq_2 != NULL && *seq_2 != NULLB) {
        printf("<INPUT TYPE=hidden name=\"sseq\" value=\"");
        for (s = seq_2; *s != '\0'; s++) {
            if (*s == '>') {
                printf("&gt;");
            } else {
                printf("%c", *s);
            }
        }
        printf("\">\n");
    } else if (two != NULL) {
        printf("<INPUT TYPE=hidden name=\"two\" value=\"%s\">\n", two);
    }
    printf("<INPUT TYPE=hidden name=\"from\" value=\"%d\">\n", from);
    printf("<INPUT TYPE=hidden name=\"to\" value=\"%d\">\n", to);
    printf("<INPUT TYPE=hidden name=\"ffrom\" value=\"%d\">\n", ffrom);
    printf("<INPUT TYPE=hidden name=\"tto\" value=\"%d\">\n", tto);
    printf("<TABLE>\n");
    printf("<TR><TD><strong> Sequence 1</strong></TD>\n");
    if ((gi = GetGIForSeqId(SeqIdFindBest(query_bsp->id, SEQID_GI))) != 0) {
        printf("<TD>gi<A HREF=http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?form=6&dopt=g&db=s&uid=%ld> %ld</A></TD>", gi, gi);
    } else {
        SeqIdWrite(query_bsp->id, buf, PRINTID_FASTA_LONG, 40);
        printf("<TD>%s</TD>", buf);
    }
    for (vnp=query_bsp->descr; vnp; vnp=vnp->next) {
        if (vnp->choice == Seq_descr_title) {
            printf("<TD>%s</TD>", vnp->data.ptrvalue);
            break;
        }
    }
    if (vnp == NULL) {
        printf("<TD></TD>");
    }
    printf("<TD><strong>Length</strong></TD><TD>%ld</TD>\n", len1);
    if (from != 0 || to != 0) {
        printf("<TD>(%ld .. %ld)</TD>\n", from, to);
    }
    printf("</TR><TR>\n");
    printf("<TR><TD><strong> Sequence 2</strong></TD>\n");
    if ((gi = GetGIForSeqId(SeqIdFindBest(subject_bsp->id, SEQID_GI))) != 0) {
        printf("<TD>gi <A HREF=http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?form=6&dopt=g&db=s&uid=%ld>%ld</A></TD>", gi, gi);
    } else {
        SeqIdWrite(subject_bsp->id, buf, PRINTID_FASTA_LONG, 40);
        printf("<TD>%s</TD>", buf);
    }
    for (vnp=subject_bsp->descr; vnp; vnp=vnp->next) {
        if (vnp->choice == Seq_descr_title) {
            printf("<TD>%s</TD>", vnp->data.ptrvalue);
            break;
        }
    }
    if (vnp == NULL) {
        printf("<TD></TD>");
    }
    printf("<TD><strong>Length</strong></TD><TD>%ld</TD>\n", len2);
    if (ffrom != 0 || tto != 0) {
        printf("<TD>(%ld .. %ld)</TD>\n", ffrom, tto);
    }
    printf("</TR></TABLE>\n");

    return;
}

#define BL2SEQ_CPU_LIMIT 600

Int2 Main(void)
{
    AsnModulePtr amp;
    SeqEntryPtr sep;
    BioseqPtr fake_bsp, query_bsp = NULL, subject_bsp = NULL;
    BioseqPtr b1, b2;
    DbtagPtr        dbtagptr;
    SeqIntPtr sip1, sip2;
    Int2 i, j, index = 0, retcode = 3;
    Int4 gopen, gext, dropoff, ma=0, ms=0, dgopen=0, dgext=0;
    Int4 from=0, to=0, ffrom=0, tto=0;
    Int2 wordsize, filter=0;
    Int2 type, prot = 0, mtrx = 0, color=1, method;
    SeqAlignPtr seqalign, sap, sapnext;
    SeqAnnotPtr seqannot, hsat= NULL, sat, satnext;
    SeqEntryPtr sep1=NULL, sep2=NULL;
    FloatHi	expect;
    Boolean is_prot=FALSE, is_aa1=FALSE, is_aa2=FALSE, is_na1=TRUE, is_na2=TRUE;
    CharPtr seq_1=NULL, seq_2=NULL, ptr, c1, c2, chptr, df1, df2;
    CharPtr sq_1=NULL, sq_2=NULL, s, one=NULL, two=NULL, sbuf, progname;
    static Char mbuf[12];
    static Char buf[41];
    BLAST_OptionsBlkPtr options = NULL;
    Int4 ll, len1, len2, txoption;
    SeqIdPtr sip;
    Int4Ptr PNTR txmatrix;
    BLAST_MatrixPtr blast_matrix;
    SeqPortPtr spp;
    Uint1 code1, code2;
    ValNodePtr vnp, error_return=NULL;
    
    AsnIoPtr     aip;
    FloatHi       scalex, scaley, scale;
    DenseDiagPtr ddp;
    DenseSegPtr  dsp;
    StdSegPtr    ssp;
    Int4         index1, i2;
    Int4         x, y, x1, x2, y1, y2, len, xx, yy;
    Int2 	     k, l, sx, sy, x_factor, y_factor;
    static PrymPtr PNTR rect;
    static PrymPtr PNTR rectY;
    SeqLocPtr    slp1=NULL, slp2=NULL, slp, sl, qslp = NULL, mslp;
    Uint1        align_type;
    
    ValNodePtr	   other_returns, mask, mask_head;
    CharPtr		   buffer;
    BLAST_KarlinBlkPtr ka_params=NULL, ka_gap_params=NULL;
    TxDfDbInfoPtr      dbinfo = NULL;
    BlastTimeKeeper    time_keeper;
    Boolean	           is_gap;
    
    WWWBlastInfoPtr theInfo;
    WWWErrorCode error = WWWErrOk; 
    BlastResponsePtr response;
    ReadDBFILEPtr rdfp;
    Int4 dbseq_num;
    CharPtr dbname;
    CharPtr error_msg;
    Int2 pagecount = 0;
    Boolean is_megablast = FALSE;

#ifdef RLIMIT_CPU
    struct rlimit rl, rlh;
    
    getrlimit(RLIMIT_CPU, &rl);
    rl.rlim_max = rl.rlim_cur = BL2SEQ_CPU_LIMIT;
    setrlimit(RLIMIT_CPU, &rl);
#ifdef SIGXCPU
    signal(SIGXCPU, TimeExpired);
#endif
#endif
    
    if (!SeqEntryLoad())
        return 1;
    
    UseLocalAsnloadDataAndErrMsg ();
    
    ErrSetMessageLevel(SEV_WARNING);
    
    /* This function will read posting data, set-up config file and
       write small message into logfile (if it exists) */
    
    theInfo = MemNew(sizeof(WWWBlastInfo));
    
    if((error = WWWGetArgs(&theInfo->info)) != WWWErrOk) {
        WWWInfoFree(theInfo->info);
        MemFree(theInfo);
        Blast2SeqMainPage(NULL, NULL, NULL, NULL, NULL, NULL, FALSE, 
                          NULL, 0, 0, 0, 0, 0, 1, 0);
        return 1;    
    }
    if((chptr = WWWGetQuery(theInfo->info)) == NULL || *chptr == NULLB) {
        WWWInfoFree(theInfo->info);
        MemFree(theInfo);
        Blast2SeqMainPage(NULL, NULL, NULL, NULL, NULL, NULL, FALSE, 
                          NULL, 0, 0, 0, 0, 0, 1, 0);
    }
    
    if(getenv("DEBUG_COMMAND_LINE") != NULL) {
        FILE *fd;
        fd = FileOpen("/tmp/__web.in", "w");
        fprintf(fd, "%s", ((WWWInfoDataPtr)theInfo->info)->query);
        FileClose(fd);
    }
    
    if((chptr = WWWGetValueByName(theInfo->info, "PROGRAM")) != NULL)
        theInfo->program = StringSave(chptr);
    else if ((chptr = WWWGetValueByName(theInfo->info, "PROT")) != NULL)
        theInfo->program = StringSave(chptr);
    else
        theInfo->program = StringSave("blastn");
    
    theInfo->align_type = 
        BlastGetTypes(theInfo->program, &theInfo->query_is_na, 
                      &theInfo->db_is_na);
    
    is_aa1 = !theInfo->query_is_na;
    is_aa2 = !theInfo->db_is_na;
    is_prot = (is_aa1 || is_aa2);
    if (is_prot)
        retcode = 2;
    
    progname = theInfo->program;
    
    options = BLASTOptionNew(progname, TRUE);
    
    if ((chptr = WWWGetValueByName(theInfo->info, "PAGE")) != NULL)
        pagecount = atoi(chptr);
    if ((chptr = WWWGetValueByName(theInfo->info, "MEGABLAST")) != NULL)
       is_megablast = options->is_megablast_search = TRUE;
    
    if ((chptr = WWWGetValueByName(theInfo->info, "GOPEN")) != NULL &&
        StringStr(chptr, "default") == NULL)
        gopen = atoi(chptr);
    else
        gopen = -1;
    
    if ((chptr = WWWGetValueByName(theInfo->info, "GEXT")) != NULL &&
        StringStr(chptr, "default") == NULL)
        gext = atoi(chptr);
    else
        gext = -1;
    
    if((chptr = WWWGetValueByName(theInfo->info, "DROPOFF")) != NULL &&
       StringStr(chptr, "default") == NULL)
        dropoff = atoi(chptr);
    else
        dropoff = 50;
    
    if((chptr = WWWGetValueByName(theInfo->info, "EXPECT")) != NULL &&
       StringStr(chptr, "default") == NULL)
        expect = atof(chptr);
    else
        expect = 10;
    
    if((chptr = WWWGetValueByName(theInfo->info, "MATCH")) != NULL &&
       StringStr(chptr, "default") == NULL)
        ma = atoi(chptr);
    else if (!StrCmp(progname, "blastn"))
        ma = 1;
    if((chptr = WWWGetValueByName(theInfo->info, "MSMATCH")) != NULL &&
       StringStr(chptr, "default") == NULL)
        ms = atoi(chptr);
    else if (!StrCmp(progname, "blastn"))
        ms = -2;
    
    if((chptr = WWWGetValueByName(theInfo->info, "FROM")) != NULL &&
       StringStr(chptr, "default") == NULL)
        from = atoi(chptr);
    else
        from = 0;
    if((chptr = WWWGetValueByName(theInfo->info, "FFROM")) != NULL &&
       StringStr(chptr, "default") == NULL)
        ffrom = atoi(chptr);
    else
        ffrom = 0;
    if((chptr = WWWGetValueByName(theInfo->info, "TO")) != NULL &&
       StringStr(chptr, "default") == NULL)
        to = atoi(chptr);
    else
        to = 0;
    if((chptr = WWWGetValueByName(theInfo->info, "TTO")) != NULL &&
       StringStr(chptr, "default") == NULL)
        tto = atoi(chptr);
    else
        tto = 0;

    if((chptr = WWWGetValueByName(theInfo->info, "STRAND")) != NULL &&
       StringStr(chptr, "default") == NULL)
        options->strand_option = atoi(chptr);
    else
        options->strand_option = Seq_strand_both;

#ifdef NCBI_ENTREZ_CLIENT
    one = WWWGetValueByName(theInfo->info, "ONE");
    two = WWWGetValueByName(theInfo->info, "TWO");
#endif
    options->cpu_limit = BL2SEQ_CPU_LIMIT;
    
    if((chptr = WWWGetValueByName(theInfo->info, "WORD")) != NULL &&
       StringStr(chptr, "default") == NULL)
        wordsize = atoi(chptr);
    else if (!is_megablast)
        wordsize = (is_prot == TRUE) ? 3 : 11;
    else {
        wordsize = 28;
    }

    if (WWWGetValueByName(theInfo->info, "FILTER") != NULL)
        filter =1;
    
    amp = AsnAllModPtr();
    
    if((chptr = WWWGetValueByName(theInfo->info, "SEQ")) == NULL ||
       *chptr == NULLB)
        chptr = WWWGetValueByName(theInfo->info, "SEQFILE1");
    
    if (chptr) {
       while (IS_WHITESP(*chptr))
          chptr++;
    }
    if (chptr && *chptr != NULLB)
       c1 = StringSave(chptr);
    else
       c1 = NULL;

    if (c1 && *c1 != '>') {
        sbuf = MemNew(StringLen(c1)+8);
        sprintf(sbuf, ">seq_1\n%s", c1);
        seq_1 = StringSave(sbuf);
        MemFree(c1);
        c1 = seq_1;
        MemFree(sbuf);
    }
    
    if((chptr = WWWGetValueByName(theInfo->info, "SSEQ")) == NULL || 
       *chptr == NULLB)
        chptr = WWWGetValueByName(theInfo->info, "SEQFILE2");
    
    if (chptr) {
       while (IS_WHITESP(*chptr))
          chptr++;
    }
    if (chptr && *chptr != NULLB)
        c2 = StringSave(chptr);
    else 
        c2 = NULL;
    
    if (c2 && *c2 != '>') {
        sbuf = MemNew(StringLen(c2)+8);
        sprintf(sbuf, ">seq_2\n%s", c2);
        seq_2 = StringSave(sbuf);
        MemFree(c2);
        c2 = seq_2;
        MemFree(sbuf);
    }
    seq_1 = c1;
    seq_2 = c2;
    if (c1 && c2 && StrNCmp(c1, c2, 6) == 0) {
        if (*c1 == '>')
            seq_1 = seq_1 + 1;
        sbuf = Malloc(StringLen(seq_1)+4);
        sprintf(sbuf, ">1_%s", seq_1);
        seq_1 = StringSave(sbuf);
        sbuf = MemFree(sbuf);
        MemFree(c1);
        if (*c2 == '>')
            seq_2 = seq_2 + 1;
        sbuf = Malloc(StringLen(seq_2)+4);
        sprintf(sbuf, ">2_%s",seq_2);
        seq_2 = StringSave(sbuf);
        MemFree(sbuf);
        MemFree(c2);
    }
    
    if (seq_1 != NULL) {
        sep = FastaToSeqBuff(seq_1, &sq_1, !is_aa1);
        query_bsp = (BioseqPtr) sep->data.ptrvalue;
        is_na1 = FastaCheckDna(seq_1);
    } else if (one != NULL && *one != NULLB) {
        if ((query_bsp = FindSeqByAccession(one)) == NULL) {
            error_msg = "The first sequence accession is not found";
            Blast2SeqMainPage(error_msg, seq_1, seq_2, 
                              one, two, NULL, is_prot, options, mtrx,
                              from, to, ffrom, tto, filter, pagecount);
        }
        
        is_na1 = ISA_na(query_bsp->mol);
    }
    if (seq_2  != NULL) {
        sep = FastaToSeqBuff(seq_2, &sq_2, !is_aa2);
        subject_bsp = (BioseqPtr) sep->data.ptrvalue;
        is_na2 = FastaCheckDna(seq_2);
    } else if (two != NULL && *two != NULLB) {
        if ((subject_bsp = FindSeqByAccession(two)) == NULL) {
            error_msg = "The second sequence accession is not found";
            Blast2SeqMainPage(error_msg, seq_1, seq_2, 
                              one, two, NULL, is_prot, options, mtrx,
                              from, to, ffrom, tto, filter, pagecount);
        }
        is_na2 = ISA_na(subject_bsp->mol);
    }
    code1 = ((is_aa1 == FALSE) ? Seq_code_iupacna:Seq_code_iupacaa);
    code2 = ((is_aa2 == FALSE) ? Seq_code_iupacna:Seq_code_iupacaa);
    
    if (is_prot) {
        if((chptr = WWWGetValueByName(theInfo->info, "MATRIX")) == NULL ||
           *chptr == NULLB)
            chptr = WWWGetValueByName(theInfo->info, "MTRX");
        if (chptr && *chptr != NULL)
            mtrx = atoi(chptr);
        else
           mtrx = 0;
        
        switch(mtrx) {
        case 1:
           sprintf(mbuf, "PAM30");
           if (gopen == -1 || gext == -1) {
              gopen = (gopen == -1) ? 9: gopen;
              gext = (gext == -1) ? 1: gext;
           }
           break;
        case 2:
           sprintf(mbuf, "PAM70");
           if (gopen == -1 || gext == -1) {
              gopen = (gopen == -1) ? 10: gopen;
              gext = (gext == -1) ? 1: gext;
           }
           break;
        case 3:
           sprintf(mbuf, "PAM250");
           if (gopen == -1 || gext == -1) {
              gopen = (gopen == -1) ? 14: gopen;
              gext = (gext == -1) ? 2: gext;
           }
           break;
        case 4:
           sprintf(mbuf, "BLOSUM90");
           if (gopen == -1 || gext == -1) {
              gopen = (gopen == -1) ? 10: gopen;
              gext = (gext == -1) ? 1: gext;
           }
           break;
        case 5:
           sprintf(mbuf, "BLOSUM50");
           if (gopen == -1 || gext == -1) {
              gopen = (gopen == -1) ? 13: gopen;
              gext = (gext == -1) ? 2: gext;
           }
           break;
        default:
           sprintf(mbuf, "BLOSUM62");
           if (gopen == -1 || gext == -1) {
              gopen = (gopen == -1) ? 11: gopen;
              gext = (gext == -1) ? 1: gext;
           }
           break;
        }

        StringCpy(options->matrix, mbuf);
        
        /* one-pass non-multiple hits search with low threshold */		
        options->two_pass_method  = FALSE;                      			
        options->multiple_hits_only  = FALSE;
        options->threshold_second = 9;
    } else {
        if (gopen == -1) 
            gopen = (is_megablast) ? 0 : 5;
        if (gext == -1) 
            gext = (is_megablast) ? 0 : 2;
        options->penalty  = ms;
        options->reward  = ma;
    }
    
    if((chptr = WWWGetValueByName(theInfo->info, "DB")) != NULL && 
       StrCmp(chptr, "=pdb") == 0) {
        dbname = StringSave("pdb");
    } else {
        dbname = StringSave("nr");
    }
    
    rdfp = readdb_new(dbname, is_aa2);
    if (rdfp) {
        readdb_get_totals(rdfp, &options->db_length, &dbseq_num);
        readdb_destruct(rdfp);
    } else
        options->db_length = (is_aa2 ? NR_SIZE_AA : NR_SIZE_NA);
              
    MemFree(dbname);

    options->wordsize  = wordsize;
    if (is_megablast) {
        options->cutoff_s2 = options->wordsize;
        options->wordsize += 4; 
        options->cutoff_s = options->wordsize;
        options->block_width = 0;
    }
    options->gap_open  = gopen;
    options->gap_extend  = gext;
    options->gap_x_dropoff  = dropoff;
    options->expect_value = expect;
    options->filter = filter;
    if (filter == 1) {
        options->filter_string = StringSave("T");
    }
    
    if (!StringICmp(progname, "tblastn") || 
        !(StringICmp(progname, "tblastx")))
        options->db_genetic_code = 1;
    
    if (query_bsp == NULL || subject_bsp == NULL) {
        error_msg = "Please enter the sequences";   
        Blast2SeqMainPage(error_msg, seq_1, seq_2, 
                          one, two, NULL, is_prot, options, mtrx,
                          from, to, ffrom, tto, filter, pagecount);
    }
    
    error_return = NULL;
    if (is_aa1 && is_na1) 
        BlastConstructErrorMessage(NULL, "First sequence must be protein for this program", 1, &error_return);  
    if (is_aa2 && is_na2)
        BlastConstructErrorMessage(NULL, "Second sequence must be protein for this program", 1, &error_return);  
    if (!is_aa1 && !is_na1)
        BlastConstructErrorMessage(NULL, "First sequence must be nucleotide for this program", 1, &error_return);  
    if (!is_aa2 && !is_na2)
        BlastConstructErrorMessage(NULL, "Second sequence must be nucleotide for this program", 1, &error_return);  
    if (error_return)
        Blast2SeqMainPage(NULL, seq_1, seq_2, one, two, error_return, is_prot, 
                          options, mtrx, from, to, ffrom, tto, filter, pagecount);
    
    BLASTOptionValidateHTML(options, progname, seq_1, seq_2, one, two, 
                            is_prot, mtrx, from, to, ffrom, tto, filter, pagecount);
    fake_bsp = BlastMakeFakeBioseq(query_bsp, NULL);
    if (from == 0 && to == 0) {
        ValNodeAddPointer(&slp1, SEQLOC_WHOLE, SeqIdDup(fake_bsp->id));
        len1 = fake_bsp->length;
    } else {
        sip1 = SeqIntNew();
        sip1->from = (from > 0) ? from-1 : 0; 
        sip1->to = (to < fake_bsp->length) ? to-1 : fake_bsp->length-1;
        sip1->id = (SeqIdPtr) SeqIdDup (query_bsp->id);
        sip1->strand = options->strand_option;
        ValNodeAddPointer(&slp1, SEQLOC_INT, sip1);
        len1 = SeqLocLen(slp1);
    }
    if (ffrom == 0 && tto == 0) {
        ValNodeAddPointer(&slp2, SEQLOC_WHOLE, SeqIdDup(subject_bsp->id));
        len2 = subject_bsp->length;
    } else {
        sip2 = SeqIntNew();
        sip2->from = (ffrom > 0) ? ffrom-1 : 0; 
        sip2->to = (tto < subject_bsp->length) ? tto-1 : subject_bsp->length-1;
        sip2->id = (SeqIdPtr) SeqIdDup (subject_bsp->id);
        sip2->strand = Seq_strand_both;
        ValNodeAddPointer(&slp2, SEQLOC_INT, sip2);
        len2 = SeqLocLen(slp2);
    }
    if ((spp = SeqPortNewByLoc(slp1, code1)) == NULL) {
        error_msg = "The first sequence location is not valid";
        Blast2SeqMainPage(error_msg, seq_1, seq_2, one, two, NULL, is_prot, options, 
                          mtrx, from, to, ffrom, tto, filter, pagecount);
    } else
       SeqPortFree(spp);
    if ((spp = SeqPortNewByLoc(slp2, code2)) == NULL) {
        error_msg = "The second sequence location is not valid";
        Blast2SeqMainPage(error_msg, seq_1, seq_2, one, two, NULL, is_prot, options, 
                          mtrx, from, to, ffrom, tto, filter, pagecount);
    } else
       SeqPortFree(spp);
    
    /* calculate SEG location
       b1 =  BioseqCopy (query_bsp->id, query_bsp->id, 0,
       query_bsp->length-1, Seq_strand_plus, FALSE);
       b2 =  BioseqCopy (subject_bsp->id, subject_bsp->id, 0,
       subject_bsp->length-1, Seq_strand_plus, FALSE);
       qslp = BlastBioseqFilterEx(b1, "T", NULL);
       mslp = BlastBioseqFilterEx(b2, "T", NULL);
       printf("q %p,m  %p\n", qslp, mslp);
       exit (0);*/
    other_returns = NULL;
    
    seqalign =  BlastTwoSequencesByLocEx(slp1, slp2, progname, 
                                         options, &other_returns, NULL);
    
    /*	seqalign =  BlastTwoSequencesEx(query_bsp, subject_bsp, progname, 
        options, &other_returns, NULL);*/
    
    if (seqalign == NULL) {
        if ((chptr = WWWGetValueByName(theInfo->info, "SEQ")) != NULL) {
            MemFree(seq_1);
            seq_1 = StringSave(chptr);
        }
        if((chptr = WWWGetValueByName(theInfo->info, "SSEQ")) != NULL) {
            MemFree(seq_2);
            seq_2 = StringSave(chptr);
        }
        CreateJavaHeadHTML(query_bsp, subject_bsp, from, to, ffrom, tto, 
                           len1, len2, progname);
        PrintParam(is_prot, mtrx, ma, ms, options, seq_2, seq_1, one, two,
                   query_bsp, subject_bsp, len1, len2, from, to, ffrom, tto, pagecount);
        printf("<strong><font color=#0000EE>No significant similarity was found</font></strong>\n");
        MemFree(seq_1);
        MemFree(seq_2);
        return 1;
    }

    mask = NULL;
    for (vnp=other_returns; vnp; vnp = vnp->next) {
        switch (vnp->choice) {
           case TXDBINFO:
               dbinfo = vnp->data.ptrvalue;
               break;
        case TXKABLK_NOGAP:
            ka_params = vnp->data.ptrvalue;
            is_gap = FALSE;
            break;
        case TXKABLK_GAP:
            ka_gap_params = vnp->data.ptrvalue;
            is_gap = TRUE;
            break;
        case TXPARAMETERS:
            buffer = vnp->data.ptrvalue;
            break;
        case TXMATRIX:
            blast_matrix = vnp->data.ptrvalue;
            if (blast_matrix)
                txmatrix = BlastMatrixToTxMatrix(blast_matrix);
            break;
        case SEQLOC_MASKING_NOTSET:
        case SEQLOC_MASKING_PLUS1:
        case SEQLOC_MASKING_PLUS2:
        case SEQLOC_MASKING_PLUS3:
        case SEQLOC_MASKING_MINUS1:
        case SEQLOC_MASKING_MINUS2:
        case SEQLOC_MASKING_MINUS3:
            ValNodeAddPointer(&mask, vnp->choice, vnp->data.ptrvalue);
            break;
        default:
            break;
        }
    }	
    
    ValNodeFree(other_returns);
    /* mask low complexity on query
       
       ValNodeAddPointer(&mask, SEQLOC_MASKING_NOTSET, qslp);
    */
    /*for debugging
      
      printf("<pre>\n");
      aip = AsnIoOpen("stdout","w");
      sat = SeqAnnotNew();
      sat->type = 2;
      sat->data = seqalign;
      SeqAnnotAsnWrite(sat, aip, NULL);
      AsnIoClose(aip);
      fflush(stdout);
      printf("</pre>\n");
      exit (0);
    */
    to = (to >0) ? to : fake_bsp->length;
    tto = (tto >0) ? tto : subject_bsp->length;
    from = (from >0) ? from : 1;
    ffrom = (ffrom >0) ? ffrom : 1;
    
    CreateJavaHeadHTML(query_bsp, subject_bsp, 
                       from, to, ffrom, tto, len1, len2, progname);
    PrintParam(is_prot, mtrx, ma, ms, options, seq_2, seq_1, one, two,
               query_bsp, subject_bsp, len1, len2, from, to, ffrom, tto, pagecount);
    
    MemFree(seq_1);
    MemFree(seq_2);
    align_type = BlastGetProgramNumber(progname);
    
    x_factor = y_factor = 1;
    if (align_type == blast_type_tblastn)
        x_factor = 3;
    else if (align_type == blast_type_blastx)
        y_factor = 3;
    
    x = y = 150;
    ll = MAX(len1*x_factor, len2*y_factor);
    scalex = (FloatHi) x*x_factor/ll;
    scaley = (FloatHi) y*y_factor/ll;
    k = 0;
    color = 1;
    index = 0;
    
    printf("<table>\n");
    printf("<tr><td>\n");
    
    /* For tblastx all alignments are in one seqalign; let's separate them */
    if (align_type == blast_type_tblastx) {
       StdSegPtr nextssp;
       SeqAlignPtr last_sap = NULL, head = NULL;
       sap = seqalign;
       ssp = seqalign->segs;
       while (ssp) {
          nextssp = ssp->next;
          ssp->next = NULL;
          seqalign->segs = ssp;
          sap = SeqAlignDup(seqalign);
          if (last_sap) {
             last_sap->next = sap;
             last_sap = last_sap->next;
          } else
             head = last_sap = sap;
          ssp = nextssp;
       }
       SeqAlignFree(seqalign);
       seqalign = head;
    }

    for (sap=seqalign; sap != NULL; sap = sap->next) {
        if (sap->segtype > 3) {	
            sap = sap->segs;
        }
        if (index%2 == 0) {
            color = 1;
        } else {
            color = 2;
        }
        if (sap->segtype == SAS_DENDIAG) {
            for (ddp = sap->segs, index1=0; ddp; ddp= ddp->next, index1++);
        } else if (sap->segtype == SAS_DENSEG) {
            dsp = sap->segs;
            index1 = dsp->numseg;
        } else if (sap->segtype == SAS_STD) {
            for (ssp = sap->segs, index1=0; ssp; ssp = ssp->next, index1++);
        }
        
        rect = MemNew((2*index1+3)*sizeof(PrymPtr));
        rectY = MemNew((2*index1+3)*sizeof(PrymPtr));
        k = CreateRectAlign(sap, rect, rectY, scalex, scaley,
                            len1, len2, color, from, ffrom, to, tto);
        DrawRectAlign(rect, k, color, 9, index);
        /*	PrintRectAlign(rect, k, color, 9, index);*/
        printf("<BR>\n");
        DrawRectAlign(rectY, k, color, 9, index);
        
        MemFree(rect);
        MemFree(rectY);
        /*	PrintRectAlign(rectY, k, color, 9, index);*/
        printf("<BR><BR>\n"); 
        index++;
    }
    printf("</td><td width=75></td><td valign=top><b>2</b></td><td>\n");
    xx = yy = 150;
    scalex = ((FloatHi) xx) / len1;
    scaley = ((FloatHi) yy) / len2;
    
    /*	printf("<INPUT TYPE=image border=0 SRC=\"bag?");*/
    printf("<IMG border=0 SRC=\"bl2bag.cgi?");
    xx = scalex * len1;
    yy = scaley * len2;
    printf("%s", NumToGun(xx));
    printf("%s", NumToGun(yy));
    printf("CCCCCC-");
    
    printf("rD9D9D9(");
    
    for (slp=qslp; slp != NULL; slp=slp->next) {
        if (slp->choice == SEQLOC_PACKED_INT) {
            for (sl = slp->data.ptrvalue; sl; sl=sl->next) {
                if (SeqLocStart(sl) >= from || SeqLocStop(sl) <= to) {
                    continue;
                }
                x = SeqLocStart(sl) * scalex;
                printf("%s", NumToGun(x));
                printf("00");
                y = SeqLocStop(sl) * scaley;
                printf("%s", NumToGun(x));
                printf("%s", NumToGun(y));
            }
        } else {
            if (SeqLocStart(slp) >= from || SeqLocStop(slp) <= to) {
                continue;
            }
            x = SeqLocStart(slp) * scalex;
            printf("%s", NumToGun(x));
            printf("00");
            y = SeqLocStop(slp) * scaley;
            printf("%s", NumToGun(x));
            printf("%s", NumToGun(y));
        }
    }
    printf(")");
    
    hsat = NULL;
    index = 0;
    
    for (sap=seqalign; sap != NULL; sap = sapnext) {
        if (sap->segtype > 3) {	
            sap = sap->segs;
        }
        sapnext = sap->next;
        sap->next = NULL;
        sat = SeqAnnotNew();
        sat->type = 2;
        sat->data = sap;
        hsat = tie_next_annot(hsat, sat);
        
        if (index%2 == 0) {
            printf("3399CC3(");
        } else {
            printf("8dC7CC3(");
        }
        if (sap->segtype == SAS_DENDIAG) {
            ddp = sap->segs;
            while (ddp != NULL) {
                if (ddp->strands[0] != Seq_strand_minus) {
                    x = ddp->starts [0] * scalex;
                } else {
                    x = (ddp->starts [0] + ddp->len) * scalex;
                }
                if (ddp->strands[1] != Seq_strand_minus) {
                    y = yy - ddp->starts [1] * scaley;
                } else {
                    y = yy - (ddp->starts [1] + ddp->len) * scaley;
                }
                printf("%s", NumToGun(x));
                printf("%s", NumToGun(y));
                if (ddp->strands[0] != Seq_strand_minus) {
                    x = (ddp->starts [0] + ddp->len) * scalex;
                } else {
                    x = ddp->starts [0] * scalex;
                }
                if (ddp->strands[1] != Seq_strand_minus) {
                    y = yy - (ddp->starts [1] + ddp->len) * scaley;
                } else {
                    y = yy - ddp->starts [1] * scaley;
                }
                printf("%s", NumToGun(x));
                printf("%s", NumToGun(y));
                ddp = ddp->next;
            }
            printf(")");
        } else if (sap->segtype == SAS_DENSEG) {
            dsp = sap->segs;
            for (index1=0; index1 < dsp->numseg; index1++) {
                i2 = 2 * index1;
                if (dsp->starts[i2] != -1 && dsp->starts[i2+1] != -1) {
                    if (dsp->strands[i2] != Seq_strand_minus) {
                        x = (dsp->starts[i2] - from) * scalex;
                    } else {
                        x = (dsp->starts[i2] + dsp->lens[index1] - from) * scalex;
                    }
                    if (dsp->strands[i2+1] != Seq_strand_minus) {
                        y = yy - (dsp->starts[i2+1] -ffrom) * scaley;
                    } else {
                        y = yy - (dsp->starts[i2+1] + dsp->lens[index1] - ffrom) * scaley;
                    }
                    printf("%s", NumToGun(x));
                    printf("%s", NumToGun(y));
                    if (dsp->strands[i2] != Seq_strand_minus) {
                        x = (dsp->starts[i2] + dsp->lens[index1] - from) * scalex;
                    } else {
                        x = (dsp->starts[i2] - from) * scalex;
                    }
                    if (dsp->strands[i2+1] != Seq_strand_minus) {
                        y = yy - (dsp->starts[i2+1] + dsp->lens[index1] - ffrom) * scaley;
                    } else {
                        y = yy - (dsp->starts[i2+1] - ffrom)* scaley;
                    }
                    printf("%s", NumToGun(x));
                    printf("%s", NumToGun(y));
                }
            }
            printf(")");
        } else if (sap->segtype == SAS_STD) {
            SeqLocPtr tmp_slp;
            ssp = sap->segs;
            while (ssp) {
                tmp_slp = ssp->loc;
                if (!tmp_slp || !tmp_slp->next) {
                    ssp = ssp->next;
                    continue;
                }
                if (tmp_slp->choice != SEQLOC_EMPTY && 
                    tmp_slp->next->choice != SEQLOC_EMPTY) {
                    
                    if (SeqLocStrand(tmp_slp) != Seq_strand_minus) {
                        x = (SeqLocStart(tmp_slp) - from) * scalex;
                    } else {
                        x = (SeqLocStop(tmp_slp) + 1 - from) * scalex;
                    }
                    if (SeqLocStrand(tmp_slp->next) != Seq_strand_minus) {
                        y = yy - (SeqLocStart(tmp_slp->next) - ffrom) * scaley;
                    } else {
                        y = yy - (SeqLocStop(tmp_slp->next) + 1 - ffrom) * scaley;
                    }
                    printf("%s", NumToGun(x));
                    printf("%s", NumToGun(y));
                    if (SeqLocStrand(tmp_slp) != Seq_strand_minus) {
                        x = (SeqLocStop(tmp_slp) + 1 - from) * scalex;
                    } else {
                        x = (SeqLocStart(tmp_slp) - from) * scalex;
                    }
                    if (SeqLocStrand(tmp_slp->next) != Seq_strand_minus) {
                        y = yy - (SeqLocStop(tmp_slp->next) + 1 - ffrom) * scaley;
                    } else {
                        y = yy - (SeqLocStart(tmp_slp->next) - ffrom) * scaley;
                    }
                    printf("%s", NumToGun(x));
                    printf("%s", NumToGun(y));
                }
                ssp = ssp->next;
            }
            printf(")");
        }
        
        index++;
    }
    
    printf("\">\n");
    printf("</td><td valign=bottom><b>1</b></td></tr></table>\n");
    printf("<BR>");
    
    color = 1;
    index = 0;
    printf("<font color=#FF0000>NOTE:</font>The statistics (bitscore and expect value) is calculated based on the size of nr database<BR><BR>\n");
    
    if (align_type == blast_type_blastn)
       printf("<font color=#FF0000>NOTE:</font>If protein translation is reversed, please repeat the search with reverse strand of the query sequence<BR><BR>\n");

    for (sat=hsat; sat != NULL; sat=satnext) {
        satnext=sat->next;
        sat->next = NULL;
        
        x = y = 450;
        
        ll = MAX(len1*x_factor, len2*y_factor);
        scalex = (FloatHi) x*x_factor/ll;
        scaley = (FloatHi) y*y_factor/ll;
        k = 0;
        
        if ((sap = sat->data) != NULL) {
            if (index%2 == 0) {
                color = 1;
            } else {
                color = 2;
            }
            printf("<a name=%d>\n", index);
            PrintOutScore(sap, is_prot, NULL, mask);
            if (sap->segtype == SAS_DENDIAG) {
                for (ddp = sap->segs, index1=0; ddp; ddp= ddp->next, index1++);
            } else if (sap->segtype == SAS_DENSEG) {
                dsp = sap->segs;
                index1 = dsp->numseg;
            } else if (sap->segtype == SAS_STD) {
                ssp = sap->segs;
                for (ssp = sap->segs, index1=0; ssp; ssp= ssp->next, index1++);
            }
            rect = MemNew((2*index1+3)*sizeof(PrymPtr));
            rectY = MemNew((2*index1+3)*sizeof(PrymPtr));
            
            k = CreateRectAlign(sap, rect, rectY, scalex, scaley,
                                len1, len2, color, from, ffrom, to, tto);
            DrawRectAlign(rect, k, color, 11, -1);
            MemFree(rect);
            printf("<BR>\n");
            DrawRectAlign(rectY, k, color, 11, -1);
            MemFree(rectY);
            printf("<BR><BR>\n");
            index++;
        }
           
        txoption = 0;
        txoption += TXALIGN_COMPRESS;
        txoption += TXALIGN_END_NUM;
        txoption += TXALIGN_SHOW_GI;
        txoption += TXALIGN_MATRIX_VAL;
        txoption += TXALIGN_SHOW_QS;
           
        if (StringICmp(progname, "blastx") == 0)
            txoption += TXALIGN_BLASTX_SPECIAL;
        
        txoption += TXALIGN_HTML;
        
        AddAlignInfoToSeqAnnot(sat, align_type); 
        
        ShowTextAlignFromAnnot(sat, 60, stdout, NULL, NULL,
                               txoption, txmatrix, mask, NULL);
    }
    BlastTimeFillStructure(&time_keeper);
    printf("<pre>\n");
    fprintf(stdout, "CPU time: %8.2f user secs.\t%8.2f sys. "
            "secs\t%8.2f total secs.\n\n", 
            time_keeper.user, time_keeper.system, time_keeper.total);
    init_buff();
    /*PrintDbReport(dbinfo, 70, stdout);*/
    
    blast_matrix = BLAST_MatrixDestruct(blast_matrix);
    if (txmatrix)
        txmatrix = TxMatrixDestruct(txmatrix);
    dbinfo = TxDfDbInfoDestruct(dbinfo);
    if (ka_params) {
        PrintKAParameters(ka_params->Lambda, ka_params->K, ka_params->H, 
                          70, stdout, is_gap);
        MemFree(ka_params);
    }
    if (ka_gap_params) {
        PrintKAParameters(ka_gap_params->Lambda, ka_gap_params->K, 
                          ka_gap_params->H, 70, stdout, is_gap);
        MemFree(ka_gap_params);
    }
    PrintTildeSepLines(buffer, 70, stdout);
    MemFree(buffer);
    free_buff();
    mask_head = mask;
    while (mask) {
        SeqLocSetFree(mask->data.ptrvalue);
        mask = mask->next;
    }
    ValNodeFree(mask_head);
    CreateTailHTML();
    options = BLASTOptionDelete(options);
    WWWInfoFree(theInfo->info);
    MemFree(progname);
    MemFree(theInfo);
    SeqLocSetFree(slp1);
    SeqLocSetFree(slp2);
    return 0;
}
