#ifndef __LUTEFISK__
#define __LUTEFISK__


/*	Define a few constants.	*/
#define AMINO_ACID_NUMBER 20	/*Number of amino acids.*/

#define ELEMENT_NUMBER 6		/*Number of elements - H, C, N, O, P, and S.*/

#define HYDROGEN	0
#define CARBON		1
#define NITROGEN	2
#define OXYGEN		3
#define PHOSPHORUS  4
#define SULFUR		5


#define WATER ((gElementMass[HYDROGEN] * 2) + gElementMass[OXYGEN])	/*Mass of water.*/
#define AMMONIA (gElementMass[NITROGEN] + (gElementMass[HYDROGEN] * 3))	/*Mass of ammonia.*/
#define CO (gElementMass[CARBON] + gElementMass[OXYGEN])	/*Mass of carbon monoxide.*/
/*#define WATER_X_100 (WATER * 100)		I don't think I need this anymore.
#define AMMONIA_X_100 (AMMONIA * 100)
#define CO_X_100 (CO * 100)*/
#define MAX_ION_NUM 500		/*Maximum number of fragment ions used in the final scoring.*/
#define MAX_SEQ_INT_SCORE 500	/*This is supposed to be the number of sequences that are
								subjected to the cross-correlation.  Otherwise, its not used.*/
#define MAX_DATA_POINTS_PER_GROUP 2500	/*The max number of data points per group of ions
										that exceed an ion threshold.  Each group is passed on
										to a function that sorts the ions.*/
#define SPECTRAL_WINDOW_WIDTH 120	/*Width of spectrum that has a limit on the number of ions.*/
#define GRAPH_LENGTH 4000	/*The maximum graph size (ie, peptides must be less than 4000 Da).*/
#define AV_TO_MONO	0.999371395	/*The weighted average ratio between average and monoisotopic 
								amino acid masses.*/
#define MONO_TO_NOMINAL 0.99949725	/*The weighted average ratio between monoisotopic and
									nominal masses.*/
#define MONO_TO_AV 1.000629	/*To convert from monoisotopic to average mass.*/
#define NOMINAL_TO_MONO 1.000503003	/*To convert from nominal to monoisotopic mass.*/
#define NOMINAL_TO_AV 1.001132319	/*To convert from nominal to average mass.*/
#define C_NODE_VALUE 10	/*The value placed at the C-terminal nodes.*/
#define N_NODE_VALUE 10	/*The value placed at the N-terminal nodes.*/
#define MIN_MASS_PER_CHARGE 350	/*For charge states > 1 there is a minimum amount of mass 
								required to hold that charge.*/
#define MAX_PEPTIDE_LENGTH 30	/*Maximum peptide length.*/
#define MAX_GAPLIST (AMINO_ACID_NUMBER * AMINO_ACID_NUMBER)
#define NODE_NODE_PENALTY	0.5		/*These are multiplied against an extension score for an
									extension that uses two amino acids.*/
#define NODE_EDGE_PENALTY	0.75	/*From node to a C-terminal one-edge node.*/
#define EDGE_EDGE_PENALTY 1.0		/*From a N-terminal one-edge node to a C-terminal
										one-edge node.*/
#define AV_RESIDUE_MASS 119	/*This is the weighted average amino acid residue mass.*/
#define TAG_MULTIPLIER 10
/*	These weighting values are used to weight the importance of various scoring parameters 
	when calculating the final score.  Used in LutefiskScore.*/
#define ATTENUATION_WEIGHT 15	/*Presence of b and y ions.*/
#define INTENSITY_WEIGHT 20	/*Ion current accounted for.*/
#define PEAKS_WEIGHT 1	/*Peaks per residue divided by peaks per average residue.*/
#define INT_ATT_WEIGHT (INTENSITY_WEIGHT + ATTENUATION_WEIGHT)
#define INT_PEAKS_WEIGHT (INTENSITY_WEIGHT + PEAKS_WEIGHT)


// MACROS
#define closeEnough(x,tol)       (((x)<0)? (-(x)<=tol):(x)<=tol)
#define MolWeightOf_Pos(mz,z)    ((mz - monoisotopicElementMass[HYDROGEN]) * (float)(z))
#define MolWeightOf_Neg(mz,z)    ((mz + monoisotopicElementMass[HYDROGEN]) * (float)(z))
#define mzOf_Pos(MW,z)           (((MW)/(float)(z)) + monoisotopicElementMass[HYDROGEN])
#define mzOf_Neg(MW,z)           (((MW)/(float)(z)) - monoisotopicElementMass[HYDROGEN])
#define chargeOf_Pos(MW,mz)      ((short)(MW)/(mz -  monoisotopicElementMass[HYDROGEN]) + 0.1)   
#define SWAP(a,b)                tempr=(a);(a)=(b);(b)=tempr


/*	Define a few structs.	*/
extern struct MSData				/*Used to hold ion information.*/
{
	float mOverZ;
	long int intensity;
	long int normIntensity;
	struct MSData *next;
};

typedef struct 	/*Structure to hold data about the CID file.*/
{
	float scanMassLow;
	float scanMassHigh;
}tmsms;

extern tmsms msms;


typedef struct 				/*Used to hold Lutefisk's parameters.*/
{
	char 		cidFilename[64];
	float 		peptideMW;
	long int	chargeState;
	float 		fragmentErr;
	float 		ionOffset;
	char 		fragmentPattern;
	float 		cysMW;
	char 		proteolysis;
	char 		centroidOrProfile;
	long int	monoToAv;
	long int 	ionsPerWindow;
	char 		aaPresent[AMINO_ACID_NUMBER];
	char 		aaAbsent[AMINO_ACID_NUMBER];
	char 		modifiedNTerm; 
	char 		modifiedCTerm; 
	float 		tagNMass;
	char 		tagSequence[MAX_PEPTIDE_LENGTH];
	float 		tagCMass; 
	long int 	finalSeqNum;
	long int 	topSeqNum;
	float 		extThresh;
	long int 	maxExtNum;
	long int 	maxGapNum;
	float 		peakWidth;
	float 		ionThreshold;
	float 		peptideErr;
	long int 	rankedSeqNum;
	char 		edmanPresent;
	long int 	ionsPerResidue;
}tParam;

extern tParam gParam;


extern struct Sequence				/*Used to hold sequence info during subsequencing.*/
{
	short int peptide[MAX_PEPTIDE_LENGTH];
	short int peptideLength;
	short int score;
	short int nodeValue;
	short int gapNum;
	struct Sequence *next;
};

extern struct SequenceScore		/*Used to hold sequence info during final scoring procedure.*/
{
	short peptide[MAX_PEPTIDE_LENGTH];
	float intensityScore;
	float crossDressingScore;
	long  rank;
	struct SequenceScore *next;
};

extern char gSingAA[AMINO_ACID_NUMBER];
  
extern float gMonoMass[AMINO_ACID_NUMBER];

extern float gAvMass[AMINO_ACID_NUMBER];

extern long gNomMass[AMINO_ACID_NUMBER];

extern float gElementMass[ELEMENT_NUMBER];

extern short gGapList[MAX_GAPLIST];

extern short gGapListIndex;

extern short gEdmanData[MAX_PEPTIDE_LENGTH][AMINO_ACID_NUMBER], gMaxCycleNum;

extern float H2O, NH3;

#endif /* __LUTEFISK__ */

