#ifndef __ALTLIB__
#define __ALTLIB__

#pragma once

//#ifdef UNIX
//#define NCBIBL13 11
//#define LASTLIB NCBIBL13+1
//#else
#define LASTLIB 10
//#endif

#define DEFAULT 0
#define FULLGB 1
#define UNIXPIR 2
#define EMBLSWISS 3
#define INTELLIG 4
#define VMSPIR 5
#define GCGBIN 6
#define LASTTXT 6


//extern short (*getlib)(), (*ranlib)();

long agetlib(),aranlib();	/* pearson fasta format */
long lgetlib(),lranlib();	/* full uncompressed GB FULLGB*/
long pgetlib(),pranlib();	/* PIR UNIX protein UNIXPIR */
long egetlib(),eranlib();	/* EMBL/SWISS-PROT EMBLSWISS */
long igetlib(),iranlib();	/* Intelligenetics INTELLIG */
long vgetlib(),vranlib();	/* PIR VMS format */
long gcg_getlib(),gcg_ranlib();	/* GCG 2bit format */


#if defined(BIGMEM) && defined(NCBIBL13)
extern long ncbl_getliba(), ncbl_ranlib(); /* ncbi blast 1.3 format */
#endif

long (*getliba[LASTLIB])()={
	agetlib,lgetlib,pgetlib,egetlib,
	igetlib,vgetlib,gcg_getlib,agetlib,
	agetlib,agetlib
#ifdef NCBIBL13
	,agetlib,ncbl_getliba
#endif
        };

long (*ranliba[LASTLIB])()={
	aranlib,lranlib,pranlib,eranlib,
	iranlib,vranlib,gcg_ranlib,aranlib,
	aranlib,aranlib
#ifdef NCBIBL13
	,aranlib,ncbl_ranlib
#endif
        };


#endif /* __ALTLIB__ */
