#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "LutefiskGlobals.h"

#include "jat.h"
#include "ffasta.h"
#define XTERNAL
#include "upam.gbl"
#include "uascii.gbl"


/* -------------------------------------------------------------------------
//  my_fgets 
*/
char *my_fgets(char *s, long n, FILE *fp)
{
	register char *t = s;
	register long c;
	
	if (n < 1)
		return(NULL);
	while (--n) {
		if ((c = getc(fp)) < 0) {
            if (feof(fp) && t != s) break;
            return(NULL);
        }
        *t++ = c;
        if (c == '\n' || c == '\r' || c == '\32')
            break;
    }
    *t = '\0';
    return(s);
}
/* -------------------------------------------------------------------------
//  ImportLutefiskPeptides 
*/
long ImportLutefiskPeptides(char *theFileName)
{
  FILE  *fptr;
  char  line[512];
  char  *bp;
  long  i, j, n;
  long  ic;
  long  sstart, sstop, sset=0;
  long  theNumOfPeptides;
  long  sq0off = 0;
  long  seqPos;
    
    
  sstart = sstop = -1;
#ifndef MSDOS
  if ((bp=strchr(theFileName,':')) != NULL) {
#else
  if ((bp=strchr(theFileName+3,':')) != NULL) {
#endif
  *bp='\0';
  if (*(bp+1)=='-') sscanf(bp+2,"%d",&sstop);
    else sscanf(bp+1,"%d-%d",&sstart,&sstop);
    sset=1;
  }

  // Try to open the file
  if (strncmp(theFileName,"-",1)!=0) {
    if ((fptr=fopen(theFileName,"r"))==NULL) {
      fprintf(stderr," could not open \"%s\"\n",theFileName);
      return 0;
    }
  }
  else fptr = stdin;
      
  if (sset==1) {
    theFileName[strlen(theFileName)]=':';
    if (sq0off==1 || sstart>1) sq0off = sstart;
  }

  // Read the sequence into the 'seq' array.
  theNumOfPeptides = 0;
  n = 0;
  while(my_fgets(line,sizeof(line),fptr) != NULL) {

    if (strstr(line,"Sequence") && strstr(line,"Rank")) {
      while(my_fgets(line,sizeof(line),fptr) != NULL) {
        if (line[0] == ' ' || line[0] == '\n' || line[0] == '\r') break;
   
        i = seqPos = 0;
        while (line[i] != ' '  && line[i] != '\n' && line[i] != '\r' 
               && line[i] != '\0' && i < 256) 
        {
        
         
          /* In Lutefisk, B denotes oxidized met. */ 
	  	if (line[i] == 'B') line[i] = 'm';
		  
          if (i == 0) fprintf(stdout, " Query %2ld: ", theNumOfPeptides + 1);   
            fprintf(stdout, "%c", line[i]);   
                       
	    if (line[i] == '[') { /* must be a dipeptide. get its mass */
	      i++;
	      if (isalpha(line[i])) {
	        /* It's a dipeptide of known composition (ex. [HG]) */ 
                fprintf(stdout, "%c", line[i]);
                lutefiskResult[theNumOfPeptides].peptide[seqPos++] = GetNominalMass(line[i++]) + GetNominalMass(line[i]);
                fprintf(stdout, "%c", line[i++]);
                lutefiskResult[theNumOfPeptides].peptide[seqPos++] = -200; // Bogus mass value for the second 
                fprintf(stdout, "%c", line[i]);
              }
	      else {
		/* It is a dipeptide specified as a mass */
                lutefiskResult[theNumOfPeptides].peptide[seqPos++] = (short)atof(&line[i]);
                lutefiskResult[theNumOfPeptides].peptide[seqPos++] = -200; // Bogus mass value for the second X
                while (line[i] != ']' && line[i] != ' ' && i < 256) {
                  fprintf(stdout, "%c", line[i]);
                  i++;
                }    
                fprintf(stdout, "%c", line[i]);
		/* fprintf(stdout, "(%ld, %ld)", lutefiskResult[theNumOfPeptides].peptide[seqPos-2], 
		                                 lutefiskResult[theNumOfPeptides].peptide[seqPos-1]);
		*/
               }	
	    }
	    else {
	      lutefiskResult[theNumOfPeptides].peptide[seqPos++] = GetNominalMass(line[i]);
	    }
		    
            i++;
          }
          if (seqPos) {
            theNumOfPeptides++;
            fprintf(stdout, "\n");
          }    
          if (theNumOfPeptides == LUTEFISK_QUERY_LIMIT) break;
        }
     }
  }    
  gNumOfQueries = theNumOfPeptides;

  fclose(fptr);

  return true;
}
/* -------------------------------------------------------------------------
//  GetNominalMass 
*/
long GetNominalMass(char inResidue) {
	
    long outReturnValue = 0;
    long i;
    

    /* Force to uppercase */
    inResidue = toupper(inResidue);
    
    if (!isalpha(inResidue)) {
        fprintf(stderr,"'%c' is not an allowed sequence char. Quitting.\n", inResidue);
        exit(0);    
    }
    
    /* Pick off non-standard residues*/
    /* 'X' is allowed to represent unknown */
    if (inResidue == 'B'
	|| inResidue == 'J'
	|| inResidue == 'O'
	|| inResidue == 'U'
        || inResidue == 'Z')
    {
      fprintf(stderr,"'%c' is not an allowed sequence char. Converting to 'X' for unknown\n", inResidue);
      inResidue = 'X';
    }
    
    for (i = 0; i < AMINO_ACID_NUMBER; i++) {
        if (gSingAA[i] == inResidue) {
	    outReturnValue = gNomMass[i];
	    break;	    
        }
    }
    
    return outReturnValue; 
}
    

/* -------------------------------------------------------------------------
//  ConvertLutefiskPeptidesToFASTAQueries 
*/

void ConvertLutefiskPeptidesToFASTAQueries(long gNumOfQueries) {

    long     i, j, k;        /* Loop indicies */
    
    
    for (i = 0; i < gNumOfQueries; i++) {
        j = k = 0;

	/* fprintf(stdout, "i: %ld\n", i);*/

        while(lutefiskResult[i].peptide[j] != 0) {
            gQuery[i].nomMass[j] = lutefiskResult[i].peptide[j];
 	    /*fprintf(stdout, "   residue: %ld\n", lutefiskResult[i].peptide[j]);*/
           
            switch(lutefiskResult[i].peptide[j]) {
            
                case  57: /* G */
                        gQuery[i].seq[k++] =  7;
                        break;
                case  71: /* A */
                        gQuery[i].seq[k++] =  0;
                        break;
                case  87: /* S */
                        gQuery[i].seq[k++] = 15;
                        break;
                case  97: /* P */
                        gQuery[i].seq[k++] = 14;
                        break;        
                case  99: /* V */
                        gQuery[i].seq[k++] = 19;
                        break;    
                case 101: /* T */
                        gQuery[i].seq[k++] = 16;
                        break;
                case 103: /* C */
                        gQuery[i].seq[k++] =  4;
                        break;
                case 113: /* I/L */
                        gQuery[i].seq[k++] = 10;
                        break;        
                case 114: /* N */
                        gQuery[i].seq[k++] =  2;
                        break;        
                case 115: /* D */
                        gQuery[i].seq[k++] =  3;
                        break;        
                case 128: /* K/Q */
                        gQuery[i].seq[k++] = 11;
                        break;
                case 129: /* E */
                        gQuery[i].seq[k++] =  6;
                        break;
                case 131: /* M */
                        gQuery[i].seq[k++] = 12;
                        break;
                case 137: /* H */
                        gQuery[i].seq[k++] =  8;
                        break;
                case 147: /* F */
                        gQuery[i].seq[k++] = 13;
                        break;
                case 156: /* R */
                        gQuery[i].seq[k++] =  1;
                        break;        
                case 163: /* Y */
                        gQuery[i].seq[k++] = 18;
                        break;        
                case 186: /* W */
                        gQuery[i].seq[k++] = 17;
                        break;    
                default: /* must be a dipeptide. Call it XX */
                        gQuery[i].seq[k++] = 22;
                        gQuery[i].seq[k++] = 22;
                        gQuery[i].length++; /* This is to double increment the query length */
                        j++;
                        lutefiskResult[i].peptide[j] = 0; // Remove the -200 dummy mass
                        break;
                        
            }
            j++;
            gQuery[i].length++;
        }
    }
}
/* -------------------------------------------------------------------------
//  AllocateQueryStructure
*/
void AllocateQueryStructure(long numOfQueries) {

    if ((gQuery = (tquery *)calloc((size_t)numOfQueries, sizeof(tquery))) == NULL) {
        fprintf(stderr," cannot allocate query array\n");
        exit(1);
    }
}
/* -------------------------------------------------------------------------
//  HashQuerySequences - hash sequence 0 for rapid lookup of seq 1 (library)
*/
void HashQuerySequences(long numOfQueries, long ktup) {

    long mhv;
    long phv;
    long i, j;
    long hv;

    if (pamfact == -1) pamfact = 0;
    else if (pamfact== -2) pamfact = 1;


    kt1 = ktup - 1;

    hmax = 375;
      AllocateHashArrays(numOfQueries, hmax);

    for (j = 0; j < numOfQueries; j++) {
        for (i = 0; i < hmax; i++) gQuery[j].hashArray[i] = -1;
        for (i = 0; i < gQuery[j].length; i++) gQuery[j].link[i] = -1;
    
        /* encode the gQuerySeqArray array */
    
        i = phv = hv = 0;
    
         for (; i < gQuery[j].length; i++) {
            hv = gQuery[j].seq[i];
            /* Move any previous value to the link array */
            gQuery[j].link[i] = gQuery[j].hashArray[hv]; 
            gQuery[j].hashArray[hv] = i;
            if (pamfact) {
                gQuery[j].pamh2[hv] = (phv += pam2[gQuery[j].seq[i]][gQuery[j].seq[i]] * ktup);
                phv -= pam2[gQuery[j].seq[i - kt1]][gQuery[j].seq[i - kt1]] * ktup;
            }
            else gQuery[j].pamh2[hv] = fact * ktup;
        }
    }
    
    if (pamfact)
        for (i = 0; i < nsq; i++) pamh1[i] = pam2[i][i] * ktup;
    else
        for (i = 0; i < nsq; i++) pamh1[i] = fact;
}

/* -------------------------------------------------------------------------
//  AllocateHashArrays 
*/
void AllocateHashArrays(long numOfQueries, long hmax) {

    long i;
    
    for (i = 0; i < numOfQueries; i++) {
        if ((gQuery[i].hashArray = (long *)calloc((size_t)hmax, sizeof(long))) == NULL) {
            fprintf(stderr," cannot allocate hash array\n");
            exit(1);
            }
        if ((gQuery[i].pamh2 = (long *)calloc((size_t)hmax, sizeof(long))) == NULL) {
            fprintf(stderr," cannot allocate pamh2 array\n");
            exit(1);
            }
        if ((gQuery[i].link = (long *)calloc((size_t)gQuery[i].length, sizeof(long))) == NULL) {
            fprintf(stderr," Cannot allocate hash link array!");
            fprintf(stderr," Query: %ld, length: %d\n", i, gQuery[i].length);
            exit(1);
        }
    }    
}

/* -------------------------------------------------------------------------
//  FreeHashArrays 
*/
void FreeHashArrays(void) {

    long i;
    
    for (i = 0; i < gNumOfQueries; i++) {
        free(gQuery[i].hashArray); 
        free(gQuery[i].link); 
        free(gQuery[i].pamh2);
    }    
}

/* -------------------------------------------------------------------------
//  ScoreRunWithMatrix - Takes a single diagonal run and finds the highest scoring
//                       run that it contains as evaluated by using the scoring
//                       matrix currently loaded in the array pam2.
*/
long ScoreRunWithMatrix(beststr *dmax, tquery *query) {

      long             theLibFilePos;
      register long    theTotal = 0;
      register char     *theQuerySeqP;
      register char     *theLibSeqP;

    struct {
          long start;
          long stop; 
          long score;
      } theCurrentRun, theBestRun;
      
            
    theLibSeqP = &aa1[theLibFilePos = dmax->dp - noff]; 
    theQuerySeqP = query->seq;
    
    if (theLibFilePos < 0) { /* Make sure we didn't back up past the N-terminus */
        theQuerySeqP += aa1 - theLibSeqP;
        theLibSeqP = &aa1[theLibFilePos = 0];
    }
    
      theCurrentRun.start = theLibFilePos;

      theCurrentRun.score = theBestRun.score = 0;
      for (; theQuerySeqP < &query->seq[query->length] && theLibFilePos < n1;
           theLibFilePos++) {
          
          if (*theQuerySeqP == 22) { /* 22 is 'X' which indicates an XX dipeptide */
              /* If the dipeptide mass is equal to the mass of the current 
                 library sequence residue plus the mass of the next residue ... */
              if (query->nomMass[theQuerySeqP - query->seq] ==
                  gNomMass[*theLibSeqP] + gNomMass[*(theLibSeqP + 1)]) {
                  
                  theTotal += pam2[*theLibSeqP][*theLibSeqP] + pam2[*(theLibSeqP+1)][*(theLibSeqP+1)];    
              }
              theLibSeqP+= 2;
            theQuerySeqP+= 2;
            theLibFilePos++;    
          }
        else theTotal += pam2[*theQuerySeqP++][*theLibSeqP++];
        
        if (theTotal > theCurrentRun.score) {
              theCurrentRun.stop  = theLibFilePos;
              theCurrentRun.score = theTotal;
        }
        else if (theTotal < 0) {
              if (theCurrentRun.score > theBestRun.score) {
                theBestRun.start = theCurrentRun.start;
                theBestRun.stop  = theCurrentRun.stop;
                theBestRun.score = theCurrentRun.score;
              }
              theTotal = theCurrentRun.score = 0;
              theCurrentRun.start = theLibFilePos;
        }
      }

      if (theCurrentRun.score > theBestRun.score) {
        theBestRun.start = theCurrentRun.start;
        theBestRun.stop  = theCurrentRun.stop;
        theBestRun.score = theCurrentRun.score;
    }

    dmax->start = theBestRun.start;
    dmax->stop = theBestRun.stop;

    return theBestRun.score;
}
/* -------------------------------------------------------------------------
//  RescoreBestRunWithMatrix - Takes the highest scoring diagonal run and tries
//                             to improve it by taking into account 2 for 1, 
//                             2 for 2, or 3 for 2 mass equivalences.
*/
#define MAX_PATHS 10

long RescoreBestRunWithMatrix(beststr *dmax, tquery *query) {

      register char     *theQuerySeqP;
      register char     *theLibSeqP;
      char            theRescoreMatrix[50][50];
    char            *theLibMatchRegionStartP;
    register char    *theLibMatchRegionEndP;
     register char     *theQuerySeqEndP;
      register long    i, j;
      register long    theTotal;
      register long    theMatrixLibIndex;
      register long    pathIndex;
      long            k;
      long            theLibFilePos;
    long            theLimit;
    
    struct {
          long start;
          long stop; 
          long currentPositioni;
          long currentPositionj;
          long score;
      } theBestRun, thePath[MAX_PATHS];
      

      
    theBestRun.start = dmax->start;
    theBestRun.stop  = dmax->stop;
    theBestRun.score = dmax->score;
    
      // Set the library seq start pointer to a little before the match region
    theLibMatchRegionStartP = &aa1[theLibFilePos = dmax->dp - noff - 5]; 
    if (theLibFilePos < 0) { // Make sure we didn't back up past the N-terminus 
        theLibMatchRegionStartP = &aa1[theLibFilePos = 0];
    }
    // Set the library seq stop pointer to a little past the match region
    theLibMatchRegionEndP = theLibMatchRegionStartP + query->length + 10;
    if (theLibMatchRegionEndP > &aa1[n1]) { // Make sure we didn't go past the C-terminus 
        theLibMatchRegionEndP = &aa1[n1];
    }
    
    theQuerySeqEndP = &query->seq[query->length];
    
    // Now fill in the rescore matrix.  It will contain flags to indicate places where 2 for 2,
    // 1 for 2, and 2 for 1 substitutions are possible.
    for (i = 0, theLibSeqP = theLibMatchRegionStartP; 
         theLibSeqP < theLibMatchRegionEndP; theLibSeqP++, i++) {
        
        for (theQuerySeqP = query->seq, j = 0; theQuerySeqP < theQuerySeqEndP; theQuerySeqP++, j++) {
            
            theRescoreMatrix[i][j] = 0;    // Zero the matrix position           
            
            if (*theLibSeqP < 20) {  // Ignore if B, Z, or X is in the 1st library position
            
                switch (*theLibSeqP) { // Take care of the case where 2 query residues = 1 lib residue
                    case  1: // R
                        if (gNomMass[*theQuerySeqP] + gNomMass[*(theQuerySeqP + 1)] == 156) {
                            theRescoreMatrix[i][j] = 3;
                        }
                        break;
                    case  2: // N
                        if (gNomMass[*theQuerySeqP] + gNomMass[*(theQuerySeqP + 1)] == 114) {
                            theRescoreMatrix[i][j] = 3;
                        }
                        break;
                    case  5: // Q
                    case 11: // K
                        if (gNomMass[*theQuerySeqP] + gNomMass[*(theQuerySeqP + 1)] == 128) {
                            theRescoreMatrix[i][j] = 3;
                        }
                        break;    
                    case 17: // W
                        if (gNomMass[*theQuerySeqP] + gNomMass[*(theQuerySeqP + 1)] == 186) {
                            theRescoreMatrix[i][j] = 3;
                        }
                        break;
                }    
                
                if (*(theLibSeqP + 1) < 20) {  // Ignore if B, Z, and X is in the 2nd lib. position
                
                    switch (*theQuerySeqP) { // Take care of the case where 1 query residue = 2 lib residues
                        case  1: // R
                            if (gNomMass[*theLibSeqP] + gNomMass[*(theLibSeqP + 1)] == 156) {
                                if (theQuerySeqP < theQuerySeqEndP - 1) theRescoreMatrix[i][j] = 2;
                            }        
                            break;
                        case  2: // N
                            if (gNomMass[*theLibSeqP] + gNomMass[*(theLibSeqP + 1)] == 114) {
                                theRescoreMatrix[i][j] = 2;
                            }
                            break;
                        case  5: // Q
                        case 11: // K
                            if (gNomMass[*theLibSeqP] + gNomMass[*(theLibSeqP + 1)] == 128) {
                                if (theQuerySeqP < theQuerySeqEndP - 1) theRescoreMatrix[i][j] = 2;
                            }
                            break;    
                        case 17: // W
                            if (gNomMass[*theLibSeqP] + gNomMass[*(theLibSeqP + 1)] == 186) {
                                theRescoreMatrix[i][j] = 2;
                            }
                            break;
                    }
            
                    if (theQuerySeqP == theQuerySeqEndP - 1) break; // Keep the last query position
                                                                    // from going below here
                    
                    // Take care of the case where 2 query residues = 2 lib residues
                    if (*theQuerySeqP != *theLibSeqP && gNomMass[*theLibSeqP] + gNomMass[*(theLibSeqP + 1)] ==
                        query->nomMass[theQuerySeqP - query->seq] + query->nomMass[theQuerySeqP - query->seq + 1]) {
                        // Don't let in dipeptide matches casused by I/L or Q/K mismatches
                         if ((*theQuerySeqP == 10 && *theLibSeqP == 9) ||
                             (*theQuerySeqP == 11 && *theLibSeqP == 5)) {
                             
                         }    
                        else theRescoreMatrix[i][j] = 1;            
                    } 
                }    
            }            
        }
    }
    
    
    // Now evaluate the rescore matrix to find the best alignment score
    theLimit =     theLibMatchRegionEndP - theLibMatchRegionStartP;
       for (theMatrixLibIndex = 0; theMatrixLibIndex < theLimit; theMatrixLibIndex++) {
                 
        // Blank the paths 
        for (i = 0; i < MAX_PATHS; i++) {
            thePath[i].start = -1; 
        }
        
        thePath[0].start = theLibFilePos + theMatrixLibIndex;     
        thePath[0].currentPositioni = theMatrixLibIndex;
        thePath[0].currentPositionj = 0;
        thePath[0].score = 0;
        
        theLibSeqP = theLibMatchRegionStartP + theMatrixLibIndex; 
        
          // N-terminus is potential cleavage site? Then give a bonus 
          if (theLibSeqP > &aa1[0]) {
              long limit = strlen(gNtermBonus);
              for (i = 0; i < limit; i++) {
                  if (*(theLibSeqP - 1) == aascii[gNtermBonus[i]]) {
                      thePath[0].score = pam2[*(theLibSeqP - 1)][*(theLibSeqP - 1)];
                  }
              }        
          }
          // If it is at the start of the sequence then give it a lys bonus
          else if (theLibSeqP == &aa1[0]) thePath[0].score = pam2[11][11];

        pathIndex = 0;
        while (thePath[pathIndex].start > -1 && pathIndex < MAX_PATHS) {
            
            i = thePath[pathIndex].currentPositioni;
            j = thePath[pathIndex].currentPositionj;
            theTotal = thePath[pathIndex].score;
            
              if (thePath[pathIndex].score > theBestRun.score) {
                theBestRun.start = thePath[pathIndex].start;
                theBestRun.stop  = thePath[pathIndex].stop;
                theBestRun.score = thePath[pathIndex].score;
              }
            
            theLibSeqP = theLibMatchRegionStartP + i;
            theQuerySeqP = query->seq + j;
            while (theLibSeqP < theLibMatchRegionEndP && theQuerySeqP < theQuerySeqEndP) {
                
                
                  if (theRescoreMatrix[i][j]) { // The possibility for some substitution exists.  
                                                // Evaluate to find the best scoring option.
                      if (theRescoreMatrix[i][j] == 1) { // A 2 for 2 substitution possibility
                          if (*(theQuerySeqP) == 22) {
                              theTotal += pam2[*(theLibSeqP)][*(theLibSeqP)];
                              theTotal += pam2[*(theLibSeqP+1)][*(theLibSeqP+1)];
                          }
                          else {
                              theTotal += pam2[*(theLibSeqP)][*(theLibSeqP)]/2;
                              theTotal += pam2[*(theLibSeqP+1)][*(theLibSeqP+1)]/2;
                          }    
                      }
                      else { // Spawn a new path
                          for (k = pathIndex+1; k < MAX_PATHS; k++) {
                              if (thePath[k].start == -1) { // Found an empty path
                                  if (theRescoreMatrix[i][j] == 3) { 
                                      // 1 lib residue for 2 query residues
                                      thePath[k].start = thePath[pathIndex].start;
                                      thePath[k].stop  = theLibFilePos + i;
                                      thePath[k].currentPositioni = i + 1;
                                      thePath[k].currentPositionj = j + 2;
                                      thePath[k].score = theTotal + 
                                                         pam2[*(theLibSeqP)][*(theLibSeqP)];
                                      
                                  }
                                  else if (theRescoreMatrix[i][j] == 2) { 
                                      // 1 query residue for 2 lib residues
                                      thePath[k].start = thePath[pathIndex].start;
                                      thePath[k].stop  = theLibFilePos + i + 1;
                                      thePath[k].currentPositioni = i + 2;
                                      thePath[k].currentPositionj = j + 1;
                                      thePath[k].score = theTotal + pam2[*(theQuerySeqP)][*(theQuerySeqP)];
                                                        /* pam2[*(theLibSeqP)][*(theLibSeqP)] +
                                                         pam2[*(theLibSeqP + 1)][*(theLibSeqP + 1)];
                                      */
                                  }
                                  break;    
                              }
                          }
                          theTotal += pam2[*(theLibSeqP)][*(theQuerySeqP)];
                      }
                  }
                  else {
                    theTotal += pam2[*(theLibSeqP)][*(theQuerySeqP)];
                  }
                          
                if (theTotal > thePath[pathIndex].score) {
                      thePath[pathIndex].stop  = theLibFilePos + i;
                      thePath[pathIndex].score = theTotal;
                }
                else if (theTotal < 0) {
                      if (thePath[pathIndex].score > theBestRun.score) {
                        theBestRun.start = thePath[pathIndex].start;
                        theBestRun.stop  = thePath[pathIndex].stop;
                        theBestRun.score = thePath[pathIndex].score;
                      }
                      theTotal = thePath[pathIndex].score = 0;
                      thePath[pathIndex].start = theLibFilePos + i;
                } 
                // Now take a step  
                if (theRescoreMatrix[i][j] == 1) { 
                      i+=2; // Take 2 steps down the diagonal
                      j+=2;
                      theLibSeqP+=2;
                      theQuerySeqP+=2;
                  }
                  else {
                      i++;
                      j++;
                      theLibSeqP++;
                      theQuerySeqP++;
                  }    
                
                
            }    
            
            if (thePath[pathIndex].score > theBestRun.score) {
                theBestRun.start = thePath[pathIndex].start;
                theBestRun.stop  = thePath[pathIndex].stop;
                theBestRun.score = thePath[pathIndex].score;
            }
            
            pathIndex++;
        }    
      }

    dmax->start = theBestRun.start;
    dmax->stop = theBestRun.stop;

    return theBestRun.score;
}
