
// ANSI headers
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

// FASTA headers
#include "ffasta.h"
#include "getenv.h"

#define FILE_NAME_SIZE   80
#define MAX_FILE_NAMES   100
#define MAX_RESULTS    15000

#if (defined(__MWERKS__))
#if (__dest_os	== __mac_os)
#include <Types.h>
#include <StandardFile.h>
#include <sioux.h>
#include "getopt.h"
	StandardFileReply freply;
	Point wpos;
	long tval;
	char prompt[256];
#define getenv mgetenv
#else if (__dest_os == __win32_os)
#endif
    extern short optind;
#else 
    extern int optind;
#endif

FILE *outfd;		/* fd for output file */


char rline[20],sline[20];
char resfile[FILE_NAME_SIZE];
char listFile[FILE_NAME_SIZE];


	long outtty;

#if (defined(__MWERKS__)  && __dest_os	== __mac_os)
	FSSpec ouSpec, q0Spec, q1Spec;
	OSErr error;
#endif


char *iprompt1=" File with paths to CIDentify files to correlate: ";


struct SequenceScore lutefiskResult[LUTEFISK_QUERY_LIMIT];
long gNumOfQueries = 0;
tquery *gQuery;

double gScore0Sum = 0;
double gScore0SqrSum = 0;
double gStdDev;

long 	gNumOfFiles;
char 	fileName[MAX_FILE_NAMES][FILE_NAME_SIZE];

long	gNumOfResults;
 	
typedef struct {
	char	seqName[76];
	long	rankScore;
	long	totalInitSum;
	long    count;
} tResults;

tResults
#ifndef FAR_PTR
	  		**gResultP;	/* array of pointers for sorting */
#else
	  		huge * huge * gResultP;
#endif


/* Private function prototypes */
void initenv(long argc, char **argv);
void usage(void);
static long GetResultFileNames(char *theFileName);
static void AllocateResutsPointerArray(long numToAllocate);
static void SortResults(void);
static void ksort(void *v[], long n,long (*comp)());
#ifdef FAR_PTR
	static void fksort(void huge * huge *v, long n, long (*comp)());
#endif
static long RankSort(tResults *ptr1, tResults *ptr2);
#ifdef FAR_PTR
	static long FRankSort(tResults huge *ptr1, tResults huge *ptr2);
#endif
static void RemoveTrailingBlanks(char *string);
static void RemoveDoubleBlanks(char *string);
static void ShowBest(void);
static char *my_fgets(char *s, long n, FILE *fp);

/*=============================================================================
*/
main(long argc, char **argv)
{
 
  	char llname[FILE_NAME_SIZE];
  	char qline[FILE_NAME_SIZE];
  	char *cptr;
  	char *bp;
  	long itemp;
  	long iln;
  	long i, j;
  	long theMeanScore0;
  	FILE  *fptr;
	char  line[512];
	long  ic;
	long  sstart, sstop, sset=0;
	long  sq0off = 0;
	long  seqPos;
	short	currentFile;
	char    *theFileName;
	long	oldNumResults;
	long	initSum;
	long	theRank;
	long	theCutoff = 0;
	short  theFlag;
	tResults *theCurrentResultP;
	char *iprompt0="CIDentifyRC combines multiple CIDentify result files from the same protein\n\n";
	short longLineFlag = false;
	char  descriptor[75];
	
	outtty = 1;
	
#if (defined(__MWERKS__)  && __dest_os	== __mac_os)
  	SIOUXSettings.showstatusline = false;
  	SIOUXSettings.asktosaveonclose = true;
  	SIOUXSettings.autocloseonquit = true;
 
  	argc = ccommand(&argv);
/*
  	if (OpenResFile("\pFASTA.rsrc")<0) {
    	SysBeep(100);
    	fprintf(stderr," WARNING FASTA.rsrc file could not be found\n");
  	}
*/
  	InitEvent();

  	error=HGetVol(NULL,&ouSpec.vRefNum, &ouSpec.parID);
  	if (error != noErr) {
  		fprintf(stderr," cannot get current directory\n");
  		exit(1);
  	}
  	wpos.h=50; wpos.v=100;
#endif

#ifdef UNIX
  	outtty=isatty(1);
#else
  	outtty=1;
#endif

	initenv(argc,argv);

#if (defined(__MWERKS__)  && __dest_os == __mac_os)
  	if (!outtty) SIOUXSettings.asktosaveonclose=FALSE;
#endif
  
	if (strlen(listFile) == 0) {
#if (defined(__MWERKS__)  && __dest_os == __mac_os)
l1:	SFileDlog(iprompt1,&freply);
    if (freply.sfGood==TRUE) {
      	PtoCstr((unsigned char *)freply.sfFile.name);
      	strcpy(listFile,(char *)freply.sfFile.name);
	  	q1Spec.vRefNum = q0Spec.vRefNum = freply.sfFile.vRefNum;
	  	q1Spec.parID = q0Spec.parID = freply.sfFile.parID;
	  	HSetVol(NULL,q0Spec.vRefNum,q0Spec.parID);
    }
    else exit(0);
#else
    fputs(iprompt0,stdout);
l1:	fputs(iprompt1,stdout);
    fflush(stdout);
    if (fgets(listFile,sizeof(listFile),stdin)==NULL) exit(0);
    if (listFile[strlen(listFile)-1]=='\n') listFile[strlen(listFile)-1]='\0';
    if (listFile[0]=='\0') goto l1;
#endif
    }

    if (GetResultFileNames(listFile) == 0) {
      	fprintf(stderr," %s file not found\n",listFile);
      	goto l1;
    }
  
  	if (gNumOfFiles <= 0) {
  	    fprintf(stderr,"No file names found.  Quitting.\n");
  	    exit(0);
  	}
 
  	AllocateResutsPointerArray((long)MAX_RESULTS);
 	
#if (defined(__MWERKS__)  && __dest_os == __mac_os)
	HSetVol(NULL,ouSpec.vRefNum,ouSpec.parID);
#endif

 	// Get a name for the output file and open it
 	outfd = stdout;
l3:     if (strlen(resfile) == 0) {
		printf(" Enter filename for results [%s]: ",resfile); 
		fflush(stdout);
	}
  	rline[0]='\0';
  	
#if (defined(__MWERKS__)  && __dest_os == __mac_os)
  	if (outtty && my_fgets(rline,sizeof(rline),stdin) == NULL) exit(0);
#else
  	if (outtty && fgets(rline,sizeof(rline),stdin) == NULL) exit(0);
#endif

  	if ((bp=strchr(rline,'\n'))!=NULL) *bp = '\0';
  	if (rline[0]!='\0') strncpy(resfile,rline,sizeof(resfile));
  	if (resfile[0]!='\0') {
    	if ((outfd=fopen(resfile,"w"))==0) {
    		printf(" could not open %s\n",resfile);
      		goto l3;
    	}
   	}
 	
 	fprintf(outfd,"\nFor the results files:\n");
 	if (outfd != stdout) printf("\nFor the results files:\n");
 	
 	// Loop through the files to correlate
	for (currentFile = 0; currentFile < gNumOfFiles; currentFile++) {
	
		theFileName = fileName[currentFile];

		// Try to open the file
		if ((fptr = fopen(theFileName,"r")) == NULL) {
			fprintf(outfd," %s (Could not be opened)\n",theFileName);
	
			if (outfd != stdout)
	    		printf(" %s (Could not be opened)\n",theFileName);
			
			continue;
		}
		else {
			fprintf(outfd," %s\n", theFileName);
			if (outfd != stdout) printf(" %s\n", theFileName);
		}	
		
		// Read the results into the array.
		theRank = 200;
		longLineFlag = false;
		
#ifdef __MWERKS__  	
  		while(my_fgets(line,sizeof(line),fptr) != NULL) {
#else
	  	while(fgets(line,sizeof(line),fptr) != NULL) {
#endif		
		
			if (!strstr(line,"The best scores are:") && !strstr(line,"Advanced options:")) continue;
			if (strstr(line,"Advanced options:")) longLineFlag = true;
			
#ifdef __MWERKS__  	
  			while(my_fgets(line,sizeof(line),fptr) != NULL) {
#else
	  		while(fgets(line,sizeof(line),fptr) != NULL) {
#endif				
				if (line[0] == '\n' || line[0] == '\r') continue;
				if ((strlen(line) > 1 && strlen(line) < 40) || line[0] == '>') break;
				theFlag = false;
				
				if (longLineFlag) {
					line[76] = '\0';
					line[89] = '\0';
					initSum = atoi(&line[81]);
					strcpy(descriptor, &line[11]);
				}
				else {
					/*line[49] = '\0';
					line[63] = '\0';
					initSum = atoi(&line[63]);*/
					line[65] = '\0';
					initSum = atoi(&line[71]);
					strcpy(descriptor, &line[0]);
				}	
				RemoveTrailingBlanks(descriptor);
				RemoveDoubleBlanks(descriptor);
				
				for (i = 0; i < gNumOfResults; i++) {
					if (!strcmp(descriptor, gResultP[i]->seqName)) {
						gResultP[i]->rankScore += theRank;
						gResultP[i]->totalInitSum += initSum;
						gResultP[i]->count++;
						theFlag = true;
						break;
					}
				}
				if (!theFlag) {
					// It's a new seq. so add it to the list
					if (gNumOfResults >= MAX_RESULTS) {
						SortResults();
						gNumOfResults = MAX_RESULTS - 50;
						theCutoff = gResultP[gNumOfResults - 1]->rankScore;
					}
					
					if (theRank >= theCutoff) {
						if ((theCurrentResultP = 
							(tResults*)calloc((size_t)1,sizeof(tResults))) == NULL) break;
							
						gResultP[gNumOfResults] = theCurrentResultP;
						strcpy(gResultP[gNumOfResults]->seqName,descriptor);
						gResultP[gNumOfResults]->rankScore = theRank;
						gResultP[gNumOfResults]->totalInitSum = initSum;
						gResultP[gNumOfResults]->count = 1;
						gNumOfResults++;
					}
				}
				
				theRank--;
				if (theRank <= 0) break;
			}
			if (theRank <= 0) break;
		}	
		
		fclose(fptr);
  	}  
    
    SortResults();
   	
  	ShowBest(); 	
} 

/*=============================================================================
*/
static long GetResultFileNames(char *theFileName)
{
	FILE  *fptr;
	char  line[512];
	char  *bp;
	long  i, j;
	long  ic;
	long  sstart, sstop, sset=0;
	long  theNumOfFiles;
	long  sq0off = 0;
	long  seqPos;
	
/*	
	sstart = sstop = -1;
#ifndef MSDOS
	if ((bp=strchr(theFileName,':')) != NULL) 
#else
	if ((bp=strchr(theFileName+3,':')) != NULL) 
#endif
	{
	  *bp='\0';
	  if (*(bp+1)=='-') sscanf(bp+2,"%d",&sstop);
	  else sscanf(bp+1,"%d-%d",&sstart,&sstop);
	  sset=1;
	}
*/
	// Try to open the file
	if ((fptr=fopen(theFileName,"r"))==NULL) {
		fprintf(stderr," could not open %s\n",theFileName);
		return 0;
	}
/*
	if (sset==1) {
	  theFileName[strlen(theFileName)]=':';
	  if (sq0off==1 || sstart>1) sq0off = sstart;
	}
*/
	// Read the results file names into the fileName array.
	theNumOfFiles = 0;
	
#ifdef __MWERKS__  	
  	while(my_fgets(line,sizeof(line),fptr) != NULL) {
#else
	while(fgets(line,sizeof(line),fptr) != NULL) {
#endif		
		
		if (line[0] != ';') {
			i = 0; 
			while (line[i] != '\n' && line[i] != '\r' && line[i] != '\0' && i < FILE_NAME_SIZE - 1) i++;
			line[i] = '\0';
			if (strlen(line)) {
				strcpy(fileName[theNumOfFiles], line);
				theNumOfFiles++;
				if (theNumOfFiles == MAX_FILE_NAMES) break;
			}	
		}
	}	
	gNumOfFiles = theNumOfFiles;
	
	fclose(fptr);

	return true;
}
/*==========================================================
//  AllocateResutsPointerArray - allocate arrays for best sort
*/
#ifdef FAR_PTR
	#ifdef __TURBOC__
		#define FCALLOC farcalloc
		#define MTYPE unsigned long
		#define FFREE farfree
	#endif
#endif

static void AllocateResutsPointerArray(long numToAllocate)		
{
#ifndef FAR_PTR
	if ((gResultP = (tResults **)calloc((size_t)numToAllocate,sizeof(tResults *))) == NULL) {
		fprintf(stderr,"cannot allocate bptr\n"); 
		exit(1);
	}

#else	/* FAR_PTR */
	void far *FCALLOC();
	if ((gResultP = (tResults huge * huge *)
	     FCALLOC((MTYPE)numToAllocate,(MTYPE)sizeof(tResults huge *))) == NULL) {
	  	fprintf(stderr,"cannot allocate bptr\n"); 
	  	exit(1);
	}
#endif	/* FAR_PTR */
}
/*=============================================================================
*/
static void SortResults(void)
{
#ifndef FAR_PTR
//	long RankSort();
	
	ksort((void *)gResultP, gNumOfResults, RankSort);
#else
//    long FRankSort();
    
	fksort((void *)gResultP, gNumOfResults, FRankSort);
#endif
}
/*=============================================================================
*/
static void ksort(void *v[], long n,long (*comp)())
{
  long gap, i, j;
  char *tmp;
	
  	for (gap=n/2; gap>0; gap/=2)
    	for (i=gap; i<n; i++)
      		for (j=i-gap; j>=0; j -= gap) {
				if ((*comp)(v[j],v[j+gap]) <= 0) break;
				tmp = v[j]; 
				v[j]=v[j+gap]; 
				v[j+gap] = tmp;
 			}
}

/*=========================================================
*/
#ifdef FAR_PTR
static void fksort(void huge * huge *v, long n, long (*comp)())
{
  long gap, i, j;
  void huge *tmp;
	
	for (gap=n/2; gap>0; gap/=2)
		for (i=gap; i<n; i++)
      		for (j=i-gap; j>=0; j -= gap) {
	    		if ((*comp)(v[j],v[j+gap]) <=0) break;
	    		tmp = v[j]; 
	    		v[j]=v[j+gap]; 
	    		v[j+gap]=tmp;
      		}
}
#endif
/*=============================================================================
//  RankSort
*/
static long RankSort(tResults *ptr1, tResults *ptr2)
{
  if (ptr1->rankScore < ptr2->rankScore) return (1);
  else if (ptr1->rankScore > ptr2->rankScore) return (-1);
  else if (ptr1->totalInitSum < ptr2->totalInitSum) return (1);
  else if (ptr1->totalInitSum > ptr2->totalInitSum) return (-1);
  else return (0);
}
/*=============================================================================
//  FRankSort
*/
#ifdef FAR_PTR

static long FRankSort(tResults huge *ptr1, tResults huge *ptr2) 
{
  if (ptr1->rankScore < ptr2->rankScore) return (1);
  else if (ptr1->rankScore > ptr2->rankScore) return (-1);
  else return (0);
}
#endif
/*=======================================================
*/
static void RemoveTrailingBlanks(char *string)
{
	char *p;

	p = string + strlen(string) - 1;
	
	while (*p == ' ') {
		*p = '\0';
		p--;
	}
	
}
/*=======================================================
*/
static void RemoveDoubleBlanks(char *string)
{
	char *p;
	char *q;
	long i;
	
	if ((p = calloc((size_t)(strlen(string) + 1),sizeof(char))) == NULL) {
		fprintf(stderr,"cannot allocate new string\n"); 
		exit(1);
	}
	q = p;
	
	i = 0;
	while (i <= strlen(string)) {
		if (string[i] == ' ' && string[i-1] == ' ') {
			i++;
			continue;
		}
		else *q = string[i];
		i++;
		q++;
	}
	
	strcpy(string, p);
	
	free(p);
}
/*=======================================================
*/

static void ShowBest(void)
{
	long 	i, istart, istop;
	char bline[200], fmt[40], pad[200];
	long ntmp;
	long	llen = 60;
	long lcont, ccont, loff;
	char *aa1ptr;
	long olib;
	long	nshow = 100;


	sprintf(fmt,"%%-%ds",llen-10);


	nshow = min(nshow,gNumOfResults);
	if (outtty) {
		printf(" How many scores would you like to see? [%d] ",nshow);
		fflush(stdout);
		
#ifdef __MWERKS__  	
		if (my_fgets(rline,sizeof(rline),stdin)==NULL) exit(0);
#else
		if (fgets(rline,sizeof(rline),stdin)==NULL) exit(0);
#endif			
		if (rline[0]!='\n' && rline[0]!=0) sscanf(rline,"%d",&nshow);
		if (nshow<=0) nshow = min(20,gNumOfResults);
	}
	
	fprintf(outfd,"\n\nThe overall best scores are:                                          Rank Sum   init1 Sum   #\n");

	if (outfd != stdout) 
		printf("\n\nThe overall best scores are:                                          Rank Sum   init1 Sum   #\n");
		    	

	istart = 0;
	istop = min(gNumOfResults,nshow);
	for (i=istart; i<istop; i++) {
		gResultP[i];

		fprintf(outfd,"%-65.65s     %5ld        %5ld    %2ld\n",gResultP[i]->seqName,
	    	          gResultP[i]->rankScore, gResultP[i]->totalInitSum, gResultP[i]->count);
	
		if (outfd != stdout)
	    	printf("%-65.65s     %5ld        %5ld    %2ld\n",gResultP[i]->seqName,
	    	       gResultP[i]->rankScore, gResultP[i]->totalInitSum, gResultP[i]->count);
	}
	 
	fflush(outfd); 
	if (outfd!=stdout) fflush(stdout);


	if (outfd!=stdout) fprintf(outfd,"\n");
}

/* -------------------------------------------------------------------------
//  my_fgets 
*/
char *my_fgets(char *s, long n, FILE *fp)
{
	register char *t = s;
	register long c;
	
	if (n < 1)
		return(NULL);
	while (--n) {
		if ((c = getc(fp)) < 0) {
            if (feof(fp) && t != s) break;
            return(NULL);
        }
        *t++ = c;
        if (c == '\n' || c == '\r' || c == '\32')
            break;
    }
    *t = '\0';
    return(s);
}
/*========================================================================
*/
void initenv(long argc, char **argv)
{
    char *cptr;
    long copt;
    extern char *optarg;
    long i;
	
    while ((copt = getopt(argc,argv,"ho:O:q")) != EOF) {
    	switch(copt) {
	    case 'h': 
		usage();
	        exit(0);
	        break;

	    case 'q': outtty = 0; break;
	    case 'o':
	    case 'O': strncpy(resfile,optarg,sizeof(resfile));
	              break;

	    default : fprintf(stderr," illegal option -%c\n",copt);
	}	
    }
	
    optind--;


    if (argc - optind > 1 && !strlen(listFile))
    	strcpy (listFile, argv[optind + 1]);
  
}

/*=============================================================================
*/
void usage(void)
{

  printf("USAGE: CIDentifyRC [- options] files_to_process\n\n"); 
  printf("      [-q]  Quiet mode\n");
  printf("      [-O]  Output file name when using quiet mode\n");
 
  printf("      [-h]   prints this usage\n");
  
  
  fflush(stdout);

}

