/*      fffasta.c         12-Feb-1984, 11-Mar-1985, 14-Oct-1985
        copyright (c) 1985,1986,1987,1988,1991,1992      William R. Pearson
*/
/*
	Sept-1991 release 1.6 uses W. Miller l_band, g_band for optimization
	25-Sept-1991	fixed RLOCAL_ALIGN() call in zzlgmata.c

	14-Mar-87	added BIGMEM for large memory machines
	   Mar-87	added TFASTA for translation of DNA
	 1-Jun-87	added LFASTA for lfasta generation from same file
	 3-Jun-87	added SFASTA for sfasta generation from same file
	28-Jun-87	made modifications for speed a la Warren Gish
			changed name to flfasta.c
	24-Aug-87	no more modulus counting in dhash(), 2X as
			fast on the SUN, now MAXDIAG = MAXTST + MAXLIB;
			(ALLOCN0 for modulus counting in LFASTA)
	19-Oct-87	modified behavior for gNumOfBest > MAXBEST, now
			resorts gNumOfBest and throws out bottom 25%
			also modifying bestcut in the process
	12-Nov-87	Added automatic detection of protein/DNA sequences
	28-Feb-88	added getopt for options
	21-Mar-88	added PAM scores for kfact
	25-Mar-88	flag -k for using PAM scores for kfact
	30-Mar-88	added menu for libraries
	30-Mar-88	combine fasta/fastgb, tfasta/tfastgb
	19-May-88	added options for fasta mail processing
			-Q - quiet, does not ask for any input
			with -Q, has heuristic for number of scores
			to display, that number will be less than mshow,
			which is set with the -o option.

	4-Feb-89	modified libchoice for a variety of different
			library formats - no more automatic library setting

	20-Nov-89	1.3a fixed bug in pamfact that prevented -k option
			from working by default with DNA

	5-Jun-90	added optall option
	3-Sept-90	use select() instead of sortbest()
			allow individual library letters to be concatenated
	13-Dec-90	fixed bug in select() due to lack of sentinel.
	23-Jan-91	fixed bug in aatran() for long sequences
	27-Jan-91	made certain than showbest() is called with gNumOfBest>0.
	20-May-91	fixed ashow to reflect nshow
	 7-Dec-92	added -h option to suppress histogram
	13-Dec-92	added -e option to scale scores by length
	26-Aug-95	added -O option to provide filename for output

*/
/*      fastn is a derivative of dfastp for DNA sequences

	fastn is designed to search a DNA sequence database
        very rapidly.  It first looks for diagonals with homology
        using a hashing algorithm.

        General structure:

        Read in the test DNA sequence, build a hash table using
        a hash length of ktup.  DNA bases will be given values
        between 0 and 3 (2 bits) and ktup of 1 to 6 will be allowed
        (hash table of 4 to 1024 entries, on larger machines, 4096
        (ktup=6) would be acceptable).

        Start reading the library.  Reading the library, looking up
        the hash table and accumulating diagonals will all be done
        in one loop.  The max n diagonals will be identified and
        scanned with the PAM matrix for each library sequence.

        The max PAM score and diagonal positions are then saved
        for comparison against the whole library.  After all sequences
        have been examined, a mean and s.d. are calculated and the
        max matches displayed.
*/

/* ANSI headers */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* FASTA headers */
#include "ffasta.h"
#include "getenv.h"
#include "jat.h"
#include "mytime.h"
#include "nxgetaa.h"
#include "pam.h"
#include "scalesws.h"
#include "zzlgmata.h"

#include "upam.gbl"		/* includes pam arrays */


char *refstr="\n Please cite:\n FASTA:W.R. Pearson & D.J. Lipman (1988) PNAS 85:2444-2448\n"
             " CIDentify: J.A. Taylor & R.S. Johnson (1997) Rapid Comm. in Mass Spec. 11:1067-1075\n";
char *verstr="CIDentify v1.0.9 based on FASTA v2.0u6 Aug, 1996";
char *gVersion = "1.0.9";

#ifdef TFASTX
	char *progstr = "TFASTX";
#else
#ifdef TFASTA 
		char *progstr = "TFASTA";
#else
#ifdef FASTX
		char *progstr = "FASTX";
#else
		char *progstr = "FASTA";
#endif
#endif
#endif


#include "mpi.h"       
#define RESULT_PACKET_NBLOCKS  16
 
int array_of_blocklengths[RESULT_PACKET_NBLOCKS] = {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

MPI_Datatype resultPacketType;
MPI_Aint array_of_displacements[RESULT_PACKET_NBLOCKS] = {0,4,8,12,16,20,24,28,32,36,40,44,48,52,56,60};
MPI_Datatype array_of_types[RESULT_PACKET_NBLOCKS] = {MPI_LONG,
                                                      MPI_LONG,
                                                      MPI_FLOAT,
                                                      MPI_LONG,
                                                      MPI_LONG,
                                                      MPI_FLOAT,
                                                      MPI_FLOAT,
                                                      MPI_LONG,
                                                      MPI_LONG,
                                                      MPI_LONG,
                                                      MPI_LONG,
                                                      MPI_LONG,
                                                      MPI_LONG,
                                                      MPI_LONG,
                                                      MPI_LONG,
                                                      MPI_SHORT};


 
int *tracker; /* For tracking which slaves have finished */
int gNumSlaves = 0;
int size, rank;




#if (defined(__MWERKS__)  && __dest_os == __mac_os)
#include "getopt.h"

#include <Types.h>
#include <StandardFile.h>
#include <sioux.h>
	StandardFileReply freply;
	Point wpos;
	long tval;
	char prompt[256];
#define getenv mgetenv	
#else if (defined(__MWERKS__)  && __dest_os == __win32_os)
#define getenv mgetenv	
#endif

#ifndef BIGMEM
#define BIGNUM 32000
#define QFILE_SIZE 40
#define LFILE_SIZE 80

#if defined(TFASTA) || defined(FASTX)
#define MAXTRN 5000	/* MAXTRN must be (MAXTST*3+MAXLIB)/3 */
#endif
#ifdef TFASTX
#define MAXTRN 15000
#endif
#if defined(TFASTA) || defined(TFASTX)
#define MAXTST 1000	/* longest test sequence */
#define MAXLIB 8000
#define MAXDIAG (MAXTST+MAXTRN)
#else
#define MAXTST 2000	/* longest test sequence */
#define MAXLIB 8000
#define MAXDIAG (MAXTST+MAXLIB)
#endif
#else
#define BIGNUM 1000000000
#define QFILE_SIZE 256
#define LFILE_SIZE 256
#define MAXTST 10000 
#define MAXLIB 50000

#if defined(TFASTA) || defined(FASTX)
#define MAXTRN 30000
#endif
#ifdef TFASTX
#define MAXTRN 90000
#define MAXDIAG  (MAXTST+MAXTRN)  /* (MAXTST+MAXLIB) */
#else
#define MAXDIAG  (MAXTST+MAXLIB) 
#endif
#endif

#ifdef LFASTA
#define MAXSAV 250
#endif

#ifndef MAXSAV
#define MAXSAV 10	/* number of best diagonals saved */
#endif

#define MAXHIST 51	/* number of histogram divisions */

#ifndef BIGMEM
#define MAXBEST 5000	/* number of good matches remembered */
#else
#define MAXBEST 20000
#endif

FILE *outfd;		/* fd for output file */
long smark[4];

FILE *tmpfd;
char tmpfname[LFILE_SIZE];
char query_file[QFILE_SIZE];  /* Query file name */
char database_choice[LFILE_SIZE]; /* Database choice */
long dataflg=0;
long revflg = 0;
char *compstr="\0";
long lnsflg=0;
long optwid=32, optwidf=0;	/* width for band optimization */
				/* changed in initparm() */
/* globals for matching */

long lmark;		/* position in library file from ftell() */
long gNumOfLibSequences;      /* number of library sequences */
long theOldNumOfLibSequences;
long gNumOfResiduesScanned;  /*  number of residues scanned */
long theOldNumOfResiduesScanned;		
#ifdef LFASTA
	long oneseq;
#endif

#ifdef NCBIBL13
#define LASTLIB NCBIBL13+1	/* this must agree with altlib.h */
#else
#define LASTLIB 10
#endif

#ifndef LFASTA
	extern long (*getlib)(), (*ranlib)();
#define GETLIB (*getlib)
#define RANLIB (*ranlib)
#else
#define GETLIB getlib
#define RANLIB ranlib
#endif

char libstr[21];	/* partial title from library sequence */
char name0[20], name1[20];	/* for labeling output */
long ixstat;		/* >0 if annotations displayed */

#define MAXLF	200	/* number of library names */
#ifdef BIGMEM
#define MAXLN	QFILE_SIZE	/* size of a library name */
#else
#define MAXLN	QFILE_SIZE
#endif

char *lbnarr;		/* name array of libraries to be opened in list */
char *lbnames[MAXLF];	/* names of libraries to be opened */
long nln;		/* number of library files */

#ifndef LFASTA
	long deftype=0;		/* default library type */
#endif

long libfn;		/* current library file being searched */
char ldname[LFILE_SIZE];

char *aa1;	/* amino acid sequence data */

#if defined(TFASTA)
	char *aa10;
	long nframe=6;
#endif

#ifdef FASTX
#define XFACT 10
	char *aa0x, *aa0y;
	long n0x, n0x31, n0x32;
#else
#ifdef TFASTX
#define XFACT 10
		char *aa0x, *aa0y;
		char *aa10, *aa1y;
		long nframe=2;
		long n1x31, n1x32;
#else
#define XFACT 0
#endif
#endif

long maxn, maxt;		/* max space for lib sequence */
long n1, nd, noff;	/* length of aa1, n0+n1, diagonal offset */
long sq0off=1, sq1off=1;
long loffset = 0l;		/* offset into sequence */

struct dstruct {	/* diagonal structure for saving current run */
        long score;	/* hash score of current match */
        long start;	/* start of current match */
        long stop;	/* end of current match */
		beststr *dmax;	/* location in gBestRunsArray[] where best score data saved */
} *diag;

#ifdef I86BUG
#define L2DSTR 3	/* log(2) of sizeof dstruct for I86 bug in many 'C'
			  			   compilers */
#endif

beststr
#ifndef FAR_PTR
	  *bbp,		/* pointer for fbest */
	  *bestptr,	/* temp pointer */
	  **bptr,	/* array of pointers for sorting */
	  *best,	/* array of best score data */
#else
	  huge * bbp,
	  huge * best,
	  huge * bestptr,	/* temp pointer */
	  huge * huge * bptr,
#endif
	  gBestRunsArray[MAXSAV],	/* best matches saved for one sequence */
	  *gBestRunsArrayPtrs[MAXSAV];


#ifdef LFASTA
	long lcrc0[2*MAXSAV];
	long lcrc1[2*MAXSAV];
	long maxcrc=2*MAXSAV;
	long ncrc;
#endif

#define PI 3.141592654

long iscore, gscore;	/* for displaying scores without showbest */

long cgap;	/* gap threshold */
long pgap;	/* gap penalty for optimized alignment of diagonals */

long gNumOfBest;	/* number of sequences better than bestcut in best */
long bestcut=1; 	/* cut off for getting into MAXBEST */
long optcut=0;	/* cut off for optimization */

/*  the following are defaults for values that are read by
    pam.c from *.mat if SMATRIX is defined */

long histint;
long bestscale=300; /* values for calculating bestcut */
long bestoff=36;	   /* these values are for BLOSUM50 */
long bkfact=6;
long scfact=3;
long bktup=2;
long ktmax=2;
long bestmax=50;
long pamfact= 1;	/* flag for using pam values for kfact */
long dnaseq = 0;	/* true if DNA query sequence */
long dnasw_flg = 0;
long ldnaseq = 0;

long bestfull=0;
long igncnt=0;
long optall=0;
long optcount=0l;
long init1flg=0;

long nsav, gLowRunScore;	/* number of saved runs, worst saved
				run, score of worst saved run */

long *hist;		/* histogram of all score */
long min_hist, max_hist, maxh;
long histflg=0;
long long_info=1;	/* long display of library sequence definition */
long dohist=0;
#ifndef LFASTA
long zscoreFlag=1;
extern long num_db_entries, z_calls;
extern float ks_dev;
extern long ks_df;
#else
long zscoreFlag=0;
long num_db_entries;
#endif

long fact, gm;                   /* scoring factors */
long hmask, hmax;		/* hash constants */
long *pamh2;			/* pam based kfact array */
static long *link, *harr;		/* hash arrays */
long ktup=1, kshft, kt1;		/* ktuple constants */

long nshow=20;			/* Number of alignments to show */
long mshow=50, ashow= -1;
long mshow_flg = 1;
#ifndef FASTX
	float e_cut=10.0;		/* threshold for E value display */
#else
	float e_cut=5.0;
#endif
long e_cut_set=0;		/* flag for set */
char rline[LFILE_SIZE],sline[LFILE_SIZE];
char resfile[LFILE_SIZE];

/* output options */
long showall, llen, markx;	/* show all of both sequences */

char ttitle[60];
char ltitle[60];

long tstart, tscan, tdone, sstime();

extern int optind;

#ifndef LFASTA
	long outtty;
#else
	extern long outtty;
#endif

char cys_status_string[80];
char gNtermBonus[20];

char *libenv, *aaenv, *smptr;
char smstr[QFILE_SIZE], sdstr[QFILE_SIZE];
char flstr[QFILE_SIZE];

#ifdef TPLOT
	char lvstr[QFILE_SIZE];
#endif

#if (defined(__MWERKS__)  && __dest_os == __mac_os)
	FSSpec ouSpec, q0Spec;
        FSSpec libSpec; /* Library file spec */
	OSErr error;
#define IntroDID 400	/* LFASTA */
#endif

#ifdef LFASTA
#define PgmDID 403
	char *iprompt0=" LFASTA compares two sequences\n";
	char *iprompt1=" first sequence file name: ";
	char *iprompt2=" second sequence file name: ";
#else
	char *iprompt1=" Lutefisk query sequence file name: ";
#ifdef TFASTA
#define PgmDID 402
		char *iprompt0=" TFASTA translates and searches a DNA sequence data bank\n";
#else
#ifdef FASTX
#define PgmDID 405
			char *iprompt0=" FASTX compares a DNA sequence to a protein data bank\n";
#else
#ifdef TFASTX
#define PgmDID 406
				char *iprompt0=" CIDentifyX translates and searches a DNA sequence data bank\n";
#else
#define PgmDID 401
				char *iprompt0=" CIDentify searches a protein or DNA sequence data bank\n";
#endif
#endif
#endif
#endif


struct SequenceScore lutefiskResult[LUTEFISK_QUERY_LIMIT];
long gNumOfQueries = 0;
tquery *gQuery;

double gScore0Sum = 0;
double gScore0SqrSum = 0;
double gStdDev;

/* Private function prototypes */
int areWeFinished(void);
void processResult(beststr* result);
void initenv(long argc, char **argv);
void usage(void);
void reseta(long dnaseq);
void resetp(long dnaseq);
void initparm(void);
void hashaa(char *aa0, long n0, long ktup);
void allochash(long n0, long hmax);
void freehash(void);
void dhash(void);

#ifdef ALLOCN0
	static void savemax(register struct dstruct *dptr, long dpos);
#else
	static void savemax(register struct dstruct *dptr);
#endif 

void initpam2(void);
long spam(beststr *dmax);
long sconn(beststr *v[], long n);
long shscore(char *aa0, long n0);
void prhist(FILE *fd);
void allocdiag(long dsize);
void showalign(long nshow);
void showlocal(long nshow);
static void AllocateBestScoreArrays(long numToAllocate);
static void freebest(void);
void showbest(void);
void selectz(long k, long n);
void sortbest(void);
void sortbeste(void);
void sortbestz(void);
/*static*/
long TwoKeyScoreSort(beststr *ptr1, beststr *ptr2);
long cmps(beststr *ptr1, beststr *ptr2);
long cmpa(beststr *ptr1, beststr *ptr2);
long cmp1(beststr *ptr1, beststr *ptr2);
long cmpz(beststr *ptr1, beststr *ptr2);
long cmpe(beststr *ptr1, beststr *ptr2);

#ifdef FAR_PTR
	static long FTwoKeyScoreSort(beststr huge *ptr1, beststr huge *ptr2);
	long fcmps(beststr huge *ptr1, beststr huge *ptr2);
	long fcmp1(beststr huge *ptr1, beststr huge *ptr2);
	long fcmpa(beststr huge *ptr1, beststr huge *ptr2);
	long fcmpz(beststr huge *ptr1, beststr huge *ptr2);
	long fcmpe(beststr huge *ptr1, beststr huge *ptr2);
#endif

long cmpp(beststr *ptr1, beststr *ptr2);
void kssort(beststr *v[], long n);
void kpsort(beststr *v[], long n);
void ksort(void *v[], long n, long (*comp)());

#ifdef FAR_PTR
	void fksort(void huge * huge *v, long n, long (*comp)());
#endif

long getlnames(char *tname);
void libchoice(char *lname, long nl, char *aaenv);
void libselect(char *lname);
void addfile(char *fname, char *env);

/*
#ifndef __MWERKS__
	char tolower(char a);
#endif
*/
char *ulindex(char *str, char chr);

/*=============================================================================
*/
main(long argc, char **argv)
{
  
  char lname[LFILE_SIZE];
  char llname[LFILE_SIZE];
  char qline[QFILE_SIZE];
  char *cptr;
  char *bp;
  long itemp;
  long iln;
  long i, j;

#ifdef FASTX
  long last_n0;
  unsigned char *fs, *fd;
#endif
  	
  int argc_MPI;
  char **argv_MPI;

  /* To parallelize the code using MPI --  Shuxia Zhang  -- */
  MPI_Init( &argc_MPI, &argv_MPI);

  MPI_Comm_rank( MPI_COMM_WORLD, &rank );
  MPI_Comm_size( MPI_COMM_WORLD, &gNumSlaves );  

  /* The above three calls start MPI 
     size -- how many processors are using 
     rank -- which processor it is    
  */ 
  
  MPI_Type_struct(16, array_of_blocklengths, array_of_displacements, array_of_types, &resultPacketType);
  MPI_Type_commit(&resultPacketType);
/*
  MPI_Type_size(resultPacketType, &size);
  printf("sizeof mpi struct = %d", size); //XXXXXXXXXXXXXXX
  MPI_Type_extent(resultPacketType, &size);
  printf("extent of mpi struct = %d", size); //XXXXXXXXXXXXXXX
*/

  strcpy(query_file, "\0");

#if (defined(__MWERKS__)  && __dest_os == __mac_os)
  	SIOUXSettings.showstatusline=FALSE;
#	ifdef TPLOT
  		InitGraf(&qd.thePort);
  		SIOUXSettings.asktosaveonclose=FALSE;
#	else
  		SIOUXSettings.asktosaveonclose=TRUE;
#	endif
  	SIOUXSettings.autocloseonquit=TRUE;
  
  	argc = ccommand(&argv);
  	  	
  	if (GetResource('DLOG',PgmDID)==(Handle)0 && OpenResFile("\pFASTA.rsrc")<0) {
    	SysBeep(100);
    	fprintf(stderr," WARNING FASTA.rsrc file could not be found\n");
  	}
  	
  	InitEvent();  	

  	error=HGetVol(NULL,&ouSpec.vRefNum, &ouSpec.parID);
  	if (error != noErr) {
  		fprintf(stderr," cannot get current directory\n");
  		exit(1);
  	}
  	wpos.h=50; wpos.v=100;
#endif

#ifndef LFASTA
#	ifdef UNIX
  		outtty=isatty(1);
#	else
  		outtty=1;
#	endif
#endif

	initenv(argc,argv);  

/*
#if (defined(__MWERKS__)  && __dest_os == __mac_os)
  	if (!outtty) SIOUXSettings.asktosaveonclose=FALSE;
#endif
*/

  	if (dataflg && (tmpfd = fopen(tmpfname,"w")) == NULL)  {
    	fprintf(stderr," cannot open temp file: %s\n",tmpfname);
    	dataflg=0;
  	}
  
  
#if (defined(__MWERKS__)  && __dest_os == __mac_os)
     NIntroDlog(PgmDID, verstr,"\0","\0","\0");	
	if (!strlen(query_file)) {
l1:		SFileDlog(iprompt1,&freply);
    	if (freply.sfGood == TRUE) {
      		PtoCstr((unsigned char *)freply.sfFile.name);
      		strcpy(query_file,(char *)freply.sfFile.name);
	  	libSpec.vRefNum = q0Spec.vRefNum = freply.sfFile.vRefNum;
	    	libSpec.parID = q0Spec.parID = freply.sfFile.parID;
	       	HSetVol(NULL,q0Spec.vRefNum,q0Spec.parID);
    	}
    	else exit(0);
    }
#else
    
    if (!strlen(query_file)) {
l1:		fputs(iprompt1,stdout); /* Display prompt "Lutefisk query sequence file name:" */
    	fflush(stdout);
       	if (my_fgets(query_file,sizeof(query_file),stdin) == NULL) exit(0);
    	if (query_file[strlen(query_file)-1] == '\n') query_file[strlen(query_file)-1] = '\0';
    	if (query_file[0]=='\0') goto l1;
    }		
#endif

    if (ImportLutefiskPeptides(query_file) == 0) {
      fprintf(stderr,"No query sequences found in \"%s\"\n", query_file);
      /* goto l1; */
      exit(0);
    }
    
  
#if defined(TFASTA) || defined(TFASTX)
	aainit();
  	dnaseq = -1;	/* force to protein */
  	ldnaseq = 1;
  	if (sqtype[0] == 'D') {
    	fprintf(stderr," tfasta compares a protein to a translated\n\
		        DNA sequence library.  Do not use a DNA scoring matrix.\n");
    	exit(1);
  	}
#endif

#ifdef TFASTX    
  	if ((aa1 = calloc((size_t)MAXTRN,sizeof(char))) == 0) {
    	fprintf(stderr," cannot allocate sequence array\n");
    	exit(1);
  	}
#else
	if ((aa1 = calloc((size_t)MAXLIB,sizeof(char))) == 0) {
    	fprintf(stderr," cannot allocate sequence array\n");
    	exit(1);
  	}
#endif
  	
  	/*maxn = MAXTST+MAXLIB;*/
	maxn = MAXLIB;
	
#ifdef TFASTX
  	if ((aa1y = calloc((size_t)MAXTRN,sizeof(char))) == 0) {
    	fprintf(stderr," cannot allocate TFASTX translation array II\n");
    	exit(1);
  	}
#endif

#if defined(TFASTA) || defined(TFASTX)
  	if ((aa10 = calloc((size_t)MAXTRN,sizeof(char))) == 0) {
    	fprintf(stderr," cannot allocate translation array\n");
    	exit(1);
  	}
#endif
  
	if (gNumOfQueries <= 0) {
    	fprintf(stderr," No queries to process.  Quitting.\n");
    	exit(0);
  	}
  	
	AllocateQueryStructure(gNumOfQueries);
	ConvertLutefiskPeptidesToFASTAQueries(gNumOfQueries);
			
#ifdef LFASTA
#   if (defined(__MWERKS__)  && __dest_os == __mac_os)    	
l2:		SFileDlog(iprompt2,&freply);
    	if (freply.sfGood==TRUE) {
      		PtoCstr((unsigned char *)freply.sfFile.name);
      		strcpy(lname,(char *)freply.sfFile.name);
	  	libSpec.vRefNum = freply.sfFile.vRefNum;
	  	libSpec.parID = freply.sfFile.parID;
	  	HSetVol(NULL,libSpec.vRefNum,libSpec.parID);
    	}
    	else exit(0);
#	else
l2:		fputs(iprompt2,stdout);
    	fflush(stdout);
    	if (my_fgets(lname,sizeof(lname),stdin)==NULL) exit(1);
    	if (lname[strlen(lname)-1]=='\n') lname[strlen(lname)-1]='\0';
    	if (*lname==0) goto l2;
#	endif
	libselect(lname);
#else
#	if (defined(__MWERKS__)  && __dest_os == __mac_os)
		HSetVol(NULL,ouSpec.vRefNum,ouSpec.parID);
#	endif

	if (!strlen(database_choice)) {
    	libchoice(database_choice,sizeof(database_choice),aaenv);
    }
    else {
	    strncpy(ltitle, database_choice, sizeof(ltitle));
    }
    
    libselect(database_choice);
#endif

    
/*
    fprintf(stderr," ktup? (1 to %d) [%d] ",ktmax,ktmax);
    if (my_fgets(qline,sizeof(qline),stdin)==NULL) exit(0);
    ktup = ktmax;
    if (qline[0]!='\0' && qline[0]!='\n') {
		sscanf(qline,"%d",&ktup);
      	if (ktup < 1 || ktup>ktmax ) {
			printf(" warning ktup = %d out of range, reset to %d\n",ktup,ktmax);
			ktup = ktmax;
      	}
    }

    
#ifndef LFASTA
	fprintf(stderr," use optimized scores? [%s]: ",(optall?"yes":"no"));
    if (my_fgets(qline,sizeof(qline),stdin)==NULL) exit(0);
    if (optall==1 && (*qline=='n' || *qline=='N')) optall = 0;
    if (optall==0 && (*qline=='y' || *qline=='Y')) optall = 1;
#endif    

#if (defined(__MWERKS__)  && __dest_os == __mac_os)
	HSetVol(NULL,q0Spec.vRefNum,q0Spec.parID);
#endif

*/ 

/*  
  	maxn -= n0 + 3;
*/
  
  	initpam2();	/* convert 1-d pam to 2-d pam2 */
  
  	initparm();
  	if (dataflg) {
    	fprintf(tmpfd,"; ktup = %d\n",ktup);
    	fprintf(tmpfd,"; cutoff = %d; optcut = %d; ggapval %d gdelval %d cgap %d\n",
	    		bestcut,optcut,ggapval,gdelval,cgap);
    	if (lnsflg) fprintf(tmpfd,"; ln scaling");
  	}
  
  	tstart = sstime();
  
  	fact = ktup*scfact;

  	HashQuerySequences(gNumOfQueries, ktup);	/* hash the query sequences */

#ifndef ALLOCN0
  	allocdiag(MAXDIAG);
#else
  	allocdiag(MAXTST);
#endif



	if (0 == rank) {
	    master();
	}
	else {
//	    sprintf(database_choice,"%s.%d", database_choice, rank - 1); /* Database choice */
	    slave();
	}

	MPI_Finalize( ); 
}


/*=============================================================================
*/
int areWeFinished()
{
    int i;
    int result = 1;

    // Skip 0 because that is the master.
    for (i = 1; i < gNumSlaves; i++) {
	if (0 == tracker[i]) {
	    result = 0;
	}
    }

    return result;
}

/*=============================================================================
*/
void processResult(beststr* result)
{
    long theTotalScore = result->score0;  

/*
    printf("score =  %ld *****\n", result->score); // XXXXXXXXX
    printf("score0 =  %ld *****\n", result->score0); // XXXXXXXXX
    printf("gscore =  %ld *****\n", result->gscore); // XXXXXXXXX
    printf("sscore =  %ld *****\n", result->sscore); // XXXXXXXXX
    printf("n1 =  %ld *****\n", result->n1); // XXXXXXXXX
    printf("start =  %ld *****\n", result->start); // XXXXXXXXX
    printf("lib =  %ld *****\n", result->lib); // XXXXXXXXX
*/

    gScore0Sum += theTotalScore;
    gScore0SqrSum +=  theTotalScore * theTotalScore;
			
#ifndef LFASTA
/*    if (dohist) {
	addhistz(result->zscore = find_zm(theTotalScore,result->n1),result->n1);
    }
*/    
#endif    /* LFASTA */	
		
    if (theTotalScore > bestcut) {

	if (gNumOfBest >= MAXBEST) {  		
//	    printf("Crunching best hit list *****\n"); // XXXXXXXXX

#ifndef LFASTA
/*	    if (!dohist) {
	        process_hist(bptr, gNumOfBest);
	        dohist=1;
	        addhistz(result->zscore = find_zm(theTotalScore,n1),n1);
	    }
*/	     
#endif    /* LFASTA */	

	    bestfull = gNumOfBest-MAXBEST/4;
	    selectz(bestfull-1,gNumOfBest);
	    bestcut = (long)(bptr[bestfull-1]->score0 + 0.5);
	    gNumOfBest = bestfull;
	}
	memcpy(bptr[gNumOfBest], result, sizeof(beststr));
				
        gNumOfBest++;
    }
    
    gNumOfLibSequences++;

#ifdef PROGRESS  // Print a dot for every 200 library sequences 
/* Disabled by JAT 10/8/97 so it will update when run as a cgi
#	ifdef UNIX
      	if (outtty)
#	endif
*/
    if (gNumOfLibSequences % 200 == 0) {
	fputc('.',stderr);
	if (gNumOfLibSequences % 10000 == 0) fprintf(stderr, "  %8ld\n", gNumOfLibSequences);
	else if (gNumOfLibSequences % 1000 == 0) fputc(' ',stderr);
	fflush(stderr);
    }
		
#endif

}

/*=============================================================================
*/
master()
{
    char *bp;
    int i, j;
    beststr result;
    long theMeanScore0;
    double lambda;
    double mu;
    MPI_Status status;

//    printf("Master starting *****\n"); // XXXXXXXXX
    fprintf(stdout, "\n%s %s%s\n", iprompt0, verstr, refstr);

    /* Allocate the slave tracking array */
    if ((tracker=(int *)calloc((size_t)gNumSlaves,sizeof(int)))
	    == NULL) {fprintf(stderr,"cannot allocate tracker array.\n"); exit(1);}
    for (i = 0; i < gNumSlaves; i++) {
	tracker[i] = 0;
    }


    AllocateBestScoreArrays(MAXBEST+1);	/* +1 required for select() */
    /* Initialize the array of pointers to the best array */
    for (i=0; i < MAXBEST + 1; i++) bptr[i] = &best[i];
    bptr++; 
    best++;
    best[-1].score=best[-1].score0= best[-1].gscore= best[-1].sscore = BIGNUM;
    best[-1].zscore = (float)BIGNUM;

    gNumOfLibSequences = theOldNumOfLibSequences = 0;
    gNumOfResiduesScanned = theOldNumOfResiduesScanned = 0;
    gNumOfBest = 0;

    printf("\n %ld Lutefisk queries vs %s library\n", gNumOfQueries, ltitle);

    while (0 == areWeFinished()) {

	MPI_Recv(&result, 1, resultPacketType, MPI_ANY_SOURCE, MPI_ANY_TAG, MPI_COMM_WORLD, &status);

	if (-1 == result.n1) {
	    /* Flag slave as done */
	    tracker[status.MPI_SOURCE] = 1;
//	    printf("\nProcess %d done\n", status.MPI_SOURCE); // XXXXXXXXX
//	    gNumOfLibSequences += result.lib;
	    gNumOfResiduesScanned += result.frame;
	}
	else {
//	    printf("\nProcessing result from process %d\n", status.MPI_SOURCE); // XXXXXXXXX
	    processResult(&result);
	}

    }



  
/*	if (zscoreFlag) {
    	sortbestz();
    	for (j = 0; j < gNumOfBest; j++)
      		bptr[j]->escore = zs_to_E(bptr[j]->zscore, bptr[j]->n1);
    	sortbeste();
  	}
  	else*/ sortbest();
 
  	tscan = sstime();

#ifndef TFASTX
   	theMeanScore0 = gScore0Sum/gNumOfLibSequences;
  	gStdDev = sqrt(gScore0SqrSum/gNumOfLibSequences - (theMeanScore0 * theMeanScore0));
#else
	/* Compensate for both the forward and reverse orientations being searched */
   	theMeanScore0 = gScore0Sum/(2 * gNumOfLibSequences);
  	gStdDev = sqrt(gScore0SqrSum/(2 * gNumOfLibSequences) - (theMeanScore0 * theMeanScore0));
#endif
  	/* Calculate extreme value distribution parameters */
        lambda = PI / (gStdDev * sqrt(6));
 
        mu = theMeanScore0 - 0.5772 / lambda;

        for (j = 0; j < gNumOfBest; j++) {
	      		bptr[j]->stddev = (bptr[j]->score0 - theMeanScore0)/gStdDev;
                        bptr[j]->escore = exp(-lambda * (bptr[j]->score0 - mu));	  
        }

#ifndef LFASTA
/*  	if (!dohist) {
    	if (gNumOfBest < 20) {
      		zscoreFlag = 0;
      		histflg = 0;
    	}
    	else {
*/    		/* This is here to catch the case when the number of best matches
  	           did not exceed the max. # thus initializing the histogram */
/*  	   		process_hist(bptr, gNumOfBest);
			dohist=1;
    	}
  	}
*/  
  	if (dataflg) {
    	fprintf(tmpfd,"; %8ld %s in %5ld sequences; scan time: ",
	    	    gNumOfResiduesScanned,sqnam,gNumOfLibSequences);
	    	    
    	ptime(tmpfd,tscan-tstart);
    	fputs("\n",tmpfd);
    	if (optall) fprintf(tmpfd,"; %d optimizations performed\n",optcount);
  	}
  	
  	
   	if (histflg) prhist(stdout);		/* print histogram, statistics */
   	
   	
   	
#endif

#if (defined(__MWERKS__)  && __dest_os == __mac_os)
	HSetVol(NULL,ouSpec.vRefNum,ouSpec.parID);
#endif
    
#ifndef LFASTA
  	outfd = stdout;
l3: if (outtty) {
		printf(" Enter filename for results [%s]: ",resfile); 
		fflush(stdout);
	}
  	rline[0]='\0';
  	if (outtty && my_fgets(rline,sizeof(rline),stdin) == NULL) exit(0);
  	if ((bp = strchr(rline,'\n')) != NULL) *bp = '\0';
  	if (rline[0] != '\0') strncpy(resfile,rline,sizeof(resfile));
  	if (resfile[0] != '\0') {
    	if ((outfd = fopen(resfile,"w")) == 0) {
    		printf(" could not open %s\n",resfile);
      		goto l3;
    	}
    	
    	if (histflg) prhist(outfd);
    	
    	{	    
	    	const time_t		theTime = (const time_t)time(NULL);
			
			fprintf(outfd,"\n CIDentify version %s  Search Date: %20s   %ld Lutefisk queries vs %s library\n\n", 
			        gVersion, ctime(&theTime), gNumOfQueries, ltitle);

	    }
   	}
	
	{
		const time_t		theTime = (const time_t)time(NULL);
		printf("\n CIDentify version %s  Search Date: %20s   %ld Lutefisk queries vs %s library\n\n", 
			gVersion, ctime(&theTime), gNumOfQueries, ltitle);
	}
#else
#ifdef TPLOT
  	outfd = stderr;
#else
	outfd = stdout;
#endif	
  	fprintf(outfd," Comparison of:\n(A) %-10s %-50s%s - %d %s\n",
	  		query_file,ttitle,compstr,n0,qsqnam);
  	fprintf(outfd,"(B) %-10s %-50s - %ld %s\n",lname,ltitle,gNumOfResiduesScanned,sqnam);
  	if (strlen(smptr)>0) fprintf(outfd," using matrix file %s\n",smptr);
  	else fprintf(outfd," using %s matrix\n",sqtype);
  
  	if (gNumOfBest<=0) {
    	fprintf(outfd," No similar regions with scores greater %d than found\n",optcut);
    	exit(0);
    }
#endif
    
#ifdef LFASTA
  	nshow = gNumOfBest;
#ifdef TPLOT
  	openplt((long)n0,(long)gNumOfResiduesScanned);
  	if (oneseq) drawdiag((long)n0,(long)gNumOfResiduesScanned);
  	showlocal(nshow);
  	closeplt();
#else
  	showlocal(nshow);
#endif
#else	/* !LFASTA */
  
  	if (gNumOfBest <= 0) {
    	fprintf(outfd," no sequences with scores greater than %d found\n",bestcut);
    	if (outfd != stdout) 
      		fprintf(outfd," no sequences with scores greater than %d found\n",bestcut);
    	exit(0);
  	}
  	showbest();	/* display best matches */
  
  	rline[0]='Y';
  	if (outtty) {
    	printf(" Display alignments also? "); fflush(stdout);
    	if (my_fgets(rline,sizeof(rline),stdin) == NULL) exit(0);
  	}

  	if (markx==10) {
    	
    	fprintf(outfd,"; pg_name: %s\n",progstr);
    	fprintf(outfd,"; pg_ver: %s\n",verstr);
    	fprintf(outfd,"; pg_matrix: %s\n",smptr);
    	fprintf(outfd,"; pg_gap-pen: %d %d\n",gdelval,ggapval);
    	fprintf(outfd,"; pg_ktup: %d\n",ktup);
    	fprintf(outfd,"; pg_optcut: %d\n",optcut);
    	fprintf(outfd,"; pg_cgap: %d\n",cgap);
  	}

  	if (toupper(rline[0])=='Y') {
    	if (outtty) {
      		printf(" number of alignments [%d]? ",nshow);
      		fflush(stdout);
      		if (my_fgets(rline,sizeof(rline),stdin)==NULL) exit(0);
      		if (rline[0]!=0) sscanf(rline,"%d",&nshow);
      		ashow=nshow;
    	}
    	else nshow = mshow;
    	
    	showalign(nshow);
  	}
  	tdone = sstime();
  	if (markx<10) {
    	printf("Library scan: "); ptime(stdout,tscan-tstart);
    	printf("  total CPU time: "); ptime(stdout,tdone-tstart);
    	printf("\n");
    	if (outfd!=stdout) {
      		fprintf(outfd,"Library scan: "); ptime(outfd,tscan-tstart);
      		fprintf(outfd,"  total CPU time: "); ptime(outfd,tdone-tstart);
      		fprintf(outfd,"\n");
    	}
  	}
#endif
 
}

/*=============================================================================
*/
slave()
{

    char *bp;
    long itemp;
    long iln;
    int rank;
    beststr doneObj;


    MPI_Comm_rank( MPI_COMM_WORLD, &rank );
//    printf("\nSlave %d starting *****\n", rank); // XXXXXXXX


#ifdef LFASTA
  	/* initialize crc array */
  	for (ncrc=0; ncrc<MAXSAV; ncrc++) lcrc0[ncrc]=lcrc1[ncrc]= -1;
  	ncrc = 0;
#	if (defined(__MWERKS__)  && __dest_os == __mac_os)
		HSetVol(NULL,libSpec.vRefNum,libSpec.parID);
#	endif
	gettitle(lname,ltitle,50);
#	if (defined(__MWERKS__)  && __dest_os == __mac_os)
		HSetVol(NULL,ouSpec.vRefNum,ouSpec.parID);
#	endif
#endif

  	/* Search through the selected libraries */
  	for (iln=0; iln<nln; iln++) {
    	libfn = iln;
    	
#if (defined(__MWERKS__)  && __dest_os == __mac_os)
		HSetVol(NULL,libSpec.vRefNum,libSpec.parID);
#endif
    	if ((itemp=openlib(lbnames[iln],"\0"))>0) {
//      		printf(" searching %s library\n",lbnames[iln]);
      		dhash();/*----------------------------------------------*/
    	}
    	if (itemp== -9) {
      		printf(" %8ld %s in %5ld sequences\n",
      		       gNumOfResiduesScanned-theOldNumOfResiduesScanned,
	     		   sqnam,gNumOfLibSequences-theOldNumOfLibSequences);
      
      		theOldNumOfResiduesScanned=gNumOfResiduesScanned; 
      		theOldNumOfLibSequences=gNumOfLibSequences; 
      		continue;
    	}
    	if (itemp<0) break;
    	
#ifndef LFASTA
    	closelib();
#endif
  	}
		
  	free(diag);
	FreeHashArrays();


	/* Tell the master we have finished */
	doneObj.n1 = -1;   /* Flag */
	doneObj.lib = gNumOfLibSequences;
	doneObj.frame = gNumOfResiduesScanned;
	MPI_Send(&doneObj, 1, resultPacketType, 0, 0, MPI_COMM_WORLD);
}

extern long *sascii, nascii[], aascii[];

/*========================================================================
*/
void initenv(long argc, char **argv)
{
  	char *cptr;
  	long copt;
  	extern char *optarg;
  	long i;
	

  	libenv="\0";
  	if ((aaenv = getenv("AABANK")) == NULL) aaenv = "\0";
  	if ((cptr = getenv("FASTLIBS")) != NULL) strncpy(flstr, cptr, sizeof(flstr));
  	else flstr[0] = '\0';

  	sascii = aascii;
  	smptr = sdstr;
  	pam = ablMS90;
	strncpy(sdstr, "BLOSUM90MS", sizeof(sdstr)); /* Set default matrix */
  	sq = aa;
  	hsq = haa;
 	nsq = naa;
  	dnaseq = 0;
  	ldnaseq = 0;

	strcpy(gNtermBonus, "KR");  /* Tryptic N-terminal bonus by default */

#ifdef TFASTA
  gdelval = -16;
  ggapval = -4;
#endif
#ifdef FASTX
  gdelval = -15;
  ggapval = -3;
  gshift = -30;
#endif
#ifdef TFASTX
  gdelval = -15;
  ggapval = -3;
  gshift = -30;
#endif

  showall = 0;

  if ((cptr=getenv("SHOWALL"))!=NULL)
    if (sscanf(cptr,"%d",&showall)!=1) showall = 1;

  if ((cptr=getenv("LINLEN"))!=NULL) sscanf(cptr,"%d",&llen);
  else llen = 75;
  if (llen>=200) llen=200;
  markx=0;
  if ((cptr=getenv("MARKX"))==NULL) markx=0;
  else sscanf(cptr,"%d",&markx);

  if ((cptr=getenv("GAPCUT"))!=NULL) sscanf(cptr,"%d",&cgap);
  else cgap=0;

  if ((cptr=getenv("OPTCUT"))!=NULL) sscanf(cptr,"%d",&optcut);
  else optcut = 0;

  if ((cptr=getenv("PAMFACT"))!=NULL) {
    sscanf(cptr,"%d",&pamfact);
    if (pamfact==1) pamfact= -2; else pamfact = 0;
  }

#ifndef LFASTA
  if ((cptr = getenv("LIBTYPE")) != NULL) sscanf(cptr,"%d",&deftype);
  if (deftype<0 || deftype>LASTLIB) deftype = 0;
#endif

	while ((copt = getopt(argc,argv,"QqaAb:C:c:d:eE:f:g:hHij:k:l:Lm:N:noO:p:t:r:s:v:w:x:y:z13")) != EOF) {
    	switch(copt) {
    		case 'h': 
      			usage();
      			exit(0);
      			break;
#ifndef LFASTA
		    case 'q':
		    case 'Q': outtty = 0; break;
		    case 'a': showall = 1; break;
		    case 'A': dnasw_flg = 1; break;
#endif
			case 'j': 
				strncpy(query_file, optarg, sizeof(query_file)); /* Lutefisk query file name */
			  	break;
			case 'p': 
				strncpy(database_choice, optarg, sizeof(database_choice)); /* Database choice */
			  	break;  
		    case 'b': 
		    	sscanf(optarg,"%d",&mshow); /* Number of results to show if using -q flag */
		      	mshow_flg = 1;
		      	if (mshow<1) mshow=1;
		      	break;
		    case 'C':   /* Set a new nominal mass for a modified Cys */
		    	sscanf(optarg,"%d",&gNomMass[4]);
		    	sprintf(&cys_status_string[0], "Cysteine nominal mass set to %d\n", gNomMass[4]);
		    	break;  	
		    case 'c': sscanf(optarg,"%d",&optcut); break;
		    case 'd': sscanf(optarg,"%d",&ashow);
		      	if (ashow<0) ashow=1;
		      	break;
		    case 'e': /* lnsflg = 1; */
		      	fprintf(stderr," ln() normalization not available\n");
		  	    break;
		    case 'E': sscanf(optarg,"%g",&e_cut);  
				e_cut_set=1;
			 	break;
		    case 'f': sscanf(optarg,"%d",&gdelval); del_set = 1;
		      	break;
		    case 'g': sscanf(optarg,"%d",&ggapval); gap_set = 1;
		      	break;
		    case 't': sscanf(optarg,"%d",&gshift); shift_set=1;
		      	break;
		    case 'k': sscanf(optarg,"%d",&cgap); break;
		    case 'H': histflg = 0; break;
		    case 'i': revflg = 1; compstr=" (rev-comp)"; break;
		    case 'l': strncpy(flstr,optarg,sizeof(flstr));
		      	break;
		    case 'L': long_info = 1; break;
		    case 'm': sscanf(optarg,"%d",&markx);
		      	if (markx == 4) llen=50;
		      	if (markx > 4 && markx != 10 ) markx = 0;
		      	break;
#ifndef FASTX
    		case 'n': dnaseq=1;
      			sascii = nascii;
      			sq = nt;
			    nsq = nnt;
			    hsq = hnt;
			    strcpy(qsqnam,"nt");
			    strcpy(sqnam,"nt");
			    strcpy(sqtype,"DNA");
			    resetp(dnaseq);
			    break;
#endif
		    case 'N':   /* Set N-terminal possibilities to grant a bonus to */
				strncpy(gNtermBonus, optarg, sizeof(gNtermBonus)); 
		    	break;  	
		    case 's': 
		      	strncpy(smstr,optarg,sizeof(smstr));
		      	if (initpam(smstr)) {
					dnaseq= -1;
					ldnaseq = (sqtype[0]=='D')?1:0;
					smptr = smstr;
		      	}
		      	break;
		    case 'w': sscanf(optarg,"%d",&llen); break;
		    case 'x': sscanf(optarg,"%ld %ld",&sq0off,&sq1off);
		      	break;
		    case 'y': sscanf(optarg,"%d",&optwid);
		      	optwidf = 1;
		      	break;
		    case 'z': zscoreFlag = 0; histflg = 0;
		      	break;
		    case 'O': strncpy(resfile,optarg,sizeof(resfile));
		      	break;
#ifndef LFASTA
    		case '1': init1flg=1; break;
    		case 'o': optall=0; break;
    		case 'r': dataflg=1; 
      			strncpy(tmpfname,optarg,sizeof(tmpfname));
      			break;
#else
    		case '1':
    		case 'Q': 
    		case 'o':
    		case 'R':fprintf(stderr," illegal option -%c\n",copt);
      			break;
#endif
#ifdef TPLOT
    		case 'v': strncpy(lvstr,optarg,sizeof(lvstr));
      			break;
#endif
#if defined(TFASTA) || defined(TFASTX)
#ifdef TFASTA
    		case '3': nframe=3; break;
#else
    		case '3': nframe=1; break;
#endif
#else
    		case '3':
#endif
    		default : fprintf(stderr," illegal option -%c\n",copt);
    		}	
    }

  	optind--;
  
  	if (dnaseq >= 0) {
    	if ((smptr = getenv("SMATRIX")) != NULL && initpam(smptr)) {
      		dnaseq = -1;
      		ldnaseq = (sqtype[0] == 'D') ? 1:0;
    	}
    	else smptr = sdstr;
  	}

 	ktmax = bktup;
	
  	if (dnaseq < 0 && strlen(smptr) > 0)
    	fprintf(stderr," matrix file reset to %s\n",smptr);
   
//  if (argc - optind < 3)
//	    return;
  	if (argc - optind > 1 && !strlen(query_file))
    	strcpy (query_file, argv[optind + 1]);
  	if (argc - optind > 2 && !strlen(database_choice))
      	strcpy (database_choice, argv[optind + 2]);  
  
	if (strlen(query_file) == 0 || strlen(database_choice) == 0) 
	{
	    if (rank == 0) {
		fprintf(stderr, "Both the query file and the database choice must be spcified on the command-line for the MPI version.\n\n");
	        usage();
	    } 
	    MPI_Finalize();
	    exit(1);
	}
}

/*=============================================================================
*/
void usage(void)
{

  printf("USAGE: CIDentify_mpi [- options]\n\n"); 
  printf("      [-q]  Quiet mode\n");
  printf("      [-O]  Output file name when using quiet mode\n");
  printf("      [-j Lutefisk query file name]\n");
  printf("      [-p Database choice]\n");
  printf("      [-C modified cysteine nominal mass]\n");
  printf("      [-N N-terminal bonus residues]\n");
  printf("      [-l FASTLIBS file name]\n");
  printf("      [-b Number of results to show when using quiet mode]\n");
  printf("      [-s scoring matrix file name]\n\n");

  printf("      [-h]   prints this usage\n");
  printf("      [-a]   show all\n");
  printf("      [-c optcut]\n");
  printf("      [-d ashow] Number of alignments to show\n");
  printf("      [-E e_cut]\n");
  printf("      [-f gdelval]\n");
  printf("      [-g ggapval]\n");
  printf("      [-t gshift]\n");
  printf("      [-k cgap]\n");
  printf("      [-i]   rev-comp\n");
  printf("      [-m mark character]\n\n");
  
  fflush(stdout);

}
/*=============================================================================
*/
void reseta(long dnaseq)
{
  sascii = aascii;
  sq=aa;
  nsq = naa;
  hsq = haa;
  pam = abl50;
  strcpy(qsqnam,"nt");
  strcpy(sqnam,"aa");
  strcpy(sqtype,"protein");
}

/*=============================================================================
*/
void resetp(long dnaseq)
{
  if (dnaseq==1) {
    bestscale=80;
    bkfact=5;
    scfact=1;
    bktup=6;
    ktmax=6;
    bestmax=80;
    bestoff=45;
    pam = npam;
    if (!del_set) gdelval = -16;
    if (!gap_set) ggapval = -4;
    if (strlen(smstr)>0)
      fprintf(stderr," resetting matrix to DNA\n");
    strncpy(sdstr,"DNA",sizeof(smstr));
    smptr = sdstr;
    ldnaseq=1;
    if (pamfact>=0) pamfact = 0;
    if (!e_cut_set) e_cut = 2.0;
  }
}

/*=============================================================================
*/
void initparm(void)
{
	char *cptr;
	long itemp, btemp;

	if (!optwidf) {
	  if (dnaseq!=1 && ktup==1) optwid = 32;
	  else optwid = 16;
	}

	/*btemp = 2*bestoff/3 + n0/bestscale + bkfact*(bktup-ktup);
	if (btemp>bestmax) */ btemp = bestmax;
	/*if (btemp > 3*n0) btemp = 3*shscore(aa0,n0)/5;*/

	bestfull = 0;

	if (cgap<=0) cgap=btemp+bestoff/3;
	if (optcut<=0) optcut=btemp;
#ifdef TFASTA
	optcut = (optcut*3)/2;
#endif
	pgap = gdelval+ggapval;
}

/*================================================================
*/
#ifdef ALLOCN0
static void savemax(register struct dstruct *dptr, long dpos)
{
	register beststr *vmptr;
	register long i;

#else
static void savemax(register struct dstruct *dptr)
{
	register long dpos;
	register beststr *vmptr;
	register long i;
#endif

	register beststr *lmp;
	static beststr *lowmax = gBestRunsArray;

#ifndef ALLOCN0
	dpos = (long)(dptr-diag);
#endif

	/* check to see if this is the continuation of a run that is already saved */

	if ((vmptr=dptr->dmax) != NULL && vmptr->dp == dpos && vmptr->start == dptr->start) {
		vmptr->stop = dptr->stop;
		if ((i = dptr->score) <= vmptr->score) return;
		vmptr->score = i;
		if (vmptr != lowmax) return;
	}
	else {
		i = lowmax->score = dptr->score;
		lowmax->dp = dpos;
		lowmax->start = dptr->start;
		lowmax->stop = dptr->stop;
		dptr->dmax = lowmax;
	}

	lmp = lowmax;

	for (vmptr = gBestRunsArray; vmptr < &gBestRunsArray[MAXSAV]; vmptr++)
		if (vmptr->score < i) {
			i = vmptr->score;
			lmp = vmptr;
		}
	gLowRunScore = i;
	lowmax = lmp;
}
	
/*==========================================================
*/	
void initpam2(void)
{
    long i, j, k;

    k=0;
    for (i=0; i<nsq; i++)
      for (j=0; j<=i; j++) 
	pam2[j][i] = pam2[i][j] = pam[k++];

   /* make certain that the inclusion of EOS never produces a positive value */

    for (i = 0; i < EOSEQ; i++) pam2[i][EOSEQ] = pam2[EOSEQ][i] = -BIGNUM;
    pam2[EOSEQ][EOSEQ] = -BIGNUM;
}

/*==========================================================
*/ 
/*long spam(beststr *dmax)
{
  long lpos;
  long tot, mtot;
  struct {long start, stop, score;} curv, maxv;
  register char *aa0p, *aa1p;

  aa1p= &aa1[lpos = dmax->start];
#ifndef FASTX
  aa0p= &aa0[lpos - dmax->dp + noff];
#else
  aa0p= &aa0x[lpos - dmax->dp + noff];
#endif
  curv.start = lpos;

  tot = curv.score = maxv.score = 0;
  for  ( ; lpos <= dmax->stop; lpos++) {
    tot += pam2[*aa0p++][*aa1p++];
    if (tot > curv.score) {
      curv.stop = lpos;
      curv.score = tot;
    }
    else if (tot < 0) {
      if (curv.score > maxv.score) {
	maxv.start = curv.start;
	maxv.stop = curv.stop;
	maxv.score = curv.score;
      }
      tot = curv.score = 0;
      curv.start = lpos;
    }
  }

  if (curv.score > maxv.score) {
    maxv.start = curv.start;
    maxv.stop = curv.stop;
    maxv.score = curv.score;
  }

  //	if (maxv.start != dmax->start || maxv.stop != dmax->stop)
  //    printf(" new region: %3d %3d %3d %3d\n",maxv.start,

  dmax->start = maxv.start;
  dmax->stop = maxv.stop;

  return maxv.score;
}
*/
/*==========================================================
*/ 
long sconn(beststr *v[], long n)
{
  long i,si,cmpp();
  struct slink {
    long score;
    beststr *vp;
    struct slink *next;
  } *start, *sl, *sj, *so, sarr[MAXSAV];
  long lstart, tstart, plstop, ptstop;

  /*	sort the score left to right in lib pos */

  kpsort(v,n);

  start = NULL;

  /*	for the remaining runs, see if they fit */

  for (i=0,si=0; i<n; i++) {

    /*	if the score is less than the gap threshold, it never helps */
    if (v[i]->score < cgap) continue;
    lstart=v[i]->start;
    tstart=lstart-v[i]->dp+noff;

    /*	put the run in the group */
    sarr[si].vp = v[i];
    sarr[si].score = v[i]->score;
    sarr[si].next = NULL;

    /* 	if it fits, then increase the score */
    for (sl=start; sl!= NULL; sl = sl->next) {
      plstop = sl->vp->stop;
      ptstop = plstop - sl->vp->dp + noff;
      if (plstop<lstart+XFACT && ptstop<tstart+XFACT) {
	sarr[si].score = sl->score+v[i]->score+pgap;
	break;
      }
    }

    /*	now recalculate where the score fits */
    if (start==NULL) start= &sarr[si];
    else for (sj=start, so=NULL; sj!=NULL; sj = sj->next) {
      if (sarr[si].score>sj->score) {
	sarr[si].next = sj;
	if (so!=NULL) so->next= &sarr[si];
	else start= &sarr[si];
	break;
      }
      so=sj;
    }
    si++;
  }

  if (start!=NULL) return (start->score);
  else return (0);
}

/*==========================================================
*/    /* calculate the 100% identical score */
long shscore(char *aa0, long n0)	
{
  long i, sum;
  for (i=0,sum=0; i<n0; i++)
    sum += pam2[aa0[i]][aa0[i]];
  return sum;
}

/*==========================================================
*/
void prhist(FILE *fd)
{
  long i,j;
  long hl,hll, el, ell, ev, maxval, maxvalt;
  char hline[80], pch, *dstr;
  long mh1, mht;
  long dotsiz, ddotsiz,doinset;
  long cum_hl;
  float cur_e, prev_e, f_int;
  float max_dev, x_tmp;
  long n_chi_sq, max_i;
  
  mh1 = maxh-1;
  mht = (3*maxh-3)/4 - 1;
  
  fprintf(fd,"\n");
  
  if (gNumOfBest < 20) {
    fprintf(fd,"%2ld queries used to search %7ld residues in %5ld sequences\n",
            gNumOfQueries,gNumOfResiduesScanned,gNumOfLibSequences);
  }
  else {
    if (histflg) {
      for (i=0, maxval=0, maxvalt=0; i < maxh; i++) {
	     if (hist[i] > maxval) maxval = hist[i];
	     if (i >= mht &&  hist[i]>maxvalt) maxvalt = hist[i];
      }
      max_dev = 0.0;
      n_chi_sq = 0;

	  if (zscoreFlag) cum_hl = -hist[0];
		
      dotsiz = (maxval-1)/60+1;
      ddotsiz = (maxvalt-1)/50+1;
      doinset = (ddotsiz < dotsiz && dotsiz > 2);


      if (mh1 > 0) {
	fprintf(fd,"\n one = represents %d library sequences\n",dotsiz);
	if (doinset) fprintf(fd," for inset = represents %d library sequences\n",ddotsiz);

	if (optall) dstr="z-opt";
	else if (init1flg) dstr="z-init1";
	else dstr="z-initn";

	fprintf(fd,"\n   %s E()\n",dstr);
      }

      prev_e =  0.0;
      for (i=0; i<=mh1; i++) {
	pch = (i==mh1) ? '>' : ' ';
	pch = (i==0) ? '<' : pch;
	hll = hl = hist[i];
	if (zscoreFlag) {
	  f_int = (float)(i*histint + min_hist) + (float)histint/2.0;
	  cur_e = zs_to_Ec(f_int);
	  cum_hl += hl;
	  ev = el = ell = (long)(cur_e - prev_e + 0.5);
	  if (hl > 0 && i>5 && i < (90-min_hist)/histint) {
	    x_tmp  = fabs((float)cum_hl - cur_e);
	    if (x_tmp > max_dev) {
	      max_dev = x_tmp;
	      max_i = i;
	    }
	    n_chi_sq++;
	  }
	  if ((el=(el+dotsiz-1)/dotsiz) > 60) el = 60;
	  else if (el < 1) el = 1;
	  if ((ell=(ell+ddotsiz-1)/ddotsiz) > 40) ell = 40;
	  fprintf(fd,"%c%3d %5ld %5ld :",
		  pch,(i<mh1)?(i)*histint+min_hist :
		  mh1*histint+min_hist,hl,ev);
	}
	else fprintf(fd,"%c%3d %5ld :",
		     pch,(i<mh1)?(i)*histint+min_hist :
		     mh1*histint+min_hist,hl);

	if ((hl=(hl+dotsiz-1)/dotsiz) > 60) hl = 60;
	if ((hll=(hll+ddotsiz-1)/ddotsiz) > 40) hll = 40;
	for (j=0; j<hl; j++) hline[j]='='; 
	if (zscoreFlag) {
	  if (el <= hl ) {
	    if (el > 0) hline[el-1]='*';
	    hline[hl]='\0';
	  }
	  else {
	    for (j = hl; j < el; j++) hline[j]=' ';
	    hline[el-1]='*';
	    hline[el]='\0';
	  }
	}
	else hline[hl]='\0';

	if (i >= mht&& doinset ) {
	  for (j = max(el,hl); j < 10; j++) hline[j]=' ';
	  hline[10]=':';
	  for (j = 11; j<11+hll; j++) hline[j]='=';
	  hline[11+hll]='\0';
	  if (zscoreFlag) {
	    if (ell <= hll) hline[10+ell]='*';
	    else {
	      for (j = 11+hll; j < 10+ell; j++) hline[j]=' ';
	      hline[10+ell] = '*';
	      hline[11+ell] = '\0';
	    }
	  }
	}

	fprintf(fd,"%s\n",hline);
	prev_e = cur_e;
      }
    }
    fprintf(fd,"%2ld queries used to search %7ld residues in %5ld sequences\n",
            gNumOfQueries,gNumOfResiduesScanned,gNumOfLibSequences);
    if (zscoreFlag) {
      fprintf(fd," statistics extrapolated from %ld to %ld sequences\n",
	      min(MAXBEST,num_db_entries),num_db_entries);
      /*
	if (histflg) 
	fprintf(fd," Kolmogorov-Smirnov statistic: %6.4f (N=%3d) at %d\n",
	max_dev/(float)(cum_hl),n_chi_sq,max_i*histint+min_hist);
	*/
    }
  }
  if (optall)
    fprintf(fd," results sorted and z-values calculated from opt score\n");
  else if (init1flg) 
    fprintf(fd," results sorted and z-values calculated from init1 score\n");
  else
    fprintf(fd," results sorted and z-values calculated from initn score\n");

  if (pamfact) strncpy(hline,"variable pamfact",sizeof(hline));
  else sprintf(hline,"fact: %d",fact);
  if (lnsflg) fprintf(fd," scores scaled by ln(n0)/ln(n1)\n");
  fprintf(fd," %4d scores better than %d saved, ktup: %d, %s\n",
	  gNumOfBest,bestcut,ktup,hline);
  fprintf(fd," %s matrix,",smptr);
/*#if !defined(FASTX) && !defined(TFASTX)
  fprintf(fd," gap penalties: %d,%d\n",gdelval,ggapval);
#else
  fprintf(fd," gap penalties: %d,%d frame-shift: %d\n",gdelval,ggapval,gshift);
#endif*/
  if (optall)
    fprintf(fd,
	    " joining threshold: %d, optimization threshold: %d, width: %d\n",
	    cgap,optcut,optwid);
  else fprintf(fd," joining threshold: %d, opt. width: %d",cgap,optwid);
  
  if (dataflg) {
    if (lnsflg) fprintf(fd,"; scores scaled by ln(n0)/ln(n1)\n");
  }

  fprintf(fd,"  scan time: "); ptime(fd,tscan-tstart); fprintf(fd,"\n");
  
  if (strlen(cys_status_string)) {
  	fprintf(fd," %s", cys_status_string);
  }
  if (strlen(gNtermBonus)) {
   	fprintf(fd," N-terminal bonus residues: %s\n", gNtermBonus);
  }
  
  fflush(fd);
}

/*==========================================================
*/
void allocdiag(long dsize)	/* allocates diagonal structures */
{

#ifdef I86BUG
	if ((long)sizeof(struct dstruct) != (1<<L2DSTR)) {
	printf(" L2DSTR incorrect - program should be recompiled %3d %3d",
		sizeof(struct dstruct),(1<<L2DSTR));
		exit(1);
		}
#endif

	diag = (struct dstruct *)calloc((size_t)dsize,sizeof(struct dstruct));

	if (diag==NULL) {
		printf(" cannot allocate diagonal arrays\n");
		exit(1);
		}
	}

#ifndef LFASTA
#ifndef A_MARK
#define A_MARK ">>"
#endif

/*==========================================================
*/
void showalign(long nshow)
{
  long ib, istart, istop, i, tmp_len;
  char bline[512], *bp, *bl_ptr;
  char fmt[40],fmt2[40];
  long lcont, ccont, loff;
  char *aa1ptr;
  long olib, tmp;
  double lnscale;
  long swscore;
  
#ifdef TFASTA
  long n10;
#endif

#ifdef TFASTX
  long n10;
  long last_n1,itt;
  char *fd, *fs;
#endif
  
  	olib = -1;
  
 	/* Set up the format string */
  	sprintf(fmt,"%s%%-%ds (%%d %%s)\n",A_MARK,llen-10);
  	if (markx<10) fprintf(outfd,"\n");

  	if (ashow < 0) ashow = nshow;

  	/* Loop through the matches to be shown */
  	istart = 0; istop = min(min(gNumOfBest,ashow),nshow);
  	for (ib=istart; ib<istop; ib++) {
    	bbp = bptr[ib];
    	if (bbp->lib!=olib) {
      		closelib();
      		if (openlib(lbnames[bbp->lib],"\0")<=0) exit(0);
      		olib=bbp->lib;
    	}
	    
    	if (long_info) {
      		RANLIB(bline,sizeof(bline),bbp->lseek);
      		tmp_len = strlen(bline);
      		bl_ptr = bline;
      		if (markx < 10) while (tmp_len > llen) {
				for (i=llen; i>10; i--)
	  			if (bl_ptr[i]==' ') {
	   				 bl_ptr[i]='\n';
	    			break;
	  			}
				if (i <= 10) break;
				tmp_len -= i;
				bl_ptr += i;
      		}
      		bline[sizeof(bline)-1]='\0';
    	}
    	else {
      		RANLIB(bline,llen-5,bbp->lseek);
      		bline[llen-4]='\0';
    	}

    	if (strlen(bline)==0) {
      		bline[0]='>';
      		strncpy(&bline[1],lbnames[bbp->lib],llen-5);
    	}
    	
#if !defined(TFASTA) && !defined(TFASTX)
    	aa1ptr=aa1;
#else
    	aa1ptr = aa10;
#endif

    	loff=0; 
    	loffset = 0l; 
    	lcont=0;
    	for (ccont=0; ccont<=bbp->cont; ccont++) {

#if !defined(TFASTA) && !defined(TFASTX)
	      	n1 = GETLIB(aa1ptr,maxn-loff,libstr,&lmark,&lcont);
	      	if (aa1ptr!=aa1) n1 += gQuery[bbp->query].length;
#else			
	      	maxt = maxn-loff-3; maxt -= maxt%3; maxt++;
	      	n10 = GETLIB(aa1ptr,maxt,libstr,&lmark,&lcont);
	      	if (aa1ptr!=aa10) n10 += 3 * gQuery[bbp->query].length;
#endif

	      	if (lcont>bbp->cont) break;
      
#if !defined(TFASTA) && !defined(TFASTX)
	    	if (lcont) {
		  		loff = gQuery[bbp->query].length;
		  		memcpy(aa1,&aa1[n1-gQuery[bbp->query].length],gQuery[bbp->query].length);
		  		aa1ptr= &aa1[loff];
		  		loffset += n1 - gQuery[bbp->query].length;
	      	}
	    	else {
		  		loff = 0;
		  		aa1ptr=aa1;
	    	}
#else
	    	if (lcont) {
		  		loff = 3 * gQuery[bbp->query].length;
		  		memcpy(aa10,&aa10[n10-loff],loff);
		  		aa1ptr= &aa10[loff];
		  		loffset += n10-loff;
		  		maxt = maxn-loff-3; 
		  		maxt -= maxt%3; 
		  		maxt++;
	    	}
	    	else {
		  		loff = 0;
		  		aa1ptr = aa10;
		  		maxt = maxn-loff-3; 
		  		maxt -= maxt%3; 
		  		maxt++;
	    	}
#endif

		}

#ifdef TFASTA
	    n1 = aatran(aa10,aa1,n10,bbp->frame);
	    loffset /= 3;
#endif

#ifdef TFASTX
	  	last_n1 = 0;
	  	for (itt=3*bbp->frame; itt<3+3*bbp->frame; itt++) {
	    	n1 = aatran(aa10,&aa1[last_n1],n10,itt);
	    	last_n1 += n1+1;
	  	}

	  	n1 = last_n1;
	  	/* we also need a rearranged version, 
	     111111222222233333333 becomes 123123123123123 */

	  	for (fs=aa1, itt=0; itt <3; itt++,fs++) {
	    	for (fd=&aa1y[itt]; *fs !=EOSEQ; fd += 3, fs++) *fd = *fs;
	    	*fd=EOSEQ;
	  	}
#endif

	    if (markx != 4 && markx<10) {
	      	fprintf(outfd,fmt,bline,bbp->n1,sqnam);

#if !defined(TFASTA) && !defined(TFASTX)
			fprintf(outfd, "initn: %4d  initn sum: %4d   E(): %6.2g \n",
					bbp->score,bbp->score0,bbp->escore);
			    
	      	if (lnsflg) {
				if (n1 > 5) lnscale = log((double)n1)/log((double)gQuery[bbp->query].length);
				else lnscale = 1.0;
				fprintf(outfd," Unnormalized scores, initn: %4d init1: %4d opt %4d\n",
						(long)((double)bbp->score*lnscale+0.5),
						(long)((double)bbp->score0*lnscale+0.5),
						(long)((double)bbp->gscore*lnscale+0.5));
	      	}
#else
#ifdef TFASTA
	      	if (zscoreFlag)
				fprintf(outfd, "Frame: %1d  init1: %4d  initn: %4d  opt: %4d z-score: %4.1f E(): %6.2g\n",
						bbp->frame+1,bbp->score,bbp->score0,bbp->gscore,bbp->zscore,bbp->escore);
	      	else
				fprintf(outfd,"Frame: %1d  init1: %4d  initn: %4d  opt: %4d\n",
						bbp->frame+1,bbp->score,bbp->score0,bbp->gscore);
#else
	      if (zscoreFlag)
				fprintf(outfd,"Strand: %c  initn: %4d  initn sum: %4d   E(): %6.2g \n",
						(bbp->frame?'R':'F'), bbp->score, bbp->score0, bbp->escore);
	      else
			fprintf(outfd,"Frame: %c  init1: %4d  initn: %4d  opt: %4d\n",
					(bbp->frame?'R':'F'),bbp->score,bbp->score0,bbp->gscore);
#endif
#endif

		}  /* if (markx!=4 && markx!=10) */
	    strncpy(name1,bline,sizeof(name1));
	    if (markx<=4) name1[6]='\0';
	    if ((bp = strchr(name1,' '))!=NULL) *bp = '\0';
	    if (markx==10) {
	      	fprintf(outfd,">>%s\n",bline);
	      	fprintf(outfd,"; fa_initn: %d\n",bbp->score);
	      	fprintf(outfd,"; fa_init1: %d\n",bbp->score0);
	      	fprintf(outfd,"; fa_opt: %d\n",bbp->gscore);
	      	fprintf(outfd,"; fa_z-score: %4.1f\n",bbp->zscore);
	      	fprintf(outfd,"; fa_expect: %6.2g\n",bbp->escore);
	    }

		
			
#if defined(FASTX) || defined(TFASTX)
	    smark[0] = smark[1] = smark[2] = smark[3] = -BIGNUM;

#ifdef FASTX
	    swscore = pmatch(gQuery[bbp->query].seq,gQuery[bbp->query].length,aa0y,n0x,aa1,n1,YES);
#endif
#ifdef TFASTX
	    swscore = pmatch(aa1,n1,aa1y,n1,gQuery[bbp->query].seq,gQuery[bbp->query].length,YES);


#endif
#else
	    smark[2]=bbp->start;
	    smark[3]=bbp->stop;
	    smark[0]=noff+smark[2]-bbp->dp;
	    smark[1]=noff+smark[3]-bbp->dp;
	    iscore=bbp->score0;
	    if (!ldnaseq || dnasw_flg) swscore=smatch(gQuery[bbp->query].seq,gQuery[bbp->query].length,aa1,n1,YES);
	    else dmatch(gQuery[bbp->query].seq, gQuery[bbp->query].length,noff-bbp->dp,YES);
#endif
	    if (markx !=4 && markx<10) fprintf(outfd,"\n");
	    fflush(outfd);
	}	    
}
#endif

/*==========================================================
*/
#ifdef LFASTA
void showlocal(long nshow)
{
	long ib, istart, istop;
	char bline[200], *bp;
	long lcont, olcont, ccont, loff;
	unsigned char *aa1ptr;
	long olib;

	olcont = -1;

	istart = 0; istop = gNumOfBest;

	bbp = bptr[0];

	for (ib=istart; ib<istop; ib++) {
	    bbp = bptr[ib];
	if (bbp->cont!=olcont) {

	RANLIB(bline,llen-5,bbp->lseek);
	if (strlen(bline)==0) {
		bline[0]='>';
		strncpy(&bline[1],lbnames[bbp->lib],llen-5);
		}

	    aa1ptr=aa1;

	    loff=0; loffset = 0l; lcont=0;
	    for (ccont=0; ccont<=bbp->cont; ccont++) {
		n1=GETLIB(aa1ptr,maxn-loff,libstr,&lmark,&lcont);
/*		if (aa1ptr!=aa1) n1 += n0;*/
		if (lcont>bbp->cont) break;
		if (lcont) {
		    loff = n0;
		    memcpy(aa1,&aa1[n1-gQuery[bbp->query].length],gQuery[bbp->query].length);
		    aa1ptr= &aa1[loff];
		    loffset += n1-gQuery[bbp->query].length;
		    }
		else {
		    loff = 0;
		    aa1ptr=aa1;
		    }
		}
		olcont = bbp->cont;
		}
		strncpy(name1,bline,6);
		name1[6]='\0';
		if ((bp = strchr(name1,' ')) != NULL) *bp = '\0';
		smark[2]=bbp->start;
		smark[3]=bbp->stop;
		smark[0]=noff+smark[2]-bbp->dp;
		smark[1]=noff+smark[3]-bbp->dp;
		iscore=bbp->score0;
#if (defined(__MWERKS__)  && __dest_os == __mac_os)
		ChkEvent();
#endif
#ifndef TPLOT
		if (dmatch(gQuery[bbp->query].seq, gQuery[bbp->query].length,smark[1],smark[3],YES)>=0) 
			fprintf(outfd,"\n----------\n");
#else		/* !TPLOT */
		dmatch(gQuery[bbp->query].seq, gQuery[bbp->query].length,smark[1],smark[3],NO);
#endif		/* TPLOT */
		}
	}
#endif
/*==========================================================
//  AllocateBestScoreArrays - allocate arrays for best sort
*/
#ifdef FAR_PTR
#ifdef __TURBOC__
#define FCALLOC farcalloc
#define MTYPE unsigned long
#define FFREE farfree
#endif
#endif

static void AllocateBestScoreArrays(long numToAllocate)		
{
#ifndef FAR_PTR
	if ((best=(beststr *)calloc((size_t)numToAllocate,sizeof(beststr)))
		== NULL) {fprintf(stderr,"cannot allocate best struct\n"); exit(1);}
	if ((bptr=(beststr **)calloc((size_t)numToAllocate,sizeof(beststr *)))
		== NULL) {fprintf(stderr,"cannot allocate bptr\n"); exit(1);}

#else	/* FAR_PTR */
	void far *FCALLOC();
	if ((best=(beststr huge *)
	     FCALLOC((MTYPE)numToAllocate,(MTYPE)sizeof(beststr)))== NULL) {
	  fprintf(stderr,"cannot allocate best struct\n"); exit(1);}
	if ((bptr=(beststr huge * huge *)
	     FCALLOC((MTYPE)numToAllocate,(MTYPE)sizeof(beststr huge *)))==NULL) {
	  fprintf(stderr,"cannot allocate bptr\n"); exit(1);}
#endif	/* FAR_PTR */
}

/*=======================================================
*/
static void freebest(void)
{
#ifndef BIGMEM
#ifndef FAR_PTR
		free(bptr);
		free(best);
#else	/* FAR_PTR */
		FFREE(bptr);
		FFREE(best);
#endif	/* FAR_PTR */
#endif	/* BIGMEM */
}

/*=======================================================
*/
#ifndef LFASTA
void showbest(void)
{
	long ib, istart, istop;
	char bline[200], fmt[40], pad[200];
	long ntmp;
	long lcont, ccont, loff;
	char *aa1ptr;
	long olib;
#ifdef TFASTA
	long n10;
#endif
#ifdef TFASTX
	long n10;
	long last_n1, itt;
	char *fs, *fd;
#endif

	if (nshow <= 0) return;

	olib = -1;

#if !defined(TFASTA) && !defined(TFASTX)
	sprintf(fmt,"%%-%ds",llen-10);
#else
	sprintf(fmt,"%%-%ds",llen-14);
#endif

	nshow = min(nshow,gNumOfBest);
	mshow = min(mshow,gNumOfBest);
	if (outtty) {
		printf(" How many scores would you like to see? [%d] ",nshow);
		fflush(stdout);
		if (my_fgets(rline,sizeof(rline),stdin)==NULL) exit(0);
		if (rline[0]!='\n' && rline[0]!=0) sscanf(rline,"%d",&nshow);
		if (nshow<=0) nshow = min(20,gNumOfBest);
	}
	else nshow = mshow;

	memset(pad,' ',llen-25);
	
#if !defined(TFASTA) && !defined(TFASTX)
	pad[llen-31]='\0';
#else
	pad[llen-31]='\0';
#endif

	if (zscoreFlag)
	  	fprintf(outfd,"\nThe best scores are:%sinitn  initn sum    E()\n",pad);
	else
	  	fprintf(outfd,"\nThe best scores are:%sinitn  initn sum    E()\n",pad);

	if (outfd != stdout)
	  	if (zscoreFlag)
	    	printf("\nThe best scores are:%sinitn  initn sum    E()\n",pad);
	  	else
	    	printf("\nThe best scores are:%sinitn  initn sum    E()\n",pad);

	istart = 0;
l1:	istop = min(gNumOfBest,nshow);
	for (ib=istart; ib<istop; ib++) {
	  bbp = bptr[ib];

	  if (!outtty && zscoreFlag && bbp->escore > e_cut) {
	    nshow = ib;
	    goto done;
	  }

	  if (bbp->lib!=olib) {
	    if (-1 != olib) closelib();
	    if (openlib(lbnames[bbp->lib],"\0")<=0) {
	    	printf("\nCouldn't open library '%s'\n", lbnames[bbp->lib]);
		exit(0);
	    }
	    olib=bbp->lib;
	  }

	  RANLIB(bline,llen-5,bbp->lseek);
	

#if !defined(TFASTA) && !defined(TFASTX)
	  bline[llen-11]='\0';
#else
	  bline[llen-15]='\0';
#endif

	  if (!optall) {
#if !defined(TFASTA) && !defined(TFASTX)
	    aa1ptr=aa1;
#else
	    aa1ptr = aa10;
#endif
	    loff=0; lcont=0;
	    for (ccont=0; ccont <= bbp->cont; ccont++) {
	    
#if !defined(TFASTA) && !defined(TFASTX)
	      n1=GETLIB(aa1ptr,maxn-loff,libstr,&lmark,&lcont);
	      if (aa1ptr!=aa1) n1 += gQuery[bbp->query].length;
#else
	      maxt = maxn-loff-3; maxt -= maxt%3; maxt++;
	      n10=GETLIB(aa1ptr,maxt,libstr,&lmark,&lcont);
	      if (aa1ptr!=aa10) n10 += 3 * gQuery[bbp->query].length;
#endif

	      if (lcont>bbp->cont) break;

#if !defined(TFASTA) && !defined(TFASTX)
	      if (lcont) {
		    loff = gQuery[bbp->query].length;
		    memcpy(aa1,&aa1[n1-gQuery[bbp->query].length],gQuery[bbp->query].length);
		    aa1ptr= &aa1[loff];
	      }
	      else {
		    loff = 0;
		    aa1ptr=aa1;
	      }
#else
	      if (lcont) {
		    loff = 3*gQuery[bbp->query].length;
		    memcpy(aa10,&aa10[n10-loff],loff);
		    aa1ptr= &aa10[loff];
		    maxt = maxn-loff-3; maxt -= maxt%3; maxt++;
	      }
	      else {
		    aa1ptr=aa10;
		    loff = 0;
		    maxt = maxn-loff-3; maxt -= maxt%3; maxt++;
	      }
#endif
	    }

/*	    if (check_nt(aa10,n10,&last_n1)==0) {
	      fprintf(stderr," error - non-nucleotide in sequence %s\n",libstr);
	      last_n1 = max(0,last_n1-10);
	      for (itt=last_n1; itt<last_n1+20; itt++) fputc(sq[aa10[itt]],stderr);
	      fputc('\n',stderr);
	      exit(1);
	    }
	    */
	    
#ifdef TFASTA
	    n1=aatran(aa10,aa1,n10,bbp->frame);
#endif

#ifdef TFASTX
  	    last_n1 = 0;
  	    for (itt=(revflg?3:0); itt<(revflg?6:3); itt++) {
	      n1 = aatran(aa10,&aa1[last_n1],n10,itt);
	      last_n1 += n1+1;
	    }
	    n1 = n10;
	    /* we also need a rearranged version, 
	       111111222222233333333 becomes 123123123123123 */
	    for (itt=0,fs=aa1; itt <3; itt++,fs++) {
	      for (fd=&aa1y[itt]; *fs !=EOSEQ; fd += 3, fs++) *fd = *fs;
	      *fd=EOSEQ;
	    }
	    bbp->gscore=dmatch(gQuery[bbp->query].seq, gQuery[bbp->query].length,bbp->dp-noff,NO);
#else
	bbp->gscore=dmatch(gQuery[bbp->query].seq, gQuery[bbp->query].length,noff-bbp->dp,NO);
#endif
	  }

	  fprintf(outfd,fmt,bline);

#if !defined(TFASTA) && !defined(TFASTX)
	  if (zscoreFlag) fprintf(outfd,"%4d     %3d     %6.2g \n",
			          bbp->score,bbp->score0,bbp->escore);
	  else fprintf(outfd,"%4d     %3d     %6.2g \n",
		              bbp->score,bbp->score0,bbp->escore);

#else
#ifndef TFASTX
	  if (zscoreFlag) fprintf(outfd,"(%1d) %4d %3d %4d %4.1f %6.2g\n",
			      bbp->frame+1,bbp->score,bbp->score0,bbp->gscore,
			      bbp->zscore,bbp->escore);
	  else fprintf(outfd,"(%1d) %4d %3d %4d\n",
		       bbp->frame+1,bbp->score,bbp->score0,bbp->gscore);
#else
	  if (zscoreFlag) fprintf(outfd,"(%c) %4d     %3d     %6.2g \n", (bbp->frame?'r':'f'), 
		                      bbp->score,bbp->score0,bbp->escore);
	  else fprintf(outfd,"(%c) %4d     %3d     %6.2g \n", (bbp->frame?'r':'f'),
		           bbp->score,bbp->score0,bbp->escore);
#endif
#endif

	  if (outfd!=stdout) {
	    fprintf(stdout,fmt,bline);

#if !defined(TFASTA) && !defined(TFASTX)
	    if (zscoreFlag) printf("%4d     %3d     %6.2g \n",
			          bbp->score,bbp->score0,bbp->escore);
	    else
	      printf("%4d     %3d      %6.2g \n", bbp->score,bbp->score0,bbp->escore);
#else
#ifndef TFASTX
	    if (zscoreFlag)
	      printf("(%1d) %4d %3d %4d %4.1f %5.2g\n",
		     bbp->frame+1,bbp->score,bbp->score0,bbp->gscore,
		     bbp->zscore,bbp->escore);
	    else 
	      printf("(%1d) %4d %3d %4d\n",
		     bbp->frame+1,bbp->score,bbp->score0,bbp->stddev);
#else
	    if (zscoreFlag)
	      printf("(%c) %4d     %3d     %6.2g \n",
		     (bbp->frame?'r':'f'),bbp->score, bbp->score0, bbp->escore);
	    else 
	      printf("(%c) %4d %3d %6.2g\n",
		     (bbp->frame?'r':'f'),bbp->score,bbp->score0,bbp->escore);
#endif
#endif
	  }
	}

	fflush(outfd); if (outfd!=stdout) fflush(stdout);

	if (outtty) {
	  printf(" More scores? [0] ");
	  fflush(stdout);
	  if (my_fgets(rline,sizeof(rline),stdin)==NULL) exit(0);
	  ntmp = 0;
	  if (rline[0]!='\n' && rline[0]!=0) sscanf(rline,"%d",&ntmp);
	  if (ntmp<=0) ntmp = 0;
	  if (ntmp>0) {
	    istart = istop;
	    nshow += ntmp;
	    mshow += ntmp;
	    goto l1;
	  }
	}
	else if (zscoreFlag && bbp->escore < e_cut) {
	  if (mshow_flg && istop >= mshow) goto done;
	  istart=istop;
	  nshow += 10;
	  goto l1;
	}

      done:
	if (outfd!=stdout) fprintf(outfd,"\n");
	}
#endif	/* LFASTA */

/*=============================================================================
*/
void selectz(long k, long n)	/* k is rank in array */
{
  long t, i, j, l, r;
  float v;
#ifndef FAR_PTR
  beststr *tmptr;
#else
  beststr huge * tmptr;
#endif

  l=0; r=n-1;


  while ( r > l ) {
    i = l-1;
    j = r;
    v = bptr[r]->score0;
    do {
      while (bptr[++i]->score0 > v ) ;
      while (bptr[--j]->score0 < v ) ;
      tmptr = bptr[i]; bptr[i]=bptr[j]; bptr[j]=tmptr;
    } while (j > i);
    bptr[j]=bptr[i]; bptr[i]=bptr[r]; bptr[r]=tmptr;
    if (i>=k) r = i-1;
    if (i<=k) l = i+1;
  }
}

/*=============================================================================
*/
void sortbest(void)
{
#ifndef FAR_PTR
  long cmps(), cmp1(), cmpa();
  if (init1flg) ksort((void *)bptr,gNumOfBest,cmp1);
  else if (optall)  ksort((void *)bptr,gNumOfBest,cmpa);
  else ksort((void *)bptr,gNumOfBest,TwoKeyScoreSort);
#else
  long fcmps(), fcmp1(), fcmpa();
  if (init1flg) fksort(bptr,gNumOfBest,fcmp1);
  else if (optall) fksort(bptr,gNumOfBest,fcmpa);
  else fksort(bptr,gNumOfBest,(void *)FTwoKeyScoreSort);
#endif
}

/*=============================================================================
*/
void sortbeste(void)
{
#ifndef FAR_PTR
  long cmpe();

  ksort((void *)bptr,gNumOfBest,cmpe);
#else
  long fcmpe();

  fksort((void *)bptr,gNumOfBest,fcmpe);
#endif
}

/*=============================================================================
*/
void sortbestz(void)
{
#ifndef FAR_PTR
  long cmpz();

  ksort((void *)bptr,gNumOfBest,cmpz);
#else
  long fcmpz();

  fksort((void *)bptr,gNumOfBest,fcmpz);
#endif
}
/*=============================================================================
//  TwoKeyScoreSort
*/
/* static */
long TwoKeyScoreSort(beststr *ptr1, beststr *ptr2) {

  if (ptr1->score0 < ptr2->score0) return (1);
  else if (ptr1->score0 > ptr2->score0) return (-1);
  else if (ptr1->score < ptr2->score) return (1);
  else if (ptr1->score > ptr2->score) return (-1);
  else return (0);
}
/*=============================================================================
*/
long cmps(beststr *ptr1, beststr *ptr2)
{
  if (ptr1->score < ptr2->score) return (1);
  else if (ptr1->score > ptr2->score) return (-1);
  else return (0);
}

/*=============================================================================
*/
long cmpa(beststr *ptr1, beststr *ptr2)
{
  if (ptr1->gscore < ptr2->gscore) return (1);
  else if (ptr1->gscore > ptr2->gscore) return (-1);
  else return (0);
}

/*=============================================================================
*/
long cmp1(beststr *ptr1, beststr *ptr2)
{
  if (ptr1->score0 < ptr2->score0) return (1);
  else if (ptr1->score0 > ptr2->score0) return (-1);
  else return (0);
}

/*=============================================================================
*/
long cmpz(beststr *ptr1, beststr *ptr2)
{
  if (ptr1->zscore < ptr2->zscore) return (1);
  else if (ptr1->zscore > ptr2->zscore) return (-1);
  else return (0);
}

/*=============================================================================
*/
long cmpe(beststr *ptr1, beststr *ptr2)
{
  if (ptr1->escore < ptr2->escore) return (-1);
  else if (ptr1->escore > ptr2->escore) return (1);
  else return (0);
}

/*=============================================================================
//  TwoKeyScoreSort
*/
#ifdef FAR_PTR

static long FTwoKeyScoreSort(beststr huge *ptr1, beststr huge *ptr2) 
{
  if (ptr1->score0 < ptr2->score0) return (1);
  else if (ptr1->score0 > ptr2->score0) return (-1);
  else if (ptr1->score < ptr2->score) return (1);
  else if (ptr1->score > ptr2->score) return (-1);
  else return (0);
}
/*=============================================================================
*/
long fcmps(beststr huge *ptr1, beststr huge *ptr2)
{
  if (ptr1->score < ptr2->score) return (1);
  else if (ptr1->score > ptr2->score) return (-1);
  else return (0);
}

/*=============================================================================
*/
long fcmp1(beststr huge *ptr1, beststr huge *ptr2)
{
  if (ptr1->score0 < ptr2->score0) return (1);
  else if (ptr1->score0 > ptr2->score0) return (-1);
  else return (0);
}

/*=============================================================================
*/
long fcmpa(beststr huge *ptr1, beststr huge *ptr2)
{
  if (ptr1->gscore < ptr2->gscore) return (1);
  else if (ptr1->gscore > ptr2->gscore) return (-1);
  else return (0);
}

/*=============================================================================
*/
long fcmpz(beststr huge *ptr1, beststr huge *ptr2)
{
  if (ptr1->zscore < ptr2->zscore) return (1);
  else if (ptr1->zscore > ptr2->zscore) return (-1);
  else return (0);
}

/*=============================================================================
*/
long fcmpe(beststr huge *ptr1, beststr huge *ptr2)
{
  if (ptr1->escore < ptr2->escore) return (-1);
  else if (ptr1->escore > ptr2->escore) return (1);
  else return (0);
}
#endif

/*=============================================================================
*/
long cmpp(beststr *ptr1, beststr *ptr2)
{
  if (ptr1->start < ptr2->start) return (-1);
  else if (ptr1->start > ptr2->start) return (1);
  else return (0);
}

/*=============================================================================
*/
void kssort(beststr *v[], long n)
{
  long gap, i, j;
  beststr *tmp;
	
  for (gap=n/2; gap>0; gap/=2)
    for (i=gap; i<n; i++)
      for (j=i-gap; j>=0; j -= gap) {
	    if (v[j]->score >= v[j+gap]->score)
	      break;
	    tmp = v[j]; v[j]=v[j+gap]; v[j+gap]=tmp;
      }
}

/*=============================================================================
*/
void kpsort(beststr *v[], long n)
{
  long gap, i, j;
  beststr *tmp;
	
  for (gap=n/2; gap>0; gap/=2)
    for (i=gap; i<n; i++)
      for (j=i-gap; j>=0; j -= gap) {
	    if (v[j]->start <= v[j+gap]->start)
	      break;
	    tmp = v[j]; v[j]=v[j+gap]; v[j+gap]=tmp;
      }
}

/*=============================================================================
*/
void ksort(void *v[], long n,long (*comp)())
{
  long gap, i, j;
  char *tmp;
	
  for (gap=n/2; gap>0; gap/=2)
    for (i=gap; i<n; i++)
      for (j=i-gap; j>=0; j -= gap) {
	if ((*comp)(v[j],v[j+gap]) <=0)
	  break;
	tmp = v[j]; v[j]=v[j+gap]; v[j+gap]=tmp;
      }
}

/*=========================================================
*/
#ifdef FAR_PTR
void fksort(void huge * huge *v, long n, long (*comp)())
{
  long gap, i, j;
  void huge *tmp;
	
  for (gap=n/2; gap>0; gap/=2)
	for (i=gap; i<n; i++)
      for (j=i-gap; j>=0; j -= gap) {
	    if ((*comp)(v[j],v[j+gap]) <=0)
	      break;
	    tmp = v[j]; v[j]=v[j+gap]; v[j+gap]=tmp;
      }
}
#endif

/*=========================================================
*/
long getlnames(char *tname)		/* read in the library names */
{
  long i;
  char *bp;
  char lline[120];
  FILE *tptr;

  if (*tname != '@') {addfile(tname,"\0"); return 1;}
  else tname++;

  if ((bp=strchr(tname,' '))!=NULL) {
    *bp='\0';
#ifndef LFASTA
    sscanf(bp+1,"%d",&deftype);
    if (deftype<0 || deftype>LASTLIB) {
      fprintf(stderr," default type error %d\n",deftype);
      deftype=0;
    }
#endif		
  }

  if ((tptr=fopen(tname,"r"))==NULL) {
    fprintf(stderr," could not open file of names: %s\n",tname);
    return 0;
  }

  while (my_fgets(lline,sizeof(lline),tptr)!=NULL) {
    if (lline[0]==';') continue;
    if ((bp=strchr(lline,'\n'))!=NULL) *bp='\0';
    if (lline[0]=='<') {
      if (ldname[0]!='\0' && strcmp(ldname,lline+1)!=0) 
	fprintf(stderr,
		" changing default directory name from %s to %s\n",
		ldname,lline+1);
      strncpy(ldname,&lline[1],sizeof(ldname));
      ldname[sizeof(ldname)-1]='\0';
      libenv=ldname;
    }
    else addfile(lline,libenv);
  }
  fclose(tptr);
  return 1;
}

/*	modified Dec 13, 1989 requires different FASTLIBS */

#define MAXCHFIL 80
#define MAXCH 40
/*=========================================================
*/
void libchoice(char *lname, long nl, char *aaenv)
{
  FILE *fch;
  char line[120], *bp;
  char *chstr[MAXCH],*chfile[MAXCH];
  char *chtmp, *charr;
  long i,j,k,chlen;


  charr = NULL;
  if (strlen(flstr) > 0) {
    chlen = MAXCH*MAXCHFIL;
    if ((chtmp = charr = calloc((size_t)chlen,sizeof(char))) == NULL) {
      fprintf(stderr,"cannot allocate choice file array\n");
      goto l1;
    }
    chlen--;
    if ((fch = fopen(flstr,"r")) == NULL) {
      fprintf(stderr," cannot open FASTLIBS file: %s\n",flstr);
      goto l1;
    }
    
    fprintf(stderr,"\n Choose sequence library:\n\n");

    for (i=j=0; j<MAXCH; i++) {
    
       if (my_fgets(line,sizeof(line),fch)==NULL) break;
      if (line[0]==';') continue;
      if ((bp=strchr(line,'\n'))!=NULL) *bp='\0';
      if ((bp=strchr(line,'$'))==NULL) continue;
      *bp++='\0';
      if ((*bp++ -'0')!=ldnaseq) continue;
      if ((k=strlen(line))>chlen) break;
      strncpy(chstr[j]=chtmp,line,chlen);
      chtmp += k+1; chlen -= k+1;
      if ((k=strlen(bp))>chlen) break;
      strncpy(chfile[j]=chtmp,bp,chlen);
      chtmp += k+1; chlen -= k+1;
      fprintf(stderr,"    %c: %s\n",*chfile[j++],line);
    }
l2: fprintf(stderr,"\n Enter library filename (e.g. %s), letter (e.g. P)\n",
	       (ldnaseq == 0)? "prot.lib" : "dna.lib");
    fprintf(stderr," or a %% followed by a list of letters (e.g. %%PN): ");
    fflush(stderr);
    if (my_fgets(line,sizeof(line),stdin) == NULL) exit(0);
    if ((bp = strchr(line,'\n')) != NULL) *bp = '\0';
    if (strlen(line) == 0) {
 
#   if (defined(__MWERKS__)  && __dest_os == __mac_os)    	

	SFileDlog("Choose sequence library:",&freply);
    	if (freply.sfGood==TRUE) {
      	   PtoCstr((unsigned char *)freply.sfFile.name);
      	   strcpy(line,(char *)freply.sfFile.name);
	   libSpec.vRefNum = freply.sfFile.vRefNum;
	   libSpec.parID = freply.sfFile.parID;
	   HSetVol(NULL,libSpec.vRefNum,libSpec.parID);
    	}
    	else exit(0);
#   else
        goto l2;
#   endif
    }
    strncpy(lname, line, nl);
  }
  else {
l1:	fprintf(stderr," library file name: [%s]",aaenv);
    fflush(stderr);
    if (my_fgets(line,sizeof(line),stdin)==NULL) exit(0);
    if ((bp=strchr(line,'\n'))!=NULL) *bp='\0';
    if (strlen(line)>0) strncpy(lname,line,nl);
    else strncpy(lname, aaenv, nl);
  }
  
  if (charr != NULL) {
    fclose(fch);
    free(charr);
  }
}
/*=============================================================
*/
void libselect(char *lname)
{
  char line[120], *bp;
  FILE *fch;
  long i;

  if (strlen(lname) > 1 && *lname != '%') getlnames(lname);
  else {
    if (*lname == '%')
      if (*flstr == '\0') {
	    fprintf(stderr," FASTLIBS undefined, cannot use %s\n",lname);
	    exit(1);
      }
      else lname++;
      
    if (strlen(flstr) > 0) {
      if ((fch = fopen(flstr,"r")) == NULL) {
	    fprintf(stderr," cannot open choice file: %s\n",flstr);
	    return;
      }
    }
    else {
      fprintf(stderr," FASTLIBS undefined\n");
      addfile(lname,"\0");
      return;
    }

    while (my_fgets(line,sizeof(line),fch) != NULL) { 
      if (line[0] == ';') continue;
      if ((bp = strchr(line,'\n')) != NULL) *bp='\0';
      if ((bp = strchr(line,'$')) == NULL) continue;
      *bp++ = '\0';
      if ((*bp++ -'0') != ldnaseq) continue;
      if (ulindex(lname,*bp) != NULL) {
	    strncpy(ltitle, line, sizeof(ltitle));
	    getlnames(bp + 1);
      }
    }
    fclose(fch);
  }
}

char *lbptr;
long nnsize;

/*=============================================================
*/
void addfile(char *fname, char *env)
{
  char tname[120];
  long len, lenv, i;

/* allocate some space for file names */
  if (lbnarr==NULL) {
    if ((lbnarr=calloc((size_t)MAXLF*MAXLN,sizeof(char)))==NULL) {
	fprintf(stderr," could not allocate name table\n");
	exit(1);
	}

    nln = 0;
    nnsize = MAXLF*MAXLN;
    lbptr = lbnarr;
  }

  if (env!=NULL) lenv = strlen(env)+1;
  else lenv = 0;
  len=strlen(fname)+1+lenv;
  if (nnsize > sizeof(tname)) {
    if (lenv > 1 && *fname != '#') {
      strncpy(tname,env,sizeof(tname));
#ifdef UNIX
      strcat(tname,"/");
#endif
    }
    else tname[0]='\0';
    strncat(tname,fname,sizeof(tname)-strlen(tname)-1);
    len=strlen(tname)+1;
    strncpy(lbptr,tname,nnsize);
  }
  else fprintf(stderr,"no more space for filenames: %s ignored\n",fname);
  if (nln< MAXLF) lbnames[nln++]=lbptr;
  else fprintf(stderr," no more file name slots: %s ignored\n",lbptr);
  lbptr += len;
  nnsize -= len;
}

/*=========================================================
*/
/*#ifndef __MWERKS__
char tolower(char a)
{
  if (a>='A' && a<='Z') return  a + ('a'-'A');
  else return a;
}
#endif
*/
/*=========================================================
*/
char *ulindex(char *str, char chr)
{
  char c;
 
  c = tolower(chr);

  while (*str != '\0' && tolower(*str) !=c ) str++;
  if (*str=='\0') return NULL;
  else return str;
}
/* -------------------------------------------------------------------------
//  dhash - this is the main loop. First zero the diagonal arrays,
//          then go through the sequence ktup at a time updating the
//          diagonals appropriately.  Finally, scan the diagonals,
//          looking for the max score  using the specified matrix
*/

void dhash(void)
{
  long i, j;
  long theNumOfDiagonals;          /* diagonal array size */
  long ndo;
  long n00;	       
  long theLibHashValue;
  long kfact;
  register struct dstruct *theDiagonalP;
  register long theQueryScore;
  
#ifndef ALLOCN0
  register struct dstruct *diagp;
#else
  register long dpos;
  long lposn0;
#endif

  struct dstruct *theMaxDiagP;
  register long theLibFilePos;
  long 		theQuerySeqPosition;
  long		theQueryLimit;
  beststr 	*theRunP;
  long 		scor;
  long 		gscor;
  long 		cscor;
  long		scor0;
  float 	zscor;
  long		theTotalScore;
  long 		im;
  long		ib;
  long		nsave;
  char 		*aa1ptr;
  float 	lnscale;
  
#if defined(TFASTA) || defined(TFASTX)
  long 		n10;
#endif

#ifdef TFASTX
  long 		last_n1;
  char 		*fs;
  char		*fd;
#endif

  long  itt,itx,lcont, ocont, loff;/* lcont is returned by getlib to
				   indicate there is more sequence
				   remaining.  ocont is the previous
				   value of lcont, for going back later.
				   loff corrects maxn for the modified
				   size of aa1 for continued sequences
				   */


  theQueryLimit = 0;
  
#ifdef FKFACT
  kfact = ktup*fact;
#endif

  ndo = 0;
/*
#ifdef FASTX
  n00 = n0x;
#else
  n00 = n0;
#endif

  noff = n00-1;

#ifdef ALLOCN0
  theNumOfDiagonals = n00;
#endif
*/

/*
	these initializations have been added to deal with reading
	sequences in chunks
*/

#if defined(TFASTA) || defined(TFASTX)
  	aa1ptr=aa10;
#else
  	aa1ptr=aa1;
#endif

	lcont=0;
	ocont=0;
	loff = 0;
  
#if !defined(TFASTA) && !defined(TFASTX)
start: while ((n1=GETLIB(aa1ptr,maxn-loff,libstr,&lmark,&lcont))>0) {
	    gNumOfLibSequences++;
	    gNumOfResiduesScanned += n1;
	    if (n1==1 || n1 < ktup) {
	      /* goto loop; */
	      goto start;
	    }
	    if (aa1 != aa1ptr) {
	    	n1 += n00; 
	    	gNumOfLibSequences--;
	    }
#else
	maxt = maxn-loff-3; 
	maxt -= maxt%3; 
	maxt++;
start: while ((n10 = GETLIB(aa1ptr,maxt,libstr,&lmark,&lcont)) > 0) {
    
      	gNumOfLibSequences++;
      	gNumOfResiduesScanned += n10;
      	if (n10 == 1 || n10 < 3 * ktup) {
			/*goto loop;*/ 
			goto start;
      	}
      	if (aa10 != aa1ptr) {
      		n10 += 3 * n00; 
      		gNumOfLibSequences--;
      	}
#endif

#ifdef TFASTA
		for (itt = 0; itt < nframe; itt++) {
		 	n1 = aatran(aa10,aa1,n10,itt);
		 	if (n1 < ktup) continue;
#else
#	ifdef TFASTX
   		for (itt = revflg; itt < nframe; itt++) {  /* Loop for searching both forward */
     		last_n1 = 0;                           /* and reverse orientations.       */
     		for (itx = 3 * itt; itx < 3 + 3 * itt; itx++) {
    			n1 = aatran(aa10,&aa1[last_n1],n10,itx);
       			last_n1 += n1 + 1;
     		}
    		n1 = n10;
    		n1x31 = (n1-2)/3;
     		n1x32 = n1x31+1 + (n1-n1x31-1)/2;
  			/* we also need a rearranged version, 
     			111111222222233333333 becomes 123123123123123 */
    		for (i = 0, fs = aa1; i < 3; i++,fs++) {
      			for (fd = &aa1y[i]; *fs != EOSEQ; fd += 3, fs++) *fd = *fs;
      			*fd = EOSEQ;
    		}
#	else
    	itt = 0;
#	endif
#endif
#if (defined(__MWERKS__)  && __dest_os == __mac_os)
			ChkEvent();
#endif
/*
#ifndef ALLOCN0
			theNumOfDiagonals = n00 + n1;
#endif
*/		
	    	/* Loop through the lutefisk query peptides ----------------------------- */			  	
			for (i = 0; i < gNumOfQueries; i++) {			
				noff = gQuery[i].length - 1;
				n00 = gQuery[i].length;
				theNumOfDiagonals = gQuery[i].length + n1;
				
				if (lnsflg && n1 > 5) lnscale = (log((float)gQuery[i].length)/log((float)n1));
				else lnscale = 1.0;
				theMaxDiagP = &diag[theNumOfDiagonals];
				/* Clear the diagonals */
				for (theDiagonalP = &diag[ndo]; theDiagonalP < theMaxDiagP;)  {
		  			theDiagonalP->stop = -1;
		  			theDiagonalP->dmax = NULL;
		  			theDiagonalP++->score = 0;
				}
				/* Clear the scores in the array of best runs */
				for (theRunP = gBestRunsArray; theRunP < &gBestRunsArray[MAXSAV]; theRunP++) 
					theRunP->score = 0;
				gLowRunScore = 0;
				
		
	        	/* start hashing */
	    		theLibHashValue = 0;
	    		for (theLibFilePos=0; theLibFilePos<kt1;)
					theLibHashValue= ((theLibHashValue&hmask)<<kshft)+hsq[aa1[theLibFilePos++]];
#ifndef ALLOCN0
				diagp = &diag[noff + kt1];
	    		for ( ; theLibFilePos < n1; theLibFilePos++, diagp++) {
		  			theLibHashValue = ((theLibHashValue&hmask)<<kshft) + hsq[aa1[theLibFilePos]];
		  			for (theQuerySeqPosition = gQuery[i].hashArray[theLibHashValue]; 
			  		     theQuerySeqPosition >= theQueryLimit; 
			  		     theQuerySeqPosition = gQuery[i].link[theQuerySeqPosition]) {
			    		
			    		if ((theQueryScore = (theDiagonalP = &diagp[-theQuerySeqPosition])->stop) >= 0) {
#else
	    		lposn0 = noff + theLibFilePos;
				for ( ; theLibFilePos<n1; theLibFilePos++,lposn0++) {
		  			theLibHashValue = ((theLibHashValue&hmask)<<kshft) + hsq[aa1[theLibFilePos]];
		  			for (theQuerySeqPosition = gQuery[i].hashArray[theLibHashValue]; 
			  		     theQuerySeqPosition >= theQueryLimit; 
			  		     theQuerySeqPosition = gQuery[i].link[theQuerySeqPosition]) {
		    			
		    			dpos = lposn0 - theQuerySeqPosition;
		    			if ((theQueryScore = (theDiagonalP = &diag[dpos%theNumOfDiagonals])->stop) >= 0) {
#endif
	     		
			      			theQueryScore += ktup;
		      				if ((theQueryScore -= theLibFilePos) <= 0) {
								scor = theDiagonalP->score;
								
								/* If the score of the diagonal is better than the worst run
							   		score currently saved on the best score list then replace
							   		the worst run with this one */
#ifdef FKFACT
								if ((theQueryScore += kfact) < 0 && gLowRunScore < scor)
#else
		  						if ((theQueryScore += (kfact = gQuery[i].pamh2[theLibHashValue])) < 0
			      					&& gLowRunScore < scor)
#endif
#ifdef ALLOCN0
		    						savemax(theDiagonalP,dpos);
#else
		    						savemax(theDiagonalP);
#endif
								if ((theQueryScore += scor) >= kfact) {
				   					theDiagonalP->score = theQueryScore;
				   					theDiagonalP->stop  = theLibFilePos;
				 				}
				 				else {
				   					theDiagonalP->score = kfact;
				   					theDiagonalP->start = (theDiagonalP->stop = theLibFilePos) - kt1;
				 				}
		      				}
		      				else {
		      				
#ifdef FKFACT
								theDiagonalP->score += fact;
#else
								theDiagonalP->score += pamh1[gQuery[i].seq[theQuerySeqPosition]];
#endif
							
								theDiagonalP->stop = theLibFilePos;
		      				}
			    		}
			    		else {
#ifdef FKFACT
	      					theDiagonalP->score = kfact;
#else
	      					theDiagonalP->score = gQuery[i].pamh2[theLibHashValue];
#endif
		      			
		      				theDiagonalP->start = (theDiagonalP->stop = theLibFilePos) - kt1;
		    			}
		  			}       /* end theQuerySeqPosition */
#ifdef LFASTA
	  				if (oneseq) theQueryLimit++;
#endif
#ifdef ALLOCN0
		  			/* reinitialize diag structure */
		  			if ((theDiagonalP= &diag[theLibFilePos%theNumOfDiagonals])->score>gLowRunScore) 
		    			savemax(theDiagonalP,theLibFilePos);
		  			theDiagonalP->stop = -1;
		  			theDiagonalP->dmax = NULL;
		  			theDiagonalP->score = 0;
#endif
				}       /* end theLibFilePos */
#ifdef ALLOCN0
				for (theQuerySeqPosition=0, dpos = noff+n1-1; 
				     theQuerySeqPosition < n00; theQuerySeqPosition++, dpos--) {
		  			if ((theDiagonalP= &diag[dpos%theNumOfDiagonals])->score>gLowRunScore) savemax(theDiagonalP,dpos);
				}
#else
				for (theDiagonalP=diag; theDiagonalP < theMaxDiagP; ) {
					/* If the score of the diagonal is better than the worst run
					   score currently saved on the best score list then replace
					   the worst run with this one */
		  			if (theDiagonalP->score>gLowRunScore) savemax(theDiagonalP);
		  			/* Wipe the diagonal info clean to get ready for the next seq. */
		  			theDiagonalP->stop = -1;
		  			theDiagonalP->dmax = NULL;
		  			theDiagonalP++->score = 0;
				}
				ndo = theNumOfDiagonals;
#endif
				/**************************************************************************/
				/*  at this point all of the elements of gLibSeqArray have been searched
					for elements of gQuerySeqArray with the results in gBestRunsArray.
				*/
				for (j = nsave = 0, theRunP = gBestRunsArray; 
				     theRunP < &gBestRunsArray[MAXSAV]; theRunP++) {
#ifdef LFASTA
		  			if (oneseq && theRunP->start == 0 && theRunP->stop == n1 - 1) continue;
#endif
			  		if (theRunP->score > 0) {
			    		theRunP->score = ScoreRunWithMatrix(theRunP, &gQuery[i]);
			    		gBestRunsArrayPtrs[j++] = theRunP;
			    		nsave++;
			  		}
				}
				
				if (nsave > 0) {
#ifndef LFASTA
#ifdef TFASTX
		  			/* TFASTX code here to modify the start, stop points for 
		     		   the three phases of the translated protein sequence
		     		   TFASTX modifies library start points, not query start points
		     		*/
					for (ib=0; ib<nsave; ib++) {
						if (gBestRunsArrayPtrs[ib]->start >= n1x32) {
				      		gBestRunsArrayPtrs[ib]->start -= n1x32;
				      		gBestRunsArrayPtrs[ib]->stop -= n1x32;
				      		gBestRunsArrayPtrs[ib]->dp -= n1x32;
				    	}
				    	if (gBestRunsArrayPtrs[ib]->start >= n1x31) {
				      		gBestRunsArrayPtrs[ib]->start -= n1x31;
				      		gBestRunsArrayPtrs[ib]->stop -= n1x31;
				      		gBestRunsArrayPtrs[ib]->dp -= n1x31;
				    	}
				  	}
#endif /* TFASTX */
					/* Try to connect runs using gaps */
				  	//scor = sconn(gBestRunsArrayPtrs, nsave);
				  	
				  	/* Find the best scoring run */
				  	for (theRunP = gBestRunsArrayPtrs[0], j = 1; j < nsave; j++)
				    	if (gBestRunsArrayPtrs[j]->score > theRunP->score) 
				    		theRunP = gBestRunsArrayPtrs[j];
					/*..................................................*/
					theRunP->score = RescoreBestRunWithMatrix(theRunP, &gQuery[i]);
					gQuery[i].bestScore = *theRunP;
/*				
				  	scor = max(scor, theRunP->score);
				  	cscor = scor = (long)((float)scor * lnscale + 0.5);
				  	scor0 = (long)((float)theRunP->score * lnscale + 0.5);
				  	if (init1flg) cscor =  scor0;
				  	theRunP->score = scor;
*/			  	
#else
	  				kssort(gBestRunsArrayPtrs,nsave);
#endif
/*	
#ifdef LFASTA
		  			for (ib=0; ib<nsave; ib++) 
		    			if ((scor0 = scor=gBestRunsArrayPtrs[ib]->score) > optcut) {
		      				theRunP=gBestRunsArrayPtrs[ib];
#else
		      		ib=0;

		      		gscor = scor;
		      		if (optall && scor > optcut) {
#if (defined(__MWERKS__)  && __dest_os == __mac_os)
						ChkEvent();
#endif
#ifndef TFASTX
						cscor = gscor = dmatch(gQuery[i].seq, gQuery[i].length,noff-theRunP->dp,NO);
#else
						cscor = gscor = dmatch(gQuery[i].seq, gQuery[i].length,theRunP->dp-noff,NO);
#endif
						optcount++;
	  				}

		  			if (dohist) addhistz(zscor=find_zm(cscor,n1),n1);
		  			else zscor = (float)cscor;


		  			if (dataflg)
						fprintf(tmpfd,"%-12s %4d %4d %4d %4d %4d %8ld\n",
								libstr,sfnum,n1,gscor,scor,scor0,lmark);
		
#endif    // LFASTA 
*/						
				} /* nsave > 0 */
			}
			
			theRunP = &gQuery[0].bestScore;
			theTotalScore = theRunP->score;
			theRunP->query = 0;
			for (i = 1; i < gNumOfQueries; i++) {
				if (gQuery[i].bestScore.score > theRunP->score) {
					theRunP = &gQuery[i].bestScore;
					theRunP->query = i;
				}	
				theTotalScore += gQuery[i].bestScore.score;
			}
			theRunP->score0 = theTotalScore;
			theRunP->gscore = 0;
			theRunP->lseek = lmark;
			theRunP->cont = ocont;
			theRunP->lib = libfn;
			theRunP->n1 = n1;
			theRunP->frame = itt;  
/*
			printf("SENDING RESULT*****\n"); // XXXXXXXXX
			printf("score =  %ld *****\n", theRunP->score); // XXXXXXXXX
			printf("score0 =  %ld *****\n", theRunP->score0); // XXXXXXXXX
			printf("gscore =  %ld *****\n", theRunP->gscore); // XXXXXXXXX
			printf("sscore =  %ld *****\n", theRunP->sscore); // XXXXXXXXX
			printf("n1 =  %ld *****\n", theRunP->n1); // XXXXXXXXX
			printf("start =  %ld *****\n", theRunP->start); // XXXXXXXXX
			printf("lib =  %ld *****\n", theRunP->lib); // XXXXXXXXX
*/			
			MPI_Send(theRunP, 1, resultPacketType, 0, 0, MPI_COMM_WORLD);

		} 
	

#if defined(TFASTA) || defined(TFASTX)
	}	/* end of for (itt ... ) */
#endif

loop:    /*......................................................................*/
	if (lcont) {

#if !defined(TFASTA) && !defined(TFASTX)
  		loff = gQuery[i].length;
  		memcpy(aa1,&aa1[n1-gQuery[i].length],gQuery[i].length);
  		aa1ptr= &aa1[loff];
#else
  		loff = 3*gQuery[i].length;
  		memcpy(aa10,&aa10[n10-loff],loff);
  		aa1ptr= &aa10[loff];
  		maxt = maxn-loff-3; maxt -= maxt%3; maxt++;
#endif
	  
  		ocont = lcont;
	}
	else {
  		loff = 0;
	  		
#if !defined(TFASTA) && !defined(TFASTX)
  		aa1ptr=aa1;
#else
  		aa1ptr = aa10;
  		maxt = maxn-loff-3; maxt -= maxt%3; maxt++;
#endif
	 
 		ocont = lcont;
	}
}




