#include <stdio.h>
#include "getopt.h"



/*LINTLIBRARY*/
#ifndef NULL
#define NULL	0
#endif

extern short strcmp();
extern char *strchr();

short	opterr = 1;
short	optind = 1;
short	optopt;
char	*optarg;

int getopt(int argc, char **argv, char *opts)
{
	static short sp = 1;
	register short c;
	register char *cp;

	if(sp == 1)
		if(optind >= argc ||
		   argv[optind][0] != '-' || argv[optind][1] == '\0')
			return(EOF);
		else if(strcmp(argv[optind], "--") == NULL) {
			optind++;
			return(EOF);
		}
	optopt = c = argv[optind][sp];
	if(c == ':' || (cp=strchr(opts, c)) == NULL) {
	    fprintf(stderr,"illegal command-line option: %c\n",c);
		if(argv[optind][++sp] == '\0') {
			optind++;
			sp = 1;
		}
		return('?');
	}
	if(*++cp == ':') {
		if(argv[optind][sp+1] != '\0')
			optarg = &argv[optind++][sp+1];
		else if(++optind >= argc) {
		    fprintf(stderr,"command-line option %c requires an argument\n",c);
			sp = 1;
			return('?');
		} else
			optarg = argv[optind++];
		sp = 1;
	} else {
		if(argv[optind][++sp] == '\0') {
			sp = 1;
			optind++;
		}
		optarg = NULL;
	}
	return(c);
}
